/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCStatementListener;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDEscapeClause;
import com.ibm.as400.access.JDSQLTokenizer;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public class JDSQLStatement {
    static final int TYPE_UNDETERMINED = 0;
    static final int TYPE_OTHER = 1;
    static final int TYPE_SELECT = 2;
    static final int TYPE_CALL = 3;
    static final int TYPE_COMMIT = 4;
    static final int TYPE_ROLLBACK = 5;
    static final int TYPE_CONNECT = 6;
    static final int TYPE_BLOCK_INSERT = 7;
    private static final String AS_ = "AS";
    private static final String CALL_ = "CALL";
    private static final String CALL0_ = "?";
    private static final String CALL1_ = "?=";
    private static final String CALL2_ = "?=CALL";
    static final String COMMA_ = ",";
    private static final String CONNECT_ = "CONNECT";
    private static final String CONNECTION_ = "CONNECTION";
    static final String CROSS_ = "CROSS";
    private static final String CURRENT_ = "CURRENT";
    private static final String DECLARE_ = "DECLARE";
    private static final String DELETE_ = "DELETE";
    private static final String DISCONNECT_ = "DISCONNECT";
    static final String EXCEPTION_ = "EXCEPTION";
    private static final String FETCH_ = "FETCH";
    private static final String FOR_ = "FOR";
    private static final String FROM_ = "FROM";
    static final String INNER_ = "INNER";
    private static final String INSERT_ = "INSERT";
    static final String JOIN_ = "JOIN";
    static final String LEFT_ = "LEFT";
    private static final String LPAREN_ = "(";
    private static final String OF_ = "OF";
    private static final String ONLY_ = "ONLY";
    private static final String READ_ = "READ";
    private static final String RELEASE_ = "RELEASE";
    private static final String ROWS_ = "ROWS";
    private static final String SELECT_ = "SELECT";
    private static final String SET_ = "SET";
    private static final String UPDATE_ = "UPDATE";
    private static final String VALUES_ = "VALUES";
    private static final String WITH_ = "WITH";
    private static final String MERGE_ = "MERGE";
    static final String METADATA_CALL = "CALL SYSIBM";
    private boolean canBeBatched_ = false;
    private String correlationName_ = null;
    private String csProcedure_ = null;
    private String csSchema_ = null;
    private boolean hasReturnValueParameter_ = false;
    private boolean isCall_ = false;
    private boolean isDeclare_ = false;
    private boolean isCurrentOf_ = false;
    private boolean isDRDAConnect_ = false;
    private boolean isDRDADisconnect_ = false;
    private boolean isForFetchOrReadOnly_ = false;
    private boolean isForUpdate_ = false;
    private boolean isImmediatelyExecutable_ = false;
    boolean isInsert_ = false;
    private boolean isSelect_ = false;
    private boolean isSet_ = false;
    private boolean isSetSpecialRegister_ = false;
    private boolean isSubSelect_ = false;
    private boolean isPackaged_ = false;
    private boolean isUpdateOrDelete_ = false;
    private int nativeType_ = 1;
    private int numberOfParameters_;
    private String selectTable_ = null;
    private JDSQLTokenizer tokenizer_ = null;
    private String value_;
    private boolean selectTableNotSet_ = true;
    private boolean selectFromInsert_ = false;
    private boolean isMetaDataCall_ = false;
    private static final Vector statementListeners_ = new Vector();

    public static void addStatementListener(AS400JDBCStatementListener listener) {
        if (listener != null) {
            statementListeners_.add(listener);
        }
    }

    public static void removeStatementListener(AS400JDBCStatementListener listener) {
        if (listener != null) {
            statementListeners_.remove(listener);
        }
    }

    JDSQLStatement(String sql) throws SQLException {
        this(sql, "", false, "default", null);
    }

    JDSQLStatement(String sql, String decimalSeparator, boolean convert, String packageCriteria, AS400JDBCConnection connection) throws SQLException {
        int call;
        int k;
        String upperCaseSql;
        int i;
        if (sql == null) {
            JDError.throwSQLException("42601");
        }
        if (sql.trim().length() == 0) {
            JDError.throwSQLException("43617");
        }
        int length = sql.length();
        for (int i2 = 0; i2 < statementListeners_.size(); ++i2) {
            AS400JDBCStatementListener listener = (AS400JDBCStatementListener)statementListeners_.elementAt(i2);
            String sql2 = listener.modifySQL(connection, sql);
            if (sql2 == null) continue;
            sql = sql2;
            if (!JDTrace.isTraceOn()) continue;
            JDTrace.logInformation(this, "SQL statement modified. Result: " + sql);
        }
        int commentStripLength = Short.MAX_VALUE;
        if (connection != null) {
            int n = commentStripLength = connection.getVRM() >= JDUtilities.vrm540 ? 0x1FFFFF : Short.MAX_VALUE;
        }
        if (length > commentStripLength) {
            String old = sql;
            JDSQLTokenizer commentStripper = new JDSQLTokenizer(sql, " \t\n\r\f", true, false);
            sql = commentStripper.toString();
            if (old.length() != sql.length()) {
                for (i = 0; i < statementListeners_.size(); ++i) {
                    AS400JDBCStatementListener listener = (AS400JDBCStatementListener)statementListeners_.elementAt(i);
                    listener.commentsStripped(connection, old, sql);
                }
            }
        }
        this.value_ = convert ? JDEscapeClause.parse(sql, decimalSeparator, connection.getVRM()) : sql;
        this.value_ = AS400BidiTransform.convertSQLToHostCCSID(this.value_, connection);
        this.tokenizer_ = new JDSQLTokenizer(this.value_, " \t\n\r\f", false, false);
        this.numberOfParameters_ = this.tokenizer_.getNumberOfParameters();
        String firstWord = "";
        while (firstWord.length() == 0 && this.tokenizer_.hasMoreTokens()) {
            String word = this.tokenizer_.nextToken();
            int len = word.length();
            for (i = 0; i < len && word.charAt(i) == '('; ++i) {
            }
            if (i >= len) continue;
            firstWord = word.substring(i).toUpperCase();
        }
        if (firstWord.startsWith(SELECT_) || firstWord.equals(WITH_) || firstWord.startsWith(VALUES_)) {
            this.isSelect_ = true;
            this.nativeType_ = 2;
        } else if (firstWord.equals(CALL_)) {
            this.isCall_ = true;
            this.nativeType_ = 3;
            if (this.value_.indexOf(METADATA_CALL) == 0) {
                this.isMetaDataCall_ = true;
            }
            if (this.value_.indexOf("WLM_SET_CLIENT_INFO") > 0) {
                this.isSetSpecialRegister_ = true;
            }
        } else if (firstWord.equals(CALL0_) || firstWord.equals(CALL1_) || firstWord.equals(CALL2_)) {
            this.isCall_ = true;
            this.nativeType_ = 3;
            this.hasReturnValueParameter_ = true;
            --this.numberOfParameters_;
        } else if (firstWord.equals(CONNECT_) || firstWord.equals(CONNECTION_) || firstWord.equals(DISCONNECT_)) {
            this.nativeType_ = 6;
            if (firstWord.equals(CONNECT_)) {
                this.isDRDAConnect_ = true;
            } else if (firstWord.equals(DISCONNECT_)) {
                this.isDRDADisconnect_ = true;
            }
        } else if (firstWord.equals(RELEASE_)) {
            upperCaseSql = this.value_.toUpperCase();
            k = upperCaseSql.indexOf("SAVEPOINT");
            if (k < 0) {
                this.nativeType_ = 6;
            }
        } else if (firstWord.equals(INSERT_)) {
            int m;
            this.isInsert_ = true;
            upperCaseSql = this.value_.toUpperCase();
            k = upperCaseSql.indexOf(ROWS_);
            int len = upperCaseSql.length();
            if (k != -1) {
                k += 4;
                while (k < len && Character.isWhitespace(upperCaseSql.charAt(k))) {
                    ++k;
                }
                if (upperCaseSql.regionMatches(k, VALUES_, 0, 6)) {
                    this.nativeType_ = 7;
                }
            }
            if ((m = upperCaseSql.indexOf(VALUES_)) != -1) {
                String valuesString;
                m += 6;
                while (m < len && Character.isWhitespace(upperCaseSql.charAt(m))) {
                    ++m;
                }
                int lastParen = upperCaseSql.lastIndexOf(")");
                if (lastParen >= 1 && lastParen > m) {
                    valuesString = upperCaseSql.substring(m + 1, lastParen);
                    StringTokenizer tokenizer = new StringTokenizer(valuesString, ", ?\n\r\t");
                    if (!tokenizer.hasMoreTokens()) {
                        this.canBeBatched_ = true;
                    }
                } else {
                    valuesString = upperCaseSql.substring(m);
                    if (valuesString.trim().equals(CALL0_)) {
                        this.canBeBatched_ = true;
                    }
                }
            }
        } else if (firstWord.equals(UPDATE_) || firstWord.equals(DELETE_)) {
            if (connection.getVRM() >= JDUtilities.vrm710 && connection.doUpdateDeleteBlocking()) {
                this.canBeBatched_ = true;
            }
            this.isUpdateOrDelete_ = true;
        } else if (firstWord.equals(MERGE_)) {
            if (connection.getVRM() >= JDUtilities.vrm710) {
                this.canBeBatched_ = true;
            }
        } else if (firstWord.equals(DECLARE_)) {
            this.isDeclare_ = true;
        } else if (firstWord.equals(SET_)) {
            this.isSet_ = true;
            this.nativeType_ = 0;
        }
        if (this.isCall_) {
            int parenPos;
            while (this.tokenizer_.hasMoreTokens() && !firstWord.endsWith(CALL_)) {
                firstWord = this.tokenizer_.nextToken().toUpperCase();
            }
            String token = this.tokenizer_.nextToken();
            int index = token.indexOf(40);
            if (index != -1) {
                token = token.substring(0, index);
            }
            String namingSeparator = connection.getProperties().getString(9).equalsIgnoreCase("sql") ? "." : "/";
            String qualifiedProcedure = null;
            StringBuffer buf = null;
            int schemaDelimEndIndex = -1;
            int separatorPos = token.indexOf(namingSeparator);
            if (token.indexOf(34) == -1 && separatorPos > 0 && separatorPos < token.length() - 1) {
                qualifiedProcedure = token;
            } else if (token.endsWith(namingSeparator)) {
                if (this.tokenizer_.hasMoreTokens()) {
                    buf = new StringBuffer(token);
                    buf.append(this.tokenizer_.nextToken());
                }
            } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().equals(namingSeparator)) {
                schemaDelimEndIndex = token.length();
                buf = new StringBuffer(token);
                buf.append(this.tokenizer_.nextToken());
                if (this.tokenizer_.hasMoreTokens()) {
                    buf.append(this.tokenizer_.nextToken());
                }
            } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().startsWith(namingSeparator)) {
                schemaDelimEndIndex = token.length();
                buf = new StringBuffer(token);
                buf.append(this.tokenizer_.nextToken());
            } else {
                qualifiedProcedure = token;
            }
            if (buf != null && (parenPos = (qualifiedProcedure = buf.toString()).indexOf(40)) != -1) {
                qualifiedProcedure = qualifiedProcedure.substring(0, parenPos);
            }
            buf = null;
            index = schemaDelimEndIndex == -1 ? qualifiedProcedure.indexOf(namingSeparator) : schemaDelimEndIndex;
            if (index == -1) {
                this.csProcedure_ = JDUtilities.upperCaseIfNotQuoted(qualifiedProcedure);
                this.csSchema_ = "";
            } else {
                this.csProcedure_ = JDUtilities.upperCaseIfNotQuoted(qualifiedProcedure.substring(index + 1));
                this.csSchema_ = JDUtilities.upperCaseIfNotQuoted(qualifiedProcedure.substring(0, index));
            }
        }
        boolean isSecondToken = true;
        while (this.tokenizer_.hasMoreTokens()) {
            String token = this.tokenizer_.nextToken().toUpperCase();
            if (this.isInsert_ && token.equals(SELECT_)) {
                this.isSubSelect_ = true;
            } else if (token.equals(CURRENT_) && this.tokenizer_.hasMoreTokens() && this.tokenizer_.nextToken().equalsIgnoreCase(OF_)) {
                this.isCurrentOf_ = true;
            } else if (token.equals(FOR_)) {
                this.parseFor();
            } else if (this.isSelect_ && token.equals(FROM_) && this.selectTableNotSet_) {
                this.selectTableNotSet_ = false;
                if (this.tokenizer_.hasMoreTokens() && !(token = this.tokenizer_.nextToken()).startsWith(LPAREN_)) {
                    String namingSeparator = connection.getProperties().getString(9).equalsIgnoreCase("sql") ? "." : "/";
                    if (token.endsWith(namingSeparator)) {
                        StringBuilder table = new StringBuilder(token);
                        if (this.tokenizer_.hasMoreTokens()) {
                            table.append(this.tokenizer_.nextToken());
                        }
                        this.selectTable_ = table.toString();
                    } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().equals(namingSeparator)) {
                        StringBuilder table = new StringBuilder(token);
                        table.append(this.tokenizer_.nextToken());
                        if (this.tokenizer_.hasMoreTokens()) {
                            table.append(this.tokenizer_.nextToken());
                        }
                        this.selectTable_ = table.toString();
                    } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().startsWith(namingSeparator)) {
                        StringBuilder table = new StringBuilder(token);
                        table.append(this.tokenizer_.nextToken());
                        this.selectTable_ = table.toString();
                    } else {
                        this.selectTable_ = token;
                    }
                    int stLen = this.selectTable_.length();
                    if (this.selectTable_.charAt(stLen - 1) == ')') {
                        this.selectTable_ = this.selectTable_.substring(0, stLen - 1);
                    }
                    if (this.tokenizer_.hasMoreTokens()) {
                        token = this.tokenizer_.nextToken().toUpperCase();
                        if (token.equals(AS_) && this.tokenizer_.hasMoreTokens()) {
                            this.correlationName_ = this.tokenizer_.nextToken().toUpperCase();
                        } else if (token.equals(FOR_)) {
                            this.parseFor();
                        }
                    }
                }
            } else if (this.isSet_ && isSecondToken && token.equals(CONNECTION_)) {
                this.nativeType_ = 6;
            } else if (this.isSet_ && isSecondToken && (token.equals(CURRENT_) || token.equals("PATH") || token.equals("SESSION") || token.equals("SCHEMA") || token.equals("CURRENT_SCHEMA") || token.equals("COLLECTION"))) {
                this.isSetSpecialRegister_ = true;
            }
            isSecondToken = false;
        }
        boolean intermediate = this.numberOfParameters_ > 0 || this.isInsert_ && this.isSubSelect_ || this.isCurrentOf_ && this.isUpdateOrDelete_;
        this.isImmediatelyExecutable_ = !intermediate && !this.isSelect_;
        boolean bl = this.isPackaged_ = this.numberOfParameters_ > 0 && !this.isCurrentOf_ || this.isInsert_ && this.isSubSelect_ || this.isSelect_ && this.isForUpdate_ || this.isDeclare_;
        if (packageCriteria.equalsIgnoreCase("select")) {
            boolean bl2 = this.isPackaged_ = this.isPackaged_ || this.isSelect_;
        }
        if (this.hasReturnValueParameter_ && (call = this.value_.toUpperCase().indexOf(CALL_)) != -1) {
            this.value_ = this.value_.substring(call);
        }
        this.value_ = this.value_.trim();
        this.tokenizer_ = null;
    }

    boolean canBatch() {
        return this.canBeBatched_;
    }

    int countParameters() {
        return this.numberOfParameters_;
    }

    String getCorrelationName() {
        return this.correlationName_;
    }

    int getNativeType() {
        return this.nativeType_;
    }

    int getNumOfParameters() {
        return this.numberOfParameters_;
    }

    String getProcedure() {
        return this.csProcedure_;
    }

    String getSchema() {
        return this.csSchema_;
    }

    String getSelectTable() {
        return this.selectTable_;
    }

    boolean hasReturnValueParameter() {
        return this.hasReturnValueParameter_;
    }

    boolean isDRDAConnect() {
        return this.isDRDAConnect_;
    }

    boolean isDRDADisconnect() {
        return this.isDRDADisconnect_;
    }

    boolean isForFetchOnly() {
        return this.isForFetchOrReadOnly_;
    }

    boolean isForUpdate() {
        return this.isForUpdate_;
    }

    boolean isImmediatelyExecutable() {
        return this.isImmediatelyExecutable_;
    }

    boolean isPackaged() {
        return this.isPackaged_;
    }

    boolean isProcedureCall() {
        return this.isCall_;
    }

    boolean isSelect() {
        return this.isSelect_;
    }

    private void parseFor() {
        if (this.tokenizer_.hasMoreTokens()) {
            String token = this.tokenizer_.nextToken().toUpperCase();
            if (token.equals(FETCH_) || token.equals(READ_)) {
                if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.nextToken().equalsIgnoreCase(ONLY_)) {
                    this.isForFetchOrReadOnly_ = true;
                }
            } else if (token.equals(UPDATE_)) {
                this.isForUpdate_ = true;
            }
        }
    }

    public void setNativeType(int type) {
        this.nativeType_ = type;
    }

    public void setSelectFromInsert(boolean selectFromInsert) {
        this.selectFromInsert_ = selectFromInsert;
    }

    public boolean isSelectFromInsert() {
        return this.selectFromInsert_;
    }

    public String toString() {
        return this.value_;
    }

    boolean getIsMetaDataCall() {
        return this.isMetaDataCall_;
    }

    public boolean isSetSpecialRegister() {
        return this.isSetSpecialRegister_;
    }

    static {
        String classNames = SystemProperties.getProperty("com.ibm.as400.access.JDBC.statementListeners");
        if (classNames != null) {
            StringTokenizer st = new StringTokenizer(classNames, COMMA_);
            while (st.hasMoreTokens()) {
                try {
                    String clazz = st.nextToken();
                    JDSQLStatement.addStatementListener((AS400JDBCStatementListener)Class.forName(clazz).newInstance());
                    Trace.log(3, "Successfully loaded JDBC statement listener " + clazz);
                }
                catch (Throwable t) {
                    Trace.log(4, "Error instantiating JDBC statement listener: ", t);
                }
            }
        }
    }
}

