/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionRedirect;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCSQLSyntaxErrorException;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.AS400JDBCTransientException;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBSQLResultSetDS;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLWarning;
import java.util.Map;

final class JDError {
    static final String EXC_ACCESS_MISMATCH = "42505";
    static final String EXC_ATTRIBUTE_VALUE_INVALID = "HY024";
    static final String EXC_BUFFER_LENGTH_INVALID = "HY090";
    static final String EXC_CHAR_CONVERSION_INVALID = "22524";
    static final String EXC_CCSID_INVALID = "22522";
    static final String EXC_COLUMN_NOT_FOUND = "42703";
    static final String EXC_CONCURRENCY_INVALID = "HY108";
    static final String EXC_CONNECTION_NONE = "08003";
    static final String EXC_CONNECTION_REJECTED = "08004";
    static final String EXC_CONNECTION_UNABLE = "08001";
    static final String EXC_COMMUNICATION_LINK_FAILURE = "08S01";
    static final String EXC_CURSOR_NAME_AMBIGUOUS = "3C000";
    static final String EXC_CURSOR_NAME_INVALID = "34000";
    static final String EXC_CURSOR_POSITION_INVALID = "HY109";
    static final String EXC_CURSOR_STATE_INVALID = "24000";
    static final String EXC_DATA_TYPE_INVALID = "HY004";
    static final String EXC_DATA_TYPE_MISMATCH = "07006";
    static final String EXC_DESCRIPTOR_INDEX_INVALID = "07009";
    static final String EXC_FUNCTION_NOT_SUPPORTED = "IM001";
    static final String EXC_FUNCTION_SEQUENCE = "HY010";
    static final String EXC_INTERNAL = "HY000";
    static final String EXC_MAX_STATEMENTS_EXCEEDED = "HY014";
    static final String EXC_OPERATION_CANCELLED = "HY008";
    static final String EXC_PARAMETER_COUNT_MISMATCH = "07001";
    static final String EXC_PARAMETER_TYPE_INVALID = "HY105";
    static final String EXC_SCALE_INVALID = "HY094";
    static final String EXC_SERVER_ERROR = "HY001";
    static final String EXC_SYNTAX_BLANK = "43617";
    static final String EXC_SYNTAX_ERROR = "42601";
    static final String EXC_TXN_STATE_INVALID = "25000";
    static final String EXC_SQL_STATEMENT_TOO_LONG = "54001";
    static final String EXC_SAVEPOINT_INVALID_IN_CONTEXT = "3B001";
    static final String EXC_SAVEPOINT_ALREADY_EXISTS = "3B501";
    static final String EXC_SAVEPOINT_DOES_NOT_EXIST = "3B502";
    static final String EXC_RDB_DOES_NOT_EXIST = "42705";
    static final String EXC_XML_PARSING_ERROR = "2200M";
    static final String EXC_CONNECTION_REESTABLISHED = "08506";
    static final String WARN_ATTRIBUTE_VALUE_CHANGED = "01608";
    static final String WARN_EXTENDED_DYNAMIC_DISABLED = "01H11";
    static final String WARN_OPTION_VALUE_CHANGED = "01S02";
    static final String WARN_PACKAGE_CACHE_DISABLED = "01H12";
    static final String WARN_PROPERTY_EXTRA_IGNORED = "01H20";
    static final String WARN_TXN_COMMITTED = "01H30";
    static final String WARN_URL_EXTRA_IGNORED = "01H10";
    static final String WARN_URL_SCHEMA_INVALID = "01H13";
    static final String WARN_1000_OPEN_STATEMENTS = "01G00";

    private JDError() {
    }

    static final String getReason(String sqlState, String[] replacementVariables) {
        return AS400JDBCDriver.getResource("JD" + sqlState, replacementVariables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getReason(AS400JDBCConnection connection, int id, int returnCode) throws SQLException {
        String string;
        DBReplyRequestedDS reply;
        block22: {
            boolean secondLevelText = connection.getProperties().equals(6, "full");
            int orsBitmap = -503316480;
            if (secondLevelText) {
                orsBitmap += 0x10000000;
            }
            DBSQLResultSetDS request = null;
            reply = null;
            try {
                request = DBDSPool.getDBSQLResultSetDS(7936, id, orsBitmap, 0);
                reply = connection.sendAndReceive(request, id);
                DBReplySQLCA sqlca = reply.getSQLCA();
                StringBuilder errorDescription = new StringBuilder();
                errorDescription.append("[");
                errorDescription.append(reply.getMessageId());
                errorDescription.append("] ");
                boolean textAppended = false;
                int absReturnCode = Math.abs(returnCode);
                if ((absReturnCode == 438 || absReturnCode == 443) && connection.getVRM() < JDUtilities.vrm540) {
                    try {
                        if (sqlca.getErrd(4) == 0) {
                            if (absReturnCode == 438) {
                                String errorString = sqlca.getErrmc(connection.getConverter());
                                errorDescription.append(errorString);
                                textAppended = true;
                            } else if (absReturnCode == 443) {
                                errorDescription.append(sqlca.getErrmc(6, connection.getConverter()));
                                textAppended = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        JDTrace.logException(null, e.getMessage(), e);
                    }
                }
                if (!textAppended) {
                    errorDescription.append(reply.getFirstLevelMessageText());
                    if (secondLevelText) {
                        errorDescription.append(" ");
                        errorDescription.append(reply.getSecondLevelMessageText());
                    }
                }
                String lastSqlState = sqlca.getSQLState(connection.getConverter());
                connection.setLastServerSQLState(lastSqlState);
                if (lastSqlState == null) {
                    connection.setLastServerSQLState(EXC_SERVER_ERROR);
                }
                string = errorDescription.toString();
                if (request == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                catch (DBDataStreamException e) {
                    return JDError.getReason(EXC_INTERNAL, null);
                }
                catch (SQLException e) {
                    String sqlState = e.getSQLState();
                    if (sqlState.equals(EXC_CONNECTION_REESTABLISHED)) {
                        throw e;
                    }
                    if (sqlState.equals(EXC_CONNECTION_NONE)) {
                        return JDError.getReason(EXC_CONNECTION_NONE, null);
                    }
                    return JDError.getReason(EXC_INTERNAL, null);
                }
            }
            request.returnToPool();
            request = null;
        }
        if (reply != null) {
            reply.returnToPool();
            reply = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getSQLState(AS400JDBCConnection connection, int id) {
        String string;
        DBReplyRequestedDS reply;
        block11: {
            String lastServerSQLState = connection.getLastServerSQLState();
            if (lastServerSQLState != null) {
                connection.setLastServerSQLState(null);
                return lastServerSQLState;
            }
            int orsBitmap = -2113929216;
            DBSQLResultSetDS request = null;
            reply = null;
            try {
                request = DBDSPool.getDBSQLResultSetDS(7936, id, orsBitmap, 0);
                reply = connection.sendAndReceive(request, id);
                String sqlState = reply.getSQLCA().getSQLState(connection.getConverter());
                if (sqlState == null) {
                    sqlState = EXC_SERVER_ERROR;
                }
                string = sqlState;
                if (request == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (reply != null) {
                        reply.returnToPool();
                        reply = null;
                    }
                    throw throwable;
                }
                catch (DBDataStreamException e) {
                    return EXC_INTERNAL;
                }
                catch (SQLException e) {
                    return EXC_INTERNAL;
                }
            }
            request.returnToPool();
            request = null;
        }
        if (reply != null) {
            reply.returnToPool();
            reply = null;
        }
        return string;
    }

    public static SQLWarning getSQLWarning(String sqlState) {
        String reason = JDError.getReason(sqlState, null);
        int sqlCode = JDError.getSqlCode(sqlState);
        SQLWarning warning = new SQLWarning(reason, sqlState, sqlCode);
        if (JDTrace.isTraceOn()) {
            String message = "Posting warning, sqlState: " + sqlState + " reason: " + reason + " vendor code " + sqlCode;
            JDTrace.logException(null, message, warning);
        }
        return warning;
    }

    public static SQLWarning getSQLWarning(AS400JDBCConnection connection, int id, int errorClass, int returnCode) throws SQLException {
        String reason = returnCode != 0 ? JDError.getReason(connection, id, returnCode) : "";
        String state = JDError.getSQLState(connection, id);
        SQLWarning warning = new SQLWarning(reason, state, returnCode);
        if (JDTrace.isTraceOn()) {
            String message = "Posting warning, id: " + id + " error class: " + errorClass + " return code: " + returnCode + " reason: " + reason + " state: " + state;
            JDTrace.logException(connection, message, warning);
        }
        return warning;
    }

    public static void throwSQLException(String sqlState) throws SQLException {
        JDError.throwSQLException(null, sqlState);
    }

    public static SQLException throwSQLException(Object thrower, String sqlState) throws SQLException {
        String reason = JDError.getReason(sqlState, null);
        int sqlCode = JDError.getSqlCode(sqlState);
        SQLException e = JDError.createSQLExceptionSubClass(thrower, reason, sqlState, sqlCode);
        if (JDTrace.isTraceOn()) {
            String message = "Throwing exception, sqlState: " + sqlState + " reason: " + reason + " vendor code " + sqlCode;
            JDTrace.logException(thrower, message, e);
        }
        throw e;
    }

    private static int getSqlCode(String sqlState) {
        if (sqlState.equals(EXC_CONNECTION_REESTABLISHED)) {
            return -4498;
        }
        return -99999;
    }

    public static void throwSQLException(String sqlState, Exception e) throws SQLException {
        JDError.throwSQLException(null, sqlState, e);
    }

    public static void throwSQLException(String sqlState, String message) throws SQLException {
        JDError.throwSQLException(null, sqlState, message);
    }

    public static void throwSQLException(Object thrower, String sqlState, String message) throws SQLException {
        String reason = JDError.getReason(sqlState, null);
        StringBuilder buffer = new StringBuilder(reason);
        if (message != null) {
            buffer.append(" (");
            buffer.append(message);
            buffer.append(')');
        }
        int sqlCode = JDError.getSqlCode(sqlState);
        SQLException e2 = JDError.createSQLExceptionSubClass(thrower, buffer.toString(), sqlState, sqlCode);
        if (JDTrace.isTraceOn()) {
            String m2 = "Throwing exception. Message text: " + message;
            JDTrace.logInformation(thrower, m2);
            m2 = "Throwing exception.  Actual exception: " + buffer.toString() + " sqlState: " + sqlState + " vendor code " + sqlCode;
            JDTrace.logException(thrower, m2, e2);
        }
        throw e2;
    }

    public static void throwSQLException(Object thrower, String sqlState, Exception e) throws SQLException {
        JDError.throwSQLException(thrower, sqlState, null, e);
    }

    public static void throwSQLException(Object thrower, String sqlState, String[] replacementVariables, Exception e) throws SQLException {
        String reason = JDError.getReason(sqlState, replacementVariables);
        StringBuilder buffer = new StringBuilder(reason);
        if (e != null) {
            buffer.append(" (");
            String message = e.getMessage();
            if (message != null) {
                buffer.append(message);
            } else {
                buffer.append(e.getClass());
            }
            buffer.append(')');
        }
        int sqlCode = JDError.getSqlCode(sqlState);
        SQLException e2 = JDError.createSQLExceptionSubClass(thrower, buffer.toString(), sqlState, sqlCode);
        if (JDTrace.isTraceOn()) {
            Object m2 = "Throwing exception. Original exception: ";
            if (e != null) {
                JDTrace.logException(thrower, (String)m2, e);
            } else {
                JDTrace.logInformation("Original exception was was null");
            }
            m2 = "Throwing exception.  Actual exception: " + buffer.toString() + " sqlState: " + sqlState + " vendor code " + sqlCode;
            JDTrace.logException(thrower, (String)m2, e2);
        }
        if (e != null) {
            e2.initCause(e);
        }
        throw e2;
    }

    public static void throwSQLException(Object thrower, String sqlState, Exception e, String m) throws SQLException {
        String reason = JDError.getReason(sqlState, null);
        StringBuilder buffer = new StringBuilder(reason);
        buffer.append(" (");
        String message = e.getMessage();
        if (message != null) {
            buffer.append(message);
        } else {
            buffer.append(e.getClass());
        }
        buffer.append(", ");
        buffer.append(m);
        buffer.append(')');
        int sqlCode = JDError.getSqlCode(sqlState);
        SQLException e2 = JDError.createSQLExceptionSubClass(thrower, buffer.toString(), sqlState, sqlCode);
        if (JDTrace.isTraceOn()) {
            Object m2 = "Throwing exception. Original exception: ";
            JDTrace.logException(thrower, (String)m2, e);
            m2 = "Throwing exception.  Actual exception: " + buffer.toString() + " sqlState: " + sqlState + " vendor code " + sqlCode;
            JDTrace.logException(thrower, (String)m2, e2);
        }
        try {
            e2.initCause(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw e2;
    }

    public static void throwSQLException(AS400JDBCConnection connection, int id, int errorClass, int returnCode) throws SQLException {
        JDError.throwSQLException(null, connection, id, errorClass, returnCode);
    }

    public static SQLException throwSQLException(Object thrower, AS400JDBCConnection connection, int id, int errorClass, int returnCode) throws SQLException {
        String reason = JDError.getReason(connection, id, returnCode);
        String state = JDError.getSQLState(connection, id);
        SQLException e = JDError.createSQLExceptionSubClass(thrower, reason, state, returnCode);
        if (JDTrace.isTraceOn()) {
            String message = "Throwing exception, id: " + id + " error class: " + errorClass + " return code: " + returnCode + " reason: " + reason + " state: " + state;
            JDTrace.logException(thrower, connection, message, e);
        }
        if (connection instanceof AS400JDBCConnectionRedirect) {
            ((AS400JDBCConnectionRedirect)connection).handleException(e);
        }
        throw e;
    }

    public static SQLException throwSQLException(Object thrower, SQLException exception) throws SQLException {
        String reason = exception.getMessage();
        String state = exception.getSQLState();
        int returnCode = exception.getErrorCode();
        SQLException e = JDError.createSQLExceptionSubClass(thrower, reason, state, returnCode);
        try {
            e.setNextException(exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (JDTrace.isTraceOn()) {
            String message = "Throwing exception,  return code: " + returnCode + " reason: " + reason + " state: " + state;
            JDTrace.logException(thrower, message, e);
        }
        throw e;
    }

    public static SQLException throwSQLClientInfoException(Object thrower, String sqlState, Exception e, Map m) throws SQLClientInfoException {
        String reason = JDError.getReason(sqlState, null);
        StringBuilder buffer = new StringBuilder(reason);
        buffer.append(" (");
        String message = e.getMessage();
        if (message != null) {
            buffer.append(message);
        } else {
            buffer.append(e.getClass());
        }
        buffer.append(')');
        int sqlCode = JDError.getSqlCode(sqlState);
        SQLClientInfoException e2 = new SQLClientInfoException(buffer.toString(), sqlState, sqlCode, m);
        if (JDTrace.isTraceOn()) {
            Object m2 = "Throwing exception. Original exception: ";
            JDTrace.logException(thrower, (String)m2, e);
            m2 = "Throwing exception.  Actual exception: " + buffer.toString() + " sqlState: " + sqlState + " vendor code " + sqlCode;
            JDTrace.logException(thrower, (String)m2, e2);
        }
        if (e != null) {
            e2.initCause(e);
        }
        throw e2;
    }

    public static SQLException createSQLExceptionSubClass(Object thrower, String message, String sqlState, int vendorCode) {
        char digit0 = sqlState.charAt(0);
        char digit1 = sqlState.charAt(1);
        switch (digit0) {
            case '0': {
                switch (digit1) {
                    case 'A': {
                        return new SQLFeatureNotSupportedException(message, sqlState, vendorCode);
                    }
                    case '8': {
                        if (vendorCode == -30082) {
                            return new SQLInvalidAuthorizationSpecException(message, sqlState, vendorCode);
                        }
                        if (vendorCode == -4498) {
                            return new AS400JDBCTransientException(message, sqlState, vendorCode);
                        }
                        return new SQLNonTransientConnectionException(message, sqlState, vendorCode);
                    }
                }
                return new SQLException(message, sqlState, vendorCode);
            }
            case '2': {
                switch (digit1) {
                    case '2': {
                        return new SQLDataException(message, sqlState, vendorCode);
                    }
                    case '3': {
                        return new SQLIntegrityConstraintViolationException(message, sqlState, vendorCode);
                    }
                    case '8': {
                        return new SQLInvalidAuthorizationSpecException(message, sqlState, vendorCode);
                    }
                }
                return new SQLException(message, sqlState, vendorCode);
            }
            case '4': {
                switch (digit1) {
                    case '0': {
                        return new SQLTransactionRollbackException(message, sqlState, vendorCode);
                    }
                    case '2': {
                        int positionOfSyntaxError = 0;
                        String sqlStatementText = null;
                        if (thrower instanceof AS400JDBCStatement) {
                            try {
                                positionOfSyntaxError = ((AS400JDBCStatement)thrower).getPositionOfSyntaxError();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            JDSQLStatement jdsqlStatement = ((AS400JDBCStatement)thrower).getJDSQLStatement();
                            if (jdsqlStatement != null) {
                                sqlStatementText = jdsqlStatement.toString();
                            }
                        }
                        return new AS400JDBCSQLSyntaxErrorException(message, sqlState, vendorCode, positionOfSyntaxError, sqlStatementText);
                    }
                }
                return new SQLException(message, sqlState, vendorCode);
            }
            case '5': {
                if (vendorCode == -952) {
                    return new SQLTimeoutException(message, sqlState, vendorCode);
                }
                return new SQLException(message, sqlState, vendorCode);
            }
            case 'I': {
                if (EXC_FUNCTION_NOT_SUPPORTED.equals(sqlState)) {
                    return new SQLFeatureNotSupportedException(message, sqlState, vendorCode);
                }
                return new SQLException(message, sqlState, vendorCode);
            }
            case 'H': {
                if ("HY017".equals(sqlState)) {
                    return new SQLNonTransientConnectionException(message, sqlState, vendorCode);
                }
                return new SQLException(message, sqlState, vendorCode);
            }
        }
        return new SQLException(message, sqlState, vendorCode);
    }
}

