/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.QueuedMessageEnumeration;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;

public class HistoryLog {
    static final long serialVersionUID = 4L;
    public static final String CURRENT_DATE = "*CURRENT";
    public static final String BEGIN = "*BEGIN";
    public static final String END = "*END";
    public static final String AVAIL = "*AVAIL";
    public static final int OMIT = 1;
    public static final int SELECT = 0;
    public static final String TYPE_COMPLETION = "*COMP";
    public static final String TYPE_COPY = "*COPY";
    public static final String TYPE_DIAGNOSTIC = "*DIAG";
    public static final String TYPE_ESCAPE = "*ESCAPE";
    public static final String TYPE_INFORMATIONAL = "*INFO";
    public static final String TYPE_INQUIRY = "*INQ";
    public static final String TYPE_NOTIFY = "*NOTIFY";
    public static final String TYPE_REPLY = "*RPY";
    public static final String TYPE_REQUEST = "*RQS";
    private String startingDate_ = "*CURRENT";
    private String startingTime_ = "*AVAIL";
    private String endingDate_ = "*END";
    private String endingTime_ = "*AVAIL";
    private Job[] jobsToList_ = new Job[0];
    private String[] messageIDs_ = new String[0];
    private int idListIndicator_ = 0;
    private int messageSeverity_ = 0;
    private int typesListIndicator_ = 0;
    private String[] messageTypes_ = new String[0];
    private AS400 system_;
    private int length_;
    private byte[] handle_;
    private boolean closeHandle_ = false;

    public HistoryLog(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing HistoryLog object, system: " + String.valueOf(system));
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing job log message list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        try {
            ListUtilities.closeList(this.system_, this.handle_);
        }
        finally {
            this.handle_ = null;
            this.closeHandle_ = false;
        }
    }

    public int getLength() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting history log list length.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public Enumeration<QueuedMessage> getMessages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving history log message list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        return new QueuedMessageEnumeration(this, this.length_);
    }

    public QueuedMessage[] getMessages(int listOffset, int number) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving history log message list, list offset: " + listOffset + ", number:", number);
        }
        if (listOffset < -1) {
            throw new ExtendedIllegalArgumentException("listOffset (" + listOffset + ")", 4);
        }
        if (number < 0 && listOffset != -1) {
            throw new ExtendedIllegalArgumentException("number (" + number + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (this.length_ == 0 || number == 0 && listOffset != -1) {
            return new QueuedMessage[0];
        }
        if (listOffset == -1) {
            number = this.length_;
            listOffset = 0;
        } else {
            if (listOffset >= this.length_) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Value of parameter 'listOffset' is beyond end of list:", listOffset + " (list length: " + this.length_ + ")");
                }
                return new QueuedMessage[0];
            }
            if (listOffset + number > this.length_) {
                number = this.length_ - listOffset;
            }
        }
        int lengthOfReceiverVariable = 1024 * number;
        byte[] data = ListUtilities.retrieveListEntries(this.system_, this.handle_, lengthOfReceiverVariable, number, listOffset, null);
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        QueuedMessage[] messages = new QueuedMessage[number];
        int offset = 0;
        for (int i = 0; i < messages.length; ++i) {
            int entryLength = BinaryConverter.byteArrayToInt(data, offset);
            int messageSeverity = BinaryConverter.byteArrayToInt(data, offset + 4);
            String messageIdentifier = conv.byteArrayToString(data, offset + 8, 7).trim();
            int messageType = (data[offset + 15] & 0xF) * 10 + (data[offset + 16] & 0xF);
            if (messageType == 0) {
                messageType = -1;
            }
            String messageFileName = conv.byteArrayToString(data, offset + 17, 10).trim();
            String messageFileLibrarySpecified = conv.byteArrayToString(data, offset + 27, 10).trim();
            String dateSent = conv.byteArrayToString(data, offset + 37, 7);
            String timeSent = conv.byteArrayToString(data, offset + 44, 6);
            String fromJob = conv.byteArrayToString(data, offset + 56, 10).trim();
            String fromJobUser = conv.byteArrayToString(data, offset + 66, 10).trim();
            String fromJobNumber = conv.byteArrayToString(data, offset + 76, 6);
            String currentUser = conv.byteArrayToString(data, offset + 82, 10).trim();
            int locOfMessageData = BinaryConverter.byteArrayToInt(data, offset + 96);
            int lengthOfMessageData = BinaryConverter.byteArrayToInt(data, offset + 100);
            int locOfReplacementData = BinaryConverter.byteArrayToInt(data, offset + 104);
            int lengthOfReplacementData = BinaryConverter.byteArrayToInt(data, offset + 108);
            String messageText = conv.byteArrayToString(data, offset + locOfMessageData, lengthOfMessageData);
            byte[] replacementDataBytes = new byte[lengthOfReplacementData];
            System.arraycopy(data, offset + locOfReplacementData, replacementDataBytes, 0, lengthOfReplacementData);
            messages[i] = new QueuedMessage(this.system_, messageSeverity, messageIdentifier, messageType, messageFileName, messageFileLibrarySpecified, dateSent, timeSent, fromJob, fromJobUser, fromJobNumber, currentUser, messageText, replacementDataBytes);
            offset += entryLength;
        }
        return messages;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + String.valueOf(this.system_));
        }
        return this.system_;
    }

    public synchronized void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int i;
        int offsetToVariableInformation;
        if (Trace.traceOn_) {
            Trace.log(1, "Loading history log message list.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.closeHandle_) {
            this.close();
        }
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        int numMessageIDs = this.messageIDs_.length;
        int sizeMessageIDs = numMessageIDs * 7;
        int numJobs = this.jobsToList_.length;
        int sizeJobs = numJobs * 26;
        int numMessageTypes = this.messageTypes_.length;
        int sizeMessageTypes = numMessageTypes * 10;
        int offsetToMessageIDs = offsetToVariableInformation = 92;
        int offsetToJobs = offsetToMessageIDs + sizeMessageIDs;
        int offsetToMessageTypes = offsetToJobs + sizeJobs;
        byte[] messageSelectionInformation = new byte[92 + sizeMessageIDs + sizeJobs + sizeMessageTypes];
        BinaryConverter.intToByteArray(92, messageSelectionInformation, 0);
        for (i = 4; i < 56; ++i) {
            messageSelectionInformation[i] = 64;
        }
        conv.stringToByteArray(this.startingDate_, messageSelectionInformation, 4);
        conv.stringToByteArray(this.startingTime_, messageSelectionInformation, 14);
        for (i = 24; i < 30; ++i) {
            messageSelectionInformation[i] = 0;
        }
        conv.stringToByteArray(this.endingDate_, messageSelectionInformation, 30);
        conv.stringToByteArray(this.endingTime_, messageSelectionInformation, 40);
        for (i = 50; i < 56; ++i) {
            messageSelectionInformation[i] = 0;
        }
        BinaryConverter.intToByteArray(this.idListIndicator_, messageSelectionInformation, 56);
        BinaryConverter.intToByteArray(numMessageIDs == 0 ? 0 : offsetToMessageIDs, messageSelectionInformation, 60);
        BinaryConverter.intToByteArray(numMessageIDs == 0 ? 0 : numMessageIDs, messageSelectionInformation, 64);
        BinaryConverter.intToByteArray(numJobs == 0 ? 0 : offsetToJobs, messageSelectionInformation, 68);
        BinaryConverter.intToByteArray(numJobs == 0 ? 0 : numJobs, messageSelectionInformation, 72);
        BinaryConverter.intToByteArray(this.messageSeverity_, messageSelectionInformation, 76);
        BinaryConverter.intToByteArray(this.typesListIndicator_, messageSelectionInformation, 80);
        BinaryConverter.intToByteArray(numMessageTypes == 0 ? 0 : offsetToMessageTypes, messageSelectionInformation, 84);
        BinaryConverter.intToByteArray(numMessageTypes == 0 ? 0 : numMessageTypes, messageSelectionInformation, 88);
        int padFor = sizeMessageIDs + sizeJobs + sizeMessageTypes;
        for (int n = offsetToMessageIDs; n < offsetToMessageIDs + padFor; ++n) {
            messageSelectionInformation[n] = 64;
        }
        for (int i2 = 0; i2 < numMessageIDs; ++i2) {
            conv.stringToByteArray(this.messageIDs_[i2], messageSelectionInformation, offsetToMessageIDs + 7 * i2);
        }
        for (int j = 0; j < numJobs; ++j) {
            Job job = this.jobsToList_[j];
            conv.stringToByteArray(job.getName().toUpperCase().trim(), messageSelectionInformation, offsetToJobs + 26 * j);
            conv.stringToByteArray(job.getUser().toUpperCase().trim(), messageSelectionInformation, offsetToJobs + 26 * j + 10);
            conv.stringToByteArray(job.getNumber(), messageSelectionInformation, offsetToJobs + 26 * j + 20);
        }
        for (int t = 0; t < numMessageTypes; ++t) {
            conv.stringToByteArray(this.messageTypes_[t], messageSelectionInformation, offsetToMessageTypes + 10 * t);
        }
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(conv.stringToByteArray("HSTL0100")), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(messageSelectionInformation), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(conv.stringToByteArray("*JOB      ")), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QMHOLHST.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] listInformation = parameters[3].getOutputData();
        this.handle_ = new byte[4];
        System.arraycopy(listInformation, 8, this.handle_, 0, 4);
        listInformation = ListUtilities.waitForListToComplete(this.system_, this.handle_, listInformation);
        this.length_ = BinaryConverter.byteArrayToInt(listInformation, 0);
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded history log message list, length: " + this.length_ + ", handle: ", this.handle_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartingDate(String date, String time) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting starting date:  " + date + " " + time);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            if (date == null || date.length() == 0) {
                this.startingDate_ = CURRENT_DATE;
            } else if (date.trim().equalsIgnoreCase(CURRENT_DATE)) {
                this.startingDate_ = CURRENT_DATE;
            } else if (date.trim().equalsIgnoreCase(BEGIN)) {
                this.startingDate_ = BEGIN;
            } else {
                if (date.trim().length() > 7) {
                    throw new ExtendedIllegalArgumentException("date (" + date + ")", 1);
                }
                this.startingDate_ = date;
            }
            if (time == null || time.length() == 0) {
                this.startingTime_ = AVAIL;
            } else if (time.trim().equalsIgnoreCase(AVAIL)) {
                this.startingTime_ = AVAIL;
            } else {
                if (time.trim().length() > 6) {
                    throw new ExtendedIllegalArgumentException("time (" + time + ")", 1);
                }
                this.startingTime_ = time;
            }
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartingDate(Date date) throws ExtendedIllegalArgumentException {
        if (date == null) {
            Trace.log(2, "Parameter 'date' is null.");
            throw new NullPointerException("date");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Setting starting date:  " + String.valueOf(date));
        }
        String start = this.dateToString(date);
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.startingDate_ = start.substring(0, 7);
            this.startingTime_ = start.substring(7);
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public Date getStartingDate() {
        if (this.startingDate_.equals(CURRENT_DATE) || this.startingDate_.equals(BEGIN)) {
            return null;
        }
        return this.stringToDate(this.startingDate_, this.startingTime_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndingDate(String date, String time) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting list ending date " + date + " " + time);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            if (date == null || date.length() == 0) {
                this.endingDate_ = END;
            } else if (date.trim().equalsIgnoreCase(CURRENT_DATE)) {
                this.endingDate_ = CURRENT_DATE;
            } else if (date.trim().equalsIgnoreCase(END)) {
                this.endingDate_ = END;
            } else {
                if (date.trim().length() > 7) {
                    throw new ExtendedIllegalArgumentException("date (" + date + ")", 1);
                }
                this.endingDate_ = date;
            }
            if (time == null || time.length() == 0) {
                this.endingTime_ = AVAIL;
            } else if (time.trim().equalsIgnoreCase(AVAIL)) {
                this.endingTime_ = AVAIL;
            } else {
                if (time.trim().length() > 6) {
                    throw new ExtendedIllegalArgumentException("time (" + time + ")", 1);
                }
                this.endingTime_ = time;
            }
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndingDate(Date date) throws ExtendedIllegalArgumentException {
        if (date == null) {
            Trace.log(2, "Parameter 'date' is null.");
            throw new NullPointerException("date");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Setting list ending date: " + String.valueOf(date));
        }
        String end = this.dateToString(date);
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.endingDate_ = end.substring(0, 7);
            this.endingTime_ = end.substring(7);
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public Date getEndingDate() {
        if (this.endingDate_.equals(CURRENT_DATE) || this.endingDate_.equals(END)) {
            return null;
        }
        return this.stringToDate(this.endingDate_, this.endingTime_);
    }

    private Date stringToDate(String date, String time) {
        Calendar calendar = AS400Calendar.getGregorianInstance();
        int centuryAndYear = Integer.parseInt(date.substring(0, 3));
        int month = Integer.parseInt(date.substring(3, 5));
        int day = Integer.parseInt(date.substring(5, 7));
        boolean timeAvail = time.equals(AVAIL);
        int hour = timeAvail ? 0 : Integer.parseInt(time.substring(0, 2));
        int minute = timeAvail ? 0 : Integer.parseInt(time.substring(2, 4));
        int second = timeAvail ? 0 : Integer.parseInt(time.substring(4));
        calendar.set(1, centuryAndYear + 1900);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private String dateToString(Date date) {
        StringBuilder buffer = new StringBuilder(13);
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        buffer.append(year < 2000 ? (char)'0' : '1');
        buffer.append(this.twoDigits(year % 100));
        buffer.append(this.twoDigits(calendar.get(2) + 1));
        buffer.append(this.twoDigits(calendar.get(5)));
        buffer.append(this.twoDigits(calendar.get(11)));
        buffer.append(this.twoDigits(calendar.get(12)));
        buffer.append(this.twoDigits(calendar.get(13)));
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageIDs(String[] ids) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting list ids");
        }
        if (ids == null) {
            Trace.log(2, "Parameter 'ids' is null.");
            throw new NullPointerException("ids");
        }
        if (ids.length > 100) {
            Trace.log(2, "Length of ids not valid.");
            throw new ExtendedIllegalArgumentException("ids (" + ids.length + ")", 1);
        }
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            int idLength = ids[i].length();
            if (idLength > 7) {
                Trace.log(2, "Length of message id is not valid.  Message ID = " + ids[i]);
                throw new ExtendedIllegalArgumentException("ids[" + i + "] (" + ids[i] + ")", 2);
            }
            if (idLength >= 7) continue;
            StringBuilder buffer = new StringBuilder(ids[i]);
            for (int j = idLength; j < 7; ++j) {
                buffer.append("0");
            }
            ids[i] = buffer.toString();
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.messageIDs_ = ids;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public String[] getMessageIDs() {
        return this.messageIDs_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageIDsListIndicator(int indicator) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message ids list indicator: " + indicator);
        }
        if (indicator != 1 && indicator != 0) {
            throw new ExtendedIllegalArgumentException("indicator(" + indicator + ")", 2);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.idListIndicator_ = indicator;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public int getMessageIDsListIndicator() {
        return this.idListIndicator_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageTypeListIndicator(int indicator) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message type list indicator:  " + indicator);
        }
        if (indicator != 1 && indicator != 0) {
            throw new ExtendedIllegalArgumentException("indicator(" + indicator + ")", 2);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.typesListIndicator_ = indicator;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public int getMessageTypeListIndicator() {
        return this.typesListIndicator_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageTypes(String[] types) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message types");
        }
        if (types == null) {
            Trace.log(2, "Parameter 'types' is null.");
            throw new NullPointerException("types");
        }
        if (types.length > 10) {
            Trace.log(2, "Length of types not valid.");
            throw new ExtendedIllegalArgumentException("types (" + types.length + ")", 1);
        }
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (type.equals(TYPE_COMPLETION) || type.equals(TYPE_COPY) || type.equals(TYPE_DIAGNOSTIC) || type.equals(TYPE_ESCAPE) || type.equals(TYPE_INFORMATIONAL) || type.equals(TYPE_INQUIRY) || type.equals(TYPE_NOTIFY) || type.equals(TYPE_REPLY) || type.equals(TYPE_REQUEST)) continue;
            throw new ExtendedIllegalArgumentException("types[" + i + "] (" + type + ")", 2);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.messageTypes_ = types;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public String[] getMessageTypes() {
        return this.messageTypes_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageSeverity(int severity) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message severity: " + severity);
        }
        if (severity < 0 || severity > 99) {
            throw new ExtendedIllegalArgumentException("severity (" + severity + ")", 2);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.messageSeverity_ = severity;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public int getMessageSeverity() {
        return this.messageSeverity_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobs(Job[] jobs) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting jobs");
        }
        if (jobs == null) {
            Trace.log(2, "Parameter 'jobs' is null.");
            throw new NullPointerException("jobs");
        }
        if (jobs.length > 5) {
            Trace.log(2, "Length of jobs not valid.");
            throw new ExtendedIllegalArgumentException("jobs (" + jobs.length + ")", 1);
        }
        for (int i = 0; i < jobs.length; ++i) {
            if (jobs[i] == null) {
                throw new NullPointerException("job(" + i + ")");
            }
            if (jobs[i].getName() == null) {
                throw new NullPointerException("job name(" + i + ")");
            }
            if (jobs[i].getNumber() == null) {
                throw new NullPointerException("job number(" + i + ")");
            }
            if (jobs[i].getUser() != null) continue;
            throw new NullPointerException("job user(" + i + ")");
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.jobsToList_ = jobs;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public Job[] getJobs() {
        return this.jobsToList_;
    }

    private String twoDigits(int value) {
        if (value > 99) {
            throw new ExtendedIllegalArgumentException("value", 2);
        }
        String full = "00" + Integer.toString(value);
        return full.substring(full.length() - 2);
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for history log invoked.");
        }
        if (this.handle_ != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

