/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrnoException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Date;

public class FileAttributes {
    private AS400 system_;
    private String path_;
    private boolean followSymbolicLink_;
    private boolean attributesRetrieved_ = false;
    String objectType_;
    long extendedAttributeSize_;
    Date createTime_;
    Date accessTime_;
    Date changeTime_;
    Date modifyTime_;
    boolean storageFree_;
    boolean checkedOut_;
    String checkedOutUser_;
    Date checkOutTime_;
    public static final int LOCAL_OBJECT = 1;
    public static final int REMOTE_OBJECT = 2;
    int localRemote_;
    String objectOwner_;
    String primaryGroup_;
    String authorizationListName_;
    byte[] fileId_;
    short asp_;
    long dataSize_;
    long allocatedSize_;
    Date resetDate_;
    Date lastUsedDate_;
    int daysUsedCount_;
    boolean pcReadOnly_;
    boolean pcHidden_;
    boolean pcSystem_;
    boolean pcArchive_;
    boolean systemArchive_;
    int codePage_;
    public static final int FILE_FORMAT_TYPE1 = 0;
    public static final int FILE_FORMAT_TYPE2 = 1;
    int fileFormat_;
    public static final int UDFS_DEFAULT_TYPE1 = 0;
    public static final int UDFS_DEFAULT_TYPE2 = 1;
    int udfsDefaultFormat_ = 0;
    public static final int UDFS_PREFERRED_STORAGE_UNIT_ANY = 0;
    public static final int UDFS_PREFERRED_STORAGE_UNIT_SSD = 1;
    private int udfsStorageUnit_ = 0;
    boolean allowCheckpointWrite_;
    int ccsid_;
    boolean signed_;
    boolean systemSigned_;
    boolean multipleSignatures_;
    public static final int STORAGE_NORMAL = 0;
    public static final int STORAGE_MINIMIZE = 1;
    public static final int STORAGE_DYNAMIC = 2;
    int diskStorageOption_;
    int mainStorageOption_;
    private boolean inheritAllowCheckPointWrite_ = false;
    boolean sysRestrictSave_;
    public static final int DIRECTORY_FORMAT_TYPE1 = 0;
    public static final int DIRECTORY_FORMAT_TYPE2 = 1;
    int directoryFormat_;
    String audit_;
    public static final int SCANNING_NO = 0;
    public static final int SCANNING_YES = 1;
    public static final int SCANNING_CHANGE_ONLY = 2;
    int createObjectScan_;
    int scan_;
    public static final int SCAN_REQUIRED = 0;
    public static final int SCAN_SUCCESS = 1;
    public static final int SCAN_FAILURE = 2;
    public static final int SCAN_PENDING_CONVERSION = 5;
    public static final int SCAN_NOT_REQUIRED = 6;
    int scanStatus_;
    boolean scanSignaturesDifferent_;
    boolean binaryScan_;
    int scanCcsid1_;
    int scanCcsid2_;
    boolean allowSave_;
    boolean restrictedRenameAndUnlink_;
    boolean journalingStatus_;
    public static final int JOURNAL_SUBTREE = 128;
    public static final int JOURNAL_OPTIONAL_ENTRIES = 8;
    public static final int JOURNAL_AFTER_IMAGES = 32;
    public static final int JOURNAL_BEFORE_IMAGES = 64;
    int journalingOptions_;
    byte[] journalIdentifier_;
    String journal_;
    Date lastJournalingStartTime_;
    String startingJournalReceiverForApply_;
    String startingJournalReceiverAspDevice_;
    boolean applyJournaledChangesRequired_;
    boolean rollbackWasEnded_;
    String createObjectAuditing_;
    public static final int SYSTEM_USE_NONE = 0;
    public static final int SYSTEM_USE_VIRTUAL_VOLUME = 1;
    public static final int SYSTEM_USE_NETWORK_SERVER_STORAGE = 2;
    int systemUse_;
    boolean setEffectiveUserId_;
    boolean setEffectiveGroupId_;
    boolean containsTemporaryObjects_;
    boolean temporaryObject_;

    public FileAttributes(AS400 system, String path) {
        this(system, path, true);
    }

    public FileAttributes(AS400 system, String path, boolean followSymbolicLink) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing FileAttributes object, system: " + String.valueOf(system) + ", path: " + path + ", followSymbolicLink: " + followSymbolicLink);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        this.system_ = system;
        this.path_ = path;
        this.followSymbolicLink_ = followSymbolicLink;
    }

    private byte[] createPathName() throws IOException {
        Converter conv = new Converter(1200, this.system_);
        byte[] pathName = new byte[32 + this.path_.length() * 2];
        BinaryConverter.intToByteArray(1200, pathName, 0);
        BinaryConverter.intToByteArray(2, pathName, 12);
        BinaryConverter.intToByteArray(this.path_.length() * 2, pathName, 16);
        conv.stringToByteArray("/", pathName, 20, 2);
        conv.stringToByteArray(this.path_, pathName, 32);
        return pathName;
    }

    public String getObjectType() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.objectType_;
    }

    public long getExtendedAttributeSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.extendedAttributeSize_;
    }

    public Date getCreateTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.createTime_;
    }

    public void setCreateTime(Date createTime) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (createTime == null) {
            Trace.log(2, "Parameter 'createTime' is null.");
            throw new NullPointerException("createTime");
        }
        this.setAttributes(createTime, (byte)4);
    }

    public Date getAccessTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.accessTime_;
    }

    public void setAccessTime(Date accessTime) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (accessTime == null) {
            Trace.log(2, "Parameter 'accessTime' is null.");
            throw new NullPointerException("accessTime");
        }
        this.setAttributes(accessTime, (byte)5);
    }

    public Date getChangeTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.changeTime_;
    }

    public Date getModifyTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.modifyTime_;
    }

    public void setModifyTime(Date modifyTime) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (modifyTime == null) {
            Trace.log(2, "Parameter 'modifyTime' is null.");
            throw new NullPointerException("modifyTime");
        }
        this.setAttributes(modifyTime, (byte)7);
    }

    public boolean isStorageFree() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.storageFree_;
    }

    public boolean isCheckedOut() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.checkedOut_;
    }

    public String getCheckedOutUser() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.checkedOutUser_;
    }

    public Date getCheckOutTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.checkOutTime_;
    }

    public int getLocalRemote() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.localRemote_;
    }

    public String getObjectOwner() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.objectOwner_;
    }

    public String getPrimaryGroup() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.primaryGroup_;
    }

    public String getAuthorizationListName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.authorizationListName_;
    }

    public byte[] getFileId() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.fileId_;
    }

    public short getAsp() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.asp_;
    }

    public long getDataSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.dataSize_;
    }

    public long getAllocatedSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.allocatedSize_;
    }

    public Date getResetDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.resetDate_;
    }

    public Date getLastUsedDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.lastUsedDate_;
    }

    public int getDaysUsedCount() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.daysUsedCount_;
    }

    public boolean isPcReadOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.pcReadOnly_;
    }

    public void setPcReadOnly(boolean pcReadOnly) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(pcReadOnly, (byte)17);
    }

    public boolean isPcHidden() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.pcHidden_;
    }

    public void setPcHidden(boolean pcHidden) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(pcHidden, (byte)18);
    }

    public boolean isPcSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.pcSystem_;
    }

    public void setPcSystem(boolean pcSystem) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(pcSystem, (byte)19);
    }

    public boolean isPcArchive() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.pcArchive_;
    }

    public void setPcArchive(boolean pcArchive) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(pcArchive, (byte)20);
    }

    public boolean isSystemArchive() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.systemArchive_;
    }

    public void setSystemArchive(boolean systemArchive) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(systemArchive, (byte)21);
    }

    public int getCodePage() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.codePage_;
    }

    public void setCodePage(int codePage) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(codePage, (byte)22);
    }

    public int getFileFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.fileFormat_;
    }

    public int getUdfsDefaultFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.udfsDefaultFormat_;
    }

    public int getUdfsPreferredStorageUnit() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.udfsStorageUnit_;
    }

    public boolean isAllowCheckpointWrite() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.allowCheckpointWrite_;
    }

    public void setAllowCheckpointWrite(boolean allowCheckpointWrite) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(allowCheckpointWrite, (byte)26);
    }

    public int getCcsid() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.ccsid_;
    }

    public void setCcsid(int ccsid) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(ccsid, (byte)27);
    }

    public boolean isSigned() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.signed_;
    }

    public boolean isSystemSigned() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.systemSigned_;
    }

    public boolean isMultipleSignatures() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.multipleSignatures_;
    }

    public int getDiskStorageOption() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.diskStorageOption_;
    }

    public void setDiskStorageOption(int diskStorageOption) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes((byte)diskStorageOption, (byte)31);
    }

    public int getMainStorageOption() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.mainStorageOption_;
    }

    public void setMainStorageOption(int mainStorageOption) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes((byte)mainStorageOption, (byte)32);
    }

    public boolean isInheritAllowCheckpointWrite() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.inheritAllowCheckPointWrite_;
    }

    public void setInheritAllowCheckpointWrite(boolean inheritAllowCheckpointWrite) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(inheritAllowCheckpointWrite, (byte)46);
    }

    public boolean isSysRestrictSave() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.sysRestrictSave_;
    }

    public int getDirectoryFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.directoryFormat_;
    }

    public String getAudit() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.audit_;
    }

    public int getCreateObjectScan() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.createObjectScan_;
    }

    public void setCreateObjectScan(int createObjectScan) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes((byte)createObjectScan, (byte)35);
    }

    public int getScan() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.scan_;
    }

    public void setScan(int scan) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes((byte)scan, (byte)36);
    }

    public int getScanStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.scanStatus_;
    }

    public boolean isScanSignaturesDifferent() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.scanSignaturesDifferent_;
    }

    public boolean isBinaryScan() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.binaryScan_;
    }

    public int getScanCcsid1() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.scanCcsid1_;
    }

    public int getScanCcsid2() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.scanCcsid2_;
    }

    public boolean isAllowSave() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.allowSave_;
    }

    public void setAllowSave(boolean allowSave) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(allowSave, (byte)38);
    }

    public boolean isRestrictedRenameAndUnlink() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.restrictedRenameAndUnlink_;
    }

    public void setRestrictedRenameAndUnlink(boolean restrictedRenameAndUnlink) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(restrictedRenameAndUnlink, (byte)39);
    }

    public boolean isJournalingStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.journalingStatus_;
    }

    public int getJournalingOptions() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.journalingOptions_;
    }

    public byte[] getJournalIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.journalIdentifier_;
    }

    public String getJournal() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.journal_;
    }

    public Date getJounalingStartTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getJournalingStartTime();
    }

    public Date getJournalingStartTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.lastJournalingStartTime_;
    }

    public String getStartingJournalReceiverForApply() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.startingJournalReceiverForApply_;
    }

    public String getStartingJournalReceiverAspDevice() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.startingJournalReceiverAspDevice_;
    }

    public boolean isApplyJournaledChangesRequired() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.applyJournaledChangesRequired_;
    }

    public boolean isRollbackWasEnded() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.rollbackWasEnded_;
    }

    public String getCreateObjectAuditing() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.createObjectAuditing_;
    }

    public void setCreateObjectAuditing(String createObjectAuditing) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (createObjectAuditing == null) {
            Trace.log(2, "Parameter 'createObjectAuditing' is null.");
            throw new NullPointerException("createObjectAuditing");
        }
        this.setAttributes(createObjectAuditing, (byte)41);
    }

    public int getSystemUse() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.systemUse_;
    }

    public void resetDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] attribute = new byte[18];
        attribute[7] = -56;
        attribute[11] = 2;
        this.setAttributes(attribute);
    }

    public boolean isSetEffectiveUserId() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.setEffectiveUserId_;
    }

    public void setSetEffectiveUserId(boolean setEffectiveUserId) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(setEffectiveUserId, (byte)1, (byte)44);
    }

    public boolean isSetEffectiveGroupId() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.setEffectiveGroupId_;
    }

    public void setSetEffectiveGroupId(boolean setEffectiveGroupId) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(setEffectiveGroupId, (byte)1, (byte)45);
    }

    public boolean containsTemporaryObjects() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.containsTemporaryObjects_;
    }

    public boolean isTemporaryObject() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.temporaryObject_;
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.attributesRetrieved_ = false;
        this.getAttributes();
    }

    private void getAttributes() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        boolean repeatRun;
        if (this.attributesRetrieved_) {
            return;
        }
        int vrm = this.system_.getVRM();
        int bufferSizeProvided = 2048;
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(2, new byte[4]), new ProgramParameter(2, bufferSizeProvided), new ProgramParameter(1, BinaryConverter.intToByteArray(bufferSizeProvided)), new ProgramParameter(2, 4), new ProgramParameter(2, 4), new ProgramParameter(1, BinaryConverter.intToByteArray(this.followSymbolicLink_ ? 1 : 0))};
        ServiceProgramCall spc = new ServiceProgramCall(this.system_, "/QSYS.LIB/QP0LLIB2.SRVPGM", "Qp0lGetAttr", 1, parameters);
        do {
            repeatRun = false;
            if (!spc.run()) {
                throw new AS400Exception(spc.getMessageList());
            }
            if (spc.getIntegerReturnValue() == -1) {
                int errno = spc.getErrno();
                Trace.log(2, "Get attributes was not successful, errno:", errno);
                throw new ErrnoException(this.system_, errno);
            }
            int bufferSizeNeeded = BinaryConverter.byteArrayToInt(parameters[4].getOutputData(), 0);
            if (bufferSizeProvided >= bufferSizeNeeded) continue;
            repeatRun = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Get attributes buffer too small, buffer size provided: " + bufferSizeProvided + ", buffer size needed: " + bufferSizeNeeded);
            }
            bufferSizeProvided = bufferSizeNeeded;
            parameters[2] = new ProgramParameter(2, bufferSizeProvided);
            parameters[3] = new ProgramParameter(1, BinaryConverter.intToByteArray(bufferSizeProvided));
        } while (repeatRun);
        this.attributesRetrieved_ = true;
        Converter conv = new Converter(this.system_.getJobCcsid(), this.system_);
        byte[] buffer = parameters[2].getOutputData();
        int offset = 0;
        int nextOffset = -1;
        while (nextOffset != 0) {
            nextOffset = BinaryConverter.byteArrayToInt(buffer, offset);
            int entrySize = BinaryConverter.byteArrayToInt(buffer, offset + 8);
            if (entrySize != 0) {
                switch (BinaryConverter.byteArrayToInt(buffer, offset + 4)) {
                    case 0: {
                        this.objectType_ = conv.byteArrayToString(buffer, offset + 16, 10).trim();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.extendedAttributeSize_ = BinaryConverter.byteArrayToUnsignedInt(buffer, offset + 16);
                        break;
                    }
                    case 4: {
                        this.createTime_ = new Date(BinaryConverter.byteArrayToUnsignedInt(buffer, offset + 16) * 1000L);
                        break;
                    }
                    case 5: {
                        this.accessTime_ = new Date(BinaryConverter.byteArrayToUnsignedInt(buffer, offset + 16) * 1000L);
                        break;
                    }
                    case 6: {
                        this.changeTime_ = new Date(BinaryConverter.byteArrayToUnsignedInt(buffer, offset + 16) * 1000L);
                        break;
                    }
                    case 7: {
                        this.modifyTime_ = new Date(BinaryConverter.byteArrayToUnsignedInt(buffer, offset + 16) * 1000L);
                        break;
                    }
                    case 8: {
                        this.storageFree_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 9: {
                        this.checkedOut_ = buffer[offset + 16] == 1;
                        this.checkedOutUser_ = conv.byteArrayToString(buffer, offset + 17, 10).trim();
                        this.checkOutTime_ = new Date(BinaryConverter.byteArrayToUnsignedInt(buffer, offset + 28) * 1000L);
                        break;
                    }
                    case 10: {
                        this.localRemote_ = buffer[offset + 16];
                        break;
                    }
                    case 11: {
                        this.objectOwner_ = conv.byteArrayToString(buffer, offset + 16, 10).trim();
                        this.primaryGroup_ = conv.byteArrayToString(buffer, offset + 26, 10).trim();
                        this.authorizationListName_ = conv.byteArrayToString(buffer, offset + 36, 10).trim();
                        break;
                    }
                    case 12: {
                        this.fileId_ = new byte[16];
                        System.arraycopy(buffer, offset + 16, this.fileId_, 0, 16);
                        break;
                    }
                    case 13: {
                        this.asp_ = BinaryConverter.byteArrayToShort(buffer, offset + 16);
                        break;
                    }
                    case 14: {
                        this.dataSize_ = BinaryConverter.byteArrayToLong(buffer, offset + 16);
                        break;
                    }
                    case 15: {
                        this.allocatedSize_ = BinaryConverter.byteArrayToLong(buffer, offset + 16);
                        break;
                    }
                    case 16: {
                        this.resetDate_ = new Date(BinaryConverter.byteArrayToUnsignedInt(buffer, offset + 16) * 1000L);
                        long seconds = BinaryConverter.byteArrayToUnsignedInt(buffer, offset + 20);
                        this.lastUsedDate_ = seconds == 0L ? null : new Date(seconds * 1000L);
                        this.daysUsedCount_ = BinaryConverter.byteArrayToUnsignedShort(buffer, offset + 24);
                        break;
                    }
                    case 17: {
                        this.pcReadOnly_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 18: {
                        this.pcHidden_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 19: {
                        this.pcSystem_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 20: {
                        this.pcArchive_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 21: {
                        this.systemArchive_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 22: {
                        this.codePage_ = BinaryConverter.byteArrayToInt(buffer, offset + 16);
                        break;
                    }
                    case 23: {
                        this.fileFormat_ = buffer[offset + 16];
                        break;
                    }
                    case 24: {
                        this.udfsDefaultFormat_ = buffer[offset + 16];
                        break;
                    }
                    case 25: {
                        String journalLibrary;
                        String journalName;
                        if (vrm >= 328448) break;
                        this.journalingStatus_ = buffer[offset + 16] == 1;
                        this.journalingOptions_ = buffer[offset + 17] & 0xFF;
                        this.journalIdentifier_ = new byte[10];
                        System.arraycopy(buffer, 18, this.journalIdentifier_, 0, 10);
                        if (buffer[offset + 28] == 0) {
                            this.journal_ = null;
                        } else {
                            journalName = conv.byteArrayToString(buffer, offset + 28, 10).trim();
                            journalLibrary = conv.byteArrayToString(buffer, offset + 38, 10).trim();
                            this.journal_ = QSYSObjectPathName.toPath(journalLibrary, journalName, "JRN");
                        }
                        long seconds = BinaryConverter.byteArrayToUnsignedInt(buffer, offset + 48);
                        this.lastJournalingStartTime_ = seconds == 0L ? null : new Date(seconds * 1000L);
                        break;
                    }
                    case 26: {
                        this.allowCheckpointWrite_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 27: {
                        this.ccsid_ = BinaryConverter.byteArrayToInt(buffer, offset + 16);
                        break;
                    }
                    case 28: {
                        this.signed_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 29: {
                        this.systemSigned_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 30: {
                        this.multipleSignatures_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 31: {
                        this.diskStorageOption_ = buffer[offset + 16];
                        break;
                    }
                    case 32: {
                        this.mainStorageOption_ = buffer[offset + 16];
                        break;
                    }
                    case 33: {
                        this.directoryFormat_ = buffer[offset + 16];
                        break;
                    }
                    case 34: {
                        this.audit_ = conv.byteArrayToString(buffer, offset + 16, 10).trim();
                        break;
                    }
                    case 35: {
                        this.createObjectScan_ = buffer[offset + 16];
                        break;
                    }
                    case 36: {
                        this.scan_ = buffer[offset + 16];
                        break;
                    }
                    case 37: {
                        this.scanStatus_ = buffer[offset + 16];
                        this.scanSignaturesDifferent_ = buffer[offset + 17] == 1;
                        this.binaryScan_ = buffer[offset + 18] == 1;
                        this.scanCcsid1_ = BinaryConverter.byteArrayToInt(buffer, offset + 20);
                        this.scanCcsid2_ = BinaryConverter.byteArrayToInt(buffer, offset + 24);
                        break;
                    }
                    case 38: {
                        this.allowSave_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 39: {
                        this.restrictedRenameAndUnlink_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 40: {
                        String journalLibrary;
                        String journalName;
                        this.journalingStatus_ = buffer[offset + 16] == 1;
                        this.journalingOptions_ = buffer[offset + 17] & 0xFF;
                        this.journalIdentifier_ = new byte[10];
                        System.arraycopy(buffer, 18, this.journalIdentifier_, 0, 10);
                        if (buffer[offset + 28] == 0) {
                            this.journal_ = null;
                        } else {
                            journalName = conv.byteArrayToString(buffer, offset + 28, 10).trim();
                            journalLibrary = conv.byteArrayToString(buffer, offset + 38, 10).trim();
                            this.journal_ = QSYSObjectPathName.toPath(journalLibrary, journalName, "JRN");
                        }
                        long seconds = BinaryConverter.byteArrayToUnsignedInt(buffer, offset + 48);
                        this.lastJournalingStartTime_ = seconds == 0L ? null : new Date(seconds * 1000L);
                        String journalReceiverName = conv.byteArrayToString(buffer, offset + 52, 10).trim();
                        String journalReceiverLibrary = conv.byteArrayToString(buffer, offset + 62, 10).trim();
                        this.startingJournalReceiverForApply_ = journalReceiverName.equals("") ? null : QSYSObjectPathName.toPath(journalReceiverLibrary, journalReceiverName, "JRNRCV");
                        this.startingJournalReceiverAspDevice_ = conv.byteArrayToString(buffer, offset + 72, 10).trim();
                        this.applyJournaledChangesRequired_ = buffer[offset + 82] == 1;
                        this.rollbackWasEnded_ = buffer[offset + 83] == 1;
                        break;
                    }
                    case 41: {
                        this.createObjectAuditing_ = conv.byteArrayToString(buffer, offset + 16, 10).trim();
                        break;
                    }
                    case 42: {
                        this.systemUse_ = buffer[offset + 16];
                        break;
                    }
                    case 43: {
                        this.temporaryObject_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 44: {
                        this.containsTemporaryObjects_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 45: {
                        this.udfsStorageUnit_ = buffer[offset + 16];
                        break;
                    }
                    case 46: {
                        this.inheritAllowCheckPointWrite_ = buffer[offset + 16] == 1;
                    }
                    case 47: {
                        this.sysRestrictSave_ = buffer[offset + 16] == 1;
                    }
                    case 300: {
                        this.setEffectiveUserId_ = buffer[offset + 16] == 1;
                        break;
                    }
                    case 301: {
                        this.setEffectiveGroupId_ = buffer[offset + 16] == 1;
                        break;
                    }
                }
            }
            offset = nextOffset;
        }
    }

    private void setAttributes(String value, byte attributeId) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] attribute = new byte[26];
        attribute[7] = attributeId;
        attribute[11] = 10;
        for (int i = 16; i < 26; ++i) {
            attribute[i] = 64;
        }
        Converter conv = new Converter(this.system_.getJobCcsid(), this.system_);
        conv.stringToByteArray(value, attribute, 16, 10);
        this.setAttributes(attribute);
    }

    private void setAttributes(byte value, byte attributeId) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] attribute = new byte[17];
        attribute[7] = attributeId;
        attribute[11] = 1;
        attribute[16] = value;
        this.setAttributes(attribute);
    }

    private void setAttributes(int value, byte attributeId) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] attribute = new byte[20];
        attribute[7] = attributeId;
        attribute[11] = 4;
        BinaryConverter.intToByteArray(value, attribute, 16);
        this.setAttributes(attribute);
    }

    private void setAttributes(boolean value, byte attributeId) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(value, (byte)0, attributeId);
    }

    private void setAttributes(boolean value, byte attributeId1, byte attributeId2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] attribute = new byte[17];
        attribute[6] = attributeId1;
        attribute[7] = attributeId2;
        attribute[11] = 1;
        if (value) {
            attribute[16] = 1;
        }
        this.setAttributes(attribute);
    }

    private void setAttributes(Date value, byte attributeId) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] attribute = new byte[20];
        attribute[7] = attributeId;
        attribute[11] = 4;
        BinaryConverter.unsignedIntToByteArray(value.getTime() / 1000L, attribute, 16);
        this.setAttributes(attribute);
    }

    private void setAttributes(byte[] attribute) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.attributesRetrieved_ = false;
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(2, attribute), new ProgramParameter(1, BinaryConverter.intToByteArray(attribute.length)), new ProgramParameter(1, BinaryConverter.intToByteArray(this.followSymbolicLink_ ? 1 : 0))};
        ServiceProgramCall spc = new ServiceProgramCall(this.system_, "/QSYS.LIB/QP0LLIB3.SRVPGM", "Qp0lSetAttr", 1, parameters);
        if (!spc.run()) {
            throw new AS400Exception(spc.getMessageList());
        }
        if (spc.getIntegerReturnValue() == -1) {
            int errno = spc.getErrno();
            Trace.log(2, "Set attributes was not successful, errno:", errno);
            throw new ErrnoException(this.system_, errno);
        }
    }
}

