/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.SequentialFile;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Reader;

final class CoverLetterReader
extends Reader {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final RecordFormat coverLetterRF_ = new RecordFormat("QAPZCOVER");
    private final SequentialFile file_ = new SequentialFile();
    private String currentLine_;
    private int currentOffset_;
    private ConvTable table_;

    CoverLetterReader(AS400 system, String path, int ccsid) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super(coverLetterRF_);
        try {
            this.file_.setSystem(system);
            this.file_.setPath(path);
            this.file_.setRecordFormat(coverLetterRF_);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.table_ = ConvTable.getTable(ccsid, null);
        this.file_.open(0, 10, 3);
        this.readRecord();
    }

    protected void finalize() {
        try {
            this.file_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.currentLine_ == null) {
                    return -1;
                }
                if (this.currentOffset_ >= this.currentLine_.length()) {
                    this.readRecord();
                }
                return this.currentLine_.charAt(this.currentOffset_++);
            }
        }
        catch (AS400Exception e) {
            this.handleException(e);
        }
        catch (AS400SecurityException e) {
            this.handleException(e);
        }
        catch (ErrorCompletingRequestException e) {
            this.handleException(e);
        }
        catch (InterruptedException e) {
            this.handleException(e);
        }
        catch (ObjectDoesNotExistException e) {
            this.handleException(e);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf) throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                int cbufOffset;
                int max;
                if (this.currentLine_ == null) {
                    return -1;
                }
                for (cbufOffset = 0; this.currentLine_ != null && cbufOffset < cbuf.length; cbufOffset += max) {
                    char[] cur = this.currentLine_.toCharArray();
                    max = cur.length - this.currentOffset_;
                    if (max > cbuf.length) {
                        max = cbuf.length;
                    }
                    System.arraycopy(cur, this.currentOffset_, cbuf, cbufOffset, max);
                    this.currentOffset_ += max;
                    if (this.currentOffset_ < this.currentLine_.length()) continue;
                    this.readRecord();
                }
                return cbufOffset;
            }
        }
        catch (AS400Exception e) {
            this.handleException(e);
        }
        catch (AS400SecurityException e) {
            this.handleException(e);
        }
        catch (ErrorCompletingRequestException e) {
            this.handleException(e);
        }
        catch (InterruptedException e) {
            this.handleException(e);
        }
        catch (ObjectDoesNotExistException e) {
            this.handleException(e);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.currentLine_ == null) {
                    return -1;
                }
                boolean numChars = false;
                int cbufOffset = off;
                while (this.currentLine_ != null && cbufOffset < off + len) {
                    char[] cur = this.currentLine_.toCharArray();
                    int max = cur.length - this.currentOffset_;
                    if (max > len - cbufOffset) {
                        max = len - cbufOffset;
                    }
                    System.arraycopy(cur, this.currentOffset_, cbuf, cbufOffset, max);
                    cbufOffset += max;
                    this.currentOffset_ += max;
                    if (this.currentOffset_ < this.currentLine_.length()) continue;
                    this.readRecord();
                }
                return cbufOffset - off;
            }
        }
        catch (AS400Exception e) {
            this.handleException(e);
        }
        catch (AS400SecurityException e) {
            this.handleException(e);
        }
        catch (ErrorCompletingRequestException e) {
            this.handleException(e);
        }
        catch (InterruptedException e) {
            this.handleException(e);
        }
        catch (ObjectDoesNotExistException e) {
            this.handleException(e);
        }
        return -1;
    }

    private void handleException(Exception e) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(2, "Error on SequentialFileReader:", (Throwable)e);
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.currentLine_ != null && this.currentOffset_ < this.currentLine_.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.file_.positionCursorBeforeFirst();
                this.readRecord();
            }
        }
        catch (AS400Exception e) {
            this.handleException(e);
        }
        catch (AS400SecurityException e) {
            this.handleException(e);
        }
        catch (ErrorCompletingRequestException e) {
            this.handleException(e);
        }
        catch (InterruptedException e) {
            this.handleException(e);
        }
        catch (ObjectDoesNotExistException e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.currentLine_ == null) {
                    return -1L;
                }
                long numChars = 0L;
                while (this.currentLine_ != null && numChars < n) {
                    int max = this.currentLine_.length() - this.currentOffset_;
                    if ((long)max > n) {
                        max = (int)n;
                    }
                    numChars += (long)max;
                    this.currentOffset_ += max;
                    if (this.currentOffset_ < this.currentLine_.length()) continue;
                    this.readRecord();
                }
                return numChars;
            }
        }
        catch (AS400Exception e) {
            this.handleException(e);
        }
        catch (AS400SecurityException e) {
            this.handleException(e);
        }
        catch (ErrorCompletingRequestException e) {
            this.handleException(e);
        }
        catch (InterruptedException e) {
            this.handleException(e);
        }
        catch (ObjectDoesNotExistException e) {
            this.handleException(e);
        }
        return -1L;
    }

    private void readRecord() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Record r = this.file_.readNext();
        if (r == null) {
            this.currentLine_ = null;
        } else {
            byte[] contents = r.getContents();
            this.currentLine_ = this.table_.byteArrayToString(contents, 0, contents.length) + "\n";
        }
        this.currentOffset_ = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.file_.close();
            }
        }
        catch (AS400Exception e) {
            this.handleException(e);
        }
        catch (AS400SecurityException e) {
            this.handleException(e);
        }
        catch (ErrorCompletingRequestException e) {
            this.handleException(e);
        }
        catch (InterruptedException e) {
            this.handleException(e);
        }
    }

    static {
        coverLetterRF_.addFieldDescription(new HexFieldDescription(new AS400ByteArray(80), "QAPZCOVER"));
    }
}

