/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTable1202;
import com.ibm.as400.access.ConvTable1208;
import com.ibm.as400.access.ConvTableAsciiMap;
import com.ibm.as400.access.ConvTableBidiMap;
import com.ibm.as400.access.ConvTableDoubleMap;
import com.ibm.as400.access.ConvTableJavaMap;
import com.ibm.as400.access.ConvTableMixedMap;
import com.ibm.as400.access.ConvTableSingleMap;
import com.ibm.as400.access.ConvTableUnicodeBigMap;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.Trace;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class ConvTableReader
extends InputStreamReader {
    private BufferedInputStream is_ = null;
    private int ccsid_ = -1;
    private ConvTable table_ = null;
    private BidiConversionProperties properties_ = new BidiConversionProperties();
    static final int DB_MODE = 1;
    static final int SB_MODE = 2;
    private int mode_ = 2;
    private static final int SB_TABLE = 10;
    private static final int DB_TABLE = 11;
    private static final int MB_TABLE = 12;
    private static final int JV_TABLE = 13;
    private static final int UTF8_TABLE = 14;
    private int tableType_ = 10;
    private char[] cache_ = new char[1024];
    private byte[] b_cache_ = new byte[2562];
    private boolean isCachedByte_ = false;
    private byte cachedByte_ = 0;
    private byte[] leftovers = new byte[3];
    private int leftoverCount = 0;
    private int nextRead_ = 0;
    private int nextWrite_ = 0;
    boolean isXML_ = false;
    private boolean isFirstRead_ = true;

    public ConvTableReader(InputStream in) throws UnsupportedEncodingException {
        super(in);
        this.is_ = new BufferedInputStream(in);
        this.initializeCcsid();
        this.initializeTable();
    }

    public ConvTableReader(InputStream in, String encoding) throws UnsupportedEncodingException {
        super(in, encoding);
        this.is_ = new BufferedInputStream(in);
        this.initializeCcsid();
        this.initializeTable();
    }

    public ConvTableReader(InputStream in, int ccsid) throws UnsupportedEncodingException {
        super(in);
        if (ccsid < 0 || ccsid > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.is_ = new BufferedInputStream(in);
        this.ccsid_ = ccsid;
        this.initializeTable();
    }

    public ConvTableReader(InputStream in, int ccsid, boolean isXML) throws UnsupportedEncodingException {
        this(in, ccsid);
        this.isXML_ = isXML;
    }

    public ConvTableReader(InputStream in, int ccsid, int bidiStringType) throws UnsupportedEncodingException {
        this(in, ccsid, new BidiConversionProperties(bidiStringType));
    }

    public ConvTableReader(InputStream in, int ccsid, int bidiStringType, boolean isXML) throws UnsupportedEncodingException {
        this(in, ccsid, new BidiConversionProperties(bidiStringType));
        this.isXML_ = isXML;
    }

    public ConvTableReader(InputStream in, int ccsid, BidiConversionProperties properties) throws UnsupportedEncodingException {
        super(in);
        if (ccsid < 0 || ccsid > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.is_ = new BufferedInputStream(in);
        this.ccsid_ = ccsid;
        this.properties_ = properties;
        this.initializeTable();
    }

    public ConvTableReader(InputStream in, int ccsid, int bidiStringType, int cacheSize) throws UnsupportedEncodingException {
        this(in, ccsid, bidiStringType);
        if (cacheSize < 1) {
            Trace.log(2, "Value of parameter 'cacheSize' is not valid:", cacheSize);
            throw new ExtendedIllegalArgumentException("cacheSize", 4);
        }
        this.cache_ = new char[cacheSize];
        this.b_cache_ = new byte[(cacheSize * 5 + 3) / 2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.table_ == null) {
                return;
            }
            this.table_ = null;
            this.cache_ = null;
            this.b_cache_ = null;
            super.close();
            this.is_.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillCache() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            if (this.nextRead_ >= this.nextWrite_) {
                int numRead = 0;
                if (Trace.traceOn_) {
                    Trace.log(5, "Filling cache for reader " + this.ccsid_ + "/" + this.tableType_ + " [" + this.toString() + "]: " + this.nextRead_ + "," + this.nextWrite_ + "," + this.cache_.length);
                }
                if (this.tableType_ == 10 || this.tableType_ == 13) {
                    numRead = this.is_.read(this.b_cache_, 0, this.cache_.length);
                } else if (this.tableType_ == 11) {
                    if (this.isCachedByte_) {
                        numRead = this.is_.read(this.b_cache_, 1, this.cache_.length - 1);
                        if (numRead == -1) {
                            if (Trace.traceOn_) {
                                Trace.log(5, "Cache not filled, end of stream reached.");
                            }
                            return false;
                        }
                        this.b_cache_[0] = this.cachedByte_;
                        if (numRead % 2 == 0) {
                            this.cachedByte_ = this.b_cache_[numRead];
                            this.isCachedByte_ = true;
                        } else {
                            this.isCachedByte_ = false;
                        }
                    } else {
                        numRead = this.is_.read(this.b_cache_, 0, this.cache_.length);
                        if (numRead > 0 && numRead % 2 != 0) {
                            this.cachedByte_ = this.b_cache_[numRead - 1];
                            this.isCachedByte_ = true;
                            --numRead;
                        }
                    }
                } else if (this.tableType_ == 12) {
                    int curRead;
                    boolean c = false;
                    if (this.mode_ == 1) {
                        this.b_cache_[numRead++] = 14;
                        if (this.isCachedByte_) {
                            this.b_cache_[numRead++] = this.cachedByte_;
                            this.isCachedByte_ = false;
                        }
                    }
                    if ((curRead = this.is_.read(this.b_cache_, numRead, this.cache_.length - 1)) == -1 && numRead == 0) {
                        if (Trace.traceOn_) {
                            Trace.log(5, "Cache not filled, end of stream reached.");
                        }
                        return false;
                    }
                    if (curRead > -1) {
                        numRead += curRead;
                    }
                    boolean needToCache = false;
                    for (int i = 0; i < numRead; ++i) {
                        if (this.mode_ == 2) {
                            if (this.b_cache_[i] != 14) continue;
                            this.mode_ = 1;
                            continue;
                        }
                        if (this.b_cache_[i] == 15) {
                            this.mode_ = 2;
                            needToCache = false;
                            continue;
                        }
                        needToCache = !needToCache;
                    }
                    if (this.mode_ == 1) {
                        if (needToCache) {
                            this.cachedByte_ = this.b_cache_[--numRead];
                            this.isCachedByte_ = true;
                        }
                        this.b_cache_[numRead++] = 15;
                    }
                } else if (this.tableType_ == 14) {
                    if (this.leftoverCount > 0) {
                        System.arraycopy(this.leftovers, 0, this.b_cache_, 0, this.leftoverCount);
                        numRead = this.is_.read(this.b_cache_, this.leftoverCount, this.cache_.length - this.leftoverCount);
                        numRead = numRead == -1 ? this.leftoverCount : numRead + this.leftoverCount;
                    } else {
                        numRead = this.is_.read(this.b_cache_, 0, this.cache_.length);
                    }
                    if (numRead == -1) {
                        if (Trace.traceOn_) {
                            Trace.log(5, "Cache not filled, end of stream reached.");
                        }
                        return false;
                    }
                    if (numRead < this.cache_.length) {
                        this.leftoverCount = 0;
                    } else {
                        int n = this.cache_.length - 1;
                        if ((this.b_cache_[n] & 0x80) == 0) {
                            this.leftoverCount = 0;
                        } else if ((this.b_cache_[n] & 0xC0) == 192) {
                            this.leftoverCount = 1;
                            this.leftovers[0] = this.b_cache_[n];
                        } else if (n > 0 && (this.b_cache_[n - 1] & 0xE0) == 224) {
                            this.leftoverCount = 2;
                            System.arraycopy(this.b_cache_, n - 1, this.leftovers, 0, this.leftoverCount);
                        } else if (n > 1 && (this.b_cache_[n - 2] & 0xF0) == 240) {
                            this.leftoverCount = 3;
                            System.arraycopy(this.b_cache_, n - 2, this.leftovers, 0, this.leftoverCount);
                        } else {
                            this.leftoverCount = 0;
                        }
                        numRead -= this.leftoverCount;
                    }
                } else {
                    if (Trace.traceOn_) {
                        Trace.log(2, "Unknown table type during conversion: " + this.tableType_);
                    }
                    throw new InternalErrorException(6);
                }
                if (numRead == -1) {
                    if (Trace.traceOn_) {
                        Trace.log(5, "Cache not filled, end of stream reached.");
                    }
                    return false;
                }
                String s = this.table_.byteArrayToString(this.b_cache_, 0, numRead, this.properties_);
                this.nextWrite_ = s.length();
                s.getChars(0, this.nextWrite_, this.cache_, 0);
                this.nextRead_ = 0;
                if (Trace.traceOn_) {
                    Trace.log(5, "Filled cache for reader: " + this.nextRead_ + "," + this.nextWrite_ + "," + this.cache_.length, ConvTable.dumpCharArray(this.cache_, this.nextWrite_));
                }
            }
            if (this.nextRead_ >= this.nextWrite_) {
                return this.fillCache();
            }
            if (this.isXML_ && this.isFirstRead_) {
                String s = String.copyValueOf(this.cache_, 0, this.nextWrite_);
                int origLen = s.length();
                try {
                    s = JDUtilities.stripXMLDeclaration(s);
                    s.getChars(0, s.length(), this.cache_, 0);
                    int trimmed = origLen - s.length();
                    this.nextWrite_ -= trimmed;
                    this.isFirstRead_ = false;
                }
                catch (SQLException e) {
                    this.nextRead_ = 0;
                    this.nextWrite_ = 6;
                    this.fillCache();
                }
            }
            return true;
        }
    }

    public int getByteCacheSize() {
        return this.b_cache_.length;
    }

    public int getCacheSize() {
        return this.cache_.length;
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    @Override
    public String getEncoding() {
        if (this.ccsid_ == -1) {
            return super.getEncoding();
        }
        return ConversionMaps.ccsidToEncoding(this.ccsid_);
    }

    private void initializeCcsid() {
        String ccsidStr;
        String enc = super.getEncoding();
        if (enc != null && (ccsidStr = ConversionMaps.encodingToCcsidString(enc)) != null) {
            this.ccsid_ = Integer.parseInt(ccsidStr);
        }
    }

    private void initializeTable() throws UnsupportedEncodingException {
        try {
            this.table_ = this.ccsid_ == -1 ? ConvTable.getTable(this.getEncoding()) : ConvTable.getTable(this.ccsid_, null);
            if (this.table_ instanceof ConvTableSingleMap || this.table_ instanceof ConvTableBidiMap || this.table_ instanceof ConvTableAsciiMap) {
                this.tableType_ = 10;
            } else if (this.table_ instanceof ConvTableDoubleMap || this.table_ instanceof ConvTable1202 || this.table_ instanceof ConvTableUnicodeBigMap) {
                this.tableType_ = 11;
            } else if (this.table_ instanceof ConvTableMixedMap) {
                this.tableType_ = 12;
            } else if (this.table_ instanceof ConvTableJavaMap) {
                this.tableType_ = 13;
            } else if (this.table_ instanceof ConvTable1208) {
                this.tableType_ = 14;
            } else {
                if (Trace.traceOn_) {
                    Trace.log(2, "Unknown conversion table type: " + String.valueOf(this.table_.getClass()));
                }
                throw new InternalErrorException(6);
            }
            if (Trace.traceOn_) {
                Trace.log(5, "ConvTableReader initialized with CCSID " + this.ccsid_ + ", encoding " + this.getEncoding() + ", string type " + this.properties_.getBidiStringType() + ", and table type " + this.tableType_ + ".");
            }
        }
        catch (UnsupportedEncodingException uee) {
            if (Trace.traceOn_) {
                Trace.log(2, "The specified CCSID is not supported in the current JVM nor by the Toolbox: " + this.ccsid_ + "/" + this.getEncoding(), (Throwable)uee);
            }
            throw uee;
        }
    }

    private void checkOpen() throws IOException {
        if (this.table_ == null) {
            this.is_.available();
            throw new IOException();
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.fillCache()) {
                return this.cache_[this.nextRead_++];
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buffer) throws IOException {
        if (buffer == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        if (buffer.length == 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.fillCache()) {
                int max = buffer.length > this.nextWrite_ - this.nextRead_ ? this.nextWrite_ - this.nextRead_ : buffer.length;
                System.arraycopy(this.cache_, this.nextRead_, buffer, 0, max);
                this.nextRead_ += max;
                return max;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        if (buffer == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        if (length == 0) {
            return 0;
        }
        if (offset < 0 || offset >= buffer.length) {
            Trace.log(2, "Value of parameter 'offset' is not valid:", offset);
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        if (length < 0 || offset + length > buffer.length) {
            Trace.log(2, "Specified length would overflow buffer:", length);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.fillCache()) {
                int max = length > this.nextWrite_ - this.nextRead_ ? this.nextWrite_ - this.nextRead_ : length;
                System.arraycopy(this.cache_, this.nextRead_, buffer, offset, max);
                this.nextRead_ += max;
                return max;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(int length) throws IOException {
        if (length < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (length == 0) {
            return "";
        }
        Object object = this.lock;
        synchronized (object) {
            StringBuilder buf = new StringBuilder();
            if (this.fillCache()) {
                while (this.fillCache() && buf.length() < length) {
                    buf.append(this.cache_, this.nextRead_++, 1);
                }
                return buf.toString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.table_ == null) {
                return super.ready();
            }
            return this.nextRead_ < this.nextWrite_ || this.is_.available() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long length) throws IOException {
        if (length < 0L) {
            Trace.log(2, "Value of parameter 'length' is not valid: " + length);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (length == 0L) {
            return 0L;
        }
        long total = 0L;
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            char[] buf = new char[length < (long)this.cache_.length ? (int)length : this.cache_.length];
            int r = this.read(buf);
            total += (long)r;
            while (r > 0 && total < length) {
                r = this.read(buf);
                if (r <= 0) continue;
                total += (long)r;
            }
            if (this.isXML_ && (long)r != total && length > total - (long)r) {
                this.nextRead_ = (int)(length - (total - (long)r));
            }
        }
        return total;
    }
}

