/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.CommandHelpHandler;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PanelGroup;
import com.ibm.as400.access.PanelGroupHelpIdentifier;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Command
implements Serializable {
    static final long serialVersionUID = 6L;
    public static final byte ACTION_ESCAPE_MESSAGE = -13;
    public static final byte ACTION_INFO_MESSAGE = -14;
    public static final byte ACTION_NO_MESSAGE = -15;
    public static final byte ACTION_SYSTEM_VALUE = -16;
    public static final int ALLOW_ALL = 7;
    public static final int ALLOW_BATCH_JOB = 4;
    public static final int ALLOW_BATCH_PROGRAM = 0;
    public static final int ALLOW_BATCH_REXX_PROCEDURE = 5;
    public static final int ALLOW_EXEC = 2;
    public static final int ALLOW_INTERACTIVE_JOB = 3;
    public static final int ALLOW_INTERACTIVE_PROGRAM = 1;
    public static final int ALLOW_INTERACTIVE_REXX_PROCEDURE = 6;
    public static final int MODE_ALL = 13;
    public static final int MODE_DEBUG = 11;
    public static final int MODE_PRODUCTION = 10;
    public static final int MODE_SERVICE = 12;
    public static final String SYSTEM_STATE = "*S";
    public static final byte THREADSAFE_CONDITIONAL = -14;
    public static final byte THREADSAFE_NO = -16;
    public static final byte THREADSAFE_YES = -15;
    public static final String USER_STATE = "*U";
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private AS400 system_;
    private String path_;
    private String commandProcessingProgram_;
    private String sourceFile_;
    private String validityCheckProgram_;
    private String mode_;
    private String whereAllowedToRun_;
    private boolean allowLimitedUser_;
    private int maxPosParms_;
    private String promptMessageFile_;
    private String messageFile_;
    private String helpPanelGroup_;
    private String helpIdentifier_;
    private String searchIndex_;
    private String currentLibrary_;
    private String productLibrary_;
    private String promptOverrideProgram_;
    private String restricted_;
    private String description_;
    private String cppState_;
    private String vcState_;
    private String poState_;
    private int ccsid_;
    private boolean guiEnabled_;
    private byte threadsafe_;
    private byte multithreadedJobAction_;
    private String xml_;
    private String xml2_;
    private transient PanelGroupHelpIdentifier[] helpIDs_;
    private String xmlProductLibrary_;
    private String xmlPanelGroup_;
    private String xmlHelpText_;
    private boolean refreshed_ = false;
    private boolean refreshedXML_ = false;
    private boolean refreshedXML2_ = false;
    private boolean refreshedHelpIDs_ = false;
    private boolean refreshedHelpText_ = false;
    private boolean refreshedParsedXML_ = false;
    private boolean loadedDescription_ = false;
    private boolean detectedMissingPTF_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_;

    public Command() {
    }

    public Command(AS400 system, String path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName.validatePath(path, "CMD");
        this.system_ = system;
        this.path_ = path;
    }

    Command(AS400 system, String path, String description) {
        this.system_ = system;
        this.path_ = path;
        this.description_ = description;
        this.loadedDescription_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Command command = this;
        synchronized (command) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
        }
        this.propertyChangeListeners_.addPropertyChangeListener(listener);
    }

    public boolean allowsLimitedUser() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.allowLimitedUser_;
    }

    public int getCCSID() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.ccsid_;
    }

    public String getCommandProcessingProgram() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.commandProcessingProgram_;
    }

    public String getCommandProcessingState() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.cppState_;
    }

    public String getCurrentLibrary() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.currentLibrary_;
    }

    public String getDescription() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_ && !this.loadedDescription_) {
            this.refreshCommandInfo();
        }
        return this.description_;
    }

    public String getHelpIdentifier() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.helpIdentifier_;
    }

    public PanelGroup getHelpPanelGroup() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        if (this.helpPanelGroup_.equals("*NONE")) {
            return null;
        }
        return new PanelGroup(this.system_, this.helpPanelGroup_);
    }

    public String getHelpSearchIndex() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.searchIndex_;
    }

    public int getMaximumPositionalParameters() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.maxPosParms_;
    }

    public MessageFile getMessageFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return new MessageFile(this.system_, this.messageFile_);
    }

    public byte getMultithreadedJobAction() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.multithreadedJobAction_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getProductLibrary() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.productLibrary_;
    }

    public MessageFile getPromptMessageFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        if (this.promptMessageFile_ != null) {
            return new MessageFile(this.system_, this.promptMessageFile_);
        }
        return null;
    }

    public String getPromptOverrideProgram() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.promptOverrideProgram_;
    }

    public String getPromptOverrideState() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.poState_;
    }

    public String getRestrictedRelease() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.restricted_;
    }

    public String getSourceFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.sourceFile_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public byte getThreadSafety() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.threadsafe_;
    }

    public String getValidityCheckProgram() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.validityCheckProgram_;
    }

    public String getValidityCheckState() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.vcState_;
    }

    public String getWhereAllowedToRun() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.whereAllowedToRun_;
    }

    public String getXML() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshedXML_) {
            this.refreshXML(true);
        }
        return this.xml_;
    }

    public String getXMLExtended() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshedXML2_) {
            this.refreshXML(false);
        }
        return this.xml2_;
    }

    public PanelGroupHelpIdentifier[] getXMLHelpIdentifiers() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (!this.refreshedHelpIDs_) {
            this.refreshHelpIDs();
        }
        return this.helpIDs_;
    }

    public String getXMLProductLibrary() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (!this.refreshedParsedXML_) {
            this.refreshParsedXML();
        }
        return this.xmlProductLibrary_;
    }

    public String getXMLPanelGroup() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (!this.refreshedParsedXML_) {
            this.refreshParsedXML();
        }
        return this.xmlPanelGroup_;
    }

    public String getXMLHelpText() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (!this.refreshedHelpText_) {
            this.refreshHelpText(null);
        }
        return this.xmlHelpText_;
    }

    public synchronized String getXMLHelpText(PanelGroup panelGroup) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (panelGroup == null) {
            throw new NullPointerException("panelGroup");
        }
        String oldText = this.xmlHelpText_;
        this.refreshHelpText(panelGroup);
        String newText = this.xmlHelpText_;
        this.xmlHelpText_ = oldText;
        return newText;
    }

    private synchronized void refreshHelpText(PanelGroup pg) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (Trace.traceOn_) {
            Trace.log(1, "Command.refreshHelpText(" + String.valueOf(pg) + ").");
        }
        this.xmlHelpText_ = null;
        String pGroup = pg == null ? this.getXMLPanelGroup() : pg.getPath();
        String prdLib = this.getXMLProductLibrary();
        boolean added = false;
        if (pGroup != null) {
            String helpResults;
            if (prdLib != null) {
                int i;
                prdLib = prdLib.trim().toUpperCase();
                Job job = new Job(this.system_);
                String[] userLibraries = job.getUserLibraryList();
                String[] sysLibraries = job.getSystemLibraryList();
                String curLibrary = job.getCurrentLibrary();
                boolean exists = false;
                if (curLibrary.trim().equalsIgnoreCase(prdLib)) {
                    exists = true;
                }
                for (i = 0; i < userLibraries.length && !exists; ++i) {
                    if (!userLibraries[i].trim().equalsIgnoreCase(prdLib)) continue;
                    exists = true;
                }
                for (i = 0; i < sysLibraries.length && !exists; ++i) {
                    if (!sysLibraries[i].trim().equalsIgnoreCase(prdLib)) continue;
                    exists = true;
                }
                if (!exists) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Command.refreshHelpText: Adding " + prdLib + " to library list.");
                    }
                    String addlible = "ADDLIBLE LIB(" + prdLib + ")";
                    CommandCall cc = new CommandCall(this.system_, addlible);
                    added = cc.run();
                }
            }
            PanelGroupHelpIdentifier[] ids = this.getXMLHelpIdentifiers();
            String[] helpIDs = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                helpIDs[i] = ids[i].getName();
            }
            PanelGroup panelGroup = new PanelGroup(this.system_, pGroup);
            this.xmlHelpText_ = helpResults = panelGroup.getHelpText(helpIDs);
            if (added) {
                if (Trace.traceOn_) {
                    Trace.log(1, "CommandHelpRetriever: Removing " + prdLib + " from library list.");
                }
                String rmvlible = "RMVLIBLE LIB(" + prdLib + ")";
                CommandCall cc = new CommandCall(this.system_, rmvlible);
                cc.run();
            }
        }
        this.refreshedHelpText_ = true;
    }

    private synchronized void refreshParsedXML() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (Trace.traceOn_) {
            Trace.log(1, "Command.refreshParsedXML().");
        }
        this.xmlPanelGroup_ = null;
        this.xmlProductLibrary_ = null;
        String xml = null;
        try {
            xml = this.getXML();
            CommandHelpHandler handler = new CommandHelpHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)handler);
            String panelGroup = handler.getPanelGroup();
            String prodLib = handler.getProductLibrary();
            boolean added = false;
            if (panelGroup != null) {
                this.xmlPanelGroup_ = panelGroup.trim();
            }
            if (prodLib != null && !prodLib.equalsIgnoreCase("__NONE")) {
                this.xmlProductLibrary_ = prodLib.trim();
            }
            this.refreshedParsedXML_ = true;
        }
        catch (SAXException e) {
            if (Trace.traceOn_) {
                Trace.log(1, "Exception in Command.refreshParsedXML().");
                Trace.log(1, e);
                Trace.log(1, "path is " + this.path_);
                Trace.log(1, "XML is " + xml);
            }
            throw e;
        }
    }

    private synchronized void refreshHelpIDs() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        CommandCall cc;
        if (Trace.traceOn_) {
            Trace.log(1, "Command.refreshHelpIDs().");
        }
        this.helpIDs_ = null;
        String xml = this.getXML();
        CommandHelpHandler handler = new CommandHelpHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        SAXParser parser = factory.newSAXParser();
        parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)handler);
        boolean added = false;
        String prdLib = this.getXMLProductLibrary();
        if (prdLib != null) {
            int i;
            Job job = new Job(this.system_);
            String[] userLibraries = job.getUserLibraryList();
            String[] sysLibraries = job.getSystemLibraryList();
            String curLibrary = job.getCurrentLibrary();
            boolean exists = false;
            if (curLibrary.trim().equalsIgnoreCase(prdLib)) {
                exists = true;
            }
            for (i = 0; i < userLibraries.length && !exists; ++i) {
                if (!userLibraries[i].trim().equalsIgnoreCase(prdLib)) continue;
                exists = true;
            }
            for (i = 0; i < sysLibraries.length && !exists; ++i) {
                if (!sysLibraries[i].trim().equalsIgnoreCase(prdLib)) continue;
                exists = true;
            }
            if (!exists) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Command.refreshHelpIDs: Adding " + prdLib + " to library list.");
                }
                String addlible = "ADDLIBLE LIB(" + prdLib + ")";
                cc = new CommandCall(this.system_, addlible);
                added = cc.run();
            }
        }
        Vector keywords = handler.getKeywords();
        String helpID = handler.getHelpID();
        String[] ids = new String[keywords.size() + 3];
        ids[0] = helpID;
        ids[1] = helpID + "/ERROR/MESSAGES";
        ids[2] = helpID + "/COMMAND/EXAMPLES";
        for (int i = 3; i < ids.length; ++i) {
            ids[i] = helpID + "/" + String.valueOf(keywords.elementAt(i - 3));
        }
        String pgName = this.getXMLPanelGroup();
        PanelGroup pg = new PanelGroup(this.system_, pgName);
        this.helpIDs_ = pg.getHelpIdentifiers(ids);
        if (added) {
            if (Trace.traceOn_) {
                Trace.log(1, "CommandHelpRetriever: Removing " + prdLib + " from library list.");
            }
            String rmvlible = "RMVLIBLE LIB(" + this.xmlProductLibrary_ + ")";
            cc = new CommandCall(this.system_, rmvlible);
            cc.run();
        }
        this.refreshedHelpIDs_ = true;
    }

    public boolean isAllowedToRun(int environment) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        switch (environment) {
            case 0: {
                return this.whereAllowedToRun_.charAt(0) == '1';
            }
            case 1: {
                return this.whereAllowedToRun_.charAt(1) == '1';
            }
            case 2: {
                return this.whereAllowedToRun_.charAt(2) == '1';
            }
            case 3: {
                return this.whereAllowedToRun_.charAt(3) == '1';
            }
            case 4: {
                return this.whereAllowedToRun_.charAt(4) == '1';
            }
            case 5: {
                return this.whereAllowedToRun_.charAt(5) == '1';
            }
            case 6: {
                return this.whereAllowedToRun_.charAt(6) == '1';
            }
            case 7: {
                return this.whereAllowedToRun_.startsWith("1111111");
            }
        }
        throw new ExtendedIllegalArgumentException("environment", 2);
    }

    public boolean isAllowedToRunBatch() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.whereAllowedToRun_.charAt(0) == '1' || this.whereAllowedToRun_.charAt(4) == '1' || this.whereAllowedToRun_.charAt(5) == '1';
    }

    public boolean isAllowedToRunInteractive() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.whereAllowedToRun_.charAt(1) == '1' || this.whereAllowedToRun_.charAt(3) == '1' || this.whereAllowedToRun_.charAt(6) == '1';
    }

    public boolean isEnabledForGUI() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.guiEnabled_;
    }

    public boolean isOperatingMode(int mode) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        switch (mode) {
            case 10: {
                return this.mode_.charAt(0) == '1';
            }
            case 11: {
                return this.mode_.charAt(1) == '1';
            }
            case 12: {
                return this.mode_.charAt(2) == '1';
            }
            case 13: {
                return this.mode_.startsWith("111");
            }
        }
        throw new ExtendedIllegalArgumentException("mode", 2);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }

    public synchronized void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        this.refreshCommandInfo();
        this.refreshXML(true);
        this.refreshParsedXML();
        this.refreshHelpIDs();
    }

    private synchronized void refreshCommandInfo() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        ProgramCall pc;
        boolean succeeded;
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing command information for " + this.path_ + ".");
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.path_ == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        int vrm = this.system_.getVRM();
        int numParms = vrm >= 393472 || vrm >= 328704 && !this.detectedMissingPTF_ ? 6 : 5;
        ProgramParameter[] parms = new ProgramParameter[numParms];
        parms[0] = new ProgramParameter(335);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(335));
        parms[2] = new ProgramParameter(CharConverter.stringToByteArray(37, this.system_, "CMDI0100"));
        byte[] cmdBytes = new byte[20];
        AS400Text text10 = new AS400Text(10, this.system_.getCcsid());
        QSYSObjectPathName p = new QSYSObjectPathName(this.path_);
        String command = p.getObjectName();
        String library = p.getLibraryName();
        text10.toBytes(command, cmdBytes, 0);
        text10.toBytes(library, cmdBytes, 10);
        parms[3] = new ProgramParameter(cmdBytes);
        parms[4] = errorCode_;
        if (numParms > 5) {
            parms[5] = new ProgramParameter(new byte[]{-15});
        }
        if (!(succeeded = (pc = new ProgramCall(this.system_, "/QSYS.LIB/QCDRCMDI.PGM", parms)).run())) {
            AS400Message[] msgList = pc.getMessageList();
            if (numParms > 5 && vrm < 393472 && vrm >= 328704 && msgList[msgList.length - 1].getID().equals("MCH0802")) {
                if (Trace.traceOn_) {
                    Trace.log(4, "PTF SI29629 is not installed: (MCH0802) " + msgList[msgList.length - 1].getText());
                }
                this.detectedMissingPTF_ = true;
                ProgramParameter[] shorterParmList = new ProgramParameter[5];
                System.arraycopy(parms, 0, shorterParmList, 0, 5);
                try {
                    pc.setParameterList(shorterParmList);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                succeeded = pc.run();
            }
            if (!succeeded) {
                throw new AS400Exception(pc.getMessageList());
            }
        }
        byte[] outputData = parms[0].getOutputData();
        CharConverter conv = new CharConverter(this.system_.getCcsid());
        String cppName = conv.byteArrayToString(outputData, 28, 10).trim();
        if (cppName.equals("*REXX")) {
            this.commandProcessingProgram_ = cppName;
        } else {
            String cppLib = conv.byteArrayToString(outputData, 38, 10).trim();
            this.commandProcessingProgram_ = QSYSObjectPathName.toPath(cppLib, cppName, "PGM");
        }
        String srcName = conv.byteArrayToString(outputData, 48, 10).trim();
        String srcLib = conv.byteArrayToString(outputData, 58, 10).trim();
        String srcMbr = conv.byteArrayToString(outputData, 68, 10).trim();
        try {
            this.sourceFile_ = QSYSObjectPathName.toPath(srcLib, srcName, srcMbr, "MBR");
        }
        catch (ExtendedIllegalArgumentException eiae) {
            if (Trace.traceOn_) {
                Trace.log(4, "Unable to process source file: '" + srcName + "," + srcLib + "," + srcMbr + "'.", (Throwable)eiae);
            }
            this.sourceFile_ = null;
        }
        String vldName = conv.byteArrayToString(outputData, 78, 10).trim();
        if (vldName.equals("*NONE")) {
            this.validityCheckProgram_ = vldName;
        } else {
            String vldLib = conv.byteArrayToString(outputData, 88, 10).trim();
            this.validityCheckProgram_ = QSYSObjectPathName.toPath(vldLib, vldName, "PGM");
        }
        this.mode_ = conv.byteArrayToString(outputData, 98, 10);
        this.whereAllowedToRun_ = conv.byteArrayToString(outputData, 108, 15);
        this.allowLimitedUser_ = outputData[123] == -15;
        this.maxPosParms_ = BinaryConverter.byteArrayToInt(outputData, 124);
        String promptName = conv.byteArrayToString(outputData, 128, 10).trim();
        if (promptName.equals("*NONE")) {
            this.promptMessageFile_ = null;
        } else {
            String promptLib = conv.byteArrayToString(outputData, 138, 10).trim();
            this.promptMessageFile_ = QSYSObjectPathName.toPath(promptLib, promptName, "MSGF");
        }
        String msgName = conv.byteArrayToString(outputData, 148, 10).trim();
        String msgLib = conv.byteArrayToString(outputData, 158, 10).trim();
        this.messageFile_ = QSYSObjectPathName.toPath(msgLib, msgName, "MSGF");
        String helpName = conv.byteArrayToString(outputData, 168, 10).trim();
        if (helpName.equals("*NONE")) {
            this.helpPanelGroup_ = helpName;
        } else {
            String helpLib = conv.byteArrayToString(outputData, 178, 10).trim();
            this.helpPanelGroup_ = QSYSObjectPathName.toPath(helpLib, helpName, "PNLGRP");
        }
        this.helpIdentifier_ = conv.byteArrayToString(outputData, 188, 10).trim();
        String searchName = conv.byteArrayToString(outputData, 198, 10).trim();
        if (searchName.equals("*NONE")) {
            this.searchIndex_ = searchName;
        } else {
            String searchLib = conv.byteArrayToString(outputData, 208, 10).trim();
            this.searchIndex_ = QSYSObjectPathName.toPath(searchLib, searchName, "SCHIDX");
        }
        this.currentLibrary_ = conv.byteArrayToString(outputData, 218, 10).trim();
        this.productLibrary_ = conv.byteArrayToString(outputData, 228, 10).trim();
        String pOverName = conv.byteArrayToString(outputData, 238, 10).trim();
        if (pOverName.equals("*NONE")) {
            this.promptOverrideProgram_ = pOverName;
        } else {
            String pOverLib = conv.byteArrayToString(outputData, 248, 10).trim();
            this.promptOverrideProgram_ = QSYSObjectPathName.toPath(pOverLib, pOverName, "PGM");
        }
        this.restricted_ = conv.byteArrayToString(outputData, 258, 6).trim();
        this.description_ = conv.byteArrayToString(outputData, 264, 50).trim();
        this.cppState_ = conv.byteArrayToString(outputData, 314, 2);
        this.vcState_ = conv.byteArrayToString(outputData, 316, 2);
        this.poState_ = conv.byteArrayToString(outputData, 318, 2);
        this.ccsid_ = BinaryConverter.byteArrayToInt(outputData, 328);
        this.guiEnabled_ = outputData[332] == -15;
        this.threadsafe_ = outputData[333];
        this.multithreadedJobAction_ = outputData[334];
        this.refreshed_ = true;
        if (Trace.traceOn_) {
            Trace.log(1, "Successfully refreshed command information for " + this.path_ + ".");
        }
    }

    private synchronized void refreshXML(boolean f) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        String format;
        String string = format = f ? "CMDD0100" : "CMDD0200";
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing XML (format " + format + ") information for " + this.path_ + ".");
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.path_ == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        ProgramParameter[] parms = new ProgramParameter[6];
        byte[] cmdBytes = new byte[20];
        AS400Text text10 = new AS400Text(10, this.system_.getCcsid());
        QSYSObjectPathName p = new QSYSObjectPathName(this.path_);
        String command = p.getObjectName().trim().toUpperCase();
        String library = p.getLibraryName().trim().toUpperCase();
        text10.toBytes(command, cmdBytes, 0);
        text10.toBytes(library, cmdBytes, 10);
        parms[0] = new ProgramParameter(cmdBytes);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(8));
        parms[2] = new ProgramParameter(CharConverter.stringToByteArray(37, this.system_, "DEST0100"));
        parms[3] = new ProgramParameter(8);
        parms[4] = new ProgramParameter(CharConverter.stringToByteArray(37, this.system_, format));
        parms[5] = errorCode_;
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QCDRCMDD.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] outputData = parms[3].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(outputData, 0);
        int bytesAvailable = BinaryConverter.byteArrayToInt(outputData, 4);
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing XML /QSYS.LIB/QCDRCMDD.PGM returned bytesAvailable=" + bytesAvailable);
        }
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(bytesAvailable + 8));
        try {
            parms[3].setOutputDataLength(bytesAvailable + 8);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        outputData = parms[3].getOutputData();
        bytesReturned = BinaryConverter.byteArrayToInt(outputData, 0);
        ConvTable conv1208 = ConvTable.getTable(1208, null);
        if (f) {
            this.xml_ = conv1208.byteArrayToString(outputData, 8, bytesReturned, 0);
            this.refreshedXML_ = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Refreshing XML /QSYS.LIB/QCDRCMDD.PGM returned data=" + this.xml_);
            }
        } else {
            this.xml2_ = conv1208.byteArrayToString(outputData, 8, bytesReturned, 0);
            this.refreshedXML2_ = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Refreshing XML /QSYS.LIB/QCDRCMDD.PGM returned data=" + this.xml2_);
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Successfully refreshed XML (format " + format + ") information for " + this.path_ + ".");
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName.validatePath(path, "CMD");
        Command command = this;
        synchronized (command) {
            String old = this.path_;
            this.path_ = path;
            this.refreshed_ = false;
            this.refreshedXML_ = false;
            this.refreshedXML2_ = false;
            this.refreshedHelpIDs_ = false;
            this.refreshedHelpText_ = false;
            this.refreshedParsedXML_ = false;
            this.loadedDescription_ = false;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("path", old, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        Command command = this;
        synchronized (command) {
            AS400 old = this.system_;
            this.system_ = system;
            this.refreshed_ = false;
            this.refreshedXML_ = false;
            this.refreshedXML2_ = false;
            this.refreshedHelpIDs_ = false;
            this.refreshedHelpText_ = false;
            this.refreshedParsedXML_ = false;
            this.loadedDescription_ = false;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", old, system);
            }
        }
    }

    public String toString() {
        return super.toString() + "[" + this.path_ + "]";
    }
}

