/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Boolean;
import com.ibm.as400.access.FieldDescription;
import java.io.Serializable;
import java.util.Vector;

public class BooleanFieldDescription
extends FieldDescription
implements Serializable {
    static final long serialVersionUID = -2040945751371810257L;

    public BooleanFieldDescription() {
    }

    public BooleanFieldDescription(AS400Boolean dataType, String name) {
        super(dataType, name);
        this.length_ = 1;
    }

    @Override
    String[] getDDSDescription() {
        Vector<Object> v = new Vector<Object>();
        StringBuilder desc = new StringBuilder(this.ddsName_);
        while (desc.length() < 10) {
            desc.append(" ");
        }
        if (!this.refFld_.equals("")) {
            desc.append("R");
        } else {
            desc.append(" ");
        }
        String len = String.valueOf(this.length_);
        int numSpaces = 5 - len.length();
        for (int i = 0; i < numSpaces; ++i) {
            desc.append(' ');
        }
        desc.append(len);
        desc.append("8");
        desc.append("  ");
        desc.append("       ");
        v.addElement(desc.toString());
        String[] keywords = super.getFieldFunctions();
        if (keywords != null) {
            for (int i = 0; i < keywords.length; ++i) {
                v.addElement(keywords[i]);
            }
        }
        if (this.defaultValue_ != null) {
            v.addElement("DFT(" + this.defaultValue_.toString() + ") ");
        } else if (this.isDFTNull_) {
            v.addElement("DFT(*NULL) ");
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public void setDataType(AS400Boolean dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
        if (this.length_ == 0) {
            this.length_ = 4;
        }
    }

    public void setDFT(Boolean defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = defaultValue;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }
}

