/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AS400Server {
    protected SocketContainer socket_;
    protected InputStream inStream_;
    protected OutputStream outStream_;
    protected int connectionID_;
    protected String jobString_;
    protected int service_;
    protected AtomicInteger referenceCount_ = new AtomicInteger(1);
    static Hashtable[] replyStreamsHashTables = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};

    final int getConnectionID() {
        return this.connectionID_;
    }

    final String getJobString() {
        return this.jobString_;
    }

    final void setJobString(String jobString) {
        this.jobString_ = jobString;
    }

    final int getService() {
        return this.service_;
    }

    final String getLocalAddress() {
        return this.socket_.getLocalAddress();
    }

    abstract boolean isConnected();

    public abstract DataStream getExchangeAttrReply();

    public abstract void setExchangeAttrReply(DataStream var1);

    public abstract DataStream sendExchangeAttrRequest(DataStream var1) throws IOException, InterruptedException;

    abstract void addInstanceReplyStream(DataStream var1);

    abstract void clearInstanceReplyStreams();

    public abstract DataStream sendAndReceive(DataStream var1) throws IOException, InterruptedException;

    abstract void sendAndDiscardReply(DataStream var1) throws IOException;

    abstract void sendAndDiscardReply(DataStream var1, int var2) throws IOException;

    abstract int send(DataStream var1) throws IOException;

    abstract int newCorrelationId();

    abstract void send(DataStream var1, int var2) throws IOException;

    abstract DataStream receive(int var1) throws IOException, InterruptedException;

    abstract void forceDisconnect();

    int getSoTimeout() throws SocketException {
        return this.socket_.getSoTimeout();
    }

    void setSoTimeout(int timeout) throws SocketException {
        this.socket_.setSoTimeout(timeout);
    }

    final int addReference() {
        int count = this.referenceCount_.incrementAndGet();
        if (Trace.traceOn_) {
            Trace.log(1, "Increment: reference count for " + String.valueOf(this) + " is " + count);
        }
        return count;
    }

    final int removeReference() {
        int count = this.referenceCount_.decrementAndGet();
        if (Trace.traceOn_) {
            Trace.log(1, "Decrement: reference count for " + String.valueOf(this) + " is " + count);
        }
        return count;
    }

    static final int getServerId(String serviceName) {
        if ("as-central".equals(serviceName)) {
            return 57344;
        }
        if ("as-file".equals(serviceName)) {
            return 57346;
        }
        if ("as-netprt".equals(serviceName)) {
            return 57347;
        }
        if ("as-database".equals(serviceName)) {
            return 57348;
        }
        if ("as-dtaq".equals(serviceName)) {
            return 57351;
        }
        if ("as-rmtcmd".equals(serviceName)) {
            return 57352;
        }
        if ("as-signon".equals(serviceName)) {
            return 57353;
        }
        if ("as-hostcnn".equals(serviceName)) {
            return 57355;
        }
        Trace.log(2, "Invalid service name: " + serviceName);
        throw new InternalErrorException(6);
    }

    static final int getServerId(int service) {
        switch (service) {
            case 6: {
                return 57344;
            }
            case 0: {
                return 57346;
            }
            case 1: {
                return 57347;
            }
            case 4: {
                return 57348;
            }
            case 3: {
                return 57351;
            }
            case 2: {
                return 57352;
            }
            case 7: {
                return 57353;
            }
            case 8: {
                return 57355;
            }
        }
        Trace.log(2, "Invalid service:", service);
        throw new InternalErrorException(6);
    }

    static int getServiceId(String serviceName) {
        if (serviceName.equals("as-file")) {
            return 0;
        }
        if (serviceName.equals("as-netprt")) {
            return 1;
        }
        if (serviceName.equals("as-rmtcmd")) {
            return 2;
        }
        if (serviceName.equals("as-dtaq")) {
            return 3;
        }
        if (serviceName.equals("as-ddm")) {
            return 5;
        }
        if (serviceName.equals("as-database")) {
            return 4;
        }
        if (serviceName.equals("as-central")) {
            return 6;
        }
        if (serviceName.equals("as-signon")) {
            return 7;
        }
        if (serviceName.equals("as-hostcnn")) {
            return 8;
        }
        Trace.log(2, "Invalid service: " + serviceName);
        throw new InternalErrorException(6);
    }

    public static void addReplyStream(DataStream replyStream, String serviceName) {
        AS400Server.addReplyStream(replyStream, AS400Server.getServiceId(serviceName));
    }

    public static void addReplyStream(DataStream replyStream, int service) {
        replyStreamsHashTables[service].put(replyStream, replyStream);
    }
}

