/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FTP;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;

public class AS400FTP
extends FTP
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 system_;
    private transient boolean connected_ = false;
    private transient boolean inConnect_ = false;
    private transient boolean inSaveFileProcessing_ = false;
    private String saveFilePublicAuthority_ = "*EXCLUDE";
    private String CDToRoot = "/";
    private static ResourceBundleLoader loader_;

    public AS400FTP() {
    }

    public AS400FTP(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    @Override
    public synchronized OutputStream append(String fileName) throws IOException {
        OutputStream result = null;
        if (this.connect()) {
            this.saveFileProcessing(fileName);
            try {
                result = super.append(fileName);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean append(String sourceFileName, String targetFileName) throws IOException {
        boolean result = false;
        if (this.connect()) {
            this.saveFileProcessing(targetFileName);
            try {
                result = super.append(sourceFileName, targetFileName);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean append(File sourceFileName, String targetFileName) throws IOException {
        boolean result = false;
        if (this.connect()) {
            this.saveFileProcessing(targetFileName);
            try {
                result = super.append(sourceFileName, targetFileName);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return result;
    }

    @Override
    public boolean cd(String directory) throws IOException {
        if (this.connect()) {
            return super.cd(directory);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean connect() throws UnknownHostException, IOException, IllegalStateException {
        if (!this.connected_) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            try {
                this.system_.signon(false);
            }
            catch (AS400SecurityException e) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Security exception in getVRM()", (Throwable)e);
                }
                throw new IOException(e);
            }
            AS400ImplRemote systemImpl = (AS400ImplRemote)this.system_.getImpl();
            Socket socket = systemImpl.getConnection(super.getPort());
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter writer = new PrintWriter(socket.getOutputStream(), true);
            super.externallyConnected(this.system_.getSystemName(), socket, reader, writer);
            this.connected_ = true;
            this.inConnect_ = true;
            try {
                if (!this.cd(this.CDToRoot) && Trace.isTraceOn()) {
                    Trace.log(1, "CD to root failed " + this.getLastMessage());
                }
            }
            finally {
                this.inConnect_ = false;
            }
            if (this.connected_) {
                super.fireEvent(0);
            }
        }
        return this.connected_;
    }

    @Override
    public String[] dir() throws IOException {
        if (this.connect()) {
            return super.dir();
        }
        return new String[0];
    }

    @Override
    public String[] dir(String criteria) throws IOException {
        if (this.connect()) {
            return super.dir(criteria);
        }
        return new String[0];
    }

    @Override
    public InputStream get(String fileName) throws IOException, FileNotFoundException {
        if (this.connect()) {
            return super.get(fileName);
        }
        return null;
    }

    @Override
    public boolean get(String sourceFileName, String targetFileName) throws IOException, FileNotFoundException {
        if (this.connect()) {
            return super.get(sourceFileName, targetFileName);
        }
        return false;
    }

    @Override
    public boolean get(String sourceFileName, File targetFile) throws IOException, FileNotFoundException {
        if (this.connect()) {
            return super.get(sourceFileName, targetFile);
        }
        return false;
    }

    @Override
    public synchronized String getCurrentDirectory() throws IOException {
        if (this.connect()) {
            return super.getCurrentDirectory();
        }
        return null;
    }

    public String getSaveFilePublicAuthority() {
        return this.saveFilePublicAuthority_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    @Override
    public synchronized String issueCommand(String cmd) throws IOException {
        boolean result = true;
        if (!this.inConnect_) {
            result = this.connect();
        }
        if (result) {
            return super.issueCommand(cmd);
        }
        return null;
    }

    @Override
    public String[] ls() throws IOException {
        if (this.connect()) {
            return super.ls();
        }
        return new String[0];
    }

    @Override
    public String[] ls(String criteria) throws IOException {
        if (this.connect()) {
            return super.ls(criteria);
        }
        return new String[0];
    }

    @Override
    public boolean noop() throws IOException {
        boolean result = true;
        if (!this.inConnect_) {
            result = this.connect();
        }
        if (result) {
            return super.noop();
        }
        return false;
    }

    @Override
    public synchronized OutputStream put(String fileName) throws IOException {
        OutputStream result = null;
        if (this.connect()) {
            this.saveFileProcessing(fileName);
            try {
                result = super.put(fileName);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean put(String sourceFileName, String targetFileName) throws IOException {
        boolean result = false;
        if (this.connect()) {
            this.saveFileProcessing(targetFileName);
            try {
                result = super.put(sourceFileName, targetFileName);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean put(File sourceFileName, String targetFileName) throws IOException {
        boolean result = false;
        if (this.connect()) {
            this.saveFileProcessing(targetFileName);
            try {
                result = super.put(sourceFileName, targetFileName);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return result;
    }

    @Override
    public synchronized String pwd() throws IOException {
        if (this.connect()) {
            return super.pwd();
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.connected_ = false;
        this.inConnect_ = false;
        this.inSaveFileProcessing_ = false;
    }

    private void saveFileProcessing(String target) throws IOException {
        block24: {
            if (!this.inSaveFileProcessing_) {
                this.inSaveFileProcessing_ = true;
                target = ((String)target).toUpperCase();
                if (((String)(target = ((String)target).trim())).endsWith(".SAVF")) {
                    if (!((String)target).startsWith("/")) {
                        String currentPath = this.pwd();
                        if (Trace.isTraceOn()) {
                            Trace.log(1, "pwd: " + currentPath);
                        }
                        if (currentPath == null) {
                            return;
                        }
                        if (currentPath.startsWith("257")) {
                            int end;
                            int start = currentPath.indexOf("\"");
                            if (start < 0) {
                                return;
                            }
                            if ((end = currentPath.indexOf("\"", ++start)) < start) {
                                return;
                            }
                            currentPath = currentPath.substring(start, end);
                            if (Trace.isTraceOn()) {
                                Trace.log(1, start + " " + end + " " + currentPath);
                            }
                        } else {
                            return;
                        }
                        target = currentPath.endsWith("/") ? currentPath + (String)target : currentPath + "/" + (String)target;
                    }
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "target: " + (String)target);
                    }
                    try {
                        QSYSObjectPathName target2 = new QSYSObjectPathName((String)target);
                        CommandCall c = new CommandCall(this.system_);
                        String command = "CRTSAVF  FILE(" + target2.getLibraryName() + "/" + target2.getObjectName() + ") AUT(" + this.saveFilePublicAuthority_ + ")";
                        if (Trace.isTraceOn()) {
                            Trace.log(1, "command string " + command);
                        }
                        try {
                            c.setCommand(command);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        c.suggestThreadsafe(false);
                        try {
                            boolean result = c.run();
                            AS400Message[] messageList = c.getMessageList();
                            String crtSaveFileMessage = messageList[0].getText();
                            if (Trace.isTraceOn()) {
                                Trace.log(1, "message[0]: " + crtSaveFileMessage);
                            }
                            if (!result && messageList[0].getID().startsWith("CPF5813")) {
                                result = true;
                            }
                            if (!result) {
                                String MRIMessage = " ";
                                MRIMessage = ResourceBundleLoader.getText("CREATE_SAVE_FILE_FAILED");
                                throw new IOException(MRIMessage + crtSaveFileMessage);
                            }
                        }
                        catch (Exception e) {
                            if (Trace.isTraceOn()) {
                                Trace.log(1, "IO Exception running command call ", (Throwable)e);
                            }
                            throw new IOException(e);
                        }
                        this.setDataTransferType(1);
                    }
                    catch (IllegalPathNameException e) {
                        if (Trace.isTraceOn()) {
                            Trace.log(1, "the put ends up in ifs");
                        }
                        break block24;
                    }
                }
                if (Trace.isTraceOn()) {
                    Trace.log(1, "the put is not for a save file ");
                }
            }
        }
    }

    @Override
    public synchronized boolean setCurrentDirectory(String directory) throws IOException {
        if (this.connect()) {
            return super.setCurrentDirectory(directory);
        }
        return false;
    }

    @Override
    public void setDataTransferType(int transferType) throws IOException {
        if (this.connect()) {
            super.setDataTransferType(transferType);
        }
    }

    @Override
    public void setPassword(String password) {
        if (!this.inConnect_) {
            throw new IllegalStateException("password");
        }
        super.setPassword(password);
    }

    public void setSaveFilePublicAuthority(String publicAuthority) throws PropertyVetoException {
        if (publicAuthority == null) {
            throw new NullPointerException("saveFilePublicAuthority");
        }
        if (publicAuthority.length() == 0) {
            throw new IllegalArgumentException("saveFilePublicAuthority");
        }
        String oldValue = this.saveFilePublicAuthority_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("saveFilePublicAuthority", oldValue, publicAuthority);
        }
        this.saveFilePublicAuthority_ = publicAuthority;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("saveFilePublicAuthority", oldValue, publicAuthority);
        }
    }

    @Override
    public void setServer(String server) throws PropertyVetoException {
        if (!this.inConnect_) {
            throw new IllegalStateException("server");
        }
        super.setServer(server);
    }

    public synchronized void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 oldSystem = this.system_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("system", oldSystem, system);
        }
        this.system_ = system;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("system", oldSystem, system);
        }
    }

    @Override
    public void setUser(String user) throws PropertyVetoException {
        if (!this.inConnect_) {
            throw new IllegalStateException("user");
        }
        super.setUser(user);
    }
}

