/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.steps;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.collect.ImmutableSet;
import com.ibm.as400.access.AS400SecurityException;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.ibmisteps.Messages;
import org.jenkinsci.plugins.ibmisteps.configuration.IBMiGlobalConfiguration;
import org.jenkinsci.plugins.ibmisteps.configuration.IBMiServerConfiguration;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.IBMiContext;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class OnIBMiStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 4356326103523728526L;
    private final String server;
    private String iasp;
    private boolean traceEnabled;

    @DataBoundConstructor
    public OnIBMiStep(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    @DataBoundSetter
    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public String getIasp() {
        return this.iasp;
    }

    @DataBoundSetter
    public void setIasp(String iasp) {
        this.iasp = iasp.trim().toUpperCase();
    }

    public StepExecution start(StepContext context) {
        return new GeneralNonBlockingStepExecution(context){
            private static final long serialVersionUID = 1L;

            public boolean start() throws Exception {
                EnvironmentExpander expander;
                IBMiContext ibmiContext;
                IBMiServerConfiguration serverConfig;
                IBMiServerConfiguration iBMiServerConfiguration = serverConfig = Util.fixNull((String)OnIBMiStep.this.server).isBlank() ? new IBMiServerConfiguration("localhost", "localhost", null, "", false) : IBMiGlobalConfiguration.get().getServer(OnIBMiStep.this.server);
                if (serverConfig != null) {
                    StandardUsernamePasswordCredentials credentials = serverConfig.getCredentialsId() != null ? (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)serverConfig.getCredentialsId(), StandardUsernamePasswordCredentials.class, (Run)((Run)this.getContext().get(Run.class))) : null;
                    ibmiContext = new IBMiContext(serverConfig.getHost(), credentials, serverConfig.getCcsidInt(), serverConfig.isSecure(), OnIBMiStep.this.iasp, OnIBMiStep.this.traceEnabled);
                    TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
                    IBMiExpander ibmiExpander = new IBMiExpander(ibmiContext.getIBMi(taskListener));
                    expander = EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)ibmiExpander);
                    if (OnIBMiStep.this.traceEnabled) {
                        taskListener.getLogger().printf("%nIBM i steps environment variables:%n%s%n%n", new Object[]{ibmiExpander});
                    }
                } else {
                    throw new IllegalArgumentException(Messages.server_not_found(OnIBMiStep.this.server));
                }
                this.getContext().newBodyInvoker().withContexts(new Object[]{ibmiContext, expander}).withCallback((BodyExecutionCallback)new Callback(ibmiContext)).start();
                return false;
            }
        };
    }

    private static class IBMiExpander
    extends EnvironmentExpander {
        private static final long serialVersionUID = -1512948481734939923L;
        private final Map<String, String> ibmiEnvVars = new HashMap<String, String>();

        public IBMiExpander(IBMi ibmi) throws AS400SecurityException, IOException {
            this.ibmiEnvVars.put(this.key("host"), ibmi.getIbmiConnection().getSystemName());
            this.ibmiEnvVars.put(this.key("profile"), ibmi.getIbmiConnection().getUserId());
            this.ibmiEnvVars.put(this.key("ccsid"), String.valueOf(ibmi.getConnectionCCSID()));
            this.ibmiEnvVars.put(this.key("command_job"), String.valueOf(ibmi.getCommandJob()));
            this.ibmiEnvVars.put(this.key("version"), ibmi.getOSVersion());
        }

        private String key(String name) {
            return String.format("IBMI_%s", name.toUpperCase());
        }

        public void expand(@NonNull EnvVars env) {
            env.putAll(this.ibmiEnvVars);
        }

        public String toString() {
            return this.ibmiEnvVars.entrySet().stream().map(envVar -> String.format("%s -> %s", envVar.getKey(), envVar.getValue())).collect(Collectors.joining("\n"));
        }
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 4348731407610313151L;
        private final IBMiContext ibmiContext;

        Callback(IBMiContext ibmiContext) {
            this.ibmiContext = ibmiContext;
        }

        protected void finished(StepContext context) {
            this.ibmiContext.close();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "onIBMi";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.OnIBMiStep_description();
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public ListBoxModel doFillServerItems(@AncestorInPath Item item) {
            ListBoxModel servers = new ListBoxModel();
            if (item != null) {
                item.checkPermission(Item.EXTENDED_READ);
                for (IBMiServerConfiguration server : IBMiGlobalConfiguration.get().getServers()) {
                    servers.add(MessageFormat.format("{0} ({1})", server.getName(), server.getHost()), server.getName());
                }
            }
            return servers;
        }
    }
}

