/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.model;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.list.OpenListException;
import com.ibm.as400.access.list.SpooledFileListItem;
import com.ibm.as400.access.list.SpooledFileOpenList;
import hudson.FilePath;
import java.io.IOException;
import java.util.UUID;
import org.jenkinsci.plugins.ibmisteps.model.CallResult;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.SpooledFileHandler;
import org.jenkinsci.plugins.ibmisteps.model.SpooledFiles;

public class CLSpooledFilehandler
implements SpooledFileHandler {
    private static final long serialVersionUID = -2465788947902207300L;

    CLSpooledFilehandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSpooledFile(IBMi ibmi, SpooledFiles.SpooledFile spooledFile, FilePath toFile) throws IOException, InterruptedException, AS400SecurityException, ErrorCompletingRequestException {
        IFSFile workFolder = new IFSFile(ibmi.getIbmiConnection(), "/tmp", String.valueOf(UUID.randomUUID()) + ".jenkins.temp");
        try {
            workFolder.mkdirs();
            IFSFile targetFile = new IFSFile(workFolder, spooledFile.getName() + "_" + spooledFile.getNumber() + ".txt");
            IFSFile workFile = new IFSFile(workFolder, targetFile.getName() + ".work");
            CallResult cpysplf = ibmi.executeCommand(String.format("CPYSPLF FILE(%s) SPLNBR(%s) TOFILE(*TOSTMF) JOB(%s/%s/%s) TOSTMF('%s')", spooledFile.getName(), spooledFile.getNumber(), spooledFile.getJobNumber(), spooledFile.getJobUser(), spooledFile.getJobName(), workFile));
            if (!cpysplf.isSuccessful()) {
                throw new IOException("CPYSPLF failed: " + cpysplf.getPrettyMessages());
            }
            CallResult cpy = ibmi.executeCommand(String.format("CPY OBJ('%s') TOOBJ('%s') TOCCSID(1208) DTAFMT(*TEXT)", workFile, targetFile));
            if (!cpysplf.isSuccessful()) {
                throw new IOException("CPY failed: " + cpy.getPrettyMessages());
            }
            ibmi.download(targetFile, toFile);
        }
        catch (Throwable throwable) {
            ibmi.executeCommand(String.format("RMDIR DIR('%s') SUBTREE(*ALL) RMVLNK(*YES)", workFolder));
            throw throwable;
        }
        ibmi.executeCommand(String.format("RMDIR DIR('%s') SUBTREE(*ALL) RMVLNK(*YES)", workFolder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpooledFiles listSpooledFiles(IBMi ibmi, String jobNumber, String jobUser, String jobName) throws IOException, InterruptedException, AS400SecurityException, ErrorCompletingRequestException, ObjectDoesNotExistException, OpenListException {
        SpooledFiles spooledFiles = new SpooledFiles();
        spooledList.setFilterJobInformation(jobName, jobUser, jobNumber);
        try (SpooledFileOpenList spooledList = new SpooledFileOpenList(ibmi.getIbmiConnection());){
            spooledList.open();
            for (Object object : spooledList.getItems(-1, 0)) {
                SpooledFileListItem spooledFileItem = (SpooledFileListItem)object;
                SpooledFiles.SpooledFile spooledFile = new SpooledFiles.SpooledFile(spooledFileItem.getName(), spooledFileItem.getNumber(), spooledFileItem.getSize(), spooledFileItem.getUserData(), spooledFileItem.getJobName(), spooledFileItem.getJobUser(), spooledFileItem.getJobNumber());
                spooledFiles.add(spooledFile);
            }
        }
        return spooledFiles;
    }
}

