/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Command;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.CommandList;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PanelGroup;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

public class CommandHelpRetriever {
    private boolean debug_ = false;
    private static Templates htmlTemplate_;
    private static Templates uimTemplate_;
    private static URIResolver defaultResolver_;
    private static String library_;
    private static String command_;
    private boolean showChoices_ = false;
    private String outputDirectory_ = ".";
    private Transformer htmlTransformer_;
    private Transformer uimTransformer_;
    private final HelpResolver resolver_ = new HelpResolver();
    private static final String[] mriHTMLTags_;
    private static final String[] mriUIMTags_;
    private static final String[][] transformedHTMLParms_;
    private static boolean genUIM_;
    private static boolean genHTML_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintWriter writer = new PrintWriter(System.out, true);
        if (args.length == 0) {
            writer.println();
            CommandHelpRetriever.usage();
        }
        try {
            CommandHelpRetriever utility = new CommandHelpRetriever();
            AS400 system = CommandHelpRetriever.parseParms(args, utility);
            CommandList list = new CommandList(system, library_, command_);
            Command[] cmds = list.generateList();
            File outDir = new File(utility.outputDirectory_);
            boolean isDir = outDir.isDirectory();
            if (!isDir && cmds.length > 1) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "The output parameter cannot be a file when a wildcard command is specified");
                }
                throw new ExtendedIllegalArgumentException("output", 2);
            }
            for (int i = 0; i < cmds.length; ++i) {
                try {
                    FileWriter out;
                    String filename;
                    QSYSObjectPathName path;
                    File outFile;
                    if (genHTML_) {
                        String html = utility.generateHTML(cmds[i]);
                        outFile = null;
                        if (isDir) {
                            path = new QSYSObjectPathName(cmds[i].getPath());
                            filename = path.getLibraryName() + "_" + path.getObjectName() + ".html";
                            outFile = new File(outDir, filename);
                        } else {
                            outFile = outDir;
                        }
                        out = new FileWriter(outFile);
                        try {
                            out.write(html);
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                    if (!genUIM_) continue;
                    String uim = utility.generateUIM(cmds[i]);
                    outFile = null;
                    if (isDir) {
                        path = new QSYSObjectPathName(cmds[i].getPath());
                        filename = path.getLibraryName() + "_" + path.getObjectName() + ".uim";
                        outFile = new File(outDir, filename);
                    } else {
                        outFile = outDir;
                    }
                    out = new FileWriter(outFile);
                    try {
                        out.write(uim);
                        continue;
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final String encode(String source) {
        StringBuilder dest = new StringBuilder();
        char[] buf = source.toCharArray();
        block6: for (int i = 0; i < buf.length; ++i) {
            switch (buf[i]) {
                case '\"': {
                    dest.append("&quot;");
                    continue block6;
                }
                case '&': {
                    dest.append("&amp;");
                    continue block6;
                }
                case '<': {
                    dest.append("&lt;");
                    continue block6;
                }
                case '>': {
                    dest.append("&gt;");
                    continue block6;
                }
                default: {
                    dest.append(buf[i]);
                }
            }
        }
        return dest.toString();
    }

    private static final String encodeAmp(String source) {
        StringBuilder dest = new StringBuilder();
        char[] buf = source.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] == '&') {
                dest.append("&amp;");
                continue;
            }
            dest.append(buf[i]);
        }
        return dest.toString();
    }

    public synchronized String generateHTML(Command command) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        if (command == null) {
            throw new NullPointerException("command");
        }
        return this.generate(command, null);
    }

    public synchronized String generateHTML(Command command, PanelGroup panelGroup) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (panelGroup == null) {
            throw new NullPointerException("panelGroup");
        }
        return this.generate(command, panelGroup);
    }

    public synchronized byte[] generateHTMLBytes(Command command, PanelGroup panelGroup) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        if (command == null) {
            throw new NullPointerException("command");
        }
        return this.generate(command, panelGroup).getBytes("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String generate(Command command, PanelGroup panelGroup) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        String helpResults;
        String whereAllowedToRun;
        String threadSafe;
        String xml;
        block29: {
            block28: {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Generating HTML documentation for '" + String.valueOf(command) + "' and panel group '" + String.valueOf(panelGroup) + "'.");
                }
                xml = command.getXML();
                if (this.debug_) {
                    String path = command.getPath();
                    QSYSObjectPathName pn = new QSYSObjectPathName(path);
                    String lib = pn.getLibraryName();
                    String name = pn.getObjectName();
                    File outDir = new File(this.outputDirectory_);
                    boolean isDir = outDir.isDirectory();
                    File outFile = null;
                    outFile = isDir ? new File(outDir, lib + "_" + name + "_XML.xml") : new File(this.outputDirectory_ + "_XML.xml");
                    try (FileWriter fw = new FileWriter(outFile);){
                        fw.write(xml);
                    }
                }
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Retrieved command XML:\n" + xml + "\n");
                }
                threadSafe = null;
                whereAllowedToRun = null;
                try {
                    switch (command.getThreadSafety()) {
                        case -16: {
                            threadSafe = "0";
                            break;
                        }
                        case -15: {
                            threadSafe = "1";
                            break;
                        }
                        case -14: {
                            threadSafe = "2";
                            break;
                        }
                    }
                    whereAllowedToRun = command.getWhereAllowedToRun();
                }
                catch (AS400Exception e) {
                    AS400Message[] msgs = e.getAS400MessageList();
                    if (msgs.length == 1 && msgs[0].getID().toUpperCase().trim().equals("CPF6250")) break block28;
                    throw new AS400Exception(msgs);
                }
            }
            if (Trace.isTraceOn()) {
                Trace.log(1, "Using command threadsafety = " + threadSafe + " and where allowed to run = " + whereAllowedToRun + ".");
            }
            helpResults = null;
            try {
                helpResults = panelGroup == null ? command.getXMLHelpText() : command.getXMLHelpText(panelGroup);
            }
            catch (AS400Exception e) {
                AS400Message[] msgs = e.getAS400MessageList();
                if (msgs.length == 1 && (msgs[0].getID().toUpperCase().trim().equals("CPF6250") || msgs[0].getID().toUpperCase().trim().equals("CPF6E3B"))) break block29;
                throw new AS400Exception(msgs);
            }
        }
        if (this.debug_ && helpResults != null) {
            String path = command.getPath();
            QSYSObjectPathName pn = new QSYSObjectPathName(path);
            String lib = pn.getLibraryName();
            String name = pn.getObjectName();
            File outDir = new File(this.outputDirectory_);
            boolean isDir = outDir.isDirectory();
            File outFile = null;
            outFile = isDir ? new File(outDir, lib + "_" + name + "_HTMLHelp.html") : new File(this.outputDirectory_ + "_HTMLHelp.html");
            try (FileWriter fw = new FileWriter(outFile);){
                fw.write(helpResults);
            }
        }
        this.setupHTMLTransformer(command.getSystem().getLocale());
        this.htmlTransformer_.setParameter("CommandHelp", helpResults == null || helpResults.trim().length() == 0 ? "__NO_HELP" : "myCommandHelpResolver");
        this.htmlTransformer_.setParameter("ShowChoicePgmValues", this.showChoices_ ? "1" : "0");
        this.htmlTransformer_.setParameter("ThreadSafe", threadSafe == null ? "0" : threadSafe);
        this.htmlTransformer_.setParameter("WhereAllowed", whereAllowedToRun == null ? "000000000000000" : whereAllowedToRun);
        this.resolver_.helpResults_ = helpResults;
        StreamSource sourceXML = new StreamSource(new StringReader(xml));
        StringWriter buf = new StringWriter();
        StreamResult output = new StreamResult(buf);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Performing XSL transform.");
            Trace.log(1, "Help Results is " + helpResults);
        }
        try {
            this.htmlTransformer_.transform(sourceXML, output);
        }
        catch (TransformerException e) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Exception from transform.");
                Trace.log(1, e);
            }
            throw e;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Successfully generated help documentation.");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String generateUIM(Command command) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Generating UIM documentation for " + String.valueOf(command) + ".");
        }
        String xml = null;
        try {
            xml = command.getXMLExtended();
        }
        catch (AS400Exception ae) {
            AS400Message[] msgs = ae.getAS400MessageList();
            if (msgs.length == 1 && msgs[0].getID().equalsIgnoreCase("CPF3C21")) {
                if (Trace.isTraceOn()) {
                    Trace.log(4, "Extended command XML format not supported by this system. Using older version.");
                }
                xml = command.getXML();
            }
            throw ae;
        }
        if (this.debug_) {
            String path = command.getPath();
            QSYSObjectPathName pn = new QSYSObjectPathName(path);
            String lib = pn.getLibraryName();
            String name = pn.getObjectName();
            File outDir = new File(this.outputDirectory_);
            boolean isDir = outDir.isDirectory();
            File outFile = null;
            outFile = isDir ? new File(outDir, lib + "_" + name + "_XML_X.xml") : new File(this.outputDirectory_ + "_XML_X.xml");
            try (FileWriter fw = new FileWriter(outFile);){
                fw.write(xml);
            }
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Retrieved extended command XML:\n" + xml + "\n");
        }
        this.setupUIMTransformer(command.getSystem().getLocale());
        StreamSource sourceXML = new StreamSource(new StringReader(xml));
        StringWriter buf = new StringWriter();
        StreamResult output = new StreamResult(buf);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Performing XSL transform of UIM.");
        }
        this.uimTransformer_.transform(sourceXML, output);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Successfully generated UIM documentation.");
        }
        return buf.toString();
    }

    public boolean getDebug() {
        return this.debug_;
    }

    public String getOutputLocation() {
        return this.outputDirectory_;
    }

    public boolean getShowChoiceProgramValues() {
        return this.showChoices_;
    }

    private static final String[][] getTransformedHTMLParms(Locale locale) {
        String[][] parms = new String[mriHTMLTags_.length + 4][];
        if (Trace.isTraceOn()) {
            Trace.log(1, "Transforming CommandHelpRetriever HTML MRI for locale: " + String.valueOf(locale));
        }
        ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.as400.access.MRI", locale);
        ResourceBundle bundle2 = ResourceBundle.getBundle("com.ibm.as400.access.MRI2", locale);
        for (int i = 0; i < mriHTMLTags_.length; ++i) {
            parms[i] = new String[]{"_" + mriHTMLTags_[i], CommandHelpRetriever.encode(bundle2.getString("GENCMDDOC_" + mriHTMLTags_[i]))};
        }
        parms[i++] = new String[]{"_DESCRIPTION", CommandHelpRetriever.encode(bundle2.getString("NETSERVER_DESCRIPTION_NAME"))};
        parms[i++] = new String[]{"_THREADSAFE_NO", CommandHelpRetriever.encode(bundle.getString("DLG_NO_BUTTON"))};
        parms[i++] = new String[]{"_THREADSAFE_YES", CommandHelpRetriever.encode(bundle.getString("DLG_YES_BUTTON"))};
        parms[i] = new String[]{"_TYPE_NAME", CommandHelpRetriever.encode(bundle2.getString("NETSERVER_NAME_NAME"))};
        return parms;
    }

    private static final String[][] getTransformedUIMParms(Locale locale) {
        String[][] parms = new String[mriUIMTags_.length][];
        if (Trace.isTraceOn()) {
            Trace.log(1, "Transforming CommandHelpRetriever UIM MRI for locale: " + String.valueOf(locale));
        }
        ResourceBundle bundle2 = ResourceBundle.getBundle("com.ibm.as400.access.MRI2", locale);
        for (int i = 0; i < mriUIMTags_.length; ++i) {
            parms[i] = new String[]{"_" + mriUIMTags_[i], CommandHelpRetriever.encodeAmp(bundle2.getString("GENCMDDOC_" + mriUIMTags_[i]))};
        }
        return parms;
    }

    private static AS400 parseParms(String[] args, CommandHelpRetriever utility) throws Exception {
        String html;
        String d;
        String o;
        String l;
        String p;
        String u;
        Vector<String> v = new Vector<String>();
        v.addElement("-system");
        v.addElement("-userid");
        v.addElement("-password");
        v.addElement("-library");
        v.addElement("-command");
        v.addElement("-showChoicePgmValues");
        v.addElement("-output");
        v.addElement("-debug");
        v.addElement("-uim");
        v.addElement("-html");
        Hashtable<String, String> shortcuts = new Hashtable<String, String>();
        shortcuts.put("-help", "-h");
        shortcuts.put("-?", "-h");
        shortcuts.put("-s", "-system");
        shortcuts.put("-sys", "-system");
        shortcuts.put("-u", "-userid");
        shortcuts.put("-uid", "-userid");
        shortcuts.put("-p", "-password");
        shortcuts.put("-pwd", "-password");
        shortcuts.put("-l", "-library");
        shortcuts.put("-lib", "-library");
        shortcuts.put("-c", "-command");
        shortcuts.put("-cmd", "-command");
        shortcuts.put("-scpv", "-showChoicePgmValues");
        shortcuts.put("-o", "-output");
        shortcuts.put("-d", "-debug");
        CommandLineArguments arguments = new CommandLineArguments(args, v, shortcuts);
        if (arguments.getOptionValue("-h") != null) {
            CommandHelpRetriever.usage();
        }
        AS400 system = new AS400();
        String s = arguments.getOptionValue("-system");
        if (s != null) {
            system.setSystemName(s);
        }
        if ((u = arguments.getOptionValue("-userid")) != null) {
            system.setUserId(u);
        }
        if ((p = arguments.getOptionValue("-password")) != null) {
            system.setPassword(p.toCharArray());
        }
        if ((l = arguments.getOptionValue("-library")) == null) {
            throw new ExtendedIllegalArgumentException("library", 2);
        }
        library_ = l;
        String c = arguments.getOptionValue("-command");
        if (c == null) {
            throw new ExtendedIllegalArgumentException("command", 2);
        }
        command_ = c;
        String pv = arguments.getOptionValue("-showChoicePgmValues");
        if (pv != null && (pv.length() == 0 || pv.equalsIgnoreCase("true"))) {
            utility.setShowChoiceProgramValues(true);
        }
        if ((o = arguments.getOptionValue("-output")) != null) {
            utility.setOutputLocation(o);
        }
        if ((d = arguments.getOptionValue("-debug")) != null && (d.length() == 0 || d.equalsIgnoreCase("true"))) {
            utility.setDebug(true);
        }
        genUIM_ = false;
        genHTML_ = true;
        String uim = arguments.getOptionValue("-uim");
        if (uim != null && (uim.length() == 0 || uim.equalsIgnoreCase("true"))) {
            genUIM_ = true;
            genHTML_ = false;
        }
        if ((html = arguments.getOptionValue("-html")) != null && (html.length() == 0 || html.equalsIgnoreCase("true"))) {
            genHTML_ = true;
        }
        return system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDebug(boolean debug) {
        CommandHelpRetriever commandHelpRetriever = this;
        synchronized (commandHelpRetriever) {
            this.debug_ = debug;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputLocation(String location) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        CommandHelpRetriever commandHelpRetriever = this;
        synchronized (commandHelpRetriever) {
            this.outputDirectory_ = location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowChoiceProgramValues(boolean show) {
        CommandHelpRetriever commandHelpRetriever = this;
        synchronized (commandHelpRetriever) {
            this.showChoices_ = show;
        }
    }

    private void setupHTMLTransformer(Locale locale) throws TransformerConfigurationException {
        this.htmlTransformer_ = htmlTemplate_.newTransformer();
        this.htmlTransformer_.setURIResolver(this.resolver_);
        String[][] transformedParms = null;
        transformedParms = locale == null ? transformedHTMLParms_ : CommandHelpRetriever.getTransformedHTMLParms(locale);
        for (int i = 0; i < transformedParms.length; ++i) {
            this.htmlTransformer_.setParameter(transformedParms[i][0], transformedParms[i][1]);
        }
    }

    private void setupUIMTransformer(Locale locale) throws TransformerConfigurationException {
        this.uimTransformer_ = uimTemplate_.newTransformer();
        String[][] transformedParms = null;
        transformedParms = locale == null ? CommandHelpRetriever.getTransformedUIMParms(Locale.getDefault()) : CommandHelpRetriever.getTransformedUIMParms(locale);
        for (int i = 0; i < transformedParms.length; ++i) {
            this.uimTransformer_.setParameter(transformedParms[i][0], transformedParms[i][1]);
        }
    }

    static void usage() {
        ResourceBundle bundle2 = ResourceBundle.getBundle("com.ibm.as400.access.MRI2");
        String usage = bundle2.getString("PROXY_SERVER_USAGE");
        String optionslc = bundle2.getString("PROXY_SERVER_OPTIONSLC");
        String optionsuc = bundle2.getString("PROXY_SERVER_OPTIONSUC");
        String shortcuts = bundle2.getString("PROXY_SERVER_SHORTCUTS");
        System.out.println(usage + ":");
        System.out.println();
        System.out.println("  com.ibm.as400.util.CommandHelpRetriever [ " + optionslc + " ]");
        System.out.println();
        System.out.println("  -library library");
        System.out.println("  -command command");
        System.out.println();
        System.out.println(optionsuc + ":");
        System.out.println();
        System.out.println("  [ -html ]");
        System.out.println("  [ -uim ]");
        System.out.println("  [ -system systemName ]");
        System.out.println("  [ -userID userID ]");
        System.out.println("  [ -password password ]");
        System.out.println("  [ -showChoicePgmValues ]");
        System.out.println("  [ -output outputLocation ]");
        System.out.println("  [ -debug ]");
        System.out.println();
        System.out.println(shortcuts + ":");
        System.out.println();
        System.out.println("  -h | -?");
        System.out.println("  -l library");
        System.out.println("  -c command");
        System.out.println("  [ -s systemName ]");
        System.out.println("  [ -u userID ]");
        System.out.println("  [ -p password ]");
        System.out.println("  [ -scpv [true | false] ]");
        System.out.println("  [ -o outputLocation ]");
        System.out.println("  [ -d [true | false] ]");
        if (System.getProperty("com.ibm.as400.util.DisableExit") == null && System.getenv("com.ibm.as400.util.DisableExit") == null) {
            System.exit(0);
        }
    }

    static {
        library_ = null;
        command_ = null;
        mriHTMLTags_ = new String[]{"ALLOW_ALL", "ALLOW_COMPILED_CL_OR_REXX1", "ALLOW_COMPILED_CL_OR_REXX2", "ALLOW_INTERACTIVE1", "ALLOW_INTERACTIVE2", "ALLOW_JOB_BATCH", "ALLOW_JOB_INTERACTIVE", "ALLOW_MODULE_BATCH", "ALLOW_MODULE_INTERACTIVE", "ALLOW_PROGRAM_BATCH", "ALLOW_PROGRAM_INTERACTIVE", "ALLOW_REXX_BATCH", "ALLOW_REXX_INTERACTIVE", "ALLOW_USING_COMMAND_API", "CHOICES", "ELEMENT", "ERRORS", "EXAMPLES", "KEY", "KEYWORD", "NAME_LOWERCASE", "NONE", "NOTES", "OPTIONAL", "PARAMETERS", "POSITIONAL", "QUALIFIER", "REQUIRED", "THREADSAFE", "THREADSAFE_CONDITIONAL", "TOP_OF_PAGE", "TYPE_CL_VARIABLE_NAME", "TYPE_COMMAND_STRING", "TYPE_COMMUNICATIONS_NAME", "TYPE_DATE", "TYPE_DECIMAL_NUMBER", "TYPE_ELEMENT_LIST", "TYPE_GENERIC_NAME", "TYPE_INTEGER", "TYPE_NOT_RESTRICTED", "TYPE_PATH_NAME", "TYPE_QUALIFIED_JOB_NAME", "TYPE_QUALIFIED_OBJECT_NAME", "TYPE_QUALIFIER_LIST", "TYPE_SIMPLE_NAME", "TYPE_TIME", "TYPE_VALUE_LOGICAL", "TYPE_VALUE_CHARACTER", "TYPE_VALUE_HEX", "TYPE_UNSIGNED_INTEGER", "UNKNOWN", "VALUES_OTHER", "VALUES_OTHER_REPEAT", "VALUES_REPEAT", "VALUES_SINGLE", "WHERE_ALLOWED_TO_RUN"};
        mriUIMTags_ = new String[]{"HELP", "HELP_FOR_COMMAND", "INTRO_COMMAND_HELP", "DESCRIBE_COMMAND", "RESTRICTIONS_HEADING", "RESTRICTION_AUT", "RESTRICTION_THREADSAFE", "LIST_SPECIAL_AUT", "LIST_OTHER_AUT", "LIST_THREADSAFE_RESTRICTIONS", "DESCRIBE_OTHER_RESTRICTION", "RESTRICTION_COMMENT", "NO_PARAMETERS", "EXAMPLES_HEADING", "EXAMPLE_1_TITLE", "DESCRIBE_EXAMPLE_1", "EXAMPLE_2_TITLE", "DESCRIBE_EXAMPLE_2", "INTRO_EXAMPLE_HELP", "ERROR_MESSAGES_HEADING", "ERROR_MESSAGES_COMMENT_1", "ERROR_MESSAGES_COMMENT_2", "ERROR_MESSAGES_COMMENT_3", "HELP_FOR_PARAMETER", "INTRO_PARAMETER_HELP", "DESCRIBE_PARAMETER", "REQUIRED_PARAMETER", "ELEMENT", "QUALIFIER", "VALUES_OTHER", "VALUES_OTHER_REPEAT", "VALUES_REPEAT", "VALUES_SINGLE", "VALUE_CHARACTER", "VALUE_CL_VARIABLE_NAME", "VALUE_COMMAND_STRING", "VALUE_COMMUNICATIONS_NAME", "VALUE_DATE", "VALUE_DECIMAL_NUMBER", "VALUE_GENERIC_NAME", "VALUE_HEX", "VALUE_INTEGER", "VALUE_LOGICAL", "VALUE_NAME", "VALUE_NOT_RESTRICTED", "VALUE_PATH_NAME", "VALUE_SIMPLE_NAME", "VALUE_TIME", "VALUE_UNSIGNED_INTEGER", "SPECIFY_VALUE", "SPECIFY_NAME", "SPECIFY_GENERIC_NAME", "SPECIFY_PATH_NAME", "SPECIFY_NUMBER", "SPECIFY_CL_VARIABLE_NAME", "SPECIFY_COMMAND_STRING", "SPECIFY_DATE", "SPECIFY_TIME", "MULTIPLE_PARAMETER_VALUES_ALLOWED", "MULTIPLE_ELEMENT_VALUES_ALLOWED", "DESCRIBE_PREDEFINED_PARAMETER_VALUE", "DESCRIBE_USERDEFINED_PARAMETER_VALUE", "DESCRIBE_PARAMETER_DEFAULT", "DESCRIBE_PARAMETER_VALUE_WITH_RANGE"};
        transformedHTMLParms_ = CommandHelpRetriever.getTransformedHTMLParms(Locale.getDefault());
        try {
            ClassLoader classloader;
            if (Trace.isTraceOn()) {
                Trace.log(1, "Loading gencmddoc.xsl.");
            }
            if ((classloader = CommandHelpRetriever.class.getClassLoader()) == null) {
                classloader = ClassLoader.getSystemClassLoader();
            }
            String docXSLURI = classloader.getResource("com/ibm/as400/util/gencmddoc.xsl").toString();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Loading gencmdhlp.xsl.");
            }
            String hlpXSLURI = classloader.getResource("com/ibm/as400/util/gencmdhlp.xsl").toString();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Loading XSL templates.");
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            defaultResolver_ = factory.getURIResolver();
            htmlTemplate_ = factory.newTemplates(new StreamSource(docXSLURI));
            uimTemplate_ = factory.newTemplates(new StreamSource(hlpXSLURI));
        }
        catch (Exception e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to initialize CommandHelpRetriever XSL and MRI.", (Throwable)e);
            }
            throw new RuntimeException(e.toString());
        }
        genUIM_ = false;
        genHTML_ = true;
    }

    private static class HelpResolver
    implements URIResolver {
        public String helpResults_;

        private HelpResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            if (href.indexOf("myCommandHelpResolver") > -1) {
                return new StreamSource(new StringReader(this.helpResults_));
            }
            if (href.indexOf("__NO_HELP") > -1) {
                return new StreamSource(new StringReader("<help>NO HELP AVAILABLE</help>"));
            }
            return defaultResolver_.resolve(href, base);
        }
    }
}

