/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.resource.RJavaProgram;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class AS400ClassPathOptimizer {
    public static final int NO_OPTIMIZATION = 0;
    public static final int LEVEL_10 = 10;
    public static final int LEVEL_20 = 20;
    public static final int LEVEL_30 = 30;
    public static final int LEVEL_40 = 40;
    public static final String LICOPT_NOPRERESOLVEEXTREF = "NOPRERESOLVEEXTREF";
    private AS400 as400_;
    private CommandCall commandCall_;
    private String classpath_;
    private boolean wait_ = false;
    private boolean optimizeInParallel_ = false;
    private int optimizationLevel_ = 0;
    private boolean optimizeDirectories_ = false;
    private String licensedInternalCodeOptions_ = "NOPRERESOLVEEXTREF";
    private PrintStream out_;

    public AS400ClassPathOptimizer() {
        this(null, null);
    }

    public AS400ClassPathOptimizer(AS400 as400) {
        this(as400, null);
    }

    public AS400ClassPathOptimizer(AS400 as400, String classpath) {
        this.setAS400(as400);
        this.setClasspath(classpath);
    }

    public void setClasspath(String classpath) {
        this.classpath_ = classpath;
    }

    public void setAS400(AS400 as400) {
        this.as400_ = as400;
    }

    public void setWaitForOptimizations(boolean s) {
        this.wait_ = s;
    }

    public boolean isWaitForOptimizations() {
        return this.wait_;
    }

    public void setOptimizeInParallel(boolean s) {
        this.optimizeInParallel_ = s;
    }

    public void setOptimizeDirectories(boolean b) {
        this.optimizeDirectories_ = b;
    }

    public boolean isOptimizeInParallel() {
        return this.optimizeInParallel_;
    }

    public String getLicensedInternalCodeOptions() {
        return this.licensedInternalCodeOptions_;
    }

    public void setLicensedInternalCodeOptions(String s) {
        this.licensedInternalCodeOptions_ = s;
    }

    public void setOptimizationLevel(int level) {
        this.optimizationLevel_ = level;
    }

    public void setOutputLog(PrintStream out) {
        this.out_ = out;
    }

    public void optimize() throws Exception {
        if (this.optimizeInParallel_) {
            this.wait_ = false;
        }
        this.run();
    }

    public void run() throws Exception {
        this.logit("classpath=" + this.classpath_);
        this.logit("wait=" + this.wait_);
        this.logit("optimizationLevel=" + this.optimizationLevel_);
        this.logit("optimizeDirectories=" + this.optimizeDirectories_);
        this.logit("optimizeInParallel=" + this.optimizeInParallel_);
        this.logit("licensedInternalCodeOptions=" + this.licensedInternalCodeOptions_);
        StringTokenizer st = new StringTokenizer(this.classpath_, ";:");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            IFSFile file = new IFSFile(this.as400_, path);
            if (file.isDirectory() && !this.optimizeDirectories_) {
                this.logit(path + " is a directory and optimize directories is false.");
                continue;
            }
            if (file.isAbsolute() && !file.exists()) {
                this.logit(path + " does not exist.");
                continue;
            }
            if (!file.isAbsolute()) {
                this.logit(path + " must be an absolute path to be optimized.");
                continue;
            }
            int level = this.retrieveOptimizationLevel(file);
            if (level < this.optimizationLevel_) {
                this.optimize(file);
                this.logit(path + " currently optimized at level " + level + " optimizing to level " + this.optimizationLevel_);
                continue;
            }
            this.logit(path + " currently optimized at level " + level + " not optimizing.");
        }
    }

    private void optimize(IFSFile file) throws Exception {
        String command = this.getOptimizationCommand(file);
        if (this.wait_) {
            this.runCommand(command);
        } else if (this.optimizeInParallel_) {
            this.runCommand("SBMJOB JOB(CRTJVAPGM) CMD(" + command + ")");
        }
    }

    void logit(String msg) {
        if (this.out_ != null) {
            this.out_.println(msg);
        }
    }

    private String getOptimizationCommand(IFSFile file) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("CRTJVAPGM ");
        sb.append("CLSF(").append(file.getAbsolutePath()).append(") ");
        sb.append("OPTIMIZE(").append(this.optimizationLevel_).append(") ");
        if (file.isDirectory() && this.optimizeDirectories_) {
            sb.append("SUBTREE(*ALL) ");
        }
        if (this.licensedInternalCodeOptions_ != null) {
            sb.append("LICOPT(").append(this.licensedInternalCodeOptions_).append(") ");
        }
        return sb.toString();
    }

    void runCommand(String command) throws Exception {
        if (this.commandCall_ == null) {
            this.commandCall_ = new CommandCall(this.as400_);
        }
        this.logit(command);
        boolean status = this.commandCall_.run(command);
        if (!status) {
            AS400Message[] log = this.commandCall_.getMessageList();
            this.logit("error running command " + command);
            for (int i = 0; i < log.length; ++i) {
                this.logit(i + ":" + log[i].getText());
            }
        }
    }

    int retrieveOptimizationLevel(IFSFile file) throws Exception {
        RJavaProgram javaProgram = new RJavaProgram(this.as400_, file.getAbsolutePath());
        Integer integer = (Integer)javaProgram.getAttributeUnchangedValue("OPTIMIZATION");
        return integer;
    }
}

