/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400AuthenticationException;
import com.ibm.as400.security.auth.AS400BasicAuthenticationCredential;
import com.ibm.as400.security.auth.AS400BasicAuthenticationPrincipal;
import com.ibm.as400.security.auth.AS400Credential;
import com.ibm.as400.security.auth.AS400Principal;
import com.ibm.as400.security.auth.AuthenticationSystem;
import com.ibm.as400.security.auth.ProfileTokenEnhancedInfo;
import com.ibm.as400.security.auth.ProfileTokenImpl;
import com.ibm.as400.security.auth.UserProfilePrincipal;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.Random;

public final class ProfileTokenCredential
extends AS400Credential
implements AS400BasicAuthenticationCredential {
    static final long serialVersionUID = 4L;
    private static boolean useEnhancedProfileTokens_ = true;
    private byte[] addr_ = new byte[9];
    private byte[] mask_ = new byte[7];
    private byte[] token_ = null;
    private int type_ = 1;
    private int timeoutInterval_ = 3600;
    private int authenticationIndicator_ = 5;
    private ProfileTokenEnhancedInfo enhancedInfo_ = new ProfileTokenEnhancedInfo();
    private boolean noRefresh_ = false;
    private int creator_ = 0;
    private static final int MAX_USERPROFILE_LENGTH = 10;
    static final int MAX_PASSWORD_LENGTH = 128;
    public static final int MAX_ADDITIONALAUTHENTICATIONFACTOR_LENGTH = 64;
    public static final int MAX_VERIFICATIONID_LENGTH = 30;
    public static final int MAX_IPADDRESS_LENGTH = 46;
    public static final int TYPE_SINGLE_USE = 1;
    public static final int TYPE_MULTIPLE_USE_NON_RENEWABLE = 2;
    public static final int TYPE_MULTIPLE_USE_RENEWABLE = 3;
    public static final int TOKEN_LENGTH = 32;
    public static final int CREATOR_UNKNOWN = 0;
    public static final int CREATOR_SIGNON_SERVER = 1;
    public static final int CREATOR_NATIVE_API = 2;
    public static final int PW_NOPWD = 1;
    public static final int PW_NOPWDCHK = 2;
    public static final String DEFAULT_VERIFICATION_ID = "QIBM_OS400_JT400              ";

    public ProfileTokenCredential() {
        new Random().nextBytes(this.addr_);
        new Random().nextBytes(this.mask_);
    }

    public ProfileTokenCredential(AS400 system, byte[] token, int tokenType, int timeoutInterval) throws AS400AuthenticationException {
        this(system, token, tokenType, timeoutInterval, null, null, 0, null, 0);
    }

    public ProfileTokenCredential(AS400 system, byte[] token, int tokenType, int timeoutInterval, String verificationID, String remoteIPAddress, int remotePort, String localIPAddress, int localPort) throws AS400AuthenticationException {
        this();
        try {
            this.setSystem(system);
            if (verificationID != null || remoteIPAddress != null) {
                this.enhancedInfo_.initialize(true, verificationID, remoteIPAddress, remotePort, localIPAddress, localPort);
                this.setToken(token, this.enhancedInfo_);
            } else {
                this.setToken(token);
                this.enhancedInfo_.reset();
            }
            this.setTokenType(tokenType);
            this.setTimeoutInterval(timeoutInterval);
        }
        catch (PropertyVetoException pve) {
            AuthenticationSystem.handleUnexpectedException(pve);
        }
    }

    private static byte[] decode(byte[] adder, byte[] mask, byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buf[i] = (byte)((mask[i % mask.length] ^ bytes[i]) - adder[i % adder.length]);
        }
        return buf;
    }

    private static byte[] encode(byte[] adder, byte[] mask, byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buf[i] = (byte)(bytes[i] + adder[i % adder.length] ^ mask[i % mask.length]);
        }
        return buf;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileTokenCredential)) {
            return false;
        }
        return this.hashCode() == ((ProfileTokenCredential)o).hashCode();
    }

    public int getTimeoutInterval() {
        return this.timeoutInterval_;
    }

    public synchronized byte[] getToken() {
        if (this.token_ == null) {
            return null;
        }
        byte[] rawBytes = ProfileTokenCredential.decode(this.addr_, this.mask_, this.token_);
        if (Trace.isTraceOn()) {
            Trace.log(3, this, " token enhancedInfo=" + this.enhancedInfo_.toString());
            Trace.log(3, (Object)this, " getPrimitiveToken returned", rawBytes);
        }
        return rawBytes;
    }

    public int getTokenType() {
        return this.type_;
    }

    public int superHashCode() {
        return super.hashCode();
    }

    public int hashCode() {
        int hash = 104473;
        if (this.token_ != null) {
            byte[] tkn = this.getToken();
            for (int i = 0; i < tkn.length; ++i) {
                hash ^= tkn[i];
            }
        }
        hash ^= this.type_ ^ 0x3841;
        hash ^= this.timeoutInterval_ ^ 0x534F;
        hash ^= this.isPrivate() ? 15501 : 12003;
        if (this.getPrincipal() != null) {
            hash ^= this.getPrincipal().hashCode();
        }
        if (this.getSystem() != null) {
            hash ^= this.getSystem().getSystemName().hashCode();
        }
        return hash;
    }

    @Override
    String implClassNameNative() {
        return "com.ibm.as400.access.ProfileTokenImplNative";
    }

    @Override
    String implClassNameRemote() {
        return "com.ibm.as400.security.auth.ProfileTokenImplRemote";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void initialize(AS400BasicAuthenticationPrincipal principal, String password, boolean isPrivate, boolean isReusable, boolean isRenewable, int timeoutInterval) throws Exception {
        char[] passwordChars = password == null ? null : password.toCharArray();
        try {
            this.initialize(principal, passwordChars, isPrivate, isReusable, isRenewable, timeoutInterval);
        }
        finally {
            ProfileTokenCredential.clearArray(passwordChars);
        }
    }

    @Override
    public void initialize(AS400BasicAuthenticationPrincipal principal, char[] password, boolean isPrivate, boolean isReusable, boolean isRenewable, int timeoutInterval) throws Exception {
        this.initialize(principal, password, null, this.authenticationIndicator_, isPrivate, isReusable, isRenewable, timeoutInterval, this.enhancedInfo_);
    }

    @Override
    public void initialize(AS400BasicAuthenticationPrincipal principal, char[] password, char[] additionalAuthFactor, int authenticationIndicator, boolean isPrivate, boolean isReusable, boolean isRenewable, int timeoutInterval, ProfileTokenEnhancedInfo enhancedInfo) throws Exception {
        AS400Principal pr;
        String systemName;
        AS400 oldSys;
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Initializing credential >> ").append(this.toString()).append(", for principal >> ").append(principal.toString()).append(", isPrivate == ").append(isPrivate).append(", isReusable == ").append(isReusable).append(", isRenewable == ").append(isRenewable).append(", timeoutInterval == ").append(timeoutInterval).append(", verificationID == ").append(enhancedInfo.getVerificationID()).append(", localIPAddress == ").append(enhancedInfo.getLocalIPAddress()).append(", localPort == ").append(enhancedInfo.getLocalPort()).append(", remoteIPAddress == ").append(enhancedInfo.getRemoteIPAddress()).append(", remotePort == ").append(enhancedInfo.getRemotePort()).toString());
        }
        if (isRenewable && !isReusable) {
            Trace.log(2, "Profile tokens must be multi-use if declared as regenerable.");
            throw new ExtendedIllegalArgumentException("isReusable", 2);
        }
        AS400 sys = AuthenticationSystem.localHost();
        if (!AuthenticationSystem.isLocal(sys) && (oldSys = this.getSystem()) != null && (systemName = oldSys.getSystemName()) != null && systemName.length() > 0) {
            sys = new AS400(systemName, principal.getUserProfileName(), password, additionalAuthFactor);
            sys.setGuiAvailable(false);
        }
        this.system_ = sys;
        this.principal_ = pr = AS400Principal.class.isAssignableFrom(principal.getClass()) ? (AS400Principal)((Object)principal) : new UserProfilePrincipal(sys, principal.getUserProfileName());
        this.private_ = isPrivate;
        this.timeoutInterval_ = timeoutInterval;
        this.type_ = isRenewable ? 3 : (isReusable ? 2 : 1);
        this.authenticationIndicator_ = authenticationIndicator;
        this.setEnhancedInfo(enhancedInfo);
        this.setTokenExtended(pr, password, additionalAuthFactor);
    }

    public void setEnhancedInfo(ProfileTokenEnhancedInfo enhancedInfo) {
        if (enhancedInfo == null) {
            Trace.log(2, "enhancedInfo is null");
            throw new ExtendedIllegalArgumentException("enhancedInfo", 2);
        }
        this.enhancedInfo_ = new ProfileTokenEnhancedInfo(enhancedInfo);
    }

    @Override
    void invalidateProperties() {
        super.invalidateProperties();
        this.token_ = null;
        this.enhancedInfo_.reset();
    }

    @Override
    public boolean isRenewable() {
        return this.type_ == 3;
    }

    public boolean isReusable() {
        return this.type_ == 2 || this.type_ == 3;
    }

    void primitiveSetToken(byte[] bytes, boolean enhancedProfileToken) throws AS400AuthenticationException {
        if (!enhancedProfileToken) {
            this.enhancedInfo_.reset();
        } else {
            this.enhancedInfo_.setEnhancedTokenCreated(true);
        }
        this.token_ = ProfileTokenCredential.encode(this.addr_, this.mask_, bytes);
    }

    @Override
    public void refresh() throws AS400SecurityException {
        this.refresh(this.getTokenType(), this.getTimeoutInterval());
    }

    public synchronized void refresh(int type, int timeoutInterval) throws AS400SecurityException {
        if (Trace.isTraceOn()) {
            Trace.log(3, this, "refresh(" + type + "," + timeoutInterval);
        }
        while (this.noRefresh_) {
            if (Trace.isTraceOn()) {
                Trace.log(3, this, " refresh stuck because of noRefresh");
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.checkAuthenticationPermission("refreshCredential");
        if (!this.isRenewable()) {
            return;
        }
        if (type < 1 || type > 3) {
            Trace.log(2, "Token type " + type + " out of range");
            throw new ExtendedIllegalArgumentException("type", 4);
        }
        if (timeoutInterval < 1 || timeoutInterval > 3600) {
            Trace.log(2, "Timeout interval " + timeoutInterval + " out of range");
            throw new ExtendedIllegalArgumentException("timeoutInterval", 4);
        }
        byte[] old = this.getToken();
        byte[] bytes = ((ProfileTokenImpl)this.getImpl()).refresh(type, timeoutInterval);
        this.primitiveSetToken(bytes, this.enhancedInfo_.isEnhancedProfileToken());
        this.type_ = type;
        this.timeoutInterval_ = timeoutInterval;
        this.fireRefreshed();
        this.firePropertyChange("token", old, bytes);
        if (Trace.isTraceOn()) {
            if (Trace.isTraceOn()) {
                Trace.log(8, (Object)this, "refresh() old  ", old);
                Trace.log(8, (Object)this, "refresh() new  ", bytes);
            }
            Trace.log(3, new StringBuffer("ProfileTokenCredential@" + System.identityHashCode(this) + " Credential refreshed with type ").append(type).append(" and timeoutInterval = ").append(timeoutInterval).append(" >> ").append(this.toString()).toString());
        }
    }

    public void setTimeoutInterval(int seconds) throws PropertyVetoException {
        this.validatePropertyChange("timeoutInterval");
        if (seconds < 1 || seconds > 3600) {
            Trace.log(2, "Number of seconds " + seconds + " out of range");
            throw new ExtendedIllegalArgumentException("seconds", 4);
        }
        Integer old = this.timeoutInterval_;
        Integer sec = seconds;
        this.fireVetoableChange("timeoutInterval", old, sec);
        this.timeoutInterval_ = seconds;
        this.firePropertyChange("timeoutInterval", old, sec);
    }

    public synchronized void setToken(byte[] bytes) throws PropertyVetoException, AS400AuthenticationException {
        this.setToken(bytes, null);
    }

    public synchronized void setToken(byte[] bytes, ProfileTokenEnhancedInfo enhancedInfo) throws PropertyVetoException, AS400AuthenticationException {
        this.validatePropertyChange("token");
        if (bytes == null) {
            Trace.log(2, "Token byte array is null");
            throw new ExtendedIllegalArgumentException("bytes", 2);
        }
        if (bytes.length != 32) {
            Trace.log(2, "Token of length " + bytes.length + " not valid ");
            throw new ExtendedIllegalArgumentException("bytes", 1);
        }
        byte[] old = this.getToken();
        this.fireVetoableChange("token", old, bytes);
        if (enhancedInfo != null) {
            this.enhancedInfo_ = enhancedInfo;
        } else {
            this.enhancedInfo_.reset();
        }
        this.primitiveSetToken(bytes, this.enhancedInfo_.isEnhancedProfileToken());
        this.firePropertyChange("token", old, bytes);
    }

    @Deprecated
    public void setToken(AS400Principal principal, String password) throws PropertyVetoException, AS400SecurityException {
        this.setToken(principal.getUserProfileName(), password);
    }

    @Deprecated
    public void setToken(String name, String password) throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        if (name == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (name.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        if (password == null) {
            Trace.log(2, "User profile password is null");
            throw new ExtendedIllegalArgumentException("password", 2);
        }
        ProfileTokenImpl impl = (ProfileTokenImpl)this.getImplPrimitive();
        char[] passwordChars = password.toCharArray();
        if (this.enhancedInfo_ == null) {
            this.enhancedInfo_ = new ProfileTokenEnhancedInfo();
        }
        byte[] newToken = impl.generateRawTokenExtended(name, passwordChars, null, this.getTokenType(), this.getTimeoutInterval(), this.enhancedInfo_);
        this.primitiveSetToken(newToken, this.enhancedInfo_.isEnhancedProfileToken());
        Arrays.fill(passwordChars, '\u0000');
        this.setImpl(impl);
        this.fireCreated();
    }

    public void setToken(AS400Principal principal, int passwordSpecialValue) throws PropertyVetoException, AS400SecurityException {
        this.setToken(principal.getUserProfileName(), passwordSpecialValue);
    }

    public void setToken(String name, int passwordSpecialValue) throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        if (name == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (name.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        switch (passwordSpecialValue) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                Trace.log(2, "Special value for password is not valid");
                throw new ExtendedIllegalArgumentException("password", 2);
            }
        }
        ProfileTokenImpl impl = (ProfileTokenImpl)this.getImplPrimitive();
        if (Trace.isTraceOn()) {
            Trace.log(1, "ProfileTokenCredential generating profile token w/special value for user: " + name);
        }
        impl.generateProfileToken(name, passwordSpecialValue, this);
        this.setImpl(impl);
        this.fireCreated();
    }

    @Deprecated
    public void setTokenExtended(AS400Principal principal, String password) throws PropertyVetoException, AS400SecurityException {
        this.setTokenExtended(principal.getUserProfileName(), password);
    }

    public void setTokenExtended(AS400Principal principal, char[] password) throws PropertyVetoException, AS400SecurityException {
        this.setTokenExtended(principal.getUserProfileName(), password);
    }

    public void setTokenExtended(AS400Principal principal, char[] password, char[] additionalAuthenticationFactor) throws PropertyVetoException, AS400SecurityException {
        this.setTokenExtended(principal.getUserProfileName(), password, additionalAuthenticationFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setTokenExtended(String name, String password) throws PropertyVetoException, AS400SecurityException {
        char[] passwordChars = password == null ? null : password.toCharArray();
        try {
            this.setTokenExtended(name, passwordChars);
        }
        finally {
            ProfileTokenCredential.clearArray(passwordChars);
        }
    }

    public void setTokenExtended(String name, char[] password) throws PropertyVetoException, AS400SecurityException {
        if (Trace.isTraceOn()) {
            Object passwordInfo = "";
            passwordInfo = password != null ? "char[" + password.length + "]" : "null";
            String nameInfo = "";
            nameInfo = name != null ? name : "null";
            Trace.log(3, "setTokenExtended(" + nameInfo + "," + (String)passwordInfo + ")");
        }
        this.validatePropertySet("system", this.getSystem());
        if (name == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (name.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        if (password == null) {
            Trace.log(2, "User profile password is null");
            throw new ExtendedIllegalArgumentException("password", 2);
        }
        ProfileTokenImpl impl = (ProfileTokenImpl)this.getImplPrimitive();
        impl.generateProfileTokenExtended(name, password, null, this);
        this.setImpl(impl);
        this.fireCreated();
    }

    public void setTokenExtended(String name, char[] password, char[] additionalAuthenticationFactor) throws PropertyVetoException, AS400SecurityException {
        if (Trace.isTraceOn()) {
            Object passwordInfo = "";
            passwordInfo = password != null ? "char[" + password.length + "]" : "null";
            String nameInfo = "";
            nameInfo = name != null ? name : "null";
            Trace.log(3, "setTokenExtended(" + nameInfo + "," + (String)passwordInfo + ")");
        }
        this.validatePropertySet("system", this.getSystem());
        if (name == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (name.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        if (password == null) {
            Trace.log(2, "User profile password is null");
            throw new ExtendedIllegalArgumentException("password", 2);
        }
        ProfileTokenImpl impl = (ProfileTokenImpl)this.getImplPrimitive();
        impl.generateProfileTokenExtended(name, password, additionalAuthenticationFactor, this);
        this.setImpl(impl);
        this.fireCreated();
    }

    public void setTokenType(int type) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(3, this, "setTokenType(" + type + ")");
        }
        this.validatePropertyChange("tokenType");
        if (type < 1 || type > 3) {
            Trace.log(2, "Token type " + type + " out of range");
            throw new ExtendedIllegalArgumentException("type", 4);
        }
        Integer old = this.type_;
        Integer typ = type;
        this.fireVetoableChange("tokenType", old, typ);
        this.type_ = type;
        this.firePropertyChange("tokenType", old, typ);
    }

    public String toString() {
        return new StringBuffer(256).append(super.toString()).append('[').append(this.getTokenType()).append(',').append(this.getTimeoutInterval()).append(']').toString();
    }

    @Override
    boolean typeIsStandalone() {
        return true;
    }

    @Override
    boolean typeIsTimed() {
        return true;
    }

    @Override
    void validateProperties() {
        super.validateProperties();
        this.validatePropertySet("token", this.getToken());
    }

    public synchronized void preventRefresh() throws InterruptedException {
        if (Trace.isTraceOn()) {
            Trace.log(3, this, "preventRefresh");
        }
        this.noRefresh_ = true;
    }

    public synchronized void allowRefresh() {
        if (Trace.isTraceOn()) {
            Trace.log(3, this, "allowRefresh");
        }
        this.noRefresh_ = false;
        this.notify();
    }

    public static boolean useEnhancedProfileTokens() {
        return useEnhancedProfileTokens_;
    }

    public void setVerificationID(String verificationID) throws PropertyVetoException {
        this.validatePropertyChange("verificationID");
        if (verificationID != null && verificationID.length() > 30) {
            throw new ExtendedIllegalArgumentException("verificationID", 1);
        }
        String old = this.enhancedInfo_.getVerificationID();
        this.fireVetoableChange("verificationID", old, verificationID);
        this.enhancedInfo_.setVerificationID(verificationID);
        this.firePropertyChange("verificationID", old, verificationID);
    }

    public String getVerificationID() {
        String verificationID;
        String string = verificationID = !useEnhancedProfileTokens_ ? "*NOUSE" : this.enhancedInfo_.getVerificationID();
        if (Trace.isTraceOn()) {
            Trace.log(3, this, "verificationId=" + verificationID);
        }
        return verificationID;
    }

    public void setLocalIPAddress(String localIPAddress) throws PropertyVetoException {
        this.validatePropertyChange("localIPAddress");
        if (localIPAddress != null && localIPAddress.length() > 46) {
            throw new ExtendedIllegalArgumentException("localIPAddress", 1);
        }
        String old = this.enhancedInfo_.getLocalIPAddress();
        this.fireVetoableChange("localIPAddress", old, localIPAddress);
        this.enhancedInfo_.setLocalIPAddress(localIPAddress);
        this.firePropertyChange("localIPAddress", old, localIPAddress);
    }

    public String getLocalIPAddress() {
        return this.enhancedInfo_.getLocalIPAddress();
    }

    public void setRemoteIPAddress(String remoteIPAddress) throws PropertyVetoException {
        this.validatePropertyChange("remoteIPAddress");
        if (remoteIPAddress != null && remoteIPAddress.length() > 46) {
            throw new ExtendedIllegalArgumentException("remoteIPAddress", 1);
        }
        String old = this.enhancedInfo_.getRemoteIPAddress();
        this.fireVetoableChange("remoteIPAddress", old, remoteIPAddress);
        this.enhancedInfo_.setRemoteIPAddress(remoteIPAddress);
        this.firePropertyChange("remoteIPAddress", old, remoteIPAddress);
    }

    public String getRemoteIPAddress() {
        String remoteIPAddress;
        String string = remoteIPAddress = useEnhancedProfileTokens_ ? this.enhancedInfo_.getRemoteIPAddress() : "*NOUSE";
        if (Trace.isTraceOn()) {
            Trace.log(3, this, " getRemoteIPAddress=" + remoteIPAddress);
        }
        return remoteIPAddress;
    }

    public void setRemotePort(int remotePort) throws PropertyVetoException {
        this.validatePropertyChange("remotePort");
        if (remotePort < 0 || remotePort > 65535) {
            throw new ExtendedIllegalArgumentException("remotePort", 2);
        }
        int old = this.enhancedInfo_.getRemotePort();
        this.fireVetoableChange("remotePort", old, remotePort);
        this.enhancedInfo_.setRemotePort(remotePort);
        this.firePropertyChange("remotePort", old, remotePort);
    }

    public int getRemotePort() {
        return this.enhancedInfo_.getRemotePort();
    }

    public void setLocalPort(int localPort) throws PropertyVetoException {
        this.validatePropertyChange("localPort");
        if (localPort < 0 || localPort > 65535) {
            throw new ExtendedIllegalArgumentException("localPort", 2);
        }
        int old = this.enhancedInfo_.getLocalPort();
        this.fireVetoableChange("localPort", old, localPort);
        this.enhancedInfo_.setLocalPort(localPort);
        this.firePropertyChange("localPort", old, localPort);
    }

    public int getLocalPort() {
        return this.enhancedInfo_.getLocalPort();
    }

    public void setAuthenticationIndicator(int authenticationIndicator) throws PropertyVetoException {
        this.validatePropertyChange("authenticationIndicator");
        if (authenticationIndicator < 1 || authenticationIndicator > 5) {
            throw new ExtendedIllegalArgumentException("authenticationIndicator", 2);
        }
        int old = authenticationIndicator;
        this.fireVetoableChange("authenticationIndicator", old, authenticationIndicator);
        this.authenticationIndicator_ = authenticationIndicator;
        this.firePropertyChange("authenticationIndicator", old, authenticationIndicator);
    }

    public int getAuthenticationIndicator() {
        return this.authenticationIndicator_;
    }

    public int getTokenCreator() {
        return this.creator_;
    }

    public void setTokenCreator(int tokenCreator) throws PropertyVetoException {
        this.validatePropertyChange("tokenCreator");
        if (tokenCreator < 0 || tokenCreator > 2) {
            Trace.log(2, "Token creator " + tokenCreator + " out of range");
            throw new ExtendedIllegalArgumentException("type", 4);
        }
        Integer old = this.creator_;
        Integer crt = tokenCreator;
        this.fireVetoableChange("tokenCreator", old, crt);
        this.creator_ = tokenCreator;
        this.firePropertyChange("tokenCreator", old, crt);
    }

    boolean isTokenSet() {
        return this.token_ != null;
    }

    public boolean isEnhancedProfileToken() {
        return this.enhancedInfo_.isEnhancedProfileToken();
    }

    public ProfileTokenEnhancedInfo getEnhancedInfo() {
        return this.enhancedInfo_;
    }

    static {
        String property = System.getProperty("com.ibm.as400.access.AS400.useEnhancedProfileTokens");
        if (property != null && property.toLowerCase().equals("false")) {
            useEnhancedProfileTokens_ = false;
        }
    }
}

