/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.BufferedResourceList;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;

public class SystemResourceList
extends BufferedResourceList {
    static final long serialVersionUID = 4L;
    private static final String closeProgramName_ = "qgyclst";
    private static final String requestHandleDataNameSuffix_ = ".requestHandle";
    private static final String closeRequestHandleDataName_ = "qgyclst.requestHandle";
    private static final String getProgramName_ = "qgygtle";
    private static final String getNumberOfRecordsToReturnDataName_ = "qgygtle.numberOfRecordsToReturn";
    private static final String getRequestHandleDataName_ = "qgygtle.requestHandle";
    private static final String getStartingRecordDataName_ = "qgygtle.startingRecord";
    private static final String listInformationDataNameSuffix_ = ".listInformation";
    private static final String listStatusIndicatorDataNameSuffix_ = ".listInformation.listStatusIndicator";
    private static final String receiverVariableLengthDataName_ = "qgygtle.receiverVariableLength";
    private static final String recordsReturnedDataNameSuffix_ = ".listInformation.recordsReturned";
    private static final String requestHandleDataNameSuffix2_ = ".listInformation.requestHandle";
    private static final String totalRecordsDataNameSuffix_ = ".listInformation.totalRecords";
    private String formatName_ = null;
    private String openListProgramName_ = null;
    private ProgramMap selectionMap_ = null;
    private Hashtable selectionBidiStringTypes_ = new Hashtable();
    private transient ProgramCallDocument document_ = null;
    private transient int formatLength_ = -1;
    private transient byte[] requestHandle_ = null;

    SystemResourceList(Presentation presentation, ResourceMetaDataTable attributes, ResourceMetaDataTable selections, ResourceMetaDataTable sorts, String openListProgramName, String formatName, ProgramMap selectionMap) {
        super(presentation, attributes, selections, sorts);
        this.initializeTransient();
        if (openListProgramName == null) {
            throw new NullPointerException("openListProgramName");
        }
        this.openListProgramName_ = openListProgramName;
        this.formatName_ = formatName;
        this.selectionMap_ = selectionMap;
    }

    @Override
    public void close() throws ResourceException {
        block11: {
            if (!this.isOpen()) {
                return;
            }
            super.close();
            this.fireBusy();
            try {
                if (this.document_ != null && this.requestHandle_ != null) {
                    this.document_.setValue(closeRequestHandleDataName_, this.requestHandle_);
                    if (!this.document_.callProgram(closeProgramName_)) {
                        throw new ResourceException(this.document_.getMessageList(closeProgramName_));
                    }
                }
            }
            catch (ResourceException e) {
                AS400Message[] msgList = e.getMessageList();
                if (msgList != null && msgList.length > 0 && msgList[0].getID().equals("GUI0001")) {
                    break block11;
                }
                throw e;
            }
            catch (PcmlException e) {
                throw new ResourceException(e);
            }
            finally {
                this.requestHandle_ = null;
                this.fireIdle();
            }
        }
    }

    ProgramCallDocument getDocument() {
        return this.document_;
    }

    private void initializeTransient() {
        this.formatLength_ = -1;
    }

    @Override
    protected boolean isBidiEnabled() {
        return true;
    }

    @Override
    public boolean isResourceAvailable(long index) throws ResourceException {
        boolean isAvailable = super.isResourceAvailable(index);
        if (!isAvailable && this.isOpen()) {
            this.loadResources(0L, 0L);
            isAvailable = index < this.getListLength();
        }
        return isAvailable;
    }

    private void loadResources(long startIndex, long length) throws ResourceException {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Loading resources (" + startIndex + ", " + length + ") from list " + String.valueOf(this) + ".");
        }
        this.fireBusy();
        try {
            if (this.formatName_ != null) {
                if (this.formatLength_ == -1) {
                    this.formatLength_ = this.document_.getOutputsize(this.formatName_);
                }
                if (length == 0L) {
                    this.document_.setIntValue(receiverVariableLengthDataName_, 1);
                } else {
                    this.document_.setIntValue(receiverVariableLengthDataName_, (int)length * this.formatLength_);
                }
            }
            this.document_.setValue(getRequestHandleDataName_, this.requestHandle_);
            this.document_.setIntValue(getNumberOfRecordsToReturnDataName_, (int)length);
            this.document_.setIntValue(getStartingRecordDataName_, (int)startIndex);
            if (!this.document_.callProgram(getProgramName_)) {
                throw new ResourceException(this.document_.getMessageList(getProgramName_));
            }
            this.process(getProgramName_, startIndex - 1L);
        }
        catch (PcmlException e) {
            throw new ResourceException(e);
        }
        finally {
            this.fireIdle();
        }
    }

    Resource newResource(String programName, int[] indices) throws PcmlException, ResourceException {
        throw new ResourceException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ResourceException {
        if (this.isOpen()) {
            return;
        }
        super.open();
        this.fireBusy();
        try {
            SystemResourceList systemResourceList = this;
            synchronized (systemResourceList) {
                if (!this.isConnectionEstablished()) {
                    this.establishConnection();
                }
                try {
                    this.setOpenParameters(this.document_);
                    boolean success = this.document_.callProgram(this.openListProgramName_);
                    if (!success) {
                        throw new ResourceException(this.document_.getMessageList(this.openListProgramName_));
                    }
                    this.requestHandle_ = (byte[])this.document_.getValue(this.openListProgramName_ + requestHandleDataNameSuffix2_);
                    this.process(this.openListProgramName_, 0L);
                }
                catch (Exception e) {
                    throw new ResourceException(e);
                }
            }
        }
        finally {
            this.fireIdle();
        }
    }

    private void process(String programName, long startIndex) throws PcmlException, ResourceException {
        int recordsReturned = this.document_.getIntValue(programName + recordsReturnedDataNameSuffix_);
        for (int i = 0; i < recordsReturned; ++i) {
            int[] indices = new int[]{i};
            Resource resource = this.newResource(programName, indices);
            this.fireResourceAdded(resource, startIndex + (long)i);
        }
        String listStatusIndicator = (String)this.document_.getValue(programName + listStatusIndicatorDataNameSuffix_);
        long newLength = this.document_.getIntValue(programName + totalRecordsDataNameSuffix_);
        if (Trace.isTraceOn()) {
            Trace.log(3, "API List status indicator = " + listStatusIndicator);
            Trace.log(3, "API List length = " + newLength);
        }
        if (listStatusIndicator.equals("2")) {
            this.fireListCompleted();
        } else if (listStatusIndicator.equals("3")) {
            this.fireListInError();
        }
        if (newLength != this.getListLength()) {
            this.fireLengthChanged(newLength);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public void refreshContents() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        if (this.isOpen()) {
            this.close();
        }
        super.refreshContents();
    }

    @Override
    public void refreshStatus() throws ResourceException {
        super.refreshStatus();
        this.loadResources(0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource resourceAt(long index) throws ResourceException {
        SystemResourceList systemResourceList = this;
        synchronized (systemResourceList) {
            Resource resource = super.resourceAt(index);
            if (resource == null) {
                this.loadResources(index + 1L, this.getPageSize());
                resource = super.resourceAt(index);
                if (resource == null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "Double load scenario, index=" + index + ", number of pages= " + this.getNumberOfPages() + ", page size=" + this.getPageSize());
                    }
                    this.loadResources(index + 1L, this.getPageSize());
                    resource = super.resourceAt(index);
                }
            }
            return resource;
        }
    }

    void setOpenParameters(ProgramCallDocument document) throws PcmlException, ResourceException {
        if (this.selectionMap_ != null) {
            ResourceMetaData[] selectionMetaData = this.getSelectionMetaData();
            Object[] ids = new Object[selectionMetaData.length];
            Object[] values = new Object[selectionMetaData.length];
            int[] bidiStringTypes = new int[selectionMetaData.length];
            for (int i = 0; i < selectionMetaData.length; ++i) {
                ids[i] = selectionMetaData[i].getID();
                values[i] = this.getSelectionValue(ids[i]);
                Integer selectionBidiStringType = (Integer)this.selectionBidiStringTypes_.get(ids[i]);
                bidiStringTypes[i] = selectionBidiStringType == null ? this.getDefaultBidiStringType() : selectionBidiStringType.intValue();
            }
            this.selectionMap_.setValues(ids, values, this.getSystem(), document, this.openListProgramName_, null, bidiStringTypes);
        }
    }

    void setDocument(ProgramCallDocument document) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        this.document_ = document;
        AS400 system = this.getSystem();
        if (system != null) {
            this.document_.setSystem(system);
        }
    }

    void setOpenListProgramName(String openListProgramName) {
        if (openListProgramName == null) {
            throw new NullPointerException("openListProgramName");
        }
        this.openListProgramName_ = openListProgramName;
    }

    @Override
    public void setSelectionValue(Object selectionID, Object value, int bidiStringType) throws ResourceException {
        super.setSelectionValue(selectionID, value, bidiStringType);
        this.selectionBidiStringTypes_.put(selectionID, bidiStringType);
    }

    @Override
    public void waitForComplete() throws ResourceException {
        super.waitForComplete();
        if (!this.isComplete()) {
            this.loadResources(-1L, 0L);
        }
    }

    @Override
    public void waitForResource(long index) throws ResourceException {
        super.waitForResource(index);
        if (this.isComplete()) {
            return;
        }
        if (!this.isResourceAvailable(index)) {
            this.loadResources(index + 1L, 0L);
        }
    }
}

