/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ActiveStatusEvent;
import com.ibm.as400.resource.ActiveStatusListener;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.ResourceEvent;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ResourceListener;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Resource
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static Object counterLock_ = new Object();
    private static long counter_;
    private ResourceMetaDataTable attributes_;
    private Dictionary attributeValues_;
    private boolean connectionEstablished_ = false;
    private String currentLevel_ = null;
    private int defaultBidiStringType_ = -1;
    private Presentation presentation_;
    private boolean propertiesFrozen_ = false;
    private Object resourceKey_;
    private AS400 system_ = null;
    private transient Vector activeStatusListeners_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    transient Vector resourceListeners_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource() {
        this.presentation_ = new Presentation();
        Object object = counterLock_;
        synchronized (object) {
            this.resourceKey_ = counter_++;
        }
        this.attributes_ = new ResourceMetaDataTable();
        this.attributeValues_ = new Hashtable();
        this.initializeTransient();
    }

    public Resource(Presentation presentation, Object resourceKey, ResourceMetaData[] attributeMetaData) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        if (resourceKey == null) {
            throw new NullPointerException("resourceKey");
        }
        this.presentation_ = presentation;
        this.resourceKey_ = resourceKey;
        this.attributes_ = new ResourceMetaDataTable(attributeMetaData);
        this.attributeValues_ = new Hashtable();
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource(Presentation presentation, Object resourceKey, ResourceMetaData[] attributeMetaData, Dictionary values) {
        this(presentation, resourceKey, attributeMetaData);
        Dictionary dictionary = values;
        synchronized (dictionary) {
            Enumeration keys = values.keys();
            while (keys.hasMoreElements()) {
                Object attributeID = keys.nextElement();
                Object value = values.get(attributeID);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Initializing attribute value " + String.valueOf(attributeID) + " (for " + String.valueOf(this) + ") to " + String.valueOf(value) + "(" + String.valueOf(value.getClass()) + ")");
                }
                ResourceMetaData singleAttributeMetaData = this.attributes_.validateID(attributeID);
                values.put(attributeID, singleAttributeMetaData.validateValue(value));
            }
        }
        this.attributeValues_ = values;
        this.initializeTransient();
    }

    public Resource(Presentation presentation, Object resourceKey, ResourceMetaDataTable attributes) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        this.presentation_ = presentation;
        this.resourceKey_ = resourceKey;
        this.attributes_ = attributes;
        this.attributeValues_ = new Hashtable();
        this.initializeTransient();
    }

    public void addActiveStatusListener(ActiveStatusListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.activeStatusListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addResourceListener(ResourceListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.resourceListeners_.addElement(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    protected boolean arePropertiesFrozen() {
        return this.propertiesFrozen_;
    }

    public boolean equals(Object other) {
        if (other instanceof Resource) {
            if (this.resourceKey_ != null && ((Resource)other).resourceKey_ != null) {
                return this.resourceKey_.equals(((Resource)other).resourceKey_);
            }
            return super.equals(other);
        }
        return false;
    }

    protected void establishConnection() throws ResourceException {
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Establishing a connection for " + String.valueOf(this) + ".");
        }
        if (!this.propertiesFrozen_) {
            this.freezeProperties();
        }
        this.connectionEstablished_ = true;
    }

    protected void fireAttributeValuesRefreshed() {
        ResourceEvent event = new ResourceEvent(this, 3);
        Vector temp = (Vector)this.resourceListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ResourceListener)list.nextElement()).attributeValuesRefreshed(event);
        }
    }

    protected void fireBusy() {
        ActiveStatusEvent event = new ActiveStatusEvent(this, 1);
        Vector temp = (Vector)this.activeStatusListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ActiveStatusListener)list.nextElement()).busy(event);
        }
    }

    protected void fireIdle() {
        ActiveStatusEvent event = new ActiveStatusEvent(this, 2);
        Vector temp = (Vector)this.activeStatusListeners_.clone();
        Enumeration list = temp.elements();
        while (list.hasMoreElements()) {
            ((ActiveStatusListener)list.nextElement()).idle(event);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport_.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vetoableChangeSupport_.fireVetoableChange(propertyName, oldValue, newValue);
    }

    protected void freezeProperties() throws ResourceException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Freezing properties for " + String.valueOf(this) + ".");
        }
        this.propertiesFrozen_ = true;
    }

    public ResourceMetaData getAttributeMetaData(Object attributeID) {
        return this.attributes_.getMetaData(attributeID);
    }

    public ResourceMetaData[] getAttributeMetaData() {
        return this.attributes_.getMetaData(this.getCurrentLevel());
    }

    public Object getAttributeValue(Object attributeID) throws ResourceException {
        if (this.isBidiEnabled()) {
            return this.getAttributeValue(attributeID, this.getDefaultBidiStringType());
        }
        return this.getAttributeValueImplementation(attributeID);
    }

    public Object getAttributeValue(Object attributeID, int bidiStringType) throws ResourceException {
        if (!this.isBidiEnabled()) {
            return this.getAttributeValue(attributeID);
        }
        return this.getAttributeValueImplementation(attributeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getAttributeValueImplementation(Object attributeID) throws ResourceException {
        Resource resource = this;
        synchronized (resource) {
            this.attributes_.validateID(attributeID);
            return this.attributeValues_.get(attributeID);
        }
    }

    String getCurrentLevel() {
        if (this.system_ == null) {
            return "";
        }
        if (this.currentLevel_ != null) {
            return this.currentLevel_;
        }
        try {
            this.currentLevel_ = ResourceLevel.vrmToLevel(this.system_.getVRM());
        }
        catch (Exception e) {
            return "";
        }
        return this.currentLevel_;
    }

    int getDefaultBidiStringType() {
        if (this.system_ == null) {
            return 0;
        }
        if (this.defaultBidiStringType_ == -1) {
            this.defaultBidiStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        return this.defaultBidiStringType_;
    }

    public Presentation getPresentation() {
        return this.presentation_;
    }

    public Object getResourceKey() {
        return this.resourceKey_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeAttributeValue(Object attributeID, Object value) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Initialized attribute value " + String.valueOf(attributeID) + " (for " + String.valueOf(this) + ") to " + String.valueOf(value) + "(" + String.valueOf(value.getClass()) + ")");
        }
        ResourceMetaData attributeMetaData = this.attributes_.validateID(attributeID);
        if (value == null) {
            throw new NullPointerException("value");
        }
        value = attributeMetaData.validateValue(value);
        Resource resource = this;
        synchronized (resource) {
            this.attributeValues_.put(attributeID, value);
        }
    }

    private void initializeTransient() {
        this.activeStatusListeners_ = new Vector();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.resourceListeners_ = new Vector();
    }

    protected boolean isBidiEnabled() {
        return false;
    }

    protected boolean isConnectionEstablished() {
        return this.connectionEstablished_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void refreshAttributeValues() throws ResourceException {
        this.fireAttributeValuesRefreshed();
    }

    public void removeActiveStatusListener(ActiveStatusListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.activeStatusListeners_.removeElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeResourceListener(ResourceListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.resourceListeners_.removeElement(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    protected void setPresentation(Presentation presentation) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        this.presentation_ = presentation;
    }

    protected void setResourceKey(Object resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException("resourceKey");
        }
        this.resourceKey_ = resourceKey;
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        AS400 oldValue = this.system_;
        this.fireVetoableChange("system", oldValue, system);
        this.system_ = system;
        this.firePropertyChange("system", oldValue, system);
    }

    public String toString() {
        if (this.presentation_ == null) {
            return super.toString();
        }
        String fullName = this.presentation_.getFullName();
        if (fullName.length() > 0) {
            return fullName;
        }
        return super.toString();
    }

    ResourceMetaData validateAttributeID(Object attributeID) {
        return this.attributes_.validateID(attributeID);
    }
}

