/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.ProgramMapEntry;
import com.ibm.as400.resource.ResourceException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ProgramAttributeSetter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private ProgramMap attributeMap_ = null;
    private int defaultBidiStringType_ = -1;
    private ProgramCallDocument document_ = null;
    private AS400 system_ = null;

    public ProgramAttributeSetter(AS400 system, ProgramCallDocument document, ProgramMap attributeMap) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (document == null) {
            throw new NullPointerException("document");
        }
        if (attributeMap == null) {
            throw new NullPointerException("attributeMap");
        }
        this.system_ = system;
        this.document_ = document;
        this.attributeMap_ = attributeMap;
    }

    public void initializeAttributeValues(ProgramAttributeGetter attributeGetter) throws ResourceException {
        this.initializeAttributeValues(attributeGetter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeAttributeValues(ProgramAttributeGetter attributeGetter, Object[] attrsToInitializeFirst) throws ResourceException {
        attributeGetter.clearBuffer();
        if (this.defaultBidiStringType_ == -1) {
            this.defaultBidiStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        try {
            ProgramAttributeSetter programAttributeSetter = this;
            synchronized (programAttributeSetter) {
                int i;
                Object[] attrIDs = this.attributeMap_.getIDs();
                if (attrsToInitializeFirst != null) {
                    for (i = 0; i < attrsToInitializeFirst.length; ++i) {
                        Object id = attrsToInitializeFirst[i];
                        boolean foundIt = false;
                        for (int j = i; j < attrIDs.length; ++j) {
                            if (!attrIDs[j].equals(id)) continue;
                            Object temp = attrIDs[i];
                            attrIDs[i] = attrIDs[j];
                            attrIDs[j] = temp;
                            foundIt = true;
                            break;
                        }
                        if (foundIt) continue;
                        Trace.log(2, "Specified attribute ID is not in the getter's map: " + (String)id);
                        throw new ResourceException(2);
                    }
                }
                for (i = 0; i < attrIDs.length; ++i) {
                    String attrID = (String)attrIDs[i];
                    Object value = attributeGetter.getValue(attrID);
                    ProgramMapEntry[] entries = this.attributeMap_.getEntries(attrID);
                    String programName = null;
                    for (int j = 0; j < entries.length; ++j) {
                        programName = entries[j].getProgramName();
                        entries[j].setValue(this.system_, this.document_, null, null, value, this.defaultBidiStringType_);
                    }
                }
            }
        }
        catch (PcmlException e) {
            throw new ResourceException(2, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Object[] attributeIDs, Object[] values) throws ResourceException {
        if (attributeIDs == null) {
            throw new NullPointerException("attributeIDs");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (attributeIDs.length != values.length) {
            throw new ExtendedIllegalArgumentException("values", 2);
        }
        if (this.defaultBidiStringType_ == -1) {
            this.defaultBidiStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        ProgramAttributeSetter programAttributeSetter = this;
        synchronized (programAttributeSetter) {
            Vector<String> programsToCall = new Vector<String>();
            for (int i = 0; i < attributeIDs.length; ++i) {
                ProgramMapEntry[] entries = this.attributeMap_.getEntries(attributeIDs[i]);
                String programName = null;
                int indexUsed = -1;
                for (int j = 0; j < entries.length; ++j) {
                    programName = entries[j].getProgramName();
                    if (!programsToCall.contains(programName)) continue;
                    indexUsed = j;
                    try {
                        entries[j].setValue(this.system_, this.document_, null, null, values[i], this.defaultBidiStringType_);
                        if (!Trace.isTraceOn()) break;
                        Trace.log(3, "Setting attribute value using PCML document " + String.valueOf(this.document_) + ", program " + programName + ".");
                        break;
                    }
                    catch (PcmlException e) {
                        throw new ResourceException(2, (Throwable)e);
                    }
                }
                if (indexUsed >= 0) continue;
                indexUsed = 0;
                programName = entries[0].getProgramName();
                try {
                    entries[0].setValue(this.system_, this.document_, null, null, values[i], this.defaultBidiStringType_);
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "Setting attribute value using PCML document " + String.valueOf(this.document_) + ", program " + programName + ".");
                    }
                    programsToCall.addElement(programName);
                    continue;
                }
                catch (PcmlException e) {
                    throw new ResourceException(2, (Throwable)e);
                }
            }
            Enumeration programs = programsToCall.elements();
            while (programs.hasMoreElements()) {
                String programName = (String)programs.nextElement();
                boolean success = false;
                try {
                    success = this.document_.callProgram(programName);
                    if (success) continue;
                    throw new ResourceException(this.document_.getMessageList(programName));
                }
                catch (PcmlException e) {
                    throw new ResourceException(2, (Throwable)e);
                }
            }
        }
    }
}

