/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.access.Trace;
import com.ibm.as400.micro.ConnectionHandler;
import com.ibm.as400.micro.MicroDataInputStream;
import com.ibm.as400.micro.MicroDataOutputStream;
import com.ibm.as400.micro.ResultSetHandler;
import com.ibm.as400.micro.Service;
import com.ibm.as400.micro.StatementHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class JdbcMeService
implements Service {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private Vector connections_ = new Vector();
    private Vector statements_ = new Vector();
    private Hashtable statementresults_;
    private Hashtable map_ = new Hashtable();
    private Properties properties_;
    private MicroDataInputStream in_;
    private MicroDataOutputStream out_;
    private int dataFlowType_ = 2;
    private int NextObjectId_ = 1;
    private ConnectionHandler connectionHandler_;
    private StatementHandler statementHandler_;
    private ResultSetHandler resultSetHandler_;

    public JdbcMeService() {
        this.statementresults_ = new Hashtable();
        this.registerDrivers();
    }

    @Override
    public void setDataStreams(MicroDataInputStream in, MicroDataOutputStream out) {
        this.in_ = in;
        this.out_ = out;
        this.connectionHandler_ = new ConnectionHandler(this, this.in_, this.out_);
        this.statementHandler_ = new StatementHandler(this, this.in_, this.out_);
        this.resultSetHandler_ = new ResultSetHandler(this, this.in_, this.out_);
    }

    @Override
    public boolean acceptsRequest(int functionId) {
        return functionId > 999 && functionId < 2000;
    }

    @Override
    public void handleRequest(int functionId) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, "Function id is " + Integer.toHexString(functionId));
        }
        if (this.isServiceRequest(functionId)) {
            this.process(functionId);
            return;
        }
        if (functionId == 4688) {
            block18: {
                boolean trace;
                if (Trace.isTraceOn()) {
                    Trace.log(6, "JDBC Service: The request is here. " + Integer.toHexString(functionId));
                }
                if (trace = Trace.isTraceOn()) {
                    Trace.setTraceOn(false);
                }
                String url = this.in_.readUTF();
                if (trace) {
                    Trace.setTraceOn(true);
                }
                try {
                    Connection c = DriverManager.getConnection(url);
                    this.connections_.addElement(c);
                    int objectId = this.getNextObjectId();
                    this.map_.put(objectId, c.hashCode());
                    this.out_.writeInt(objectId);
                    this.out_.flush();
                }
                catch (SQLException e) {
                    this.handleException(e);
                }
                catch (Exception e) {
                    if (!Trace.isTraceOn()) break block18;
                    Trace.log(2, e);
                }
            }
            return;
        }
        int handle = this.in_.readInt();
        Object object = this.processJdbcObject(handle);
        if (object instanceof Connection) {
            this.connectionHandler_.process((Connection)object, functionId);
        } else if (object instanceof Statement) {
            this.statementHandler_.process((Statement)object, functionId);
        } else if (object instanceof ResultSet) {
            this.resultSetHandler_.process((ResultSet)object, functionId);
        } else {
            if (Trace.isTraceOn()) {
                Trace.log(6, "Error, unknown Jdbc object < " + String.valueOf(object) + ">");
            }
            try {
                throw new SQLException("Error, unknown Jdbc object < " + String.valueOf(object) + ">");
            }
            catch (SQLException e) {
                this.handleException(e);
            }
        }
    }

    public Object processJdbcObject(int handle) throws IOException {
        block6: {
            Integer oObjectHash = (Integer)this.map_.get(handle);
            int iObjectHash = oObjectHash;
            Object mapValue = null;
            try {
                int i;
                Collection col = this.statementresults_.values();
                for (ResultSet rs : col) {
                    int rsHandle = rs.hashCode();
                    if (iObjectHash != rsHandle) continue;
                    return rs;
                }
                for (i = 0; i < this.statements_.size(); ++i) {
                    Statement s = (Statement)this.statements_.elementAt(i);
                    int stmtHandle = s.hashCode();
                    if (iObjectHash != stmtHandle) continue;
                    return s;
                }
                for (i = 0; i < this.connections_.size(); ++i) {
                    Connection c = (Connection)this.connections_.elementAt(i);
                    int connHandle = c.hashCode();
                    if (iObjectHash != connHandle) continue;
                    return c;
                }
            }
            catch (Exception e) {
                if (!Trace.isTraceOn()) break block6;
                Trace.log(2, e);
            }
        }
        if (Trace.isTraceOn()) {
            Trace.log(2, "ERROR! returning null from processJdbcObject!");
        }
        return null;
    }

    public void addStatement(Statement s) {
        this.statements_.addElement(s);
    }

    public void addConnection(Connection c) {
        this.connections_.addElement(c);
    }

    public void addResultSet(Statement s, ResultSet rs) throws SQLException {
        this.statementresults_.remove(s);
        this.statementresults_.put(s, rs);
    }

    public void removeStatement(Statement s) {
        this.statements_.remove(s);
        this.statementresults_.remove(s);
    }

    public void removeResultSet(ResultSet rs) throws SQLException {
        Collection col = this.statementresults_.values();
        col.remove(rs);
    }

    public void removeConnection(Connection c) {
        Connection toTry = null;
        for (int i = 0; i < this.statements_.size(); ++i) {
            Statement s;
            block4: {
                s = (Statement)this.statements_.elementAt(i);
                try {
                    toTry = s.getConnection();
                }
                catch (SQLException e) {
                    if (!Trace.isTraceOn()) break block4;
                    Trace.log(2, "Exception thrown trying to get the connection for a statement.", (Throwable)e);
                }
            }
            if (c != toTry) continue;
            if (Trace.isTraceOn()) {
                Trace.log(6, "Implicitly closing a statement because of connection close");
            }
            this.removeStatement(s);
        }
        this.connections_.remove(c);
    }

    public void handleException(SQLException e) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(2, e);
        }
        this.out_.writeInt(-1);
        String s = e.getSQLState();
        if (s == null) {
            s = "null";
        }
        this.out_.writeUTF(s);
        s = e.getMessage();
        if (s == null) {
            s = "null";
        }
        this.out_.writeUTF(s);
        this.out_.flush();
    }

    public int getNextObjectId() {
        int returnValue = this.NextObjectId_++;
        return returnValue;
    }

    public int mapObject(Object object) {
        int objectId = this.getNextObjectId();
        this.map_.put(objectId, object.hashCode());
        return objectId;
    }

    public void registerDrivers() {
        block3: {
            String driver = "com.ibm.as400.access.AS400JDBCDriver";
            if (Trace.isTraceOn()) {
                Trace.log(6, "Loading driver: " + driver);
            }
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                if (!Trace.isTraceOn()) break block3;
                Trace.log(6, "Failed to load driver " + driver);
            }
        }
    }

    public boolean isServiceRequest(int funcId) {
        return funcId > 1900 && funcId < 1999;
    }

    public void process(int funcId) throws IOException {
        switch (funcId) {
            case 6400: {
                this.setDataFlowType();
                break;
            }
            default: {
                System.out.println("Error - JDBC-ME Service request unrecognized - function code: " + funcId);
            }
        }
    }

    public int getDataFlowType() {
        return this.dataFlowType_;
    }

    public void setDataFlowType() throws IOException {
        int type = this.in_.readInt();
        if (type == 1 || type == 2 || type == 3) {
            this.dataFlowType_ = type;
            this.out_.writeInt(1);
            this.out_.flush();
        } else {
            this.handleServiceException("An invalid setting was passed for setting the data flow type: " + type);
        }
    }

    public void handleServiceException(String message) throws IOException {
        this.out_.writeInt(-1);
        this.out_.writeUTF("JDBC");
        this.out_.writeUTF(message);
        this.out_.flush();
    }
}

