/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Date;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Time;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlMessageLog;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.RfmlDocument;
import com.ibm.as400.data.SystemResourceFinder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;

class PcmlDataValues
implements Serializable {
    static final long serialVersionUID = -8169008879805188674L;
    private PcmlData m_owner;
    private PcmlDimensions m_indices;
    private Object m_value = null;
    private long m_valueTs = 0L;
    private byte[] m_bytes = null;
    private long m_bytesTs = 0L;
    private int m_bidiStringType = 0;

    private PcmlDataValues() {
    }

    PcmlDataValues(PcmlData creator, PcmlDimensions indices) {
        this();
        this.m_owner = creator;
        this.m_indices = new PcmlDimensions(indices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        PcmlDataValues pcmlDataValues = this;
        synchronized (pcmlDataValues) {
            if (this.m_owner.getUsage() == 2 && this.m_bytesTs > this.m_valueTs) {
                this.m_value = null;
                this.m_valueTs = 0L;
            }
            if (this.m_owner.getUsage() == 3 && this.m_valueTs > this.m_bytesTs) {
                this.m_bytes = null;
                this.m_bytesTs = 0L;
            }
            out.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    void readObjectPostprocessing() {
        if (this.m_valueTs == this.m_bytesTs && this.m_valueTs > 0L) {
            this.m_valueTs = this.m_owner.getDoc().getDeserializationTimestamp();
            this.m_bytesTs = this.m_owner.getDoc().getDeserializationTimestamp();
        }
        if (this.m_valueTs > this.m_bytesTs) {
            this.m_valueTs = this.m_owner.getDoc().getDeserializationTimestamp();
            this.m_bytesTs = 0L;
        }
        if (this.m_bytesTs > this.m_valueTs) {
            this.m_bytesTs = this.m_owner.getDoc().getDeserializationTimestamp();
            this.m_valueTs = 0L;
        }
    }

    void flushValues() {
        this.m_value = null;
        this.m_bytes = null;
        this.m_valueTs = 0L;
        this.m_bytesTs = 0L;
    }

    String getQualifiedName() {
        return this.m_owner.getQualifiedName();
    }

    String getNameForException() {
        return this.m_owner.getNameForException();
    }

    long getTimestamp() {
        return Math.max(this.m_valueTs, this.m_bytesTs);
    }

    public Object getValue() throws PcmlException {
        return this.bytesToValue();
    }

    public void setValue(Object v) throws PcmlException {
        if (v == null) {
            throw new PcmlException("NULL_VALUE", new Object[]{this.getNameForException()});
        }
        if (this.getDataType() == 7) {
            throw new PcmlException("STRUCT_VALUE", new Object[]{this.getNameForException()});
        }
        if (this.getDataType() == 1 && (v instanceof String || v instanceof char[])) {
            this.m_value = v;
        } else if (v.getClass().equals(this.getValueClass())) {
            this.m_value = v instanceof BigDecimal ? ((BigDecimal)v).setScale(this.getPrecision(), 6) : v;
        } else {
            TimeZone timeZone = this.m_owner.getDoc().getTimeZone();
            this.m_value = PcmlDataValues.convertValue(v, this.getDataType(), this.getLength(), this.getPrecision(), this.getNameForException(), timeZone);
        }
        this.m_valueTs = this.m_owner.getDoc().getCorrelationID();
    }

    public void setBytes(byte[] ba) {
        this.m_bytes = ba;
        this.m_bytesTs = this.m_owner.getDoc().getCorrelationID();
    }

    public void setStringType(int type) {
        if (this.m_bidiStringType == type) {
            return;
        }
        this.m_bidiStringType = type;
        this.m_value = null;
        this.m_valueTs = 0L;
    }

    private Object bytesToValue() throws PcmlException {
        String initValue;
        if (this.m_bytesTs > this.m_valueTs) {
            this.m_valueTs = this.m_bytesTs;
            this.toObject(this.m_bytes);
        }
        if (this.m_value == null && (initValue = this.m_owner.getInit()) != null) {
            this.setValue(initValue);
        }
        if (this.m_value == null) {
            return this.m_value;
        }
        if (this.getDataType() == 6) {
            byte[] srcArray = (byte[])this.m_value;
            byte[] cloneArray = new byte[srcArray.length];
            System.arraycopy(srcArray, 0, cloneArray, 0, srcArray.length);
            return cloneArray;
        }
        return this.m_value;
    }

    int getDataType() {
        return this.m_owner.getDataType();
    }

    int getLength() throws PcmlException {
        String charType = this.m_owner.getCharType();
        if (charType != null && charType.equals("twobyte")) {
            return this.resolveIntegerValue(this.m_owner.getLength(), this.m_owner.getLengthId()) * 2;
        }
        return this.resolveIntegerValue(this.m_owner.getLength(), this.m_owner.getLengthId());
    }

    int getOffset() throws PcmlException {
        return this.resolveIntegerValue(this.m_owner.getOffset(), this.m_owner.getOffsetId());
    }

    int getCcsid() throws PcmlException {
        int tmpCcsid = this.resolveIntegerValue(this.m_owner.getCcsid(), this.m_owner.getCcsidId());
        if (tmpCcsid == 0) {
            PcmlNode node = this.m_owner.getParent();
            for (node = node.getParent(); node != this.m_owner.getDoc(); node = node.getParent()) {
            }
            if (node instanceof PcmlProgram) {
                return ((PcmlProgram)node).getProgramCCSID();
            }
            if (node instanceof RfmlDocument) {
                return ((RfmlDocument)node).getCcsidInt();
            }
            return this.m_owner.getDoc().getAs400().getCcsid();
        }
        return tmpCcsid;
    }

    int getPrecision() {
        return this.m_owner.getPrecision();
    }

    String getDateFormat() {
        return this.m_owner.getDateFormat();
    }

    String getDateSeparator() {
        return this.m_owner.getDateSeparator();
    }

    String getTimeFormat() {
        return this.m_owner.getTimeFormat();
    }

    String getTimeSeparator() {
        return this.m_owner.getTimeSeparator();
    }

    String getTrim() {
        return this.m_owner.getTrim();
    }

    boolean isArray() {
        return this.m_owner.isArray();
    }

    public int byteLength() throws PcmlException {
        int length = this.getLength();
        switch (this.getDataType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return length;
            }
            case 3: {
                return length / 2 + 1;
            }
            case 4: {
                return length;
            }
            case 8: {
                String format;
                if (length == 0 && (format = this.getDateFormat()) != null) {
                    length = AS400Date.getByteLength(AS400Date.toFormat(format), PcmlNode.separatorAsChar(this.getDateSeparator()));
                }
                return length;
            }
            case 9: {
                String format;
                if (length == 0 && (format = this.getTimeFormat()) != null) {
                    length = AS400Time.getByteLength(AS400Time.toFormat(format), PcmlNode.separatorAsChar(this.getTimeSeparator()));
                }
                return length;
            }
            case 10: {
                if (length == 0) {
                    length = 26;
                }
                return length;
            }
        }
        throw new PcmlException("BAD_DATA_TYPE", new Object[]{this.getDataType(), this.getNameForException()});
    }

    private Class getValueClass() throws PcmlException {
        int dataLength = this.getLength();
        int dataPrecision = this.getPrecision();
        int dataType = this.getDataType();
        switch (dataType) {
            case 1: {
                return String.class;
            }
            case 11: {
                return String.class;
            }
            case 2: {
                if (dataLength == 2) {
                    if (dataPrecision == 16) {
                        return Integer.class;
                    }
                    return Short.class;
                }
                if (dataLength == 4) {
                    if (dataPrecision == 32) {
                        return Long.class;
                    }
                    return Integer.class;
                }
                if (dataLength == 8) {
                    if (dataPrecision == 64) {
                        return BigInteger.class;
                    }
                    return Long.class;
                }
            }
            case 3: 
            case 4: {
                return BigDecimal.class;
            }
            case 5: {
                if (dataLength == 4) {
                    return Float.class;
                }
                return Double.class;
            }
            case 6: {
                return new byte[0].getClass();
            }
            case 8: {
                return Date.class;
            }
            case 9: {
                return Time.class;
            }
            case 10: {
                return Timestamp.class;
            }
        }
        throw new PcmlException("BAD_DATA_TYPE", new Object[]{this.getDataType(), this.getNameForException()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toBytes(OutputStream bytes, int offset) throws PcmlException {
        AS400DataType aS400DataType;
        Object value = null;
        int dataType = this.getDataType();
        int dataLength = this.getLength();
        if (dataLength == 0) {
            dataLength = this.byteLength();
        }
        int bytesConverted = 0;
        value = this.getValue();
        if (value == null) {
            throw new PcmlException("INPUT_VALUE_NOT_SET", new Object[]{this.getNameForException()});
        }
        AS400DataType converter = this.m_owner.getDoc().getConverter(dataType, dataLength, this.getPrecision(), this.getCcsid(), this.getDateFormat(), this.getDateSeparator(), this.getTimeFormat(), this.getTimeSeparator());
        byte[] byteArray = new byte[dataLength];
        if (dataType != 1) {
            aS400DataType = converter;
            synchronized (aS400DataType) {
                converter.toBytes(value, byteArray);
                bytesConverted = converter.getByteLength();
            }
        }
        aS400DataType = converter;
        synchronized (aS400DataType) {
            ((AS400Text)converter).toBytes(value, byteArray, 0, this.m_bidiStringType);
            bytesConverted = converter.getByteLength();
        }
        try {
            bytes.write(byteArray, 0, bytesConverted);
        }
        catch (IOException e) {
            throw new PcmlException(e);
        }
        if (Trace.isTracePCMLOn()) {
            Object parseMsg = this.m_indices.size() > 0 ? SystemResourceFinder.format("WRITE_DATA_W_INDICES", new Object[]{Integer.toHexString(offset), Integer.toString(bytesConverted), this.getNameForException(), this.m_indices.toString(), PcmlMessageLog.toHexString(byteArray, 0, bytesConverted)}) : SystemResourceFinder.format("WRITE_DATA", new Object[]{Integer.toHexString(offset), Integer.toString(bytesConverted), this.getNameForException(), PcmlMessageLog.toHexString(byteArray, 0, bytesConverted)});
            parseMsg = (String)parseMsg + "\t  " + String.valueOf(Thread.currentThread());
            Trace.log(7, (String)parseMsg);
        }
        return bytesConverted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toObject(byte[] bytes) throws PcmlException {
        Object newVal = null;
        int dataType = this.getDataType();
        AS400DataType converter = this.m_owner.getDoc().getConverter(dataType, this.getLength(), this.getPrecision(), this.getCcsid(), this.getDateFormat(), this.getDateSeparator(), this.getTimeFormat(), this.getTimeSeparator());
        if (dataType != 1) {
            AS400DataType aS400DataType = converter;
            synchronized (aS400DataType) {
                newVal = converter.toObject(bytes);
            }
        }
        AS400DataType aS400DataType = converter;
        synchronized (aS400DataType) {
            newVal = ((AS400Text)converter).toObject(bytes, 0, this.m_bidiStringType);
        }
        if (dataType == 1) {
            newVal = PcmlDataValues.trimString((String)newVal, this.getTrim());
        }
        this.setValue(newVal);
        return newVal;
    }

    public int parseBytes(byte[] bytes, int offset, Hashtable offsetStack) throws PcmlException {
        int nbrBytes = 0;
        int skipBytes = 0;
        int myOffset = this.getOffset();
        if (myOffset != 0) {
            if (myOffset < 0 || myOffset > bytes.length) {
                throw new PcmlException("BAD_OFFSET_VALUE", new Object[]{myOffset, bytes.length, "<data>", this.getNameForException()});
            }
            Integer myOffsetbase = null;
            String myOffsetfrom = this.m_owner.getOffsetfromId();
            if (myOffsetfrom != null) {
                myOffsetbase = (Integer)offsetStack.get(myOffsetfrom);
                if (myOffsetbase == null) {
                    throw new PcmlException("OFFSETFROM_NOT_FOUND", new Object[]{myOffsetfrom, this.getNameForException()});
                }
            } else if (this.m_owner.getOffsetfrom() >= 0) {
                myOffsetbase = this.m_owner.getOffsetfrom();
            } else {
                myOffsetfrom = ((PcmlDocNode)this.m_owner.getParent()).getQualifiedName();
                myOffsetbase = (Integer)offsetStack.get(myOffsetfrom);
            }
            if (myOffsetbase != null && ((myOffset += myOffsetbase.intValue()) < 0 || myOffset > bytes.length)) {
                throw new PcmlException("BAD_TOTAL_OFFSET", new Object[]{myOffset, bytes.length, myOffsetbase, myOffsetfrom, "<data>", this.getNameForException()});
            }
            if (myOffset > offset) {
                skipBytes = myOffset - offset;
            }
        }
        if ((nbrBytes = this.byteLength()) < 0 || nbrBytes > 0xFFEFF0) {
            throw new PcmlException("BAD_DATA_LENGTH", new Object[]{nbrBytes, 0xFFEFF0, "<data>", this.getNameForException()});
        }
        if (offset + skipBytes + nbrBytes > bytes.length) {
            throw new PcmlException("INSUFFICIENT_INPUT_DATA", new Object[]{Integer.toString(offset + skipBytes + nbrBytes), Integer.toString(bytes.length), "<data>", this.getNameForException()});
        }
        byte[] newBytes = new byte[nbrBytes];
        for (int b = 0; b < nbrBytes; ++b) {
            newBytes[b] = bytes[offset + skipBytes + b];
        }
        this.setBytes(newBytes);
        if (Trace.isTracePCMLOn()) {
            Object parseMsg = this.m_indices.size() > 0 ? SystemResourceFinder.format("READ_DATA_W_INDICES", new Object[]{Integer.toHexString(offset + skipBytes), Integer.toString(nbrBytes), this.getNameForException(), this.m_indices.toString(), PcmlMessageLog.toHexString(newBytes)}) : SystemResourceFinder.format("READ_DATA", new Object[]{Integer.toHexString(offset + skipBytes), Integer.toString(nbrBytes), this.getNameForException(), PcmlMessageLog.toHexString(newBytes)});
            parseMsg = (String)parseMsg + "\t  " + String.valueOf(Thread.currentThread());
            Trace.log(7, (String)parseMsg);
        }
        return skipBytes + nbrBytes;
    }

    private int resolveIntegerValue(int intLiteral, String intId) throws PcmlException {
        if (intId != null) {
            PcmlData intNode = (PcmlData)this.m_owner.getRootNode().getElement(intId);
            Object nodeValue = intNode.getValue(this.m_indices);
            if (nodeValue instanceof String) {
                return Integer.parseInt((String)nodeValue);
            }
            if (nodeValue instanceof Number) {
                return ((Number)nodeValue).intValue();
            }
            if (nodeValue == null) {
                throw new PcmlException("INPUT_VALUE_NOT_SET", new Object[]{intNode.getNameForException()});
            }
            throw new PcmlException("STRING_OR_NUMBER", new Object[]{nodeValue.getClass().getName(), intNode.getNameForException()});
        }
        return intLiteral;
    }

    public static Object convertValue(Object newVal, int dataType, int dataLength, int dataPrecision, String nodeNameForException, TimeZone serverTimeZone) throws PcmlException {
        Object convertedVal = null;
        if (newVal == null) {
            throw new PcmlException("NULL_VALUE", new Object[]{nodeNameForException});
        }
        switch (dataType) {
            case 1: {
                if (newVal instanceof String) {
                    convertedVal = newVal;
                    break;
                }
                convertedVal = newVal.toString();
                break;
            }
            case 2: {
                if (dataLength == 2) {
                    if (dataPrecision == 16) {
                        if (newVal instanceof String) {
                            convertedVal = Integer.valueOf((String)newVal);
                            break;
                        }
                        if (newVal instanceof Integer) {
                            convertedVal = newVal;
                            break;
                        }
                        if (newVal instanceof Number) {
                            convertedVal = ((Number)newVal).intValue();
                            break;
                        }
                        throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
                    }
                    if (newVal instanceof String) {
                        convertedVal = Short.valueOf((String)newVal);
                        break;
                    }
                    if (newVal instanceof Short) {
                        convertedVal = newVal;
                        break;
                    }
                    if (newVal instanceof Number) {
                        convertedVal = ((Number)newVal).shortValue();
                        break;
                    }
                    throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
                }
                if (dataLength == 4) {
                    if (dataPrecision == 32) {
                        if (newVal instanceof String) {
                            convertedVal = Long.valueOf((String)newVal);
                            break;
                        }
                        if (newVal instanceof Long) {
                            convertedVal = newVal;
                            break;
                        }
                        if (newVal instanceof Number) {
                            convertedVal = ((Number)newVal).longValue();
                            break;
                        }
                        throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
                    }
                    if (newVal instanceof String) {
                        convertedVal = Integer.valueOf((String)newVal);
                        break;
                    }
                    if (newVal instanceof Integer) {
                        convertedVal = newVal;
                        break;
                    }
                    if (newVal instanceof Number) {
                        convertedVal = ((Number)newVal).intValue();
                        break;
                    }
                    throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
                }
                if (dataPrecision == 64) {
                    if (newVal instanceof String) {
                        convertedVal = new BigInteger((String)newVal);
                        break;
                    }
                    if (newVal instanceof BigInteger) {
                        convertedVal = newVal;
                        break;
                    }
                    if (newVal instanceof Number) {
                        long longVal = ((Number)newVal).longValue();
                        convertedVal = new BigInteger(Long.toString(longVal));
                        break;
                    }
                    throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
                }
                if (newVal instanceof String) {
                    convertedVal = Long.valueOf((String)newVal);
                    break;
                }
                if (newVal instanceof Long) {
                    convertedVal = newVal;
                    break;
                }
                if (newVal instanceof Number) {
                    convertedVal = ((Number)newVal).longValue();
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
            }
            case 3: 
            case 4: {
                if (newVal instanceof BigDecimal) {
                    convertedVal = ((BigDecimal)newVal).setScale(dataPrecision, 6);
                    break;
                }
                if (newVal instanceof String) {
                    convertedVal = new BigDecimal((String)newVal);
                    if (((BigDecimal)convertedVal).scale() == dataPrecision) break;
                    convertedVal = ((BigDecimal)convertedVal).setScale(dataPrecision, 6);
                    break;
                }
                if (newVal instanceof Number) {
                    convertedVal = new BigDecimal(((Number)newVal).doubleValue()).setScale(dataPrecision, 6);
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
            }
            case 5: {
                if (dataLength == 4) {
                    if (newVal instanceof String) {
                        convertedVal = Float.valueOf((String)newVal);
                        break;
                    }
                    if (newVal instanceof Float) {
                        convertedVal = newVal;
                        break;
                    }
                    if (newVal instanceof Number) {
                        convertedVal = Float.valueOf(((Number)newVal).floatValue());
                        break;
                    }
                    throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
                }
                if (newVal instanceof String) {
                    convertedVal = Double.valueOf((String)newVal);
                    break;
                }
                if (newVal instanceof Double) {
                    convertedVal = newVal;
                    break;
                }
                if (newVal instanceof Number) {
                    convertedVal = ((Number)newVal).doubleValue();
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
            }
            case 6: {
                if (newVal instanceof String) {
                    StringTokenizer st = new StringTokenizer((String)newVal, " ,");
                    byte byteVal = 0;
                    byte[] byteArray = new byte[dataLength];
                    for (int i = 0; i < dataLength; ++i) {
                        if (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            try {
                                byteVal = Byte.decode(token);
                            }
                            catch (NumberFormatException nfe) {
                                try {
                                    byte[] bytes = BinaryConverter.stringToBytes(token);
                                    byteVal = bytes[0];
                                }
                                catch (NumberFormatException e) {
                                    throw nfe;
                                }
                            }
                        }
                        byteArray[i] = byteVal;
                    }
                    convertedVal = byteArray;
                    break;
                }
                if (newVal instanceof Number) {
                    byte byteVal = ((Number)newVal).byteValue();
                    byte[] byteArray = new byte[dataLength];
                    for (int i = 0; i < dataLength; ++i) {
                        byteArray[i] = byteVal;
                    }
                    convertedVal = byteArray;
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
            }
            case 8: {
                if (newVal instanceof String) {
                    convertedVal = AS400Date.parseXsdString((String)newVal, serverTimeZone);
                    break;
                }
                if (newVal instanceof Date) {
                    convertedVal = (Date)newVal;
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
            }
            case 9: {
                if (newVal instanceof String) {
                    convertedVal = AS400Time.parseXsdString((String)newVal, serverTimeZone);
                    break;
                }
                if (newVal instanceof Time) {
                    convertedVal = (Time)newVal;
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
            }
            case 10: {
                if (newVal instanceof String) {
                    convertedVal = AS400Timestamp.parseXsdString((String)newVal, serverTimeZone);
                    break;
                }
                if (newVal instanceof Timestamp) {
                    convertedVal = (Timestamp)newVal;
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{newVal.getClass().getName(), nodeNameForException});
            }
            default: {
                throw new PcmlException("BAD_DATA_TYPE", new Object[]{dataType, nodeNameForException});
            }
        }
        return convertedVal;
    }

    static String trimString(String str, String trimEnd) {
        int lengthReturned;
        if (trimEnd != null && trimEnd.equals("none")) {
            return str;
        }
        char[] charBuff = str.toCharArray();
        int startOffset = 0;
        if (trimEnd == null || trimEnd.equals("right") || trimEnd.equals("both")) {
            block6: for (lengthReturned = charBuff.length; lengthReturned > 0; --lengthReturned) {
                switch (charBuff[lengthReturned - 1]) {
                    case '\u0000': 
                    case ' ': {
                        continue block6;
                    }
                }
            }
        }
        if (trimEnd != null && (trimEnd.equals("left") || trimEnd.equals("both"))) {
            block7: while (startOffset < lengthReturned) {
                switch (charBuff[startOffset]) {
                    case '\u0000': 
                    case ' ': {
                        ++startOffset;
                        --lengthReturned;
                        continue block7;
                    }
                }
            }
        }
        return new String(charBuff, startOffset, lengthReturned);
    }
}

