/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import com.ibm.as400.access.UserEnumeration;
import com.ibm.as400.access.UserGroup;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

public class UserList
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final String ALL = "*ALL";
    public static final String USER = "*USER";
    public static final String GROUP = "*GROUP";
    public static final String MEMBER = "*MEMBER";
    public static final String NONE = "*NONE";
    public static final String NOGROUP = "*NOGROUP";
    private AS400 system_ = null;
    private String userInfo_ = "*ALL";
    private String groupInfo_ = "*NONE";
    private String userProfile_ = "*ALL";
    private int length_ = 0;
    private byte[] handle_ = null;
    private boolean closeHandle_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public UserList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserList object.");
        }
    }

    public UserList(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserList object, system: " + String.valueOf(system));
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    public UserList(AS400 system, String userInfo, String groupInfo) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserList object, system: " + String.valueOf(system) + ", user info: " + userInfo + ", group info: " + groupInfo);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (userInfo == null) {
            Trace.log(2, "Parameter 'userInfo' is null.");
            throw new NullPointerException("userInfo");
        }
        if (groupInfo == null) {
            Trace.log(2, "Parameter 'groupInfo' is null.");
            throw new NullPointerException("groupInfo");
        }
        if (groupInfo.length() > 10) {
            Trace.log(2, "Length of parameter 'groupInfo' is not valid: '" + groupInfo + "'");
            throw new ExtendedIllegalArgumentException("groupInfo (" + groupInfo + ")", 1);
        }
        if (!(userInfo.equals(ALL) || userInfo.equals(USER) || userInfo.equals(GROUP) || userInfo.equals(MEMBER))) {
            Trace.log(2, "Value of parameter 'userInfo' is not valid: " + userInfo);
            throw new ExtendedIllegalArgumentException("userInfo (" + userInfo + ")", 2);
        }
        if (userInfo.equals(MEMBER) && groupInfo.equals(NONE)) {
            Trace.log(2, "Value of parameter 'groupInfo' is not valid: " + groupInfo);
            throw new ExtendedIllegalArgumentException("groupInfo (" + groupInfo + ")", 2);
        }
        if (!userInfo.equals(MEMBER) && !groupInfo.equals(NONE)) {
            Trace.log(2, "Value of parameter 'groupInfo' is not valid: " + groupInfo);
            throw new ExtendedIllegalArgumentException("groupInfo (" + groupInfo + ")", 2);
        }
        this.system_ = system;
        this.userInfo_ = userInfo;
        this.groupInfo_ = groupInfo;
    }

    public UserList(AS400 system, String userInfo, String groupInfo, String userProfile) {
        this(system, userInfo, groupInfo);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserList object, userProfile: " + userProfile);
        }
        if (userProfile == null) {
            Trace.log(2, "Parameter 'userProfile' is null.");
            throw new NullPointerException("userProfile");
        }
        if (userProfile.length() > 10) {
            Trace.log(2, "Length of parameter 'userProfile' is not valid: '" + userProfile + "'");
            throw new ExtendedIllegalArgumentException("userProfile (" + userProfile + ")", 1);
        }
        this.userProfile_ = userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        UserList userList = this;
        synchronized (userList) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        UserList userList = this;
        synchronized (userList) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing user list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        try {
            ListUtilities.closeList(this.system_, this.handle_);
        }
        finally {
            this.handle_ = null;
            this.closeHandle_ = false;
        }
    }

    public String getGroupInfo() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting group info: " + this.groupInfo_);
        }
        return this.groupInfo_;
    }

    public synchronized int getLength() {
        block5: {
            if (Trace.traceOn_) {
                Trace.log(1, "Getting user list length.");
            }
            try {
                if (this.handle_ == null || this.closeHandle_) {
                    this.load();
                }
            }
            catch (Exception e) {
                Trace.log(2, "Exception caught getting length of user list:", (Throwable)e);
                if (!(e instanceof ExtendedIllegalStateException)) break block5;
                throw (ExtendedIllegalStateException)e;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + String.valueOf(this.system_));
        }
        return this.system_;
    }

    public String getUserInfo() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user info: " + this.userInfo_);
        }
        return this.userInfo_;
    }

    public String getUserProfile() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user profile: " + this.userProfile_);
        }
        return this.userProfile_;
    }

    public synchronized Enumeration<User> getUsers() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, RequestNotSupportedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving user list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        return new UserEnumeration(this, this.length_);
    }

    public synchronized User[] getUsers(int listOffset, int number) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving user list, list offset: " + listOffset + ", number:", number);
        }
        if (listOffset < -1) {
            throw new ExtendedIllegalArgumentException("listOffset (" + listOffset + ")", 4);
        }
        if (number < 0 && listOffset != -1) {
            throw new ExtendedIllegalArgumentException("number (" + number + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (this.length_ == 0 || number == 0 && listOffset != -1) {
            return new User[0];
        }
        if (listOffset == -1) {
            number = this.length_;
            listOffset = 0;
        } else {
            if (listOffset >= this.length_) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Value of parameter 'listOffset' is beyond end of list:", listOffset + " (list length: " + this.length_ + ")");
                }
                return new User[0];
            }
            if (listOffset + number > this.length_) {
                number = this.length_ - listOffset;
            }
        }
        int lengthOfReceiverVariable = number * 62;
        byte[] data = ListUtilities.retrieveListEntries(this.system_, this.handle_, lengthOfReceiverVariable, number, listOffset, null);
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        User[] users = new User[number];
        int i = 0;
        int offset = 0;
        while (i < users.length) {
            String profileName = conv.byteArrayToString(data, offset, 10).trim();
            boolean isGroupProfile = data[offset + 10] == -15;
            boolean groupHasMember = data[offset + 11] == -15;
            String textDescription = conv.byteArrayToString(data, offset + 12, 50).trim();
            users[i] = isGroupProfile ? new UserGroup(this.system_, profileName, groupHasMember, textDescription) : new User(this.system_, profileName, groupHasMember, textDescription);
            ++i;
            offset += 62;
        }
        return users;
    }

    public synchronized void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Loading user list.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.closeHandle_) {
            this.close();
        }
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        byte[] selectionCriteria = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        conv.stringToByteArray(this.userInfo_, selectionCriteria);
        byte[] groupProfileName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        conv.stringToByteArray(this.groupInfo_.toUpperCase().trim(), groupProfileName);
        byte[] profileName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        conv.stringToByteArray(this.userProfile_.toUpperCase().trim(), profileName);
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(new byte[]{-63, -28, -29, -28, -16, -15, -11, -16}), new ProgramParameter(selectionCriteria), new ProgramParameter(groupProfileName), new ErrorCodeParameter(), new ProgramParameter(profileName)};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QGYOLAUS.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] listInformation = parameters[2].getOutputData();
        this.handle_ = new byte[4];
        System.arraycopy(listInformation, 8, this.handle_, 0, 4);
        listInformation = ListUtilities.waitForListToComplete(this.system_, this.handle_, listInformation);
        this.length_ = BinaryConverter.byteArrayToInt(listInformation, 0);
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded user list, length: " + this.length_ + ", handle: ", Trace.toHexString(this.handle_));
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupInfo(String groupInfo) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting group info: " + groupInfo);
        }
        if (groupInfo == null) {
            Trace.log(2, "Parameter 'groupInfo' is null.");
            throw new NullPointerException("groupInfo");
        }
        if (groupInfo.length() > 10) {
            Trace.log(2, "Length of parameter 'groupInfo' is not valid: '" + groupInfo + "'");
            throw new ExtendedIllegalArgumentException("groupInfo (" + groupInfo + ")", 1);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            UserList userList = this;
            synchronized (userList) {
                this.groupInfo_ = groupInfo;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String oldValue = this.groupInfo_;
        String newValue = groupInfo;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("groupInfo", oldValue, newValue);
        }
        UserList userList = this;
        synchronized (userList) {
            this.groupInfo_ = groupInfo;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("groupInfo", oldValue, newValue);
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + String.valueOf(system));
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.handle_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = system;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserInfo(String userInfo) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user info: " + userInfo);
        }
        if (userInfo == null) {
            Trace.log(2, "Parameter 'userInfo' is null.");
            throw new NullPointerException("userInfo");
        }
        if (!(userInfo.equals(ALL) || userInfo.equals(USER) || userInfo.equals(GROUP) || userInfo.equals(MEMBER))) {
            Trace.log(2, "Value of parameter 'userInfo' is not valid: " + userInfo);
            throw new ExtendedIllegalArgumentException("userInfo", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            UserList userList = this;
            synchronized (userList) {
                this.userInfo_ = userInfo;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String oldValue = this.userInfo_;
        String newValue = userInfo;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("userInfo", oldValue, newValue);
        }
        UserList userList = this;
        synchronized (userList) {
            this.userInfo_ = userInfo;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("userInfo", oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserProfile(String userProfile) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user profile: " + userProfile);
        }
        if (userProfile == null) {
            Trace.log(2, "Parameter 'userProfile' is null.");
            throw new NullPointerException("userProfile");
        }
        if (userProfile.length() > 10) {
            Trace.log(2, "Length of parameter 'userProfile' is not valid: '" + userProfile + "'");
            throw new ExtendedIllegalArgumentException("userProfile (" + userProfile + ")", 1);
        }
        UserList userList = this;
        synchronized (userList) {
            this.userProfile_ = userProfile;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for user list invoked.");
        }
        if (this.handle_ != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

