/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrnoException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSIoctlRep;
import com.ibm.as400.access.IFSIoctlReq;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

public class UDFS {
    private AS400 system_;
    private String path_;
    private String storageUnit_;
    private IFSFileDescriptorImplRemote fd_ = new IFSFileDescriptorImplRemote();

    public UDFS(AS400 system, String path) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UDFS object, system: " + String.valueOf(system) + " path: " + path);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        this.system_ = system;
        this.path_ = path;
    }

    public void create() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating UDFS.");
        }
        StringBuilder cmd = new StringBuilder("CRTUDFS UDFS('" + this.path_ + "')");
        if (this.storageUnit_ != null && !this.storageUnit_.equalsIgnoreCase("*ANY")) {
            if (this.system_.getVRM() >= 459008) {
                cmd.append(" UNIT(").append(this.storageUnit_).append(")");
            } else if (Trace.traceOn_) {
                Trace.log(4, "setPreferredStorageUnit(*SSD) is not supported prior to IBM i 7.1.");
            }
        }
        this.runCommand(cmd.toString());
    }

    public void create(String publicDataAuthority, String[] publicObjectAuthority, String auditingValue, String scanningOption, boolean specialRestrictions, String defaultDiskStorageOption, String defaultMainStorageOption, String caseSensitivity, String defaultFileFormat, String description) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating UDFS.");
        }
        int vrm = this.system_.getVRM();
        StringBuilder cmd = new StringBuilder("CRTUDFS UDFS('" + this.path_ + "')");
        cmd.append(" DTAAUT(").append(publicDataAuthority).append(")");
        cmd.append(" OBJAUT(").append(UDFS.setArrayToString(publicObjectAuthority)).append(")");
        cmd.append(" CRTOBJAUD(").append(auditingValue).append(")");
        if (vrm >= 328448) {
            cmd.append(" CRTOBJSCAN(").append(scanningOption).append(")");
            cmd.append(" RSTDRNMUNL(").append(specialRestrictions ? "*YES" : "*NO").append(")");
        }
        if (vrm >= 393472) {
            cmd.append(" DFTDISKSTG(").append(defaultDiskStorageOption).append(")");
            cmd.append(" DFTMAINSTG(").append(defaultMainStorageOption).append(")");
        }
        cmd.append(" CASE(").append(caseSensitivity).append(")");
        cmd.append(" DFTFILEFMT(").append(defaultFileFormat).append(")");
        cmd.append(" TEXT('").append(description).append("')");
        if (this.storageUnit_ != null && !this.storageUnit_.equalsIgnoreCase("*ANY")) {
            if (vrm >= 459008) {
                cmd.append(" UNIT(").append(this.storageUnit_).append(")");
            } else if (Trace.traceOn_) {
                Trace.log(4, "setPreferredStorageUnit(*SSD) is not supported prior to IBM i 7.1.");
            }
        }
        this.runCommand(cmd.toString());
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Deleting UDFS.");
        }
        this.runCommand("DLTUDFS UDFS('" + this.path_ + "')");
    }

    public void mount(String mountPoint) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Mounting UDFS.");
        }
        this.runCommand("ADDMFS TYPE(*UDFS) MFS('" + this.path_ + "') MNTOVRDIR('" + mountPoint + "')");
    }

    public void mount(String mountPoint, boolean rwOption, boolean suidOption) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Mounting UDFS.");
        }
        this.runCommand("ADDMFS TYPE(*UDFS) MFS('" + this.path_ + "') MNTOVRDIR('" + mountPoint + "') OPTIONS('" + (rwOption ? "rw," : "ro,") + (suidOption ? "suid" : "nosuid") + "')");
    }

    public void unmount() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Unmounting UDFS.");
        }
        this.runCommand("RMVMFS TYPE(*UDFS) MFS('" + this.path_ + "')");
    }

    private static String setArrayToString(String[] array) {
        int arrayLength = array.length;
        if (arrayLength == 0) {
            return "*INDIR";
        }
        if (arrayLength == 1) {
            return array[0];
        }
        StringBuilder buf = new StringBuilder(array[0]);
        for (int i = 1; i < arrayLength; ++i) {
            buf.append(" ");
            buf.append(array[i]);
        }
        return buf.toString();
    }

    private void runCommand(String command) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        CommandCall cmd = new CommandCall(this.system_, command);
        cmd.suggestThreadsafe(false);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    private static byte[] createPathName(AS400 system, String path) throws IOException {
        path = path.replace('/', '\\');
        Converter conv = new Converter(1200, system);
        byte[] pathName = new byte[4 + path.length() * 2];
        BinaryConverter.intToByteArray(path.length() * 2, pathName, 0);
        conv.stringToByteArray(path, pathName, 4);
        return pathName;
    }

    public UdfsInformationStructure getUdfsInformationStructure() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.fd_.system_ = (AS400ImplRemote)this.system_.getImpl();
        this.fd_.connect();
        DataStream baseReply = this.fd_.server_.sendAndReceive(new IFSIoctlReq(1, UDFS.createPathName(this.system_, this.path_)));
        if (!(baseReply instanceof IFSIoctlRep)) {
            Trace.log(2, "Unknown reply datastream:", baseReply.data_);
            throw new InternalErrorException(2);
        }
        IFSIoctlRep reply = (IFSIoctlRep)baseReply;
        return new UdfsInformationStructure(reply.getReplyData());
    }

    public MountedFsInformationStructure getMountedFsInformationStructure() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.fd_.system_ = (AS400ImplRemote)this.system_.getImpl();
        this.fd_.connect();
        DataStream baseReply = this.fd_.server_.sendAndReceive(new IFSIoctlReq(4, UDFS.createPathName(this.system_, this.path_)));
        if (!(baseReply instanceof IFSIoctlRep)) {
            Trace.log(2, "Unknown reply datastream:", baseReply.data_);
            throw new InternalErrorException(2);
        }
        IFSIoctlRep reply = (IFSIoctlRep)baseReply;
        return new MountedFsInformationStructure(reply.getReplyData());
    }

    public void setPreferredStorageUnit(String storageUnit) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting storage unit to " + storageUnit);
        }
        if (storageUnit == null || storageUnit.equalsIgnoreCase("*ANY")) {
            this.storageUnit_ = null;
        } else if (storageUnit.equalsIgnoreCase("*SSD")) {
            this.storageUnit_ = "*SSD";
        } else {
            throw new ExtendedIllegalArgumentException("storageUnit (" + storageUnit + ")", 2);
        }
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSIoctlRep(), 0);
    }

    public class MountedFsInformationStructure {
        private boolean idUdfs_;
        private boolean isMounted_;

        public boolean isUdfs() {
            return this.idUdfs_;
        }

        public boolean isMounted() {
            return this.isMounted_;
        }

        private MountedFsInformationStructure(byte[] replyData) throws ErrorCompletingRequestException {
            int rc = BinaryConverter.byteArrayToInt(replyData, 0);
            if (rc != 0) {
                Trace.log(2, "Get mounted FS information structure was not successful, errno:", rc);
                throw new ErrnoException(UDFS.this.system_, rc);
            }
            this.idUdfs_ = replyData[4] != 0;
            this.isMounted_ = replyData[5] != 0;
        }
    }

    public class UdfsInformationStructure {
        private String owner_;
        private int ccsid_;
        private String caseSensitivity_;
        private String description_;
        private String pathWhereMounted_;

        public String getOwner() {
            return this.owner_;
        }

        public int getCcsid() {
            return this.ccsid_;
        }

        public String getCaseSensitivity() {
            return this.caseSensitivity_;
        }

        public String getDescription() {
            return this.description_;
        }

        public String getPathWhereMounted() {
            return this.pathWhereMounted_;
        }

        private UdfsInformationStructure(byte[] replyData) throws ErrorCompletingRequestException, IOException {
            Converter convu = new Converter(1200, UDFS.this.system_);
            Converter conve = new Converter(37, UDFS.this.system_);
            int rc = BinaryConverter.byteArrayToInt(replyData, 0);
            if (rc != 0) {
                Trace.log(2, "Get UDFS information structure was not successful, errno:", rc);
                throw new ErrnoException(UDFS.this.system_, rc);
            }
            this.owner_ = conve.byteArrayToString(replyData, 4, 10).trim();
            this.ccsid_ = BinaryConverter.byteArrayToUnsignedShort(replyData, 14);
            this.caseSensitivity_ = replyData[16] == 0 ? "*MONO" : "*MIXED";
            byte descriptionLength = replyData[19];
            this.description_ = conve.byteArrayToString(replyData, 21, descriptionLength).trim();
            this.pathWhereMounted_ = convu.byteArrayToString(replyData, 121, replyData.length - 121);
        }
    }
}

