/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.SystemValueInfo;
import com.ibm.as400.access.SystemValueUtility;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class SystemValueList
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int GROUP_ALC = 0;
    public static final int GROUP_ALL = 9;
    public static final int GROUP_DATTIM = 1;
    public static final int GROUP_EDT = 2;
    public static final int GROUP_LIBL = 3;
    public static final int GROUP_MSG = 4;
    public static final int GROUP_NET = 8;
    public static final int GROUP_SEC = 5;
    public static final int GROUP_STG = 6;
    public static final int GROUP_SYSCTL = 7;
    public static final int TYPE_ARRAY = 4;
    public static final int TYPE_DATE = 5;
    public static final int TYPE_DECIMAL = 2;
    public static final int TYPE_INTEGER = 3;
    public static final int TYPE_STRING = 1;
    static final byte SERVER_TYPE_BINARY = -62;
    static final byte SERVER_TYPE_CHAR = -61;
    private static final int VRM420 = 262656;
    private static final int VRM430 = 262912;
    private static final int VRM440 = 263168;
    private static final int VRM510 = 327936;
    private static final int VRM520 = 328192;
    private static final int VRM530 = 328448;
    private static final int VRM540 = 328704;
    private static final int VRM610 = 393472;
    private static final int GROUP_COUNT = 10;
    private static final String[] GROUP_NAMES = new String[]{ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_ALC_NAME"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_DATTIM_NAME"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_EDT_NAME"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_LIBL_NAME"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_MSG_NAME"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_SEC_NAME"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_STG_NAME"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_SYSCTL_NAME"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_NET_NAME"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_ALL_NAME")};
    private static final String[] GROUP_DESCRIPTIONS = new String[]{ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_ALC_DESC"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_DATTIM_DESC"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_EDT_DESC"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_LIBL_DESC"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_MSG_DESC"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_SEC_DESC"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_STG_DESC"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_SYSCTL_DESC"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_NET_DESC"), ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_ALL_DESC")};
    private static Hashtable list = new Hashtable(260);
    static Vector[] groups = new Vector[]{new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector()};
    private AS400 system_ = null;
    private boolean connected_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public SystemValueList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValueList object.");
        }
    }

    public SystemValueList(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValueGroup object, system: " + String.valueOf(system));
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValueList systemValueList = this;
        synchronized (systemValueList) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValueList systemValueList = this;
        synchronized (systemValueList) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    private void connect() throws AS400SecurityException, IOException {
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.connected_ = true;
    }

    public Vector getGroup(int group) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.connected_) {
            this.connect();
        }
        if (group < 0 || group > 9) {
            Trace.log(2, "Value of parameter 'group' is not valid:", group);
            throw new ExtendedIllegalArgumentException("group", 2);
        }
        Vector infos = groups[group];
        if (this.system_.getVRM() <= 327936) {
            switch (group) {
                case 5: {
                    infos = (Vector)infos.clone();
                    infos.removeElement(SystemValueList.lookup("QFRCCVNRST"));
                    break;
                }
                case 7: {
                    infos = (Vector)infos.clone();
                    infos.addElement(SystemValueList.lookup("QFRCCVNRST"));
                }
            }
        }
        return SystemValueList.sort(SystemValueUtility.retrieve(this.system_, infos.elements(), SystemValueList.getGroupName(group), SystemValueList.getGroupDescription(group)));
    }

    public static int getGroupCount() {
        return 10;
    }

    public static String getGroupDescription(int group) {
        if (group < 0 || group > 9) {
            Trace.log(2, "Value of parameter 'group' is not valid:", group);
            throw new ExtendedIllegalArgumentException("group", 2);
        }
        return GROUP_DESCRIPTIONS[group];
    }

    public static String getGroupDescription(int group, Locale locale) {
        if (group < 0 || group > 9) {
            Trace.log(2, "Value of parameter 'group' is not valid:", group);
            throw new ExtendedIllegalArgumentException("group", 2);
        }
        if (locale == null) {
            return GROUP_DESCRIPTIONS[group];
        }
        switch (group) {
            case 0: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_ALC_DESC", locale);
            }
            case 1: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_DATTIM_DESC", locale);
            }
            case 2: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_EDT_DESC", locale);
            }
            case 3: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_LIBL_DESC", locale);
            }
            case 4: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_MSG_DESC", locale);
            }
            case 5: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_SEC_DESC", locale);
            }
            case 6: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_STG_DESC", locale);
            }
            case 7: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_SYSCTL_DESC", locale);
            }
            case 8: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_NET_DESC", locale);
            }
            case 9: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_ALL_DESC", locale);
            }
        }
        return GROUP_DESCRIPTIONS[group];
    }

    public static String getGroupName(int group) {
        if (group < 0 || group > 9) {
            Trace.log(2, "Value of parameter 'group' is not valid:", group);
            throw new ExtendedIllegalArgumentException("group", 2);
        }
        return GROUP_NAMES[group];
    }

    public static String getGroupName(int group, Locale locale) {
        if (group < 0 || group > 9) {
            Trace.log(2, "Value of parameter 'group' is not valid:", group);
            throw new ExtendedIllegalArgumentException("group", 2);
        }
        if (locale == null) {
            return GROUP_NAMES[group];
        }
        switch (group) {
            case 0: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_ALC_NAME", locale);
            }
            case 1: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_DATTIM_NAME", locale);
            }
            case 2: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_EDT_NAME", locale);
            }
            case 3: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_LIBL_NAME", locale);
            }
            case 4: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_MSG_NAME", locale);
            }
            case 5: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_SEC_NAME", locale);
            }
            case 6: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_STG_NAME", locale);
            }
            case 7: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_SYSCTL_NAME", locale);
            }
            case 8: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_NET_NAME", locale);
            }
            case 9: {
                return ResourceBundleLoader.getSystemValueText("SYSTEM_VALUE_GROUP_ALL_NAME", locale);
            }
        }
        return GROUP_NAMES[group];
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + String.valueOf(this.system_));
        }
        return this.system_;
    }

    static SystemValueInfo lookup(String name) {
        SystemValueInfo obj = (SystemValueInfo)list.get(name);
        if (obj == null) {
            Trace.log(2, "System value was not found: " + name);
            throw new ExtendedIllegalArgumentException(name, 5);
        }
        return obj;
    }

    static String lookupDescription(SystemValueInfo info, Locale locale) {
        return ResourceBundleLoader.getSystemValueText(info.name_.toUpperCase().trim() + "_DES", locale);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + String.valueOf(system));
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = system;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }

    static Vector sort(Vector vec) {
        int len = vec.size();
        if (len < 2) {
            return vec;
        }
        SystemValue middle = (SystemValue)vec.elementAt(len / 2);
        Vector<SystemValue> lessthan = new Vector<SystemValue>(len / 2);
        Vector<SystemValue> equalto = new Vector<SystemValue>(len / 2);
        Vector<SystemValue> greaterthan = new Vector<SystemValue>(len / 2);
        Enumeration elements = vec.elements();
        while (elements.hasMoreElements()) {
            SystemValue obj = (SystemValue)elements.nextElement();
            int comparison = obj.getName().compareTo(middle.getName());
            if (comparison < 0) {
                lessthan.addElement(obj);
                continue;
            }
            if (comparison > 0) {
                greaterthan.addElement(obj);
                continue;
            }
            equalto.addElement(obj);
        }
        lessthan.trimToSize();
        equalto.trimToSize();
        greaterthan.trimToSize();
        Vector lefthalf = SystemValueList.sort(lessthan);
        Vector righthalf = SystemValueList.sort(greaterthan);
        Vector whole = new Vector(lefthalf.size() + righthalf.size() + equalto.size());
        elements = lefthalf.elements();
        while (elements.hasMoreElements()) {
            whole.addElement(elements.nextElement());
        }
        elements = equalto.elements();
        while (elements.hasMoreElements()) {
            whole.addElement(elements.nextElement());
        }
        elements = righthalf.elements();
        while (elements.hasMoreElements()) {
            whole.addElement(elements.nextElement());
        }
        return whole;
    }

    static {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Populating system value table...");
        }
        list.put("ALRBCKFP", new SystemValueInfo("ALRBCKFP", -61, 8, 2, 4, 8, 262656, ResourceBundleLoader.getSystemValueText("ALRBCKFP_DES")));
        list.put("ALRCTLD", new SystemValueInfo("ALRCTLD", -61, 10, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("ALRCTLD_DES")));
        list.put("ALRDFTFP", new SystemValueInfo("ALRDFTFP", -61, 10, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("ALRDFTFP_DES")));
        list.put("ALRFTR", new SystemValueInfo("ALRFTR", -61, 20, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("ALRFTR_DES")));
        list.put("ALRHLDCNT", new SystemValueInfo("ALRHLDCNT", -62, 4, 1, 3, 8, 262656, ResourceBundleLoader.getSystemValueText("ALRHLDCNT_DES")));
        list.put("ALRLOGSTS", new SystemValueInfo("ALRLOGSTS", -61, 8, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("ALRLOGSTS_DES")));
        list.put("ALRPRIFP", new SystemValueInfo("ALRPRIFP", -61, 10, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("ALRPRIFP_DES")));
        list.put("ALRRQSFP", new SystemValueInfo("ALRRQSFP", -61, 8, 2, 4, 8, 262656, ResourceBundleLoader.getSystemValueText("ALRRQSFP_DES")));
        list.put("ALRSTS", new SystemValueInfo("ALRSTS", -61, 10, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("ALRSTS_DES")));
        list.put("ALWANYNET", new SystemValueInfo("ALWANYNET", -61, 10, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("ALWANYNET_DES")));
        list.put("ALWHPRTWR", new SystemValueInfo("ALWHPRTWR", -61, 10, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("ALWHPRTWR_DES")));
        list.put("ALWVRTAPPN", new SystemValueInfo("ALWVRTAPPN", -61, 10, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("ALWVRTAPPN_DES")));
        list.put("DDMACC", new SystemValueInfo("DDMACC", -61, 20, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("DDMACC_DES")));
        list.put("DFTCNNLST", new SystemValueInfo("DFTCNNLST", -61, 10, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("DFTCNNLST_DES")));
        list.put("DFTMODE", new SystemValueInfo("DFTMODE", -61, 8, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("DFTMODE_DES")));
        list.put("DFTNETTYPE", new SystemValueInfo("DFTNETTYPE", -61, 10, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("DFTNETTYPE_DES")));
        list.put("DTACPR", new SystemValueInfo("DTACPR", -62, 4, 1, 3, 8, 262656, ResourceBundleLoader.getSystemValueText("DTACPR_DES")));
        list.put("DTACPRINM", new SystemValueInfo("DTACPRINM", -62, 4, 1, 3, 8, 262656, ResourceBundleLoader.getSystemValueText("DTACPRINM_DES")));
        list.put("HPRPTHTMR", new SystemValueInfo("HPRPTHTMR", -61, 10, 4, 4, 8, 262656, ResourceBundleLoader.getSystemValueText("HPRPTHTMR_DES")));
        list.put("JOBACN", new SystemValueInfo("JOBACN", -61, 10, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("JOBACN_DES")));
        list.put("LCLCPNAME", new SystemValueInfo("LCLCPNAME", -61, 8, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("LCLCPNAME_DES")));
        list.put("LCLLOCNAME", new SystemValueInfo("LCLLOCNAME", -61, 8, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("LCLLOCNAME_DES")));
        list.put("LCLNETID", new SystemValueInfo("LCLNETID", -61, 8, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("LCLNETID_DES")));
        list.put("MAXHOP", new SystemValueInfo("MAXHOP", -62, 4, 1, 3, 8, 262656, ResourceBundleLoader.getSystemValueText("MAXHOP_DES")));
        list.put("MAXINTSSN", new SystemValueInfo("MAXINTSSN", -62, 4, 1, 3, 8, 262656, ResourceBundleLoader.getSystemValueText("MAXINTSSN_DES")));
        list.put("MSGQ", new SystemValueInfo("MSGQ", -61, 20, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("MSGQ_DES")));
        list.put("NETSERVER", new SystemValueInfo("NETSERVER", -61, 17, 5, 4, 8, 262656, ResourceBundleLoader.getSystemValueText("NETSERVER_DES")));
        list.put("NODETYPE", new SystemValueInfo("NODETYPE", -61, 8, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("NODETYPE_DES")));
        list.put("NWSDOMAIN", new SystemValueInfo("NWSDOMAIN", -61, 8, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("NWSDOMAIN_DES")));
        list.put("OUTQ", new SystemValueInfo("OUTQ", -61, 20, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("OUTQ_DES")));
        list.put("PCSACC", new SystemValueInfo("PCSACC", -61, 20, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("PCSACC_DES")));
        list.put("PNDSYSNAME", new SystemValueInfo("PNDSYSNAME", -61, 8, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("PNDSYSNAME_DES"), true));
        list.put("RAR", new SystemValueInfo("RAR", -62, 4, 1, 3, 8, 262656, ResourceBundleLoader.getSystemValueText("RAR_DES")));
        list.put("SYSNAME", new SystemValueInfo("SYSNAME", -61, 8, 1, 1, 8, 262656, ResourceBundleLoader.getSystemValueText("SYSNAME_DES")));
        list.put("VRTAUTODEV", new SystemValueInfo("VRTAUTODEV", -62, 4, 1, 3, 8, 262656, ResourceBundleLoader.getSystemValueText("VRTAUTODEV_DES")));
        list.put("ALWADDCLU", new SystemValueInfo("ALWADDCLU", -61, 10, 1, 1, 8, 263168, ResourceBundleLoader.getSystemValueText("ALWADDCLU_DES")));
        list.put("MDMCNTRYID", new SystemValueInfo("MDMCNTRYID", -61, 2, 1, 1, 8, 263168, ResourceBundleLoader.getSystemValueText("MDMCNTRYID_DES")));
        list.put("QABNORMSW", new SystemValueInfo("QABNORMSW", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QABNORMSW_DES"), true));
        list.put("QACGLVL", new SystemValueInfo("QACGLVL", -61, 10, 8, 4, 4, 262656, ResourceBundleLoader.getSystemValueText("QACGLVL_DES")));
        list.put("QACTJOB", new SystemValueInfo("QACTJOB", -62, 4, 1, 3, 0, 262656, ResourceBundleLoader.getSystemValueText("QACTJOB_DES")));
        list.put("QADLACTJ", new SystemValueInfo("QADLACTJ", -62, 4, 1, 3, 0, 262656, ResourceBundleLoader.getSystemValueText("QADLACTJ_DES")));
        list.put("QADLSPLA", new SystemValueInfo("QADLSPLA", -62, 4, 1, 3, 0, 262656, ResourceBundleLoader.getSystemValueText("QADLSPLA_DES")));
        list.put("QADLTOTJ", new SystemValueInfo("QADLTOTJ", -62, 4, 1, 3, 0, 262656, ResourceBundleLoader.getSystemValueText("QADLTOTJ_DES")));
        list.put("QALWOBJRST", new SystemValueInfo("QALWOBJRST", -61, 10, 15, 4, 5, 262656, ResourceBundleLoader.getSystemValueText("QALWOBJRST_DES")));
        list.put("QALWUSRDMN", new SystemValueInfo("QALWUSRDMN", -61, 10, 50, 4, 5, 262656, ResourceBundleLoader.getSystemValueText("QALWUSRDMN_DES")));
        list.put("QASTLVL", new SystemValueInfo("QASTLVL", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QASTLVL_DES")));
        list.put("QATNPGM", new SystemValueInfo("QATNPGM", -61, 20, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QATNPGM_DES")));
        list.put("QAUDCTL", new SystemValueInfo("QAUDCTL", -61, 10, 5, 4, 5, 262656, ResourceBundleLoader.getSystemValueText("QAUDCTL_DES")));
        list.put("QAUDENDACN", new SystemValueInfo("QAUDENDACN", -61, 10, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QAUDENDACN_DES")));
        list.put("QAUDFRCLVL", new SystemValueInfo("QAUDFRCLVL", -62, 4, 1, 3, 5, 262656, ResourceBundleLoader.getSystemValueText("QAUDFRCLVL_DES")));
        list.put("QAUDLVL", new SystemValueInfo("QAUDLVL", -61, 10, 16, 4, 5, 262656, ResourceBundleLoader.getSystemValueText("QAUDLVL_DES")));
        list.put("QAUTOCFG", new SystemValueInfo("QAUTOCFG", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QAUTOCFG_DES")));
        list.put("QAUTORMT", new SystemValueInfo("QAUTORMT", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QAUTORMT_DES")));
        list.put("QAUTOSPRPT", new SystemValueInfo("QAUTOSPRPT", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QAUTOSPRPT_DES")));
        list.put("QAUTOVRT", new SystemValueInfo("QAUTOVRT", -62, 4, 1, 3, 7, 262656, ResourceBundleLoader.getSystemValueText("QAUTOVRT_DES")));
        list.put("QBASACTLVL", new SystemValueInfo("QBASACTLVL", -62, 4, 1, 3, 6, 262656, ResourceBundleLoader.getSystemValueText("QBASACTLVL_DES")));
        list.put("QBASPOOL", new SystemValueInfo("QBASPOOL", -62, 4, 1, 3, 6, 262656, ResourceBundleLoader.getSystemValueText("QBASPOOL_DES")));
        list.put("QBOOKPATH", new SystemValueInfo("QBOOKPATH", -61, 63, 5, 4, 7, 262656, ResourceBundleLoader.getSystemValueText("QBOOKPATH_DES")));
        list.put("QCCSID", new SystemValueInfo("QCCSID", -62, 4, 1, 3, 7, 262656, ResourceBundleLoader.getSystemValueText("QCCSID_DES")));
        list.put("QCENTURY", new SystemValueInfo("QCENTURY", -61, 1, 1, 1, 1, 262656, ResourceBundleLoader.getSystemValueText("QCENTURY_DES")));
        list.put("QCHRID", new SystemValueInfo("QCHRID", -61, 10, 2, 4, 7, 262656, ResourceBundleLoader.getSystemValueText("QCHRID_DES")));
        list.put("QCMNARB", new SystemValueInfo("QCMNARB", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QCMNARB_DES")));
        list.put("QCMNRCYLMT", new SystemValueInfo("QCMNRCYLMT", -61, 10, 2, 4, 7, 262656, ResourceBundleLoader.getSystemValueText("QCMNRCYLMT_DES")));
        list.put("QCNTRYID", new SystemValueInfo("QCNTRYID", -61, 2, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QCNTRYID_DES")));
        list.put("QCONSOLE", new SystemValueInfo("QCONSOLE", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QCONSOLE_DES"), true));
        list.put("QCRTAUT", new SystemValueInfo("QCRTAUT", -61, 10, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QCRTAUT_DES")));
        list.put("QCRTOBJAUD", new SystemValueInfo("QCRTOBJAUD", -61, 10, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QCRTOBJAUD_DES")));
        list.put("QCTLSBSD", new SystemValueInfo("QCTLSBSD", -61, 20, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QCTLSBSD_DES")));
        list.put("QCURSYM", new SystemValueInfo("QCURSYM", -61, 1, 1, 1, 2, 262656, ResourceBundleLoader.getSystemValueText("QCURSYM_DES")));
        list.put("QDATE", new SystemValueInfo("QDATE", -61, 7, 1, 5, 1, 262656, ResourceBundleLoader.getSystemValueText("QDATE_DES")));
        list.put("QDATFMT", new SystemValueInfo("QDATFMT", -61, 3, 1, 1, 2, 262656, ResourceBundleLoader.getSystemValueText("QDATFMT_DES")));
        list.put("QDATSEP", new SystemValueInfo("QDATSEP", -61, 1, 1, 1, 2, 262656, ResourceBundleLoader.getSystemValueText("QDATSEP_DES")));
        list.put("QDAY", new SystemValueInfo("QDAY", -61, 3, 1, 1, 1, 262656, ResourceBundleLoader.getSystemValueText("QDAY_DES")));
        list.put("QDAYOFWEEK", new SystemValueInfo("QDAYOFWEEK", -61, 4, 1, 1, 1, 262656, ResourceBundleLoader.getSystemValueText("QDAYOFWEEK_DES"), true));
        list.put("QDBRCVYWT", new SystemValueInfo("QDBRCVYWT", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QDBRCVYWT_DES")));
        list.put("QDECFMT", new SystemValueInfo("QDECFMT", -61, 1, 1, 1, 2, 262656, ResourceBundleLoader.getSystemValueText("QDECFMT_DES")));
        list.put("QDEVNAMING", new SystemValueInfo("QDEVNAMING", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QDEVNAMING_DES")));
        list.put("QDEVRCYACN", new SystemValueInfo("QDEVRCYACN", -61, 20, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QDEVRCYACN_DES")));
        list.put("QDSCJOBITV", new SystemValueInfo("QDSCJOBITV", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QDSCJOBITV_DES")));
        list.put("QDSPSGNINF", new SystemValueInfo("QDSPSGNINF", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QDSPSGNINF_DES")));
        list.put("QDYNPTYSCD", new SystemValueInfo("QDYNPTYSCD", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QDYNPTYSCD_DES")));
        list.put("QFRCCVNRST", new SystemValueInfo("QFRCCVNRST", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QFRCCVNRST_DES")));
        list.put("QHOUR", new SystemValueInfo("QHOUR", -61, 2, 1, 1, 1, 262656, ResourceBundleLoader.getSystemValueText("QHOUR_DES")));
        list.put("QHSTLOGSIZ", new SystemValueInfo("QHSTLOGSIZ", -62, 4, 1, 3, 4, 262656, ResourceBundleLoader.getSystemValueText("QHSTLOGSIZ_DES")));
        list.put("QIGC", new SystemValueInfo("QIGC", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QIGC_DES"), true));
        list.put("QIGCCDEFNT", new SystemValueInfo("QIGCCDEFNT", -61, 10, 2, 4, 7, 262656, ResourceBundleLoader.getSystemValueText("QIGCCDEFNT_DES")));
        list.put("QINACTITV", new SystemValueInfo("QINACTITV", -61, 10, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QINACTITV_DES")));
        list.put("QINACTMSGQ", new SystemValueInfo("QINACTMSGQ", -61, 10, 2, 4, 5, 262656, ResourceBundleLoader.getSystemValueText("QINACTMSGQ_DES")));
        list.put("QIPLDATTIM", new SystemValueInfo("QIPLDATTIM", -61, 20, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QIPLDATTIM_DES")));
        list.put("QIPLSTS", new SystemValueInfo("QIPLSTS", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QIPLSTS_DES"), true));
        list.put("QIPLTYPE", new SystemValueInfo("QIPLTYPE", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QIPLTYPE_DES")));
        list.put("QJOBMSGQFL", new SystemValueInfo("QJOBMSGQFL", -61, 10, 1, 1, 0, 262656, ResourceBundleLoader.getSystemValueText("QJOBMSGQFL_DES")));
        list.put("QJOBMSGQMX", new SystemValueInfo("QJOBMSGQMX", -62, 4, 1, 3, 0, 262656, ResourceBundleLoader.getSystemValueText("QJOBMSGQMX_DES")));
        list.put("QJOBMSGQSZ", new SystemValueInfo("QJOBMSGQSZ", -62, 4, 1, 3, 0, 262656, ResourceBundleLoader.getSystemValueText("QJOBMSGQSZ_DES")));
        list.put("QJOBMSGQTL", new SystemValueInfo("QJOBMSGQTL", -62, 4, 1, 3, 0, 262656, ResourceBundleLoader.getSystemValueText("QJOBMSGQTL_DES")));
        list.put("QJOBSPLA", new SystemValueInfo("QJOBSPLA", -62, 4, 1, 3, 0, 262656, ResourceBundleLoader.getSystemValueText("QJOBSPLA_DES")));
        list.put("QKBDBUF", new SystemValueInfo("QKBDBUF", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QKBDBUF_DES")));
        list.put("QKBDTYPE", new SystemValueInfo("QKBDTYPE", -61, 3, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QKBDTYPE_DES")));
        list.put("QLANGID", new SystemValueInfo("QLANGID", -61, 3, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QLANGID_DES")));
        list.put("QLEAPADJ", new SystemValueInfo("QLEAPADJ", -62, 4, 1, 3, 1, 262656, ResourceBundleLoader.getSystemValueText("QLEAPADJ_DES")));
        list.put("QLMTDEVSSN", new SystemValueInfo("QLMTDEVSSN", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QLMTDEVSSN_DES")));
        list.put("QLMTSECOFR", new SystemValueInfo("QLMTSECOFR", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QLMTSECOFR_DES")));
        list.put("QLOCALE", new SystemValueInfo("QLOCALE", -61, 2080, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QLOCALE_DES")));
        list.put("QMAXACTLVL", new SystemValueInfo("QMAXACTLVL", -62, 4, 1, 3, 6, 262656, ResourceBundleLoader.getSystemValueText("QMAXACTLVL_DES")));
        list.put("QMAXSGNACN", new SystemValueInfo("QMAXSGNACN", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QMAXSGNACN_DES")));
        list.put("QMAXSIGN", new SystemValueInfo("QMAXSIGN", -61, 6, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QMAXSIGN_DES")));
        list.put("QMCHPOOL", new SystemValueInfo("QMCHPOOL", -62, 4, 1, 3, 6, 262656, ResourceBundleLoader.getSystemValueText("QMCHPOOL_DES")));
        list.put("QMINUTE", new SystemValueInfo("QMINUTE", -61, 2, 1, 1, 1, 262656, ResourceBundleLoader.getSystemValueText("QMINUTE_DES")));
        list.put("QMODEL", new SystemValueInfo("QMODEL", -61, 4, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QMODEL_DES"), true));
        list.put("QMONTH", new SystemValueInfo("QMONTH", -61, 2, 1, 1, 1, 262656, ResourceBundleLoader.getSystemValueText("QMONTH_DES")));
        list.put("QPASTHRSVR", new SystemValueInfo("QPASTHRSVR", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QPASTHRSVR_DES")));
        list.put("QPFRADJ", new SystemValueInfo("QPFRADJ", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QPFRADJ_DES")));
        list.put("QPRBFTR", new SystemValueInfo("QPRBFTR", -61, 10, 2, 4, 4, 262656, ResourceBundleLoader.getSystemValueText("QPRBFTR_DES")));
        list.put("QPRBHLDITV", new SystemValueInfo("QPRBHLDITV", -62, 4, 1, 3, 4, 262656, ResourceBundleLoader.getSystemValueText("QPRBHLDITV_DES")));
        list.put("QPRTDEV", new SystemValueInfo("QPRTDEV", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QPRTDEV_DES")));
        list.put("QPRTKEYFMT", new SystemValueInfo("QPRTKEYFMT", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QPRTKEYFMT_DES")));
        list.put("QPRTTXT", new SystemValueInfo("QPRTTXT", -61, 30, 1, 1, 4, 262656, ResourceBundleLoader.getSystemValueText("QPRTTXT_DES")));
        list.put("QPWDEXPITV", new SystemValueInfo("QPWDEXPITV", -61, 6, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QPWDEXPITV_DES")));
        list.put("QPWDLMTAJC", new SystemValueInfo("QPWDLMTAJC", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QPWDLMTAJC_DES")));
        list.put("QPWDLMTCHR", new SystemValueInfo("QPWDLMTCHR", -61, 10, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QPWDLMTCHR_DES")));
        list.put("QPWDLMTREP", new SystemValueInfo("QPWDLMTREP", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QPWDLMTREP_DES")));
        list.put("QPWDMAXLEN", new SystemValueInfo("QPWDMAXLEN", -62, 4, 1, 3, 5, 262656, ResourceBundleLoader.getSystemValueText("QPWDMAXLEN_DES")));
        list.put("QPWDMINLEN", new SystemValueInfo("QPWDMINLEN", -62, 4, 1, 3, 5, 262656, ResourceBundleLoader.getSystemValueText("QPWDMINLEN_DES")));
        list.put("QPWDPOSDIF", new SystemValueInfo("QPWDPOSDIF", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QPWDPOSDIF_DES")));
        list.put("QPWDRQDDGT", new SystemValueInfo("QPWDRQDDGT", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QPWDRQDDGT_DES")));
        list.put("QPWDRQDDIF", new SystemValueInfo("QPWDRQDDIF", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QPWDRQDDIF_DES")));
        list.put("QPWDVLDPGM", new SystemValueInfo("QPWDVLDPGM", -61, 20, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QPWDVLDPGM_DES")));
        list.put("QPWRDWNLMT", new SystemValueInfo("QPWRDWNLMT", -62, 4, 1, 3, 7, 262656, ResourceBundleLoader.getSystemValueText("QPWRDWNLMT_DES")));
        list.put("QPWRRSTIPL", new SystemValueInfo("QPWRRSTIPL", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QPWRRSTIPL_DES")));
        list.put("QQRYDEGREE", new SystemValueInfo("QQRYDEGREE", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QQRYDEGREE_DES")));
        list.put("QQRYTIMLMT", new SystemValueInfo("QQRYTIMLMT", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QQRYTIMLMT_DES")));
        list.put("QRCLSPLSTG", new SystemValueInfo("QRCLSPLSTG", -61, 10, 1, 1, 0, 262656, ResourceBundleLoader.getSystemValueText("QRCLSPLSTG_DES")));
        list.put("QRETSVRSEC", new SystemValueInfo("QRETSVRSEC", -61, 1, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QRETSVRSEC_DES")));
        list.put("QRMTIPL", new SystemValueInfo("QRMTIPL", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QRMTIPL_DES")));
        list.put("QRMTSIGN", new SystemValueInfo("QRMTSIGN", -61, 20, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QRMTSIGN_DES")));
        list.put("QRMTSRVATR", new SystemValueInfo("QRMTSRVATR", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QRMTSRVATR_DES")));
        list.put("QSCPFCONS", new SystemValueInfo("QSCPFCONS", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QSCPFCONS_DES")));
        list.put("QSECOND", new SystemValueInfo("QSECOND", -61, 2, 1, 1, 1, 262656, ResourceBundleLoader.getSystemValueText("QSECOND_DES")));
        list.put("QSECURITY", new SystemValueInfo("QSECURITY", -61, 2, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QSECURITY_DES")));
        list.put("QSETJOBATR", new SystemValueInfo("QSETJOBATR", -61, 10, 16, 4, 7, 262656, ResourceBundleLoader.getSystemValueText("QSETJOBATR_DES")));
        list.put("QSFWERRLOG", new SystemValueInfo("QSFWERRLOG", -61, 10, 1, 1, 4, 262656, ResourceBundleLoader.getSystemValueText("QSFWERRLOG_DES")));
        list.put("QSPCENV", new SystemValueInfo("QSPCENV", -61, 10, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QSPCENV_DES")));
        list.put("QSRLNBR", new SystemValueInfo("QSRLNBR", -61, 8, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QSRLNBR_DES"), true));
        list.put("QSRTSEQ", new SystemValueInfo("QSRTSEQ", -61, 20, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QSRTSEQ_DES")));
        list.put("QSRVDMP", new SystemValueInfo("QSRVDMP", -61, 10, 1, 1, 4, 262656, ResourceBundleLoader.getSystemValueText("QSRVDMP_DES")));
        list.put("QSTGLOWACN", new SystemValueInfo("QSTGLOWACN", -61, 10, 1, 1, 6, 262656, ResourceBundleLoader.getSystemValueText("QSTGLOWACN_DES")));
        list.put("QSTGLOWLMT", new SystemValueInfo("QSTGLOWLMT", -62, 7, 4, 1, 2, 6, 262656, ResourceBundleLoader.getSystemValueText("QSTGLOWLMT_DES")));
        list.put("QSTRPRTWTR", new SystemValueInfo("QSTRPRTWTR", -61, 1, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QSTRPRTWTR_DES"), true));
        list.put("QSTRUPPGM", new SystemValueInfo("QSTRUPPGM", -61, 20, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QSTRUPPGM_DES")));
        list.put("QSTSMSG", new SystemValueInfo("QSTSMSG", -61, 10, 1, 1, 4, 262656, ResourceBundleLoader.getSystemValueText("QSTSMSG_DES")));
        list.put("QSVRAUTITV", new SystemValueInfo("QSVRAUTITV", -62, 4, 1, 3, 7, 262656, ResourceBundleLoader.getSystemValueText("QSVRAUTITV_DES")));
        list.put("QSYSLIBL", new SystemValueInfo("QSYSLIBL", -61, 10, 15, 4, 3, 262656, ResourceBundleLoader.getSystemValueText("QSYSLIBL_DES")));
        list.put("QTIME", new SystemValueInfo("QTIME", -61, 9, 1, 5, 1, 262656, ResourceBundleLoader.getSystemValueText("QTIME_DES")));
        list.put("QTIMSEP", new SystemValueInfo("QTIMSEP", -61, 1, 1, 1, 2, 262656, ResourceBundleLoader.getSystemValueText("QTIMSEP_DES")));
        list.put("QTOTJOB", new SystemValueInfo("QTOTJOB", -62, 4, 1, 3, 0, 262656, ResourceBundleLoader.getSystemValueText("QTOTJOB_DES")));
        list.put("QTSEPOOL", new SystemValueInfo("QTSEPOOL", -61, 10, 1, 1, 6, 262656, ResourceBundleLoader.getSystemValueText("QTSEPOOL_DES")));
        list.put("QUPSDLYTIM", new SystemValueInfo("QUPSDLYTIM", -61, 10, 2, 4, 7, 262656, ResourceBundleLoader.getSystemValueText("QUPSDLYTIM_DES")));
        list.put("QUPSMSGQ", new SystemValueInfo("QUPSMSGQ", -61, 20, 1, 1, 7, 262656, ResourceBundleLoader.getSystemValueText("QUPSMSGQ_DES")));
        list.put("QUSEADPAUT", new SystemValueInfo("QUSEADPAUT", -61, 10, 1, 1, 5, 262656, ResourceBundleLoader.getSystemValueText("QUSEADPAUT_DES")));
        list.put("QUSRLIBL", new SystemValueInfo("QUSRLIBL", -61, 10, 25, 4, 3, 262656, ResourceBundleLoader.getSystemValueText("QUSRLIBL_DES")));
        list.put("QUTCOFFSET", new SystemValueInfo("QUTCOFFSET", -61, 5, 1, 1, 1, 262656, ResourceBundleLoader.getSystemValueText("QUTCOFFSET_DES")));
        list.put("QYEAR", new SystemValueInfo("QYEAR", -61, 2, 1, 1, 1, 262656, ResourceBundleLoader.getSystemValueText("QYEAR_DES")));
        list.put("QCHRIDCTL", new SystemValueInfo("QCHRIDCTL", -61, 10, 1, 1, 7, 262912, ResourceBundleLoader.getSystemValueText("QCHRIDCTL_DES")));
        list.put("QDYNPTYADJ", new SystemValueInfo("QDYNPTYADJ", -61, 1, 1, 1, 7, 262912, ResourceBundleLoader.getSystemValueText("QDYNPTYADJ_DES")));
        list.put("QIGCFNTSIZ", new SystemValueInfo("QIGCFNTSIZ", -62, 4, 1, 1, 2, 7, 262912, ResourceBundleLoader.getSystemValueText("QIGCFNTSIZ_DES")));
        list.put("QPRCMLTTSK", new SystemValueInfo("QPRCMLTTSK", -61, 1, 1, 1, 7, 262912, ResourceBundleLoader.getSystemValueText("QPRCMLTTSK_DES")));
        list.put("QPRCFEAT", new SystemValueInfo("QPRCFEAT", -61, 4, 1, 1, 7, 262912, ResourceBundleLoader.getSystemValueText("QPRCFEAT_DES"), true));
        list.put("QCFGMSGQ", new SystemValueInfo("QCFGMSGQ", -61, 20, 1, 1, 4, 263168, ResourceBundleLoader.getSystemValueText("QCFGMSGQ_DES")));
        list.put("QMLTTHDACN", new SystemValueInfo("QMLTTHDACN", -61, 1, 1, 1, 7, 263168, ResourceBundleLoader.getSystemValueText("QMLTTHDACN_DES")));
        list.put("QMAXJOB", new SystemValueInfo("QMAXJOB", -62, 4, 1, 3, 0, 327936, ResourceBundleLoader.getSystemValueText("QMAXJOB_DES")));
        list.put("QMAXSPLF", new SystemValueInfo("QMAXSPLF", -62, 4, 1, 3, 0, 327936, ResourceBundleLoader.getSystemValueText("QMAXSPLF_DES")));
        list.put("QVFYOBJRST", new SystemValueInfo("QVFYOBJRST", -61, 1, 1, 1, 5, 327936, ResourceBundleLoader.getSystemValueText("QVFYOBJRST_DES")));
        list.put("QSHRMEMCTL", new SystemValueInfo("QSHRMEMCTL", -61, 1, 1, 1, 5, 327936, ResourceBundleLoader.getSystemValueText("QSHRMEMCTL_DES")));
        list.put("QLIBLCKLVL", new SystemValueInfo("QLIBLCKLVL", -61, 1, 1, 1, 3, 327936, ResourceBundleLoader.getSystemValueText("QLIBLCKLVL_DES")));
        list.put("QPWDLVL", new SystemValueInfo("QPWDLVL", -62, 4, 1, 3, 5, 327936, ResourceBundleLoader.getSystemValueText("QPWDLVL_DES")));
        list.put("QSPLFACN", new SystemValueInfo("QSPLFACN", -61, 10, 1, 1, 0, 328192, ResourceBundleLoader.getSystemValueText("QSPLFACN_DES")));
        list.put("QDBFSTCCOL", new SystemValueInfo("QDBFSTCCOL", -61, 10, 1, 1, 7, 328192, ResourceBundleLoader.getSystemValueText("QDBFSTCCOL_DES")));
        list.put("QAUDLVL2", new SystemValueInfo("QAUDLVL2", -61, 10, 99, 4, 5, 328448, ResourceBundleLoader.getSystemValueText("QAUDLVL2_DES")));
        list.put("QDATETIME", new SystemValueInfo("QDATETIME", -61, 20, 1, 1, 1, 328448, ResourceBundleLoader.getSystemValueText("QDATETIME_DES")));
        list.put("QENDJOBLMT", new SystemValueInfo("QENDJOBLMT", -62, 4, 1, 3, 7, 328448, ResourceBundleLoader.getSystemValueText("QENDJOBLMT_DES")));
        list.put("QSAVACCPTH", new SystemValueInfo("QSAVACCPTH", -61, 1, 1, 1, 7, 328448, ResourceBundleLoader.getSystemValueText("QSAVACCPTH_DES")));
        list.put("QSCANFS", new SystemValueInfo("QSCANFS", -61, 10, 20, 4, 5, 328448, ResourceBundleLoader.getSystemValueText("QSCANFS_DES")));
        list.put("QSCANFSCTL", new SystemValueInfo("QSCANFSCTL", -61, 10, 20, 4, 5, 328448, ResourceBundleLoader.getSystemValueText("QSCANFSCTL_DES")));
        list.put("QTIMADJ", new SystemValueInfo("QTIMADJ", -61, 28, 1, 1, 1, 328448, ResourceBundleLoader.getSystemValueText("QTIMADJ_DES")));
        list.put("QTIMZON", new SystemValueInfo("QTIMZON", -61, 10, 1, 1, 1, 328448, ResourceBundleLoader.getSystemValueText("QTIMZON_DES")));
        list.put("QTHDRSCAFN", new SystemValueInfo("QTHDRSCAFN", -61, 10, 2, 4, 7, 328448, ResourceBundleLoader.getSystemValueText("QTHDRSCAFN_DES")));
        list.put("QTHDRSCADJ", new SystemValueInfo("QTHDRSCADJ", -61, 1, 1, 1, 7, 328448, ResourceBundleLoader.getSystemValueText("QTHDRSCADJ_DES")));
        list.put("QALWJOBITP", new SystemValueInfo("QALWJOBITP", -61, 1, 1, 1, 7, 328704, ResourceBundleLoader.getSystemValueText("QALWJOBITP_DES")));
        list.put("QLOGOUTPUT", new SystemValueInfo("QLOGOUTPUT", -61, 10, 1, 1, 4, 328704, ResourceBundleLoader.getSystemValueText("QLOGOUTPUT_DES")));
        list.put("QPWDRULES", new SystemValueInfo("QPWDRULES", -61, 15, 50, 4, 5, 393472, ResourceBundleLoader.getSystemValueText("QPWDRULES_DES")));
        list.put("QPWDCHGBLK", new SystemValueInfo("QPWDCHGBLK", -61, 10, 1, 1, 5, 393472, ResourceBundleLoader.getSystemValueText("QPWDCHGBLK_DES")));
        list.put("QPWDEXPWRN", new SystemValueInfo("QPWDEXPWRN", -62, 4, 1, 3, 5, 393472, ResourceBundleLoader.getSystemValueText("QPWDEXPWRN_DES")));
        list.put("QSSLPCL", new SystemValueInfo("QSSLPCL", -61, 10, 10, 4, 5, 393472, ResourceBundleLoader.getSystemValueText("QSSLPCL_DES")));
        list.put("QSSLCSLCTL", new SystemValueInfo("QSSLCSLCTL", -61, 10, 1, 1, 5, 393472, ResourceBundleLoader.getSystemValueText("QSSLCSLCTL_DES")));
        list.put("QSSLCSL", new SystemValueInfo("QSSLCSL", -61, 40, 32, 4, 5, 393472, ResourceBundleLoader.getSystemValueText("QSSLCSL_DES")));
        Enumeration elements = list.elements();
        while (elements.hasMoreElements()) {
            SystemValueInfo obj = (SystemValueInfo)elements.nextElement();
            groups[obj.group_].addElement(obj);
            groups[9].addElement(obj);
        }
    }
}

