/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLVariableCompressible;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLLongVarcharForBitData
extends SQLDataBase
implements SQLVariableCompressible {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final byte[] default_ = new byte[0];
    private int length_ = 0;
    private int maxLength_;
    private byte[] value_;

    SQLLongVarcharForBitData(int maxLength, SQLConversionSettings settings) {
        super(settings);
        this.maxLength_ = maxLength;
        this.value_ = default_;
    }

    @Override
    public Object clone() {
        return new SQLLongVarcharForBitData(this.maxLength_, this.settings_);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(rawBytes, offset);
        AS400ByteArray typeConverter = new AS400ByteArray(this.length_);
        this.value_ = (byte[])typeConverter.toObject(rawBytes, offset + 2);
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        AS400ByteArray typeConverter = new AS400ByteArray(this.length_);
        BinaryConverter.unsignedShortToByteArray(this.length_, rawBytes, offset);
        typeConverter.toBytes(this.value_, rawBytes, offset + 2);
    }

    @Override
    public int convertToCompressedBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        AS400ByteArray typeConverter = new AS400ByteArray(this.length_);
        BinaryConverter.unsignedShortToByteArray(this.length_, rawBytes, offset);
        int bytesWritten = 2;
        typeConverter.toBytes(this.value_, rawBytes, offset + 2);
        return bytesWritten += this.length_;
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof String) {
            try {
                this.value_ = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException nfe) {
                JDError.throwSQLException((Object)this, "07006", nfe);
            }
        } else if (object instanceof byte[]) {
            this.value_ = (byte[])object;
        } else if (object instanceof InputStream) {
            this.value_ = SQLLongVarcharForBitData.getBytesFromInputStream((InputStream)object, scale, this);
        } else if (object instanceof Reader) {
            this.value_ = SQLLongVarcharForBitData.getBytesFromReader((Reader)object, scale, this);
        } else if (object instanceof Blob) {
            this.value_ = ((Blob)object).getBytes(1L, (int)((Blob)object).length());
        } else if (object instanceof Clob) {
            try {
                this.value_ = BinaryConverter.stringToBytes(((Clob)object).getSubString(1L, (int)((Clob)object).length()));
            }
            catch (NumberFormatException nfe) {
                JDError.throwSQLException((Object)this, "07006", nfe);
            }
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + String.valueOf(object) + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        int valueLength = this.value_.length;
        if (valueLength > this.maxLength_) {
            byte[] newValue = new byte[this.maxLength_];
            System.arraycopy(this.value_, 0, newValue, 0, this.maxLength_);
            this.value_ = newValue;
            this.truncated_ = valueLength - this.maxLength_;
            this.outOfBounds_ = false;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
        this.length_ = this.value_.length;
    }

    @Override
    public int getSQLType() {
        return 20;
    }

    @Override
    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    @Override
    public int getDisplaySize() {
        return this.maxLength_;
    }

    @Override
    public String getJavaClassName() {
        return "[B";
    }

    @Override
    public String getLiteralPrefix() {
        return "X'";
    }

    @Override
    public String getLiteralSuffix() {
        return "'";
    }

    @Override
    public String getLocalName() {
        return "LONG VARCHAR";
    }

    @Override
    public int getMaximumPrecision() {
        return 32739;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 456;
    }

    @Override
    public int getPrecision() {
        return this.maxLength_;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return -4;
    }

    @Override
    public String getTypeName() {
        return "LONG VARCHAR () FOR BIT DATA";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.value_.length;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new ByteArrayInputStream(this.getBytes());
    }

    @Override
    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        byte[] bytes = this.getBytes();
        return new AS400JDBCBlob(bytes, this.maxLength_);
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public byte[] getBytes() {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length > maxFieldSize && maxFieldSize > 0) {
            byte[] truncatedValue = new byte[maxFieldSize];
            System.arraycopy(this.value_, 0, truncatedValue, 0, maxFieldSize);
            return truncatedValue;
        }
        return this.value_;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    @Override
    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = BinaryConverter.bytesToHexString(this.getBytes());
        return new AS400JDBCClob(string, string.length());
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.getBytes();
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    @Override
    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCNClob(BinaryConverter.bytesToHexString(this.getBytes()), this.maxLength_);
    }

    @Override
    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() throws SQLException {
        this.savedValue_ = this.value_;
    }
}

