/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBlob
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    private static final byte[] default_ = new byte[0];
    private int maxLength_;
    private byte[] value_ = default_;
    private Object savedObject_;
    private int scale_ = -1;

    SQLBlob(int maxLength, SQLConversionSettings settings) {
        super(settings);
        this.maxLength_ = maxLength;
    }

    @Override
    public Object clone() {
        return new SQLBlob(this.maxLength_, null);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        int length = BinaryConverter.byteArrayToInt(rawBytes, offset);
        this.value_ = new byte[length];
        System.arraycopy(rawBytes, offset + 4, this.value_, 0, this.value_.length);
        this.savedObject_ = null;
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        BinaryConverter.intToByteArray(this.value_.length, rawBytes, offset);
        System.arraycopy(this.value_, 0, rawBytes, offset + 4, this.value_.length);
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            this.truncated_ = bytes.length > this.maxLength_ ? bytes.length - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (object instanceof String) {
            byte[] bytes = null;
            try {
                bytes = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException nfe) {
                JDError.throwSQLException((Object)this, "07006", nfe);
                throw new SQLException();
            }
            object = bytes;
            this.outOfBounds_ = false;
            this.truncated_ = bytes.length > this.maxLength_ ? bytes.length - this.maxLength_ : 0;
        } else if (object instanceof Clob) {
            byte[] bytes = null;
            try {
                bytes = BinaryConverter.stringToBytes(((Clob)object).getSubString(1L, (int)((Clob)object).length()));
            }
            catch (NumberFormatException nfe) {
                JDError.throwSQLException((Object)this, "07006", nfe);
                throw new SQLException();
            }
            object = bytes;
            this.outOfBounds_ = false;
            this.truncated_ = bytes.length > this.maxLength_ ? bytes.length - this.maxLength_ : 0;
        } else if (object instanceof Reader) {
            int length = scale;
            byte[] bytes = null;
            if (length >= 0) {
                try {
                    int blockSize = length < 1000000 ? length : 1000000;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    HexReaderInputStream stream = new HexReaderInputStream((Reader)object);
                    byte[] byteBuffer = new byte[blockSize];
                    int totalBytesRead = 0;
                    int bytesRead = stream.read(byteBuffer, 0, blockSize);
                    while (bytesRead > -1 && totalBytesRead < length) {
                        baos.write(byteBuffer, 0, bytesRead);
                        int bytesRemaining = length - (totalBytesRead += bytesRead);
                        if (bytesRemaining < blockSize) {
                            blockSize = bytesRemaining;
                        }
                        bytesRead = stream.read(byteBuffer, 0, blockSize);
                    }
                    bytes = baos.toByteArray();
                    if (bytes.length < length) {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    int objectLength = bytes.length;
                    if (bytes.length > this.maxLength_) {
                        byte[] newValue = new byte[this.maxLength_];
                        System.arraycopy(bytes, 0, newValue, 0, this.maxLength_);
                        bytes = newValue;
                    }
                    stream.close();
                    object = bytes;
                    this.truncated_ = objectLength - bytes.length;
                }
                catch (ExtendedIOException eie) {
                    JDError.throwSQLException((Object)this, "07006", eie);
                }
                catch (IOException ie) {
                    JDError.throwSQLException("HY000", ie);
                }
            } else if (length == -2 || length == -1) {
                try {
                    int blockSize = 1000000;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    HexReaderInputStream stream = new HexReaderInputStream((Reader)object);
                    byte[] byteBuffer = new byte[blockSize];
                    int totalBytesRead = 0;
                    int bytesRead = stream.read(byteBuffer, 0, blockSize);
                    while (bytesRead > -1) {
                        baos.write(byteBuffer, 0, bytesRead);
                        totalBytesRead += bytesRead;
                        bytesRead = stream.read(byteBuffer, 0, blockSize);
                    }
                    bytes = baos.toByteArray();
                    int objectLength = bytes.length;
                    if (bytes.length > this.maxLength_) {
                        byte[] newValue = new byte[this.maxLength_];
                        System.arraycopy(bytes, 0, newValue, 0, this.maxLength_);
                        bytes = newValue;
                    }
                    stream.close();
                    object = bytes;
                    this.truncated_ = objectLength - bytes.length;
                }
                catch (ExtendedIOException eie) {
                    JDError.throwSQLException((Object)this, "07006", eie);
                }
                catch (IOException ie) {
                    JDError.throwSQLException("HY000", ie);
                }
            } else {
                JDError.throwSQLException("07006");
            }
        } else if (!(object instanceof Blob) && !(object instanceof InputStream)) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + String.valueOf(object) + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        if (scale != -1) {
            this.scale_ = scale;
        }
        if (this.truncated_ > 0) {
            this.doConversion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        block20: {
            try {
                Object object = this.savedObject_;
                if (object instanceof byte[]) {
                    this.value_ = (byte[])object;
                    int objectLength = this.value_.length;
                    if (this.value_.length > this.maxLength_) {
                        byte[] newValue = new byte[this.maxLength_];
                        System.arraycopy(this.value_, 0, newValue, 0, this.maxLength_);
                        this.value_ = newValue;
                    }
                    this.truncated_ = objectLength - this.value_.length;
                    break block20;
                }
                if (object instanceof Blob) {
                    int lengthToUse;
                    Blob blob = (Blob)object;
                    int blobLength = (int)blob.length();
                    int n = lengthToUse = blobLength < 0 ? Integer.MAX_VALUE : blobLength;
                    if (lengthToUse > this.maxLength_) {
                        lengthToUse = this.maxLength_;
                    }
                    this.value_ = blob.getBytes(1L, lengthToUse);
                    this.truncated_ = blobLength - lengthToUse;
                    break block20;
                }
                if (object instanceof InputStream) {
                    int length = this.scale_;
                    if (length >= 0) {
                        InputStream stream = (InputStream)object;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        int blockSize = length < 1000000 ? length : 1000000;
                        byte[] byteBuffer = new byte[blockSize];
                        try {
                            int totalBytesRead = 0;
                            int bytesRead = stream.read(byteBuffer, 0, blockSize);
                            while (bytesRead > -1 && totalBytesRead < length) {
                                baos.write(byteBuffer, 0, bytesRead);
                                int bytesRemaining = length - (totalBytesRead += bytesRead);
                                if (bytesRemaining < blockSize) {
                                    blockSize = bytesRemaining;
                                }
                                bytesRead = stream.read(byteBuffer, 0, blockSize);
                            }
                        }
                        catch (IOException ie) {
                            JDError.throwSQLException("HY000", ie);
                        }
                        this.value_ = baos.toByteArray();
                        if (this.value_.length < length) {
                            JDError.throwSQLException((Object)this, "07006");
                        }
                        int objectLength = this.value_.length;
                        if (this.value_.length > this.maxLength_) {
                            byte[] newValue = new byte[this.maxLength_];
                            System.arraycopy(this.value_, 0, newValue, 0, this.maxLength_);
                            this.value_ = newValue;
                        }
                        this.truncated_ = objectLength - this.value_.length;
                        break block20;
                    }
                    if (length == -2) {
                        InputStream stream = (InputStream)object;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        int blockSize = 1000000;
                        byte[] byteBuffer = new byte[blockSize];
                        try {
                            int totalBytesRead = 0;
                            int bytesRead = stream.read(byteBuffer, 0, blockSize);
                            while (bytesRead > -1) {
                                baos.write(byteBuffer, 0, bytesRead);
                                totalBytesRead += bytesRead;
                                bytesRead = stream.read(byteBuffer, 0, blockSize);
                            }
                        }
                        catch (IOException ie) {
                            JDError.throwSQLException("HY000", ie);
                        }
                        this.value_ = baos.toByteArray();
                        int objectLength = this.value_.length;
                        if (this.value_.length > this.maxLength_) {
                            byte[] newValue = new byte[this.maxLength_];
                            System.arraycopy(this.value_, 0, newValue, 0, this.maxLength_);
                            this.value_ = newValue;
                        }
                        this.truncated_ = objectLength - this.value_.length;
                        break block20;
                    }
                    JDError.throwSQLException("07006");
                    break block20;
                }
                JDError.throwSQLException("07006");
            }
            finally {
                this.savedObject_ = null;
            }
        }
    }

    @Override
    public int getSQLType() {
        return 3;
    }

    @Override
    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    @Override
    public int getDisplaySize() {
        return this.maxLength_;
    }

    @Override
    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCBlob";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "BLOB";
    }

    @Override
    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 404;
    }

    @Override
    public int getPrecision() {
        return this.maxLength_;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 2004;
    }

    @Override
    public String getTypeName() {
        return "BLOB";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.value_.length;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new ByteArrayInputStream(this.value_);
    }

    @Override
    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCBlob(this.value_, this.maxLength_);
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    @Override
    public Object getObject() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCBlob(this.value_, this.maxLength_);
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.value_);
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCSQLXML(this.value_, (long)this.maxLength_);
    }

    @Override
    public void saveValue() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }
}

