/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBigint
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private long value_ = 0L;
    private int vrm_;

    SQLBigint(int vrm, SQLConversionSettings settings) {
        super(settings);
        this.vrm_ = vrm;
    }

    @Override
    public Object clone() {
        return new SQLBigint(this.vrm_, this.settings_);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.value_ = BinaryConverter.byteArrayToLong(rawBytes, offset);
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        BinaryConverter.longToByteArray(this.value_, rawBytes, offset);
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (object instanceof String) {
            try {
                this.value_ = Long.parseLong((String)object);
            }
            catch (NumberFormatException nfe) {
                try {
                    BigInteger bigInteger = new BigDecimal((String)object).toBigInteger();
                    if (bigInteger.compareTo(LONG_MAX_VALUE) > 0) {
                        this.truncated_ = bigInteger.toByteArray().length - 8;
                        this.outOfBounds_ = true;
                        this.value_ = Long.MAX_VALUE;
                    } else if (bigInteger.compareTo(LONG_MIN_VALUE) < 0) {
                        this.truncated_ = bigInteger.toByteArray().length - 8;
                        this.outOfBounds_ = true;
                        this.value_ = Long.MIN_VALUE;
                    } else {
                        this.value_ = bigInteger.longValue();
                    }
                }
                catch (NumberFormatException e) {
                    JDError.throwSQLException((Object)this, "07006", e);
                }
            }
        } else if (object instanceof Number) {
            long longValue = ((Number)object).longValue();
            double doubleValue = ((Number)object).doubleValue();
            if (doubleValue > 9.223372036854776E18 || doubleValue > 0.0 && longValue <= 0L) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
                this.value_ = Long.MAX_VALUE;
            } else if (doubleValue < -9.223372036854776E18 || doubleValue < 0.0 && longValue >= 0L) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
                this.value_ = Long.MIN_VALUE;
            } else {
                this.value_ = ((Number)object).longValue();
            }
        } else if (object instanceof Boolean) {
            this.value_ = (Boolean)object == true ? 1L : 0L;
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + String.valueOf(object) + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    @Override
    public int getSQLType() {
        return 1;
    }

    @Override
    public String getJavaClassName() {
        return "java.lang.Long";
    }

    @Override
    public String getCreateParameters() {
        return null;
    }

    @Override
    public int getDisplaySize() {
        return 20;
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "BIGINT";
    }

    @Override
    public int getMaximumPrecision() {
        return 19;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 492;
    }

    @Override
    public int getPrecision() {
        return 19;
    }

    @Override
    public int getRadix() {
        return 10;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return -5;
    }

    @Override
    public String getTypeName() {
        return "BIGINT";
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public int getActualSize() {
        return 8;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (scale <= 0) {
            return BigDecimal.valueOf(this.value_);
        }
        return BigDecimal.valueOf(this.value_).setScale(scale);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_ != 0L;
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.value_ > 127L || this.value_ < -128L) {
            if (this.value_ > 32767L || this.value_ < -32768L) {
                if (this.value_ > Integer.MAX_VALUE || this.value_ < Integer.MIN_VALUE) {
                    this.truncated_ = 7;
                    this.outOfBounds_ = true;
                } else {
                    this.truncated_ = 3;
                    this.outOfBounds_ = true;
                }
            } else {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
        }
        return (byte)this.value_;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public float getFloat() throws SQLException {
        if ((float)this.value_ > Float.MAX_VALUE || (float)this.value_ < -3.4028235E38f) {
            this.truncated_ = 4;
            this.outOfBounds_ = true;
        } else {
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        }
        return this.value_;
    }

    @Override
    public int getInt() throws SQLException {
        if (this.value_ > Integer.MAX_VALUE || this.value_ < Integer.MIN_VALUE) {
            this.truncated_ = 4;
            this.outOfBounds_ = true;
        } else {
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        }
        return (int)this.value_;
    }

    @Override
    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public short getShort() throws SQLException {
        if (this.value_ > 32767L || this.value_ < -32768L) {
            if (this.value_ > Integer.MAX_VALUE || this.value_ < Integer.MIN_VALUE) {
                this.truncated_ = 6;
                this.outOfBounds_ = true;
            } else {
                this.truncated_ = 2;
                this.outOfBounds_ = true;
            }
        }
        return (short)this.value_;
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return Long.toString(this.value_);
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return Long.toString(this.value_);
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

