/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.Trace;

class ProgramCallCancelThread
extends Thread {
    static final String copyright = "Copyright (C) 1996-2011 International Business Machines Corporation and others.";
    protected ProgramCall programCall_;

    public ProgramCallCancelThread(ProgramCall s) {
        this.programCall_ = s;
    }

    @Override
    public void run() {
        boolean traceOn;
        block11: {
            traceOn = JDTrace.isTraceOn();
            if (traceOn) {
                Trace.log(3, "run()");
            }
            try {
                if (this.programCall_ != null) {
                    ProgramCallCancelThread.sleep(this.programCall_.getTimeout() * 1000);
                    traceOn = Trace.traceOn_;
                    if (this.programCall_ != null && this.programCall_.isRunning()) {
                        if (traceOn) {
                            Trace.log(3, "NOTE:  ProgramCallCancelThread is cancelling a program call by user request.");
                        }
                        this.programCall_.cancel();
                    } else if (traceOn) {
                        Trace.log(3, "Doing nothing since program not running");
                    }
                } else if (traceOn) {
                    Trace.log(3, "Doing nothing since program is null");
                }
            }
            catch (Exception e) {
                if (!traceOn) break block11;
                Trace.log(3, "Exception " + String.valueOf(e) + " caught");
            }
        }
        if (traceOn) {
            Trace.log(3, "Thread done");
        }
    }
}

