/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.PermissionAccess;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QSYSPermission;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;

class PermissionAccessQSYS
extends PermissionAccess {
    public PermissionAccessQSYS(AS400 system) {
        super(system);
    }

    @Override
    public void addUser(String objName, UserPermission permission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall addUser = PermissionAccessQSYS.getAddCommand(this.as400_, objName, permission);
        if (!addUser.run()) {
            AS400Message[] msgList = addUser.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    protected final String expandQuotes(String objName) {
        return PermissionAccessQSYS.expandQuotes0(objName);
    }

    static String expandQuotes0(String objName) {
        StringBuilder buf = new StringBuilder(objName);
        buf.insert(0, '\'');
        buf.append('\'');
        if (objName.indexOf(34) != -1) {
            buf.insert(0, "''");
            buf.append("''");
        }
        return buf.toString();
    }

    private static CommandCall getAddCommand(AS400 sys, String objName, UserPermission permission) {
        String object;
        String userProfile;
        QSYSPermission qsysPermission;
        boolean isAuthList;
        block3: {
            QSYSObjectPathName objectPathName = new QSYSObjectPathName(objName);
            String objectType = objectPathName.getObjectType();
            isAuthList = objectType.equals("AUTL");
            if (!isAuthList) {
                return PermissionAccessQSYS.getChgCommand(sys, objName, permission);
            }
            qsysPermission = (QSYSPermission)permission;
            userProfile = qsysPermission.getUserID();
            object = objectPathName.getObjectName();
            try {
                object = CharConverter.convertIFSQSYSPathnameToJobPathname(object, sys.getCcsid());
            }
            catch (Exception e) {
                if (!Trace.traceOn_) break block3;
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)e);
            }
        }
        String command = "ADDAUTLE AUTL(" + object + ") USER(" + userProfile + ") AUT(" + qsysPermission.getAuthorities(isAuthList) + ")";
        CommandCall cmd = new CommandCall(sys, command);
        return cmd;
    }

    private static CommandCall getClrCommand(AS400 sys, String objName, UserPermission permission) {
        String command;
        String objectType;
        Object object;
        String userProfile;
        QSYSObjectPathName objectPathName;
        block9: {
            objectPathName = new QSYSObjectPathName(objName);
            QSYSPermission qsysPermission = (QSYSPermission)permission;
            userProfile = qsysPermission.getUserID();
            object = objectPathName.getObjectName();
            objectType = objectPathName.getObjectType();
            boolean isAuthList = objectType.equals("AUTL");
            if (((String)object).equals("")) {
                object = objectPathName.getLibraryName();
            } else if (!isAuthList) {
                object = objectPathName.getLibraryName() + "/" + (String)object;
            }
            if (objectType.equalsIgnoreCase("MBR")) {
                objectType = "FILE";
            }
            try {
                object = CharConverter.convertIFSQSYSPathnameToJobPathname((String)object, sys.getCcsid());
            }
            catch (Exception e) {
                if (!Trace.traceOn_) break block9;
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)e);
            }
        }
        if (objectType.equals("AUTL")) {
            command = "CHGAUTLE AUTL(" + (String)object + ") USER(" + userProfile + ") AUT(*EXCLUDE)";
        } else {
            Object aspParm = "";
            String aspName = objectPathName.getAspName();
            if (!aspName.equals("")) {
                aspParm = " ASPDEV(" + aspName + ")";
            }
            command = "GRTOBJAUT OBJ(" + (String)object + ") OBJTYPE(*" + objectType + ") USER(" + userProfile + ")" + (String)aspParm + " AUT(*EXCLUDE)";
        }
        CommandCall cmd = new CommandCall(sys, command);
        return cmd;
    }

    private static CommandCall getChgCommand(AS400 sys, String objName, UserPermission permission) {
        String command;
        boolean isAuthList;
        String objectType;
        Object object;
        String userProfile;
        QSYSPermission qsysPermission;
        QSYSObjectPathName objectPathName;
        block9: {
            objectPathName = new QSYSObjectPathName(objName);
            qsysPermission = (QSYSPermission)permission;
            userProfile = qsysPermission.getUserID();
            object = objectPathName.getObjectName();
            objectType = objectPathName.getObjectType();
            isAuthList = objectType.equals("AUTL");
            if (((String)object).equals("")) {
                object = "QSYS/" + objectPathName.getLibraryName();
            } else if (!isAuthList) {
                object = objectPathName.getLibraryName() + "/" + (String)object;
            }
            if (objectType.equalsIgnoreCase("MBR")) {
                objectType = "FILE";
            }
            try {
                object = CharConverter.convertIFSQSYSPathnameToJobPathname((String)object, sys.getCcsid());
            }
            catch (Exception e) {
                if (!Trace.traceOn_) break block9;
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)e);
            }
        }
        if (objectType.equals("AUTL")) {
            command = "CHGAUTLE AUTL(" + (String)object + ") USER(" + userProfile + ") AUT(" + qsysPermission.getAuthorities(isAuthList) + ")";
        } else {
            Object aspParm = "";
            String aspName = objectPathName.getAspName();
            if (!aspName.equals("")) {
                aspParm = " ASPDEV(" + aspName + ")";
            }
            command = "GRTOBJAUT OBJ(" + (String)object + ") OBJTYPE(*" + objectType + ") USER(" + userProfile + ")" + (String)aspParm + " AUT(" + qsysPermission.getAuthorities(isAuthList) + ") REPLACE(*YES)";
        }
        CommandCall cmd = new CommandCall(sys, command);
        return cmd;
    }

    private static CommandCall getRmvCommand(AS400 sys, String objName, String userName, boolean followSymbolicLinks) {
        String command;
        QSYSObjectPathName objectPathName;
        String objectType;
        String name = PermissionAccessQSYS.toUpperCasePath(objName);
        String asp = null;
        int locationOfQSYS = name.toUpperCase().indexOf("/QSYS.LIB");
        if (locationOfQSYS > 0) {
            asp = objName.substring(0, locationOfQSYS);
            objName = objName.substring(locationOfQSYS);
        }
        if ((objectType = (objectPathName = new QSYSObjectPathName(objName)).getObjectType()).equals("AUTL")) {
            String object;
            block11: {
                object = objectPathName.getObjectName();
                try {
                    object = CharConverter.convertIFSQSYSPathnameToJobPathname(object, sys.getCcsid());
                }
                catch (Exception e) {
                    if (!Trace.traceOn_) break block11;
                    Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)e);
                }
            }
            command = "RMVAUTLE AUTL(" + object + ") USER(" + userName + ")";
        } else if (objectType.equals("MBR")) {
            Object object = asp != null ? asp + "/QSYS.LIB/" : "/QSYS.LIB/";
            if (!objectPathName.getLibraryName().equals("")) {
                object = (String)object + objectPathName.getLibraryName() + ".LIB/";
            }
            object = (String)object + objectPathName.getObjectName() + ".FILE";
            command = "CHGAUT OBJ(" + PermissionAccessQSYS.expandQuotes0((String)object) + ") USER(" + userName + ") DTAAUT(*NONE) OBJAUT(*NONE)";
            if (!followSymbolicLinks) {
                command = command + " SYMLNK(*YES)";
            }
        } else {
            Object localName = objName;
            if (asp != null) {
                localName = asp + (String)localName;
            }
            command = "CHGAUT OBJ(" + PermissionAccessQSYS.expandQuotes0((String)localName) + ") USER(" + userName + ") DTAAUT(*NONE) OBJAUT(*NONE)";
            if (!followSymbolicLinks) {
                command = command + " SYMLNK(*YES)";
            }
        }
        CommandCall cmd = new CommandCall(sys, command);
        return cmd;
    }

    @Override
    public UserPermission getUserPermission(Record userRecord) throws UnsupportedEncodingException {
        String profileName = ((String)userRecord.getField("profileName")).trim();
        String userOrGroup = ((String)userRecord.getField("userOrGroup")).trim();
        String dataAuthority = ((String)userRecord.getField("dataAuthority")).trim();
        String autListMgt = ((String)userRecord.getField("autListMgt")).trim();
        String objMgt = ((String)userRecord.getField("objMgt")).trim();
        String objExistence = ((String)userRecord.getField("objExistence")).trim();
        String objAlter = ((String)userRecord.getField("objAlter")).trim();
        String objRef = ((String)userRecord.getField("objRef")).trim();
        String objOperational = ((String)userRecord.getField("objOperational")).trim();
        String dataRead = ((String)userRecord.getField("dataRead")).trim();
        String dataAdd = ((String)userRecord.getField("dataAdd")).trim();
        String dataUpdate = ((String)userRecord.getField("dataUpdate")).trim();
        String dataDelete = ((String)userRecord.getField("dataDelete")).trim();
        String dataExecute = ((String)userRecord.getField("dataExecute")).trim();
        String reserved2 = ((String)userRecord.getField("reserved2")).trim();
        QSYSPermission permission = new QSYSPermission(profileName);
        permission.setGroupIndicator(this.getIntValue(userOrGroup));
        permission.setAuthorizationListManagement(this.getBooleanValue(autListMgt));
        permission.setManagement(this.getBooleanValue(objMgt));
        permission.setExistence(this.getBooleanValue(objExistence));
        permission.setAlter(this.getBooleanValue(objAlter));
        permission.setReference(this.getBooleanValue(objRef));
        permission.setOperational(this.getBooleanValue(objOperational));
        permission.setRead(this.getBooleanValue(dataRead));
        permission.setAdd(this.getBooleanValue(dataAdd));
        permission.setUpdate(this.getBooleanValue(dataUpdate));
        permission.setDelete(this.getBooleanValue(dataDelete));
        permission.setExecute(this.getBooleanValue(dataExecute));
        if (dataAuthority.equalsIgnoreCase("*AUTL")) {
            permission.setFromAuthorizationList(true);
        }
        return permission;
    }

    @Override
    public void removeUser(String objName, String userName) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall removeUser = PermissionAccessQSYS.getRmvCommand(this.as400_, objName, userName, this.followSymbolicLinks_);
        if (!removeUser.run()) {
            AS400Message[] msgList = removeUser.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setAuthority(String objName, UserPermission permission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall setAuthority = PermissionAccessQSYS.getChgCommand(this.as400_, objName, permission);
        if (!setAuthority.run()) {
            AS400Message[] msgList = setAuthority.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setAuthorizationList(String objName, String autList, String oldValue) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall setAUTL;
        String objectType;
        Object object;
        QSYSObjectPathName objectPathName;
        block5: {
            objectPathName = new QSYSObjectPathName(objName);
            object = objectPathName.getObjectName();
            object = ((String)object).equals("") ? "QSYS/" + objectPathName.getLibraryName() : objectPathName.getLibraryName() + "/" + (String)object;
            objectType = objectPathName.getObjectType();
            if (objectType.trim().equalsIgnoreCase("MBR")) {
                objectType = "FILE";
            }
            setAUTL = new CommandCall(this.as400_);
            try {
                object = CharConverter.convertIFSQSYSPathnameToJobPathname((String)object, this.as400_.getCcsid());
            }
            catch (Exception e) {
                if (!Trace.traceOn_) break block5;
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)e);
            }
        }
        Object aspParm = "";
        String aspName = objectPathName.getAspName();
        if (!aspName.equals("")) {
            aspParm = " ASPDEV(" + aspName + ")";
        }
        String cmd = !oldValue.equalsIgnoreCase("*NONE") && autList.equalsIgnoreCase("*NONE") ? "RVKOBJAUT OBJ(" + (String)object + ") OBJTYPE(*" + objectType + ")" + (String)aspParm + " AUTL(" + oldValue + ")" : "GRTOBJAUT OBJ(" + (String)object + ") OBJTYPE(*" + objectType + ")" + (String)aspParm + " AUTL(" + autList + ")";
        setAUTL.setCommand(cmd);
        if (!setAUTL.run()) {
            AS400Message[] msgList = setAUTL.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setFromAuthorizationList(String objName, boolean fromAutl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall fromAUTL;
        String objectType;
        Object object;
        QSYSObjectPathName objectPathName;
        block5: {
            objectPathName = new QSYSObjectPathName(objName);
            object = objectPathName.getObjectName();
            object = ((String)object).equals("") ? "QSYS/" + objectPathName.getLibraryName() : objectPathName.getLibraryName() + "/" + (String)object;
            objectType = objectPathName.getObjectType();
            if (objectType.equalsIgnoreCase("MBR")) {
                objectType = "FILE";
            }
            fromAUTL = new CommandCall(this.as400_);
            try {
                object = CharConverter.convertIFSQSYSPathnameToJobPathname((String)object, this.as400_.getCcsid());
            }
            catch (Exception e) {
                if (!Trace.traceOn_) break block5;
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)e);
            }
        }
        Object aspParm = "";
        String aspName = objectPathName.getAspName();
        if (!aspName.equals("")) {
            aspParm = " ASPDEV(" + aspName + ")";
        }
        String cmd = fromAutl ? "GRTOBJAUT OBJ(" + (String)object + ") OBJTYPE(*" + objectType + ") USER(*PUBLIC)" + (String)aspParm + " AUT(*AUTL)" : "GRTOBJAUT OBJ(" + (String)object + ") OBJTYPE(*" + objectType + ") USER(*PUBLIC)" + (String)aspParm + " AUT(*EXCLUDE)";
        fromAUTL.setCommand(cmd);
        if (!fromAUTL.run()) {
            AS400Message[] msgList = fromAUTL.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setSensitivity(String objName, int sensitivityLevel) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
    }
}

