/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NPAttrBin4;
import com.ibm.as400.access.NPAttrFloat;
import com.ibm.as400.access.NPAttrString;
import com.ibm.as400.access.NPAttribute;
import com.ibm.as400.access.NPAttributeIFS;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.util.Enumeration;
import java.util.Hashtable;

abstract class NPCPAttributeValue
extends NPCodePoint {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private Hashtable attrTable_;
    private boolean fDataOutOfDate_;
    private boolean fListOutOfDate_;
    static final String emptyString = "";
    private static final int LEN_ATTR_HEADER = 4;
    private static final int LEN_ATTR_ENTRY = 12;

    NPCPAttributeValue(NPCPAttributeValue cp) {
        super(cp);
        this.fDataOutOfDate_ = cp.fDataOutOfDate_;
        this.fListOutOfDate_ = cp.fListOutOfDate_;
        this.attrTable_ = new Hashtable(41);
        if (this.fDataOutOfDate_) {
            Enumeration list = cp.attrTable_.elements();
            while (list.hasMoreElements()) {
                NPAttribute attr = (NPAttribute)list.nextElement();
                if (attr == null) continue;
                try {
                    this.attrTable_.put(attr.getID(), attr.clone());
                }
                catch (CloneNotSupportedException e) {
                    Trace.log(2, " NPCPAttribributeValue: Error cloning new attribute" + String.valueOf(e));
                    throw new InternalErrorException(e.toString(), 6);
                }
            }
        } else {
            this.fListOutOfDate_ = true;
        }
    }

    NPCPAttributeValue(int ID) {
        super(ID);
        this.fDataOutOfDate_ = false;
        this.fListOutOfDate_ = false;
        this.attrTable_ = new Hashtable(41);
    }

    NPCPAttributeValue(int ID, byte[] data) {
        super(ID, data);
        this.fDataOutOfDate_ = false;
        this.fListOutOfDate_ = true;
        this.attrTable_ = new Hashtable(41);
    }

    @Override
    int getLength() {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        return super.getLength();
    }

    boolean getfListOutOfDate() {
        return this.fListOutOfDate_;
    }

    @Override
    void setDataBuffer(byte[] dataBuffer, int datalen, int offset) {
        this.fListOutOfDate_ = true;
        this.fDataOutOfDate_ = false;
        super.setDataBuffer(dataBuffer, datalen, offset);
    }

    @Override
    byte[] getDataBuffer() {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        return super.getDataBuffer();
    }

    @Override
    byte[] getDataBuffer(int dataLength) {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        this.fListOutOfDate_ = true;
        return super.getDataBuffer(dataLength);
    }

    @Override
    void reset() {
        this.zeroAttrTable();
        this.fListOutOfDate_ = false;
        this.fDataOutOfDate_ = false;
        super.reset();
    }

    void setAttrValue(int attrID, String value) {
        if (!NPAttribute.idIsValid(attrID)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attrID), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if (attrID < 0) {
            NPAttributeIFS ifsAttr = NPAttributeIFS.ifsAttrs[Math.abs(attrID) - 1];
            if (value.startsWith("*")) {
                this.attrTable_.put(ifsAttr.nameID_, new NPAttrString(ifsAttr.nameID_, value));
            } else {
                QSYSObjectPathName ifsPath = null;
                ifsPath = ifsAttr.typeID_ != 0 ? new QSYSObjectPathName(value) : new QSYSObjectPathName(value, ifsAttr.typeString_);
                this.attrTable_.put(ifsAttr.nameID_, new NPAttrString(ifsAttr.nameID_, ifsPath.getObjectName()));
                this.attrTable_.put(ifsAttr.libraryID_, new NPAttrString(ifsAttr.libraryID_, ifsPath.getLibraryName()));
                if (ifsAttr.typeID_ != 0) {
                    Object strType = "*";
                    strType = (String)strType + ifsPath.getObjectType();
                    this.attrTable_.put(ifsAttr.typeID_, new NPAttrString(ifsAttr.typeID_, (String)strType));
                }
            }
        } else {
            this.attrTable_.put(attrID, new NPAttrString(attrID, value));
        }
        this.fDataOutOfDate_ = true;
    }

    String getStringValue(int attrID) {
        boolean fRC = false;
        String rcString = null;
        if (!NPAttribute.idIsValid(attrID)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attrID), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if (attrID < 0) {
            String name = null;
            String lib = null;
            String type = null;
            NPAttributeIFS ifsAttr = NPAttributeIFS.ifsAttrs[Math.abs(attrID) - 1];
            Object attr = this.attrTable_.get(ifsAttr.nameID_);
            if (attr != null) {
                name = ((NPAttrString)attr).get();
            }
            if (name != null && (attr = this.attrTable_.get(ifsAttr.libraryID_)) != null && 0 == (lib = ((NPAttrString)attr).get()).compareTo(emptyString)) {
                lib = "          ";
            }
            if (ifsAttr.typeID_ != 0) {
                attr = this.attrTable_.get(ifsAttr.typeID_);
                if (attr != null && (type = ((NPAttrString)attr).get()) != null && type.startsWith("*")) {
                    type = type.substring(1, type.length());
                }
            } else {
                type = ifsAttr.typeString_;
            }
            if (name != null) {
                rcString = name.startsWith("*") ? name : QSYSObjectPathName.toPath(lib, name, type);
            }
        } else {
            Object attr = this.attrTable_.get(attrID);
            if (attr != null) {
                if (attr instanceof NPAttrString) {
                    NPAttrString attrString = (NPAttrString)attr;
                    rcString = attrString.get();
                } else {
                    throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attrID), 7);
                }
            }
        }
        return rcString;
    }

    void setAttrValue(int attrID, int value) {
        if (!NPAttribute.idIsValid(attrID)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attrID), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        this.attrTable_.put(attrID, new NPAttrBin4(attrID, value));
        this.fDataOutOfDate_ = true;
    }

    Integer getIntValue(int attrID) {
        Object attr;
        boolean fRC = false;
        Integer rcInt = null;
        if (!NPAttribute.idIsValid(attrID)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attrID), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if ((attr = this.attrTable_.get(attrID)) != null) {
            if (attr instanceof NPAttrBin4) {
                NPAttrBin4 attrBin4 = (NPAttrBin4)attr;
                rcInt = attrBin4.get();
            } else {
                throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attrID), 7);
            }
        }
        return rcInt;
    }

    void setAttrValue(int attrID, float value) {
        if (!NPAttribute.idIsValid(attrID)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attrID), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        this.attrTable_.put(attrID, new NPAttrFloat(attrID, value));
        this.fDataOutOfDate_ = true;
    }

    Float getFloatValue(int attrID) {
        Object attr;
        boolean fRC = false;
        Float rcFloat = null;
        if (!NPAttribute.idIsValid(attrID)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attrID), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if ((attr = this.attrTable_.get(attrID)) != null) {
            if (attr instanceof NPAttrFloat) {
                NPAttrFloat attrFloat = (NPAttrFloat)attr;
                rcFloat = Float.valueOf(attrFloat.get());
            } else {
                throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attrID), 7);
            }
        }
        return rcFloat;
    }

    void addUpdateAttributes(NPCPAttributeValue cp) {
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if (cp.fListOutOfDate_) {
            cp.updateList();
        }
        Enumeration e = cp.attrTable_.elements();
        while (e.hasMoreElements()) {
            NPAttribute attr = (NPAttribute)e.nextElement();
            if (attr == null) continue;
            this.attrTable_.put(attr.getID(), attr);
        }
        this.fDataOutOfDate_ = true;
    }

    void removeAttribute(int attrID) {
        if (!NPAttribute.idIsValid(attrID)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attrID), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if (attrID < 0) {
            NPAttributeIFS ifsAttr = NPAttributeIFS.ifsAttrs[Math.abs(attrID) - 1];
            this.attrTable_.remove(ifsAttr.nameID_);
            this.attrTable_.remove(ifsAttr.libraryID_);
            if (ifsAttr.typeID_ != 0) {
                this.attrTable_.remove(ifsAttr.typeID_);
            }
        } else {
            this.attrTable_.remove(attrID);
        }
    }

    private void updateData() {
        NPAttribute attr;
        int elements = 0;
        int dataLength = 4;
        Enumeration e = this.attrTable_.elements();
        while (e.hasMoreElements()) {
            attr = (NPAttribute)e.nextElement();
            if (attr == null) continue;
            dataLength += 12;
            dataLength += attr.getHostLength(this.converter_);
            ++elements;
        }
        byte[] data = super.getDataBuffer(dataLength);
        int dataOffset = super.getOffset();
        BinaryConverter.unsignedShortToByteArray(elements, data, dataOffset);
        BinaryConverter.unsignedShortToByteArray(12, data, dataOffset += 2);
        int valueOffset = (dataOffset += 2) + 12 * elements;
        e = this.attrTable_.elements();
        while (e.hasMoreElements() && elements != 0) {
            attr = (NPAttribute)e.nextElement();
            if (attr == null) continue;
            BinaryConverter.unsignedShortToByteArray(attr.getID(), data, dataOffset);
            BinaryConverter.unsignedShortToByteArray(attr.getType(), data, dataOffset += 2);
            BinaryConverter.intToByteArray(attr.getHostLength(this.converter_), data, dataOffset += 2);
            BinaryConverter.intToByteArray(valueOffset + 6, data, dataOffset += 4);
            dataOffset += 4;
            System.arraycopy(attr.getHostData(this.converter_), 0, data, valueOffset, attr.getHostLength(this.converter_));
            valueOffset += attr.getHostLength(this.converter_);
            --elements;
        }
        this.fDataOutOfDate_ = false;
    }

    private void updateList() {
        byte nullbyte = 0;
        NPAttribute attr = null;
        this.zeroAttrTable();
        byte[] data = super.getDataBuffer();
        if (data != null && data.length >= 4) {
            long dataLength = super.getDataLength();
            int offset = super.getOffset();
            if (dataLength > 4L) {
                short size;
                int elements = BinaryConverter.byteArrayToShort(data, offset);
                offset += 2;
                if (elements != 0 && (size = BinaryConverter.byteArrayToShort(data, offset)) >= 12 && dataLength >= (long)((offset += 2) + elements * size)) {
                    while (elements != 0) {
                        short ID = BinaryConverter.byteArrayToShort(data, offset);
                        short type = BinaryConverter.byteArrayToShort(data, offset += 2);
                        int length = BinaryConverter.byteArrayToInt(data, offset += 2);
                        int valueOffset = BinaryConverter.byteArrayToInt(data, offset += 4);
                        offset += 4;
                        valueOffset -= 6;
                        switch (type) {
                            case 3: 
                            case 4: {
                                attr = new NPAttrBin4(ID, data, valueOffset, length);
                                break;
                            }
                            case 5: 
                            case 6: {
                                attr = new NPAttrString(ID, data, valueOffset, length, this.converter_);
                                break;
                            }
                            case 7: {
                                attr = new NPAttrFloat(ID, data, valueOffset, length);
                                break;
                            }
                            case 9: {
                                for (int i = 0; i < length; ++i) {
                                    if (data[i + valueOffset] != nullbyte || i >= length - 1 || data[i + valueOffset + 1] == nullbyte) continue;
                                    data[i + valueOffset] = 122;
                                }
                                attr = new NPAttrString(ID, data, valueOffset, length, this.converter_);
                                break;
                            }
                        }
                        this.attrTable_.put(Integer.valueOf(ID), attr);
                        --elements;
                        offset += size - 12;
                    }
                }
            }
        }
        this.fListOutOfDate_ = false;
    }

    private void zeroAttrTable() {
        this.attrTable_.clear();
    }
}

