/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MessageFile
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final DateFormat YYYYMMDD_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final int NO_FORMATTING = 0;
    public static final int RETURN_FORMATTING_CHARACTERS = 1;
    public static final int SUBSTITUTE_FORMATTING_CHARACTERS = 2;
    public static final int CCSID_OF_JOB = 0;
    private int helpTextFormatting_ = 0;
    private AS400 system_ = null;
    private String path_ = "";
    private String library_ = null;
    private String name_ = null;
    private transient boolean connected_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private String previousMessageId_ = null;
    public static final String NEXT = "*NEXT";
    public static final String FIRST = "*FIRST";
    private static final byte[] OPTION_MSGID = new byte[]{92, -44, -30, -57, -55, -60, 64, 64, 64, 64};
    private static final byte[] OPTION_NEXT = new byte[]{92, -43, -59, -25, -29, 64, 64, 64, 64, 64};
    private static final byte[] OPTION_FIRST = new byte[]{92, -58, -55, -39, -30, -29, 64, 64, 64, 64};

    public MessageFile() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageFile object.");
        }
    }

    public MessageFile(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageFile object, system: " + String.valueOf(system));
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    public MessageFile(AS400 system, String path) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageFile object, system: " + String.valueOf(system) + " path: " + path);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(path, "MSGF");
        this.library_ = ifs.getLibraryName();
        this.name_ = ifs.getObjectName();
        this.path_ = path;
        this.system_ = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        MessageFile messageFile = this;
        synchronized (messageFile) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        MessageFile messageFile = this;
        synchronized (messageFile) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    public static String substituteFormattingCharacters(String sourceText) {
        return MessageFile.substituteFormattingCharacters(sourceText, false);
    }

    private static String substituteFormattingCharacters(String sourceText, boolean bidi) {
        String targetText = sourceText;
        targetText = MessageFile.replaceText(targetText, "&N", "\n");
        targetText = MessageFile.replaceText(targetText, "&P", "\n      ");
        targetText = MessageFile.replaceText(targetText, "&B", "\n    ");
        if (bidi) {
            targetText = MessageFile.replaceText(targetText, "N&", "\n");
            targetText = MessageFile.replaceText(targetText, "P&", "\n      ");
            targetText = MessageFile.replaceText(targetText, "B&", "\n    ");
        }
        return targetText;
    }

    public int getHelpTextFormatting() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting help text formatting:", this.helpTextFormatting_);
        }
        return this.helpTextFormatting_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting path: " + this.path_);
        }
        return this.path_;
    }

    public AS400Message getMessage(String ID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + ID);
        }
        return this.getMessage(ID, null, 0, 0, 0);
    }

    public AS400Message getMessage(String ID, int type) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + ID + ", type:", type);
        }
        return this.getMessage(ID, null, type, 0, 0);
    }

    public AS400Message getMessage(String ID, String substitutionText) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + ID + ", substitutionText: " + substitutionText);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (AS400BidiTransform.isBidiCcsid(this.system_.getCcsid())) {
            return this.getMessage(ID, substitutionText, AS400BidiTransform.getStringType(this.system_.getCcsid()));
        }
        return this.getMessage(ID, substitutionText, 0);
    }

    public AS400Message getMessage(String ID, String substitutionText, int type) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + ID + ", substitutionText: " + substitutionText + ", type:", type);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        return this.getMessage(ID, substitutionText != null ? new Converter(this.system_.getCcsid(), this.system_).stringToByteArray(substitutionText, type) : null, type, 0, 0);
    }

    public AS400Message getMessage(String ID, byte[] substitutionText) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + ID + ", substitutionText:", substitutionText);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (AS400BidiTransform.isBidiCcsid(this.system_.getCcsid())) {
            return this.getMessage(ID, substitutionText, AS400BidiTransform.getStringType(this.system_.getCcsid()));
        }
        return this.getMessage(ID, substitutionText, 0, 0, 0);
    }

    public AS400Message getMessage(String ID, byte[] substitutionText, int type) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + ID + ", type:" + type + ", substitutionText:", substitutionText);
        }
        return this.getMessage(ID, substitutionText, type, 0, 0);
    }

    public AS400Message getMessage(String ID, byte[] substitutionText, int type, int ccsidOfSubstitutionText, int ccsidToConvertTo) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException {
        int ccsidOfTextBytes;
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message from message file, ID: " + ID + ", type:" + type + ", ccsidOfSubstitutionText:" + ccsidOfSubstitutionText + ", substitutionText:", substitutionText);
        }
        if (ID == null) {
            Trace.log(2, "Parameter 'ID' is null.");
            throw new NullPointerException("ID");
        }
        if (ID.length() > 7) {
            Trace.log(2, "Length of parameter 'ID' is not valid: '" + ID + "'");
            throw new ExtendedIllegalArgumentException("ID (" + ID + ")", 1);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.path_.length() == 0) {
            Trace.log(2, "Cannot connect to server before setting path.");
            throw new ExtendedIllegalStateException("path", 4);
        }
        this.connected_ = true;
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        byte[] nameBytes = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        conv.stringToByteArray(this.name_, nameBytes, 0, 10, type);
        conv.stringToByteArray(this.library_, nameBytes, 10, 10, type);
        byte[] optionBytes = OPTION_MSGID;
        if (ID.equals(FIRST)) {
            optionBytes = OPTION_FIRST;
            ID = "";
        } else if (ID.equals(NEXT)) {
            if (this.previousMessageId_ == null) {
                optionBytes = OPTION_FIRST;
                ID = "";
            } else {
                optionBytes = OPTION_NEXT;
                ID = this.previousMessageId_;
            }
        }
        byte[] idBytes = new byte[]{64, 64, 64, 64, 64, 64, 64};
        conv.stringToByteArray(ID, idBytes, 0, 7);
        if (substitutionText == null) {
            substitutionText = new byte[]{};
        }
        byte[] starNoBytes = new byte[]{92, -43, -42, 64, 64, 64, 64, 64, 64, 64};
        byte[] starYesBytes = new byte[]{92, -24, -59, -30, 64, 64, 64, 64, 64, 64};
        byte[] replace = substitutionText.length == 0 ? starNoBytes : starYesBytes;
        byte[] format = this.helpTextFormatting_ == 0 ? starNoBytes : starYesBytes;
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(5120), new ProgramParameter(new byte[]{0, 0, 20, 0}), new ProgramParameter(new byte[]{-39, -29, -27, -44, -16, -12, -16, -16}), new ProgramParameter(idBytes), new ProgramParameter(nameBytes), new ProgramParameter(substitutionText), new ProgramParameter(BinaryConverter.intToByteArray(substitutionText.length)), new ProgramParameter(replace), new ProgramParameter(format), new ProgramParameter(new byte[8]), new ProgramParameter(optionBytes), new ProgramParameter(BinaryConverter.intToByteArray(ccsidToConvertTo)), new ProgramParameter(BinaryConverter.intToByteArray(ccsidOfSubstitutionText))};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QMHRTVM.PGM", parameters);
        pc.suggestThreadsafe();
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList()[0]);
        }
        if (ccsidToConvertTo == 0) {
            ccsidOfTextBytes = this.system_.getCcsid();
        } else {
            ccsidOfTextBytes = ccsidToConvertTo;
            conv = new Converter(ccsidOfTextBytes, this.system_);
        }
        byte[] messageInformation = parameters[0].getOutputData();
        ID = conv.byteArrayToString(messageInformation, 26, 7, type).trim();
        AS400Message msg = null;
        if (ID.length() > 0) {
            msg = new AS400Message();
            msg.setID(ID);
            msg.setSeverity(BinaryConverter.byteArrayToInt(messageInformation, 8));
            String _createDate = conv.byteArrayToString(messageInformation, 200, 7, 0);
            String _modificationDate = conv.byteArrayToString(messageInformation, 212, 7, 0);
            Date createDate = this.convertDate(_createDate);
            Date modificationDate = this.convertDate(_modificationDate);
            msg.setCreateDate(createDate);
            msg.setModificationDate(modificationDate);
            int defaultReplyOffset = BinaryConverter.byteArrayToInt(messageInformation, 52);
            int defaultReplyLength = BinaryConverter.byteArrayToInt(messageInformation, 56);
            int messageOffset = BinaryConverter.byteArrayToInt(messageInformation, 64);
            int messageLength = BinaryConverter.byteArrayToInt(messageInformation, 68);
            int helpOffset = BinaryConverter.byteArrayToInt(messageInformation, 76);
            int helpLength = BinaryConverter.byteArrayToInt(messageInformation, 80);
            msg.setDefaultReply(conv.byteArrayToString(messageInformation, defaultReplyOffset, defaultReplyLength, type));
            msg.setText(conv.byteArrayToString(messageInformation, messageOffset, messageLength, type));
            String helpText = conv.byteArrayToString(messageInformation, helpOffset, helpLength, type);
            if (this.helpTextFormatting_ == 2) {
                helpText = MessageFile.substituteFormattingCharacters(helpText, AS400BidiTransform.isBidiCcsid(ccsidOfTextBytes));
            }
            msg.setHelp(helpText);
            this.previousMessageId_ = ID;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date convertDate(String input) {
        Date output = null;
        String centuryAddedDate = (input.charAt(0) == '0' ? "19" : "20") + input.substring(1);
        try {
            DateFormat dateFormat = YYYYMMDD_FORMAT;
            synchronized (dateFormat) {
                output = YYYYMMDD_FORMAT.parse(centuryAddedDate);
            }
        }
        catch (ParseException e) {
            if (Trace.traceOn_) {
                Trace.log(2, "Invalid date " + input);
            }
            throw new IllegalArgumentException(e.toString());
        }
        return output;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + String.valueOf(this.system_));
        }
        return this.system_;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    private static String replaceText(String s, String oldPhrase, String newPhrase) {
        int index = ((String)s).indexOf(oldPhrase);
        while (index >= 0) {
            if (index == 0) {
                s = newPhrase + ((String)s).substring(3);
            } else {
                StringBuilder b = new StringBuilder(((String)s).substring(0, index));
                b.append(newPhrase);
                b.append(((String)s).substring(index + 2));
                s = b.toString();
            }
            index = ((String)s).indexOf(oldPhrase);
        }
        return s;
    }

    public void setHelpTextFormatting(int helpTextFormatting) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting help text formatting:", helpTextFormatting);
        }
        if (helpTextFormatting < 0 || helpTextFormatting > 2) {
            Trace.log(2, "Value of parameter 'helpTextFormatting' is not valid: " + helpTextFormatting);
            throw new ExtendedIllegalArgumentException("helpTextFormatting (" + helpTextFormatting + ")", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.helpTextFormatting_ = helpTextFormatting;
        } else {
            Integer oldValue = this.helpTextFormatting_;
            Integer newValue = helpTextFormatting;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("helpTextFormatting", oldValue, newValue);
            }
            this.helpTextFormatting_ = helpTextFormatting;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("helpTextFormatting", oldValue, newValue);
            }
        }
    }

    public void setPath(String path) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting path: " + path);
        }
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException("path", 5);
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(path, "MSGF");
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.library_ = ifs.getLibraryName();
            this.name_ = ifs.getObjectName();
            this.path_ = path;
        } else {
            String oldValue = this.path_;
            String newValue = path;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("path", oldValue, newValue);
            }
            this.library_ = ifs.getLibraryName();
            this.name_ = ifs.getObjectName();
            this.path_ = path;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("path", oldValue, newValue);
            }
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + String.valueOf(system));
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = system;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }
}

