/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.QueuedMessageEnumeration;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class JobLog
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final int maxMessageLength_ = 511;
    private static final int maxMessageHelpLength_ = 3000;
    private static final int qgygtleHeaderLength_ = 81;
    private AS400 system_;
    private String name_ = "*";
    private String user_ = "";
    private String number_ = "";
    private int length_;
    private byte[] handle_;
    private boolean closeHandle_ = false;
    private boolean listDirection_ = true;
    private byte[] startingMessageKey_;
    private Vector numberOfFieldIdentifiers_ = new Vector();
    public static final int ALERT_OPTION = 101;
    public static final int REPLACEMENT_DATA = 201;
    public static final int MESSAGE = 301;
    public static final int MESSAGE_WITH_REPLACEMENT_DATA = 302;
    public static final int MESSAGE_HELP = 401;
    public static final int MESSAGE_HELP_WITH_REPLACEMENT_DATA = 402;
    public static final int MESSAGE_HELP_WITH_FORMATTING_CHARACTERS = 403;
    public static final int MESSAGE_HELP_WITH_REPLACEMENT_DATA_AND_FORMATTING_CHARACTERS = 404;
    public static final int DEFAULT_REPLY = 501;
    public static final int SENDER_TYPE = 602;
    public static final int SENDING_PROGRAM_NAME = 603;
    public static final int SENDING_MODULE_NAME = 604;
    public static final int SENDING_PROCEDURE_NAME = 605;
    public static final int SENDING_STATEMENT_NUMBERS = 606;
    public static final int SENDING_USER_PROFILE = 607;
    public static final int RECEIVING_TYPE = 702;
    public static final int RECEIVING_PROGRAM_NAME = 703;
    public static final int RECEIVING_MODULE_NAME = 704;
    public static final int RECEIVING_PROCEDURE_NAME = 705;
    public static final int RECEIVING_STATEMENT_NUMBERS = 706;
    public static final int MESSAGE_FILE_LIBRARY_USED = 801;
    public static final int REPLY_STATUS = 1001;
    public static final int REQUEST_STATUS = 1101;
    public static final int REQUEST_LEVEL = 1201;
    public static final int CCSID_FOR_TEXT = 1301;
    public static final int CCSID_CONVERSION_STATUS_TEXT = 1302;
    public static final int CCSID_FOR_DATA = 1303;
    public static final int CCSID_CONVERSION_STATUS_DATA = 1304;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private static final byte[] typeCompletion_ = new byte[]{92, -61, -42, -44, -41, 64, 64, 64, 64, 64};
    private static final byte[] typeDiagnostic_ = new byte[]{92, -60, -55, -63, -57, 64, 64, 64, 64, 64};
    private static final byte[] typeEscape_ = new byte[]{92, -59, -30, -61, -63, -41, -59, 64, 64, 64};
    private static final byte[] typeInformational_ = new byte[]{92, -55, -43, -58, -42, 64, 64, 64, 64, 64};
    private static final byte[] callStackEntry_ = new byte[]{92, 64, 64, 64, 64, 64, 64, 64, 64, 64};

    public JobLog() {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding default list information: REPLY_STATUS, SENDING_PROGRAM_NAME, DEFAULT_REPLY, MESSAGE_HELP_WITH_REPLACEMENT_DATA_AND_FORMATTING_CHARACTERS, MESSAGE_WITH_REPLACEMENT_DATA, ALERT_OPTION ");
        }
        this.addDefaultListInformation();
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobLog object.");
        }
    }

    public JobLog(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobLog object, system: " + String.valueOf(system));
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Adding default list information: REPLY_STATUS, SENDING_PROGRAM_NAME, DEFAULT_REPLY, MESSAGE_HELP_WITH_REPLACEMENT_DATA_AND_FORMATTING_CHARACTERS, MESSAGE_WITH_REPLACEMENT_DATA, ALERT_OPTION ");
        }
        this.addDefaultListInformation();
        this.system_ = system;
    }

    public JobLog(AS400 system, String name, String user, String number) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobLog object, system: " + String.valueOf(system) + ", name: " + name + ", user: " + user + ", number: " + number);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (user == null) {
            Trace.log(2, "Parameter 'user' is null.");
            throw new NullPointerException("user");
        }
        if (number == null) {
            Trace.log(2, "Parameter 'number' is null.");
            throw new NullPointerException("number");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Adding default list information: REPLY_STATUS, SENDING_PROGRAM_NAME, DEFAULT_REPLY, MESSAGE_HELP_WITH_REPLACEMENT_DATA_AND_FORMATTING_CHARACTERS, MESSAGE_WITH_REPLACEMENT_DATA, ALERT_OPTION ");
        }
        this.addDefaultListInformation();
        this.system_ = system;
        this.name_ = name;
        this.user_ = user;
        this.number_ = number;
    }

    public void addAttributeToRetrieve(int attribute) throws IOException {
        if (!this.numberOfFieldIdentifiers_.contains(attribute)) {
            switch (attribute) {
                case 1001: {
                    this.numberOfFieldIdentifiers_.add(1001);
                    break;
                }
                case 603: {
                    this.numberOfFieldIdentifiers_.add(603);
                    break;
                }
                case 501: {
                    this.numberOfFieldIdentifiers_.add(501);
                    break;
                }
                case 404: {
                    this.numberOfFieldIdentifiers_.add(404);
                    break;
                }
                case 302: {
                    this.numberOfFieldIdentifiers_.add(302);
                    break;
                }
                case 101: {
                    this.numberOfFieldIdentifiers_.add(101);
                    break;
                }
                case 201: {
                    this.numberOfFieldIdentifiers_.add(201);
                    break;
                }
                case 301: {
                    this.numberOfFieldIdentifiers_.add(301);
                    break;
                }
                case 401: {
                    this.numberOfFieldIdentifiers_.add(401);
                    break;
                }
                case 402: {
                    this.numberOfFieldIdentifiers_.add(402);
                    break;
                }
                case 403: {
                    this.numberOfFieldIdentifiers_.add(403);
                    break;
                }
                case 602: {
                    this.numberOfFieldIdentifiers_.add(602);
                    break;
                }
                case 604: {
                    this.numberOfFieldIdentifiers_.add(604);
                    break;
                }
                case 605: {
                    this.numberOfFieldIdentifiers_.add(605);
                    break;
                }
                case 606: {
                    this.numberOfFieldIdentifiers_.add(606);
                    break;
                }
                case 607: {
                    this.numberOfFieldIdentifiers_.add(607);
                    break;
                }
                case 702: {
                    this.numberOfFieldIdentifiers_.add(702);
                    break;
                }
                case 703: {
                    this.numberOfFieldIdentifiers_.add(703);
                    break;
                }
                case 704: {
                    this.numberOfFieldIdentifiers_.add(704);
                    break;
                }
                case 705: {
                    this.numberOfFieldIdentifiers_.add(705);
                    break;
                }
                case 706: {
                    this.numberOfFieldIdentifiers_.add(706);
                    break;
                }
                case 801: {
                    this.numberOfFieldIdentifiers_.add(801);
                    break;
                }
                case 1101: {
                    this.numberOfFieldIdentifiers_.add(1101);
                    break;
                }
                case 1201: {
                    this.numberOfFieldIdentifiers_.add(1201);
                    break;
                }
                case 1301: {
                    this.numberOfFieldIdentifiers_.add(1301);
                    break;
                }
                case 1302: {
                    this.numberOfFieldIdentifiers_.add(1302);
                    break;
                }
                case 1303: {
                    this.numberOfFieldIdentifiers_.add(1303);
                    break;
                }
                case 1304: {
                    this.numberOfFieldIdentifiers_.add(1304);
                    break;
                }
                default: {
                    Trace.log(2, "Value of parameter 'attribute' is not valid: " + attribute);
                    throw new ExtendedIllegalArgumentException("attribute", 2);
                }
            }
        }
    }

    public void clearAttributesToRetrieve() {
        this.numberOfFieldIdentifiers_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing job log message list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        try {
            ListUtilities.closeList(this.system_, this.handle_);
        }
        finally {
            this.handle_ = null;
            this.closeHandle_ = false;
        }
    }

    public int getLength() {
        block5: {
            if (Trace.traceOn_) {
                Trace.log(1, "Getting job log list length.");
            }
            try {
                if (this.handle_ == null || this.closeHandle_) {
                    this.load();
                }
            }
            catch (Exception e) {
                Trace.log(2, "Exception caught getting length of job log list:", (Throwable)e);
                if (!(e instanceof ExtendedIllegalStateException)) break block5;
                throw (ExtendedIllegalStateException)e;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public boolean getListDirection() {
        return this.listDirection_;
    }

    public Enumeration<QueuedMessage> getMessages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving job log message list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        return new QueuedMessageEnumeration(this, this.length_);
    }

    public QueuedMessage[] getMessages(int listOffset, int number) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving job log message list, list offset: " + listOffset + ", number:", number);
        }
        if (listOffset < -1) {
            throw new ExtendedIllegalArgumentException("listOffset (" + listOffset + ")", 4);
        }
        if (number < 0 && listOffset != -1) {
            throw new ExtendedIllegalArgumentException("number (" + number + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (this.length_ == 0 || number == 0 && listOffset != -1) {
            return new QueuedMessage[0];
        }
        if (listOffset == -1) {
            number = this.length_;
            listOffset = 0;
        } else {
            if (listOffset >= this.length_) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Value of parameter 'listOffset' is beyond end of list:", listOffset + " (list length: " + this.length_ + ")");
                }
                return new QueuedMessage[0];
            }
            if (listOffset + number > this.length_) {
                number = this.length_ - listOffset;
            }
        }
        int lengthOfReceiverVariable = 1024 * number;
        byte[] data = ListUtilities.retrieveListEntries(this.system_, this.handle_, lengthOfReceiverVariable, number, listOffset, null);
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        QueuedMessage[] messages = new QueuedMessage[number];
        int offset = 0;
        for (int i = 0; i < messages.length; ++i) {
            int entryOffset = BinaryConverter.byteArrayToInt(data, offset);
            int fieldOffset = BinaryConverter.byteArrayToInt(data, offset + 4);
            int numFields = BinaryConverter.byteArrayToInt(data, offset + 8);
            int messageSeverity = BinaryConverter.byteArrayToInt(data, offset + 12);
            String messageIdentifier = conv.byteArrayToString(data, offset + 16, 7).trim();
            int messageType = (data[offset + 23] & 0xF) * 10 + (data[offset + 24] & 0xF);
            if (messageType == 0) {
                messageType = -1;
            }
            byte[] messageKey = new byte[4];
            System.arraycopy(data, offset + 25, messageKey, 0, 4);
            String messageFileName = conv.byteArrayToString(data, offset + 29, 10).trim();
            String messageFileLibrarySpecified = conv.byteArrayToString(data, offset + 39, 10).trim();
            String dateSent = conv.byteArrayToString(data, offset + 49, 7);
            String timeSent = conv.byteArrayToString(data, offset + 56, 6);
            messages[i] = new QueuedMessage(this.system_, messageSeverity, messageIdentifier, messageType, messageKey, messageFileName, messageFileLibrarySpecified, dateSent, timeSent);
            for (int j = 0; j < numFields; ++j) {
                int offsetToNextField = BinaryConverter.byteArrayToInt(data, fieldOffset);
                int fieldID = BinaryConverter.byteArrayToInt(data, fieldOffset + 8);
                byte type = data[fieldOffset + 12];
                int dataLen = BinaryConverter.byteArrayToInt(data, fieldOffset + 28);
                if (type == -61) {
                    if (fieldID == 201) {
                        byte[] substitutionData = new byte[dataLen];
                        System.arraycopy(data, fieldOffset + 32, substitutionData, 0, dataLen);
                        messages[i].setValueInternal(fieldID, substitutionData);
                    } else {
                        messages[i].setValueInternal(fieldID, conv.byteArrayToString(data, fieldOffset + 32, dataLen));
                    }
                } else if (type == -62) {
                    if (dataLen > 4) {
                        messages[i].setAsLong(fieldID, BinaryConverter.byteArrayToLong(data, fieldOffset + 32));
                    } else {
                        messages[i].setAsInt(fieldID, BinaryConverter.byteArrayToInt(data, fieldOffset + 32));
                    }
                } else {
                    int numStatements = BinaryConverter.byteArrayToInt(data, fieldOffset + 32);
                    String[] statements = new String[numStatements];
                    for (int k = 0; k < numStatements; ++k) {
                        statements[k] = conv.byteArrayToString(data, fieldOffset + 36 + k * 10, 10);
                    }
                    messages[i].setValueInternal(fieldID, statements);
                }
                fieldOffset = offsetToNextField;
            }
            offset = entryOffset;
        }
        return messages;
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting name: " + this.name_);
        }
        return this.name_;
    }

    public String getNumber() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting number: " + this.number_);
        }
        return this.number_;
    }

    public byte[] getStartingMessageKey() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting starting message key:", this.startingMessageKey_);
        }
        return this.startingMessageKey_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + String.valueOf(this.system_));
        }
        return this.system_;
    }

    public String getUser() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user: " + this.user_);
        }
        return this.user_;
    }

    public synchronized void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Loading job log message list.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (!this.name_.equals("*")) {
            if (this.user_.equals("")) {
                Trace.log(2, "Cannot connect to server before setting user.");
                throw new ExtendedIllegalStateException("user", 4);
            }
            if (this.number_.equals("")) {
                Trace.log(2, "Cannot connect to server before setting number.");
                throw new ExtendedIllegalStateException("number", 4);
            }
        }
        if (this.closeHandle_) {
            this.close();
        }
        byte[] messageSelectionInformation = this.listInformationArray();
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(messageSelectionInformation), new ProgramParameter(BinaryConverter.intToByteArray(messageSelectionInformation.length)), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QGYOLJBL.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] listInformation = parameters[2].getOutputData();
        this.handle_ = new byte[4];
        System.arraycopy(listInformation, 8, this.handle_, 0, 4);
        listInformation = ListUtilities.waitForListToComplete(this.system_, this.handle_, listInformation);
        this.length_ = BinaryConverter.byteArrayToInt(listInformation, 0);
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded job log message list, length: " + this.length_ + ", handle: ", this.handle_);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListDirection(boolean listDirection) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting list direction: " + listDirection);
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            this.listDirection_ = listDirection;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting name: " + name);
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobLog jobLog = this;
            synchronized (jobLog) {
                this.name_ = name;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String oldValue = this.name_;
        String newValue = name;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("name", oldValue, newValue);
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            this.name_ = name;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("name", oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumber(String number) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting number: " + number);
        }
        if (number == null) {
            Trace.log(2, "Parameter 'number' is null.");
            throw new NullPointerException("number");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobLog jobLog = this;
            synchronized (jobLog) {
                this.number_ = number;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String oldValue = this.number_;
        String newValue = number;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("number", oldValue, newValue);
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            this.number_ = number;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("number", oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartingMessageKey(byte[] startingMessageKey) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting starting message key:", startingMessageKey);
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            this.startingMessageKey_ = startingMessageKey;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + String.valueOf(system));
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.handle_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = system;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUser(String user) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user: " + user);
        }
        if (user == null) {
            Trace.log(2, "Parameter 'user' is null.");
            throw new NullPointerException("user");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobLog jobLog = this;
            synchronized (jobLog) {
                this.user_ = user;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String oldValue = this.user_;
        String newValue = user;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("user", oldValue, newValue);
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            this.user_ = user;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("user", oldValue, newValue);
        }
    }

    public static void writeMessage(AS400 system, String messageID, int messageType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Writing message to job log, system: " + String.valueOf(system) + ", message ID: " + messageID + ", message type:", messageType);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (messageID == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        switch (messageType) {
            case 1: 
            case 2: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'messageType' is not valid: " + messageType);
                throw new ExtendedIllegalArgumentException("messageType (" + messageType + ")", 2);
            }
        }
        JobLog.sendProgramMessage(system, messageID, "/QSYS.LIB/QCPFMSG.MSGF", null, messageType, false);
    }

    public static void writeMessage(AS400 system, String messageID, int messageType, byte[] substitutionData) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Writing message to job log, system: " + String.valueOf(system) + ", message ID: " + messageID + ", message type: " + messageType + ", substitution data:", substitutionData);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (messageID == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        switch (messageType) {
            case 1: 
            case 2: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'messageType' is not valid: " + messageType);
                throw new ExtendedIllegalArgumentException("messageType (" + messageType + ")", 2);
            }
        }
        JobLog.sendProgramMessage(system, messageID, "/QSYS.LIB/QCPFMSG.MSGF", substitutionData, messageType, false);
    }

    public static void writeMessage(AS400 system, String messageID, int messageType, String messageFile) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (messageID == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        switch (messageType) {
            case 1: 
            case 2: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'messageType' is not valid: " + messageType);
                throw new ExtendedIllegalArgumentException("messageType (" + messageType + ")", 2);
            }
        }
        if (messageFile == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        QSYSObjectPathName.validatePath(messageFile, "MSGF");
        JobLog.sendProgramMessage(system, messageID, messageFile, null, messageType, false);
    }

    public static void writeMessage(AS400 system, String messageID, int messageType, String messageFile, byte[] substitutionData) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (messageID == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        switch (messageType) {
            case 1: 
            case 2: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'messageType' is not valid: " + messageType);
                throw new ExtendedIllegalArgumentException("messageType (" + messageType + ")", 2);
            }
        }
        if (messageFile == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        QSYSObjectPathName.validatePath(messageFile, "MSGF");
        JobLog.sendProgramMessage(system, messageID, messageFile, substitutionData, messageType, false);
    }

    public static void writeMessage(AS400 system, String messageID, int messageType, String messageFile, byte[] substitutionData, boolean onThread) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (messageID == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        switch (messageType) {
            case 1: 
            case 2: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'messageType' is not valid: " + messageType);
                throw new ExtendedIllegalArgumentException("messageType (" + messageType + ")", 2);
            }
        }
        if (messageFile == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        QSYSObjectPathName.validatePath(messageFile, "MSGF");
        JobLog.sendProgramMessage(system, messageID, messageFile, substitutionData, messageType, onThread);
    }

    private void addDefaultListInformation() {
        this.numberOfFieldIdentifiers_.add(1001);
        this.numberOfFieldIdentifiers_.add(603);
        this.numberOfFieldIdentifiers_.add(501);
        this.numberOfFieldIdentifiers_.add(404);
        this.numberOfFieldIdentifiers_.add(302);
        this.numberOfFieldIdentifiers_.add(101);
    }

    private byte[] listInformationArray() throws IOException {
        byte[] messageSelectionInformation = new byte[81 + this.numberOfFieldIdentifiers_.size() * 4];
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        if (this.listDirection_) {
            System.arraycopy(new byte[]{92, -43, -59, -25, -29}, 0, messageSelectionInformation, 0, 5);
        } else {
            System.arraycopy(new byte[]{92, -41, -39, -27, 64}, 0, messageSelectionInformation, 0, 5);
        }
        for (int i = 5; i < 52; ++i) {
            messageSelectionInformation[i] = 64;
        }
        conv.stringToByteArray(this.name_.toUpperCase().trim(), messageSelectionInformation, 10);
        conv.stringToByteArray(this.user_.toUpperCase().trim(), messageSelectionInformation, 20);
        conv.stringToByteArray(this.number_, messageSelectionInformation, 30);
        byte[] startingMessageKey = this.startingMessageKey_ != null ? this.startingMessageKey_ : (this.listDirection_ ? MessageQueue.OLDEST : MessageQueue.NEWEST);
        System.arraycopy(startingMessageKey, 0, messageSelectionInformation, 52, 4);
        BinaryConverter.intToByteArray(511, messageSelectionInformation, 56);
        BinaryConverter.intToByteArray(3000, messageSelectionInformation, 60);
        BinaryConverter.intToByteArray(80, messageSelectionInformation, 64);
        BinaryConverter.intToByteArray(this.numberOfFieldIdentifiers_.size(), messageSelectionInformation, 68);
        BinaryConverter.intToByteArray(81 + this.numberOfFieldIdentifiers_.size() * 4 - 1, messageSelectionInformation, 72);
        BinaryConverter.intToByteArray(1, messageSelectionInformation, 76);
        Enumeration fields = this.numberOfFieldIdentifiers_.elements();
        int offset = 80;
        while (fields.hasMoreElements()) {
            BinaryConverter.intToByteArray((Integer)fields.nextElement(), messageSelectionInformation, offset);
            offset += 4;
        }
        messageSelectionInformation[80 + this.numberOfFieldIdentifiers_.size() * 4] = 92;
        return messageSelectionInformation;
    }

    private static void sendProgramMessage(AS400 system, String messageID, String messageFile, byte[] replacementData, int messageType, boolean onThread) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Converter conv = new Converter(system.getCcsid(), system);
        byte[] messageIdentifier = new byte[]{64, 64, 64, 64, 64, 64, 64};
        conv.stringToByteArray(messageID, messageIdentifier, 0, 7);
        byte[] qualifiedMessageFileName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        QSYSObjectPathName path = new QSYSObjectPathName(messageFile);
        conv.stringToByteArray(path.getObjectName(), qualifiedMessageFileName, 0, 10);
        conv.stringToByteArray(path.getLibraryName(), qualifiedMessageFileName, 10, 10);
        if (replacementData == null) {
            replacementData = new byte[]{};
        }
        byte[] type = null;
        switch (messageType) {
            case 1: {
                type = typeCompletion_;
                break;
            }
            case 2: {
                type = typeDiagnostic_;
                break;
            }
            case 15: {
                type = typeEscape_;
                break;
            }
            case 4: {
                type = typeInformational_;
                break;
            }
        }
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(messageIdentifier), new ProgramParameter(qualifiedMessageFileName), new ProgramParameter(replacementData), new ProgramParameter(BinaryConverter.intToByteArray(replacementData.length)), new ProgramParameter(type), new ProgramParameter(callStackEntry_), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(4), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(system, "/QSYS.LIB/QMHSNDPM.PGM", parameters);
        if (onThread) {
            pc.setThreadSafe(true);
        }
        if (!pc.run()) {
            AS400Message[] msgs = pc.getMessageList();
            if (msgs.length == 1 && msgs[0].getID().equals(messageID) && msgs[0].getType() == messageType) {
                if (Trace.traceOn_) {
                    Trace.log(3, "The expected escape message is ignored.");
                }
                return;
            }
            throw new AS400Exception(msgs);
        }
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for job log invoked.");
        }
        if (this.handle_ != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

