/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;

public class JavaProgram
implements Serializable {
    static final long serialVersionUID = -209990140140936884L;
    private boolean loaded_ = false;
    private AS400 system_;
    private String path_;
    private String fileOwner_;
    private Date fileChangeDate_;
    private Date javaProgramCreationDate_;
    private int numberOfAttachedPrograms_;
    private int numberOfClassesWithJavaPrograms_;
    private int numberOfClassesWithoutPrograms_;
    private int numberOfClassesWithErrors_;
    private int numberOfClasses_;
    private int optimizationLevel_;
    private String performanceCollectionEnabledFlag_;
    private String performanceCollectionType_;
    private boolean useAdoptedAuthority_;
    private String adoptedAuthorityProfile_;
    private int sizeOfAttachedPrograms_;
    private String javaProgramVersion_;
    private String profilingDataStatus_;
    private String LICoptions_;
    public static final String ADOPTED_AUTHORITY_PROFILE_USER = "*USER";
    public static final String ADOPTED_AUTHORITY_PROFILE_OWNER = "*OWNER";
    public static final String PERFORMANCE_COLLECTION_TYPE_ENTRYEXIT = "*ENTRYEXIT";
    public static final String PERFORMANCE_COLLECTION_TYPE_FULL = "*FULL";
    public static final String PROFILING_DATA_STATUS_NOCOL = "*NOCOL";
    public static final String PROFILING_DATA_STATUS_COL = "*COL";
    public static final String PROFILING_DATA_STATUS_APY = "*APY";

    public JavaProgram() {
    }

    public JavaProgram(AS400 system, String path) {
        this.setSystem(system);
        this.setPath(path);
    }

    private void checkVRM() throws UnsupportedOperationException {
        try {
            if (this.getSystem() != null && this.getSystem().getVRM() > 459008) {
                Trace.log(2, "JavaProgram is not supported beyond IBM i 7.1.");
                throw new UnsupportedOperationException("JavaProgram");
            }
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when checking system VRM.", (Throwable)e);
            }
            throw new UnsupportedOperationException(e);
        }
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getAdoptedAuthorityProfile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        if (this.adoptedAuthorityProfile_.equals("0")) {
            return ADOPTED_AUTHORITY_PROFILE_USER;
        }
        return ADOPTED_AUTHORITY_PROFILE_OWNER;
    }

    public Date getFileChangeDate() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return (Date)this.fileChangeDate_.clone();
    }

    public String getFileOwner() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.fileOwner_;
    }

    public Date getJavaProgramCreationDate() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return (Date)this.javaProgramCreationDate_.clone();
    }

    public String getJavaProgramVersion() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.javaProgramVersion_;
    }

    public int getNumberOfClasses() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.numberOfClasses_;
    }

    public int getNumberOfClassesWithCurrentJavaPrograms() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.numberOfClassesWithJavaPrograms_;
    }

    public int getNumberOfClassesWithErrors() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.numberOfClassesWithErrors_;
    }

    public int getNumberOfClassesWithoutCurrentJavaPrograms() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.numberOfClassesWithoutPrograms_;
    }

    public int getNumberOfAttachedPrograms() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.numberOfAttachedPrograms_;
    }

    public int getOptimizationLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.optimizationLevel_;
    }

    public String getPerformanceCollectionEnabledFlag() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.performanceCollectionEnabledFlag_;
    }

    public String getPerformanceCollectionType() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        if (this.performanceCollectionType_.equals("0")) {
            return PERFORMANCE_COLLECTION_TYPE_ENTRYEXIT;
        }
        return PERFORMANCE_COLLECTION_TYPE_FULL;
    }

    public boolean isUseAdoptedAuthority() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.useAdoptedAuthority_;
    }

    public int getSizeOfAttachedJavaPrograms() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.sizeOfAttachedPrograms_;
    }

    public String getProfilingDataStatus() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        if (this.profilingDataStatus_.equals("0")) {
            return PROFILING_DATA_STATUS_NOCOL;
        }
        if (this.profilingDataStatus_.equals("1")) {
            return PROFILING_DATA_STATUS_COL;
        }
        return PROFILING_DATA_STATUS_APY;
    }

    public String getLICOptions() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.LICoptions_;
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException {
        Calendar cal;
        this.checkVRM();
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        int len = 4096;
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(len), new ProgramParameter(BinaryConverter.intToByteArray(len)), new ProgramParameter(conv.stringToByteArray("RJPI0100")), new ProgramParameter(0), new ProgramParameter(BinaryConverter.intToByteArray(0)), new ProgramParameter(conv.stringToByteArray("RJPC0100")), new ProgramParameter(conv.stringToByteArray(this.path_)), new ProgramParameter(BinaryConverter.intToByteArray(this.path_.length())), new ProgramParameter(conv.stringToByteArray(" ")), new ProgramParameter(BinaryConverter.intToByteArray(0)), new ProgramParameter(0), new ProgramParameter(BinaryConverter.intToByteArray(0)), new ProgramParameter(BinaryConverter.intToByteArray(1)), new ProgramParameter(conv.stringToByteArray("*PGM")), new ProgramParameter(BinaryConverter.intToByteArray(0))};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QJVAMAT.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] output = parms[0].getOutputData();
        this.fileOwner_ = conv.byteArrayToString(output, 8, 10);
        String d = conv.byteArrayToString(output, 18, 13);
        if (d.trim().length() == 13) {
            cal = AS400Calendar.getGregorianInstance();
            cal.clear();
            cal.set(Integer.parseInt(d.substring(0, 3)) + 1900, Integer.parseInt(d.substring(3, 5)) - 1, Integer.parseInt(d.substring(5, 7)), Integer.parseInt(d.substring(7, 9)), Integer.parseInt(d.substring(9, 11)), Integer.parseInt(d.substring(11, 13)));
            this.fileChangeDate_ = cal.getTime();
        } else {
            this.fileChangeDate_ = null;
        }
        d = conv.byteArrayToString(output, 31, 13);
        if (d.trim().length() == 13) {
            cal = AS400Calendar.getGregorianInstance();
            cal.clear();
            cal.set(Integer.parseInt(d.substring(0, 3)) + 1900, Integer.parseInt(d.substring(3, 5)) - 1, Integer.parseInt(d.substring(5, 7)), Integer.parseInt(d.substring(7, 9)), Integer.parseInt(d.substring(9, 11)), Integer.parseInt(d.substring(11, 13)));
            this.javaProgramCreationDate_ = cal.getTime();
        } else {
            this.javaProgramCreationDate_ = null;
        }
        this.numberOfAttachedPrograms_ = BinaryConverter.byteArrayToInt(output, 44);
        this.numberOfClassesWithJavaPrograms_ = BinaryConverter.byteArrayToInt(output, 48);
        this.numberOfClassesWithoutPrograms_ = BinaryConverter.byteArrayToInt(output, 52);
        this.numberOfClassesWithErrors_ = BinaryConverter.byteArrayToInt(output, 56);
        this.numberOfClasses_ = BinaryConverter.byteArrayToInt(output, 60);
        this.optimizationLevel_ = BinaryConverter.byteArrayToInt(output, 64);
        this.performanceCollectionEnabledFlag_ = conv.byteArrayToString(output, 68, 1);
        this.performanceCollectionType_ = conv.byteArrayToString(output, 69, 1);
        String useAdopAuthority = conv.byteArrayToString(output, 70, 1);
        this.adoptedAuthorityProfile_ = conv.byteArrayToString(output, 71, 1);
        this.sizeOfAttachedPrograms_ = BinaryConverter.byteArrayToInt(output, 72);
        String version = Integer.toString((output[76] & 0xFF) + 256, 16).substring(1);
        String release = Integer.toString((output[77] & 0xFF) + 256, 16).substring(1);
        this.javaProgramVersion_ = this.getVersion((version + release).toCharArray());
        this.profilingDataStatus_ = Byte.toString(output[78]);
        int offsetToLICOptions = BinaryConverter.byteArrayToInt(output, 80);
        int lengthOfLIC = BinaryConverter.byteArrayToInt(output, 84);
        int lengthOfAvailableLIC = BinaryConverter.byteArrayToInt(output, 88);
        this.LICoptions_ = conv.byteArrayToString(output, offsetToLICOptions, lengthOfLIC);
        this.useAdoptedAuthority_ = !useAdopAuthority.equals("0");
        this.loaded_ = true;
    }

    private String getVersion(char[] version) {
        Object v = "V";
        Object r = "R";
        Object m = "M";
        if (version[0] != '0') {
            v = (String)v + version[0];
        }
        v = (String)v + version[1];
        r = (String)r + version[2];
        m = (String)m + version[3];
        return (String)v + (String)r + (String)m;
    }

    public void setSystem(AS400 system) {
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    public void setPath(String path) {
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path_ = path;
    }
}

