/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDUtilities;

final class JDSearchPattern {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final String ESCAPE_CHAR_ = "\\";
    private String patternString_;

    JDSearchPattern(String patternString) {
        this.patternString_ = patternString != null ? patternString.trim() : null;
    }

    final boolean containsEscape() {
        return this.patternString_ != null ? this.patternString_.indexOf(ESCAPE_CHAR_) != -1 : false;
    }

    final boolean containsSearchPattern() {
        return this.patternString_ != null ? this.patternString_.indexOf(37) != -1 || this.patternString_.indexOf(95) != -1 : false;
    }

    static final String getEscape() {
        return ESCAPE_CHAR_;
    }

    final int getIndicator() {
        int indicator = this.containsSearchPattern() || this.containsEscape() ? 241 : 240;
        return indicator;
    }

    final String getPatternString() {
        return this.patternString_;
    }

    final String getSQLWhereClause(String columnName) {
        StringBuilder clause = new StringBuilder();
        if (this.isSpecified()) {
            clause.append(columnName);
            clause.append(" ");
            if (this.containsSearchPattern()) {
                clause.append("LIKE  '");
                clause.append(JDSearchPattern.unquote(this.patternString_));
                clause.append("' ");
                if (this.containsEscape()) {
                    clause.append("ESCAPE '");
                    clause.append(ESCAPE_CHAR_);
                    clause.append("' ");
                }
            } else {
                clause.append("=  '");
                clause.append(JDSearchPattern.unquote(this.patternString_));
                clause.append("' ");
            }
        }
        return clause.toString();
    }

    final boolean isSpecified() {
        return this.patternString_ != null;
    }

    private static final String unquote(String name) {
        return JDUtilities.prepareForSingleQuotes(name, false);
    }
}

