/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.JDTrace;

class AS400JDBCQueryCancelThread
extends Thread {
    static final String copyright = "Copyright (C) 1996-2011 International Business Machines Corporation and others.";
    protected AS400JDBCStatement statement_;

    public AS400JDBCQueryCancelThread(AS400JDBCStatement s) {
        this.statement_ = s;
    }

    @Override
    public void run() {
        boolean traceOn;
        block11: {
            traceOn = JDTrace.isTraceOn();
            if (traceOn) {
                JDTrace.logInformation(this, "run()");
            }
            try {
                if (this.statement_ != null) {
                    int queryTimeout = this.statement_.getInternalQueryTimeout();
                    AS400JDBCQueryCancelThread.sleep(queryTimeout * 1000);
                    traceOn = JDTrace.isTraceOn();
                    if (this.statement_ != null && this.statement_.isQueryRunning()) {
                        if (traceOn) {
                            JDTrace.logInformation(this, "NOTE:  AS400JDBCQueryCancelThread is cancelling a statement by user request.");
                        }
                        this.statement_.cancel();
                    } else if (traceOn) {
                        JDTrace.logInformation(this, "Doing nothing since query not running");
                    }
                } else if (traceOn) {
                    JDTrace.logInformation(this, "Doing nothing since statement is null");
                }
            }
            catch (Exception e) {
                if (!traceOn) break block11;
                JDTrace.logInformation(this, "Exception " + String.valueOf(e) + " caught");
            }
        }
        if (traceOn) {
            JDTrace.logInformation(this, "Thread done");
        }
    }
}

