/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;

public class AS400DateTimeConverter {
    protected AS400 as400_;

    public AS400DateTimeConverter(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = system;
    }

    public static byte[] convert(AS400 system, byte[] in, String inFormat, String outFormat) {
        byte[] out = null;
        if (Trace.isTraceInformationOn()) {
            Trace.log(3, "convert");
            StringBuffer inStringBuffer = new StringBuffer();
            Trace.printByteArray(inStringBuffer, in);
            Trace.log(3, "input parameters : " + inStringBuffer.toString() + " | " + inFormat + " | " + outFormat);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        ProgramCall pgm = new ProgramCall(system);
        try {
            String progName = "/QSYS.LIB/QWCCVTDT.PGM";
            AS400Text text10 = new AS400Text(10);
            ProgramParameter[] parmlist = new ProgramParameter[5];
            parmlist[0] = new ProgramParameter(text10.toBytes(inFormat));
            parmlist[1] = new ProgramParameter(in);
            parmlist[2] = new ProgramParameter(text10.toBytes(outFormat));
            parmlist[3] = new ProgramParameter(17);
            byte[] errorCode = new byte[70];
            parmlist[4] = new ProgramParameter(errorCode);
            pgm.setProgram(progName, parmlist);
            pgm.suggestThreadsafe();
            if (!pgm.run()) {
                Trace.log(2, "program failed!");
                AS400Message[] messagelist = pgm.getMessageList();
                for (int i = 0; i < messagelist.length; ++i) {
                }
                throw new AS400Exception(messagelist);
            }
            out = parmlist[3].getOutputData();
        }
        catch (Exception e) {
            Trace.log(2, "convert failed : " + String.valueOf(e));
        }
        if (Trace.isTraceInformationOn()) {
            Trace.log(3, "convert");
            StringBuffer outStringBuffer = new StringBuffer();
            Trace.printByteArray(outStringBuffer, out);
            Trace.log(3, "output value : " + outStringBuffer.toString());
        }
        return out;
    }

    public static Date getDate(AS400 as400, byte[] in, String format) {
        Trace.log(3, "getDate");
        String outFormat = "*YYMD";
        byte[] out = AS400DateTimeConverter.convert(as400, in, format, outFormat);
        RecordFormat recordFormat = new RecordFormat();
        CharacterFieldDescription[] cfd = new CharacterFieldDescription[]{new CharacterFieldDescription(new AS400Text(4), "year"), new CharacterFieldDescription(new AS400Text(2), "month"), new CharacterFieldDescription(new AS400Text(2), "day"), new CharacterFieldDescription(new AS400Text(2), "hour"), new CharacterFieldDescription(new AS400Text(2), "minute"), new CharacterFieldDescription(new AS400Text(2), "second"), new CharacterFieldDescription(new AS400Text(3), "millisecond")};
        for (int i = 0; i < 7; ++i) {
            recordFormat.addFieldDescription(cfd[i]);
        }
        try {
            Record record = recordFormat.getNewRecord(out);
            Calendar dateTime = AS400Calendar.getGregorianInstance();
            dateTime.clear();
            dateTime.set(Integer.parseInt(((String)record.getField("year")).trim()), Integer.parseInt(((String)record.getField("month")).trim()) - 1, Integer.parseInt(((String)record.getField("day")).trim()), Integer.parseInt(((String)record.getField("hour")).trim()), Integer.parseInt(((String)record.getField("minute")).trim()), Integer.parseInt(((String)record.getField("second")).trim()));
            return dateTime.getTime();
        }
        catch (UnsupportedEncodingException e) {
            Trace.log(3, "convert Date/Time : " + String.valueOf(e));
            return null;
        }
    }

    public static byte[] getByteArray(AS400 as400, Date date, String format) {
        Trace.log(3, "getByteArray");
        Calendar dateTime = AS400Calendar.getGregorianInstance();
        dateTime.setTime(date);
        RecordFormat recordFormat = new RecordFormat();
        CharacterFieldDescription[] cfd = new CharacterFieldDescription[]{new CharacterFieldDescription(new AS400Text(4), "year"), new CharacterFieldDescription(new AS400Text(2), "month"), new CharacterFieldDescription(new AS400Text(2), "day"), new CharacterFieldDescription(new AS400Text(2), "hour"), new CharacterFieldDescription(new AS400Text(2), "minute"), new CharacterFieldDescription(new AS400Text(2), "second"), new CharacterFieldDescription(new AS400Text(3), "millisecond")};
        for (int i = 0; i < 7; ++i) {
            recordFormat.addFieldDescription(cfd[i]);
        }
        Record record = recordFormat.getNewRecord();
        record.setField("year", (Object)Integer.toString(dateTime.get(1)));
        record.setField("month", (Object)Integer.toString(dateTime.get(2) + 1));
        record.setField("day", (Object)Integer.toString(dateTime.get(5)));
        record.setField("hour", (Object)Integer.toString(dateTime.get(11)));
        record.setField("minute", (Object)Integer.toString(dateTime.get(12)));
        record.setField("second", (Object)Integer.toString(dateTime.get(13)));
        record.setField("millisecond", (Object)Integer.toString(dateTime.get(14)));
        byte[] in = null;
        try {
            in = record.getContents();
            AS400Text aS400Text = new AS400Text(17);
        }
        catch (Exception e) {
            Trace.log(2, "Error constructing program parameters");
        }
        String inFormat = "*YYMD";
        return AS400DateTimeConverter.convert(as400, in, inFormat, format);
    }
}

