/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ibmisteps.model;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.IBMiMessage;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;
import org.jenkinsci.plugins.ibmisteps.model.IBMiJob;

public class CallResult
implements Serializable {
    private static final long serialVersionUID = -7184769518123385346L;
    private static final Pattern JOB_PATTERN = Pattern.compile(" (\\d{1,6})/([^/ ]{1,10})/([^/ ]{1,10}) ");
    private final List<IBMiMessage> messages = new ArrayList<IBMiMessage>();
    private final boolean successful;

    public CallResult(IBMi ibmi, boolean successful, AS400Message[] as400Messages) {
        this.successful = successful;
        Stream.of(as400Messages).map(message -> new IBMiMessage(ibmi, (AS400Message)message)).forEach(this.messages::add);
    }

    public IBMiMessage getMessage(String messageId) {
        return this.messages.stream().filter(m -> m.getID().equalsIgnoreCase(messageId)).findFirst().orElse(null);
    }

    public List<IBMiMessage> getMessages() {
        return this.messages;
    }

    @CheckForNull
    public IBMiMessage getLastMessage() {
        return this.messages.isEmpty() ? null : this.messages.get(this.messages.size() - 1);
    }

    public String getPrettyMessages() {
        return this.getPrettyMessages("");
    }

    public String getPrettyMessages(String prefix) {
        return this.messages.stream().map(m -> MessageFormat.format("{0}[{1}][{2}] {3}", prefix, m.getID(), m.getSeverity(), m.getText())).collect(Collectors.joining("\n"));
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public List<IBMiJob> getSubmittedJobs() {
        return this.messages.stream().filter(message -> message.getID().equals("CPC1221")).map(message -> JOB_PATTERN.matcher(message.getText())).filter(Matcher::find).map(matcher -> new IBMiJob(matcher.group(1), matcher.group(2), matcher.group(3))).toList();
    }

    public String toString() {
        return MessageFormat.format("Successful: {0}; Messages: {1}", this.successful, this.getPrettyMessages());
    }
}

