/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Message;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Objects;
import java.util.function.Supplier;
import org.jenkinsci.plugins.ibmisteps.model.IBMi;

public class IBMiMessage
extends AS400Message
implements Serializable {
    private static final long serialVersionUID = 4119612591789660630L;
    private final transient Supplier<String> substitutionDataRetriever;
    private final Calendar date;

    public IBMiMessage(IBMi ibmi, AS400Message as400Message) {
        super(as400Message.getID(), as400Message.getText(), as400Message.getFileName(), as400Message.getLibraryName(), as400Message.getSeverity(), as400Message.getType(), as400Message.getSubstitutionData(), as400Message.getHelp());
        this.setDefaultReply(as400Message.getDefaultReply());
        this.date = as400Message.getDate();
        this.substitutionDataRetriever = () -> ibmi.getCharConverter().byteArrayToString(as400Message.getSubstitutionData());
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getSubstitutionDataAsString() {
        return this.substitutionDataRetriever != null ? this.substitutionDataRetriever.get() : "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof AS400Message)) return false;
        AS400Message m = (AS400Message)o;
        if (!this.checkEquals(this.getID(), m.getID())) return false;
        if (!this.checkEquals(this.getText(), m.getText())) return false;
        if (!this.checkEquals(this.getFileName(), m.getFileName())) return false;
        if (!this.checkEquals(this.getLibraryName(), m.getLibraryName())) return false;
        if (!this.checkEquals(this.getSeverity(), m.getSeverity())) return false;
        if (!this.checkEquals(this.getType(), m.getType())) return false;
        if (!this.checkEquals(this.getHelp(), m.getHelp())) return false;
        if (!this.checkEquals(this.getDate(), m.getDate())) return false;
        if (!this.checkEquals(this.getDefaultReply(), m.getDefaultReply())) return false;
        return true;
    }

    private boolean checkEquals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public int hashCode() {
        return Objects.hash(this.getID(), this.getText(), this.getFileName(), this.getLibraryName(), this.getSeverity(), this.getType(), this.getHelp(), this.getDate(), this.getDefaultReply());
    }
}

