/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.hubot.util;

import com.google.common.annotations.VisibleForTesting;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.thoughtslive.jenkins.plugins.hubot.api.ResponseData;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotSite;
import org.thoughtslive.jenkins.plugins.hubot.service.HubotService;
import org.thoughtslive.jenkins.plugins.hubot.steps.BasicHubotStep;
import org.thoughtslive.jenkins.plugins.hubot.util.Common;

public abstract class HubotAbstractSynchronousNonBlockingStepExecution<T>
extends SynchronousNonBlockingStepExecution<T> {
    private static final long serialVersionUID = -6557391471762434587L;
    protected transient PrintStream logger = null;
    protected transient HubotService hubotService = null;
    protected transient boolean failOnError = true;
    protected transient String room = null;
    protected transient String buildUserName = null;
    protected transient String buildCause = null;
    protected transient String buildUserId = null;
    protected transient EnvVars envVars;
    protected transient HubotSite site = null;
    protected transient Run<?, ?> run;
    protected transient TaskListener listener;
    private String failOnErrorStr = null;
    private String url = null;

    protected HubotAbstractSynchronousNonBlockingStepExecution(StepContext context) throws IOException, InterruptedException {
        super(context);
        this.run = (Run)context.get(Run.class);
        this.listener = (TaskListener)context.get(TaskListener.class);
        this.envVars = (EnvVars)context.get(EnvVars.class);
    }

    protected <T> ResponseData<T> verifyCommon(BasicHubotStep step) {
        this.logger = this.listener.getLogger();
        Object errorMessage = null;
        URL mainURL = null;
        String message = step.getMessage();
        if (Util.fixEmpty((String)message) == null) {
            errorMessage = "Hubot: Message is empty or null.";
        }
        if (errorMessage != null) {
            return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
        }
        this.room = Util.fixEmpty((String)step.getRoom());
        this.url = Util.fixEmpty((String)step.getUrl());
        this.failOnErrorStr = Util.fixEmpty((String)step.getFailOnError());
        if (this.url == null) {
            this.site = HubotSite.get(this.run.getParent(), this.listener, step.getSite());
        }
        if (this.site == null) {
            if (this.url == null) {
                this.url = (String)this.envVars.get((Object)"HUBOT_URL");
            }
            if (this.room == null) {
                this.room = (String)this.envVars.get((Object)"HUBOT_DEFAULT_ROOM");
            }
            if (this.failOnErrorStr == null) {
                this.failOnErrorStr = (String)this.envVars.get((Object)"HUBOT_FAIL_ON_ERROR");
            }
            if (Util.fixEmpty((String)this.url) == null) {
                errorMessage = "Hubot: HUBOT_URL or step parameter equivalent is empty or null.";
            } else {
                try {
                    mainURL = new URL(Common.sanitizeURL(this.url));
                }
                catch (MalformedURLException e) {
                    errorMessage = "Hubot: Malformed HUBOT_URL.";
                }
            }
            if (this.room == null) {
                errorMessage = "Hubot: HUBOT_DEFAULT_ROOM or step parameter equivalent is empty or null.";
            }
            if (this.failOnErrorStr != null) {
                try {
                    this.failOnError = Boolean.parseBoolean(this.failOnErrorStr);
                }
                catch (Exception e) {
                    errorMessage = "Hubot: Unable to parse failOnError.";
                }
            }
        } else {
            if (this.room != null) {
                this.site.setRoom(this.room);
            }
            if (this.failOnErrorStr != null) {
                this.site.setFailOnError(Boolean.parseBoolean(this.failOnErrorStr));
            }
            if (Util.fixEmpty((String)this.site.getUrl().toString()) == null) {
                errorMessage = "Hubot: url is empty or null on site: " + this.site.getName();
            }
            if (Util.fixEmpty((String)this.site.getRoom()) == null) {
                errorMessage = "Hubot: Room is empty or null on site: " + this.site.getName();
            }
            this.room = this.site.getRoom();
            this.failOnError = this.site.isFailOnError();
        }
        if (errorMessage != null) {
            return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
        }
        this.setHubotService(this.site, mainURL, this.room);
        this.buildUserName = Common.prepareBuildUserName(this.run.getCauses(), this.envVars);
        this.buildUserId = Common.prepareBuildUserId(this.run.getCauses(), this.envVars);
        this.buildCause = Common.prepareBuildCause(this.run.getCauses());
        return null;
    }

    @VisibleForTesting
    public void setHubotService(HubotService service) {
        this.hubotService = service;
    }

    private void setHubotService(HubotSite site, URL url, String room) {
        if (site == null) {
            site = HubotSite.builder().url(url).room(room).build();
        }
        if (this.hubotService == null) {
            this.hubotService = new HubotService(site);
        }
    }
}

