/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.hubot.steps;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.hubot.api.Message;
import org.thoughtslive.jenkins.plugins.hubot.api.ResponseData;
import org.thoughtslive.jenkins.plugins.hubot.config.GlobalConfig;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotFolderProperty;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotSite;
import org.thoughtslive.jenkins.plugins.hubot.config.notifications.Type;
import org.thoughtslive.jenkins.plugins.hubot.steps.BasicHubotStep;
import org.thoughtslive.jenkins.plugins.hubot.util.Common;
import org.thoughtslive.jenkins.plugins.hubot.util.HubotAbstractSynchronousNonBlockingStepExecution;

public class SendStep
extends BasicHubotStep {
    private static final long serialVersionUID = 5310947910434533239L;

    @DataBoundConstructor
    public SendStep(String message) {
        this.message = message;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new SendStepExecution(this, context);
    }

    public static class SendStepExecution
    extends HubotAbstractSynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = -7049396675002254309L;
        private final SendStep step;

        protected SendStepExecution(SendStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected Boolean run() throws Exception {
            String status;
            ResponseData<Object> response = this.verifyCommon(this.step);
            String string = status = this.step.getStatus() == null ? Type.SUCCESS.name() : this.step.getStatus();
            if (response == null) {
                if (this.site != null) {
                    this.logger.println("Hubot: Sending " + status + " message to room: " + this.site.getRoom() + " of site: " + this.site.getName());
                } else {
                    this.logger.println("Hubot: ROOM - " + this.room + " - Message - " + this.step.getMessage());
                }
                FilePath ws = (FilePath)this.getContext().get(FilePath.class);
                Map tokens = Common.expandMacros(this.step.getTokens(), this.run, ws, this.listener);
                Message message = Message.builder().message(this.step.getMessage()).userName(this.buildUserName).userId(this.buildUserId).envVars(this.envVars).buildCause(this.buildCause).status(status).tokens(tokens).extraData(this.step.getExtraData()).stepName(Common.STEP.SEND.name()).ts(System.currentTimeMillis()).build();
                response = this.hubotService.sendMessage(message);
            }
            return Common.logResponse(response, this.logger, this.failOnError).isSuccessful();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "hubotSend";
        }

        public String getDisplayName() {
            return "Hubot: Send message";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }

        public ListBoxModel doFillSiteItems(@AncestorInPath Item project) {
            ArrayList<ListBoxModel.Option> hubotSites = new ArrayList<ListBoxModel.Option>();
            hubotSites.add(new ListBoxModel.Option("Optional - Please select, otherwise it will use default site from parent folder(s)/global.", ""));
            Object folderName = null;
            if (project != null) {
                ItemGroup parent = project.getParent();
                while (parent != null) {
                    if (parent instanceof AbstractFolder) {
                        HubotSite[] sites;
                        AbstractFolder folder = (AbstractFolder)parent;
                        folderName = folderName == null ? folder.getName() : folder.getName() + " \u00bb " + (String)folderName;
                        HubotFolderProperty jfp = (HubotFolderProperty)folder.getProperties().get(HubotFolderProperty.class);
                        if (jfp != null && (sites = jfp.getSites()) != null && sites.length > 0) {
                            for (HubotSite site : sites) {
                                hubotSites.add(new ListBoxModel.Option((String)folderName + " - " + site.getName(), site.getName()));
                            }
                        }
                    }
                    if (parent instanceof Item) {
                        parent = ((Item)parent).getParent();
                        continue;
                    }
                    parent = null;
                }
            }
            for (HubotSite site : new GlobalConfig().getSites()) {
                hubotSites.add(new ListBoxModel.Option("Global - " + site.getName(), site.getName()));
            }
            return new ListBoxModel(hubotSites);
        }
    }
}

