/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.hubot.service;

import hudson.Util;
import okhttp3.OkHttpClient;
import org.apache.log4j.Logger;
import org.thoughtslive.jenkins.plugins.hubot.api.Message;
import org.thoughtslive.jenkins.plugins.hubot.api.ResponseData;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotSite;
import org.thoughtslive.jenkins.plugins.hubot.service.HubotEndPoints;
import org.thoughtslive.jenkins.plugins.hubot.util.Common;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class HubotService {
    private static final Logger LOGGER = Logger.getLogger((String)HubotService.class.getName());
    private final HubotEndPoints hubotEndPoints;
    private final HubotSite hubotSite;

    public HubotService(HubotSite hubotSite) {
        OkHttpClient httpClient = new OkHttpClient();
        this.hubotSite = hubotSite;
        this.hubotEndPoints = (HubotEndPoints)new Retrofit.Builder().baseUrl(Common.sanitizeURL(hubotSite.getUrl().toString())).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).client(httpClient).build().create(HubotEndPoints.class);
    }

    public ResponseData<Void> sendMessage(Message message) {
        try {
            Object room = this.hubotSite.isUseFolderName() && Util.fixEmpty((String)this.hubotSite.getRoomPrefix()) != null ? this.hubotSite.getRoomPrefix().trim() + this.hubotSite.getRoom().trim() : this.hubotSite.getRoom().trim();
            return Common.parseResponse(this.hubotEndPoints.sendMessage((String)room, message).execute());
        }
        catch (Exception e) {
            return Common.buildErrorResponse(e);
        }
    }
}

