/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.hubot.config.notifications;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.Serializable;
import jenkins.model.Jenkins;
import lombok.Generated;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.hubot.config.notifications.Type;

public class Config
implements Describable<Config>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8251804333532726515L;
    private final boolean notifyEnabled;
    private final String roomNames;
    private final Type notificationType;
    private final String tokens;

    @DataBoundConstructor
    public Config(boolean notifyEnabled, String roomNames, Type notificationType, String tokens) {
        this.notifyEnabled = notifyEnabled;
        this.roomNames = roomNames;
        this.notificationType = notificationType;
        this.tokens = tokens;
    }

    public Descriptor<Config> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public Config clone() throws CloneNotSupportedException {
        super.clone();
        return Config.builder().notifyEnabled(this.notifyEnabled).roomNames(this.roomNames).notificationType(this.notificationType).tokens(this.tokens).build();
    }

    @Generated
    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    @Generated
    public String toString() {
        return "Config(notifyEnabled=" + this.isNotifyEnabled() + ", roomNames=" + this.getRoomNames() + ", notificationType=" + String.valueOf((Object)this.getNotificationType()) + ", tokens=" + this.getTokens() + ")";
    }

    @Generated
    public boolean isNotifyEnabled() {
        return this.notifyEnabled;
    }

    @Generated
    public String getRoomNames() {
        return this.roomNames;
    }

    @Generated
    public Type getNotificationType() {
        return this.notificationType;
    }

    @Generated
    public String getTokens() {
        return this.tokens;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Config> {
        public String getDisplayName() {
            return "Hubot Notification";
        }
    }

    @Generated
    public static class ConfigBuilder {
        @Generated
        private boolean notifyEnabled;
        @Generated
        private String roomNames;
        @Generated
        private Type notificationType;
        @Generated
        private String tokens;

        @Generated
        ConfigBuilder() {
        }

        @Generated
        public ConfigBuilder notifyEnabled(boolean notifyEnabled) {
            this.notifyEnabled = notifyEnabled;
            return this;
        }

        @Generated
        public ConfigBuilder roomNames(String roomNames) {
            this.roomNames = roomNames;
            return this;
        }

        @Generated
        public ConfigBuilder notificationType(Type notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Generated
        public ConfigBuilder tokens(String tokens) {
            this.tokens = tokens;
            return this;
        }

        @Generated
        public Config build() {
            return new Config(this.notifyEnabled, this.roomNames, this.notificationType, this.tokens);
        }

        @Generated
        public String toString() {
            return "Config.ConfigBuilder(notifyEnabled=" + this.notifyEnabled + ", roomNames=" + this.roomNames + ", notificationType=" + String.valueOf((Object)this.notificationType) + ", tokens=" + this.tokens + ")";
        }
    }
}

