/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.hubot.config;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import jenkins.model.Jenkins;
import lombok.Generated;
import org.apache.log4j.Logger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.thoughtslive.jenkins.plugins.hubot.api.Message;
import org.thoughtslive.jenkins.plugins.hubot.api.ResponseData;
import org.thoughtslive.jenkins.plugins.hubot.config.GlobalConfig;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotFolderProperty;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotJobProperty;
import org.thoughtslive.jenkins.plugins.hubot.config.notifications.Config;
import org.thoughtslive.jenkins.plugins.hubot.config.notifications.Type;
import org.thoughtslive.jenkins.plugins.hubot.service.HubotService;
import org.thoughtslive.jenkins.plugins.hubot.util.Common;

public class HubotSite
extends AbstractDescribableImpl<HubotSite>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -455439000126041809L;
    private static final Logger LOGGER = Logger.getLogger((String)HubotSite.class.getName());
    private boolean defaultSite;
    private String name;
    private URL url;
    private String room;
    private String roomPrefix;
    private boolean failOnError;
    private boolean useFolderName;
    private List<Config> notifications;

    @DataBoundConstructor
    public HubotSite(boolean defaultSite, String name, URL url, String room, String roomPrefix, boolean failOnError, boolean useFolderName, List<Config> notifications) {
        this.defaultSite = defaultSite;
        this.name = Util.fixEmpty((String)name);
        this.url = url;
        this.room = room;
        this.roomPrefix = roomPrefix;
        this.failOnError = failOnError;
        this.useFolderName = useFolderName;
        this.notifications = notifications;
    }

    public static HubotSite get(Job<?, ?> job, TaskListener listener) {
        HubotJobProperty jpp = (HubotJobProperty)job.getProperty(HubotJobProperty.class);
        boolean enableNotifications = false;
        String siteName = null;
        if (jpp != null) {
            enableNotifications = jpp.isEnableNotifications();
            siteName = Util.fixEmpty((String)jpp.getSiteNames());
        }
        if (enableNotifications) {
            return HubotSite.get(job, listener, siteName);
        }
        return null;
    }

    public static HubotSite get(Job<?, ?> job, TaskListener listener, String siteName) {
        HubotSite hubotSite = null;
        HubotSite defaultSite = null;
        ItemGroup parent = job.getParent();
        String folderName = null;
        try {
            while (parent != null) {
                if (parent instanceof AbstractFolder) {
                    HubotSite[] sites;
                    HubotFolderProperty jfp;
                    HubotSite[] folder = (HubotSite[])parent;
                    if (folderName == null) {
                        folderName = folder.getName();
                    }
                    if ((jfp = (HubotFolderProperty)folder.getProperties().get(HubotFolderProperty.class)) != null && (sites = jfp.getSites()) != null && sites.length > 0) {
                        for (HubotSite site : sites) {
                            HubotSite cloneSite = site.clone();
                            if (cloneSite.isUseFolderName()) {
                                cloneSite.setRoom(folder.getName());
                            }
                            if (siteName != null) {
                                if (!cloneSite.getName().equalsIgnoreCase(siteName) || hubotSite != null) continue;
                                hubotSite = cloneSite;
                                continue;
                            }
                            if (!cloneSite.isDefaultSite() || defaultSite != null) continue;
                            defaultSite = cloneSite;
                        }
                    }
                }
                if (parent instanceof Item) {
                    parent = ((Item)parent).getParent();
                    continue;
                }
                parent = null;
            }
            if (hubotSite == null && defaultSite == null) {
                for (HubotSite site : new GlobalConfig().getSites()) {
                    HubotSite cloneSite = site.clone();
                    if (site.isUseFolderName() && folderName != null) {
                        cloneSite.setRoom(folderName);
                    }
                    if (siteName != null) {
                        if (!cloneSite.getName().equalsIgnoreCase(siteName) || hubotSite != null) continue;
                        hubotSite = cloneSite;
                        continue;
                    }
                    if (!cloneSite.isDefaultSite() || defaultSite != null) continue;
                    defaultSite = cloneSite;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to get hubot site", (Throwable)e);
        }
        return hubotSite == null ? defaultSite : hubotSite;
    }

    public HubotSite clone() throws CloneNotSupportedException {
        super.clone();
        HubotSite site = HubotSite.builder().defaultSite(this.defaultSite).name(this.name).url(this.url).room(this.room).roomPrefix(this.roomPrefix).failOnError(this.failOnError).useFolderName(this.useFolderName).notifications(this.notifications).build();
        return site;
    }

    @Generated
    public static HubotSiteBuilder builder() {
        return new HubotSiteBuilder();
    }

    @Generated
    public boolean isDefaultSite() {
        return this.defaultSite;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public URL getUrl() {
        return this.url;
    }

    @Generated
    public String getRoom() {
        return this.room;
    }

    @Generated
    public String getRoomPrefix() {
        return this.roomPrefix;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public boolean isUseFolderName() {
        return this.useFolderName;
    }

    @Generated
    public List<Config> getNotifications() {
        return this.notifications;
    }

    @Generated
    public void setDefaultSite(boolean defaultSite) {
        this.defaultSite = defaultSite;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setUrl(URL url) {
        this.url = url;
    }

    @Generated
    public void setRoom(String room) {
        this.room = room;
    }

    @Generated
    public void setRoomPrefix(String roomPrefix) {
        this.roomPrefix = roomPrefix;
    }

    @Generated
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Generated
    public void setUseFolderName(boolean useFolderName) {
        this.useFolderName = useFolderName;
    }

    @Generated
    public void setNotifications(List<Config> notifications) {
        this.notifications = notifications;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HubotSite)) {
            return false;
        }
        HubotSite other = (HubotSite)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDefaultSite() != other.isDefaultSite()) {
            return false;
        }
        if (this.isFailOnError() != other.isFailOnError()) {
            return false;
        }
        if (this.isUseFolderName() != other.isUseFolderName()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        URL this$url = this.getUrl();
        URL other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        String this$room = this.getRoom();
        String other$room = other.getRoom();
        if (this$room == null ? other$room != null : !this$room.equals(other$room)) {
            return false;
        }
        String this$roomPrefix = this.getRoomPrefix();
        String other$roomPrefix = other.getRoomPrefix();
        if (this$roomPrefix == null ? other$roomPrefix != null : !this$roomPrefix.equals(other$roomPrefix)) {
            return false;
        }
        List<Config> this$notifications = this.getNotifications();
        List<Config> other$notifications = other.getNotifications();
        return !(this$notifications == null ? other$notifications != null : !((Object)this$notifications).equals(other$notifications));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HubotSite;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDefaultSite() ? 79 : 97);
        result = result * 59 + (this.isFailOnError() ? 79 : 97);
        result = result * 59 + (this.isUseFolderName() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        URL $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        String $room = this.getRoom();
        result = result * 59 + ($room == null ? 43 : $room.hashCode());
        String $roomPrefix = this.getRoomPrefix();
        result = result * 59 + ($roomPrefix == null ? 43 : $roomPrefix.hashCode());
        List<Config> $notifications = this.getNotifications();
        result = result * 59 + ($notifications == null ? 43 : ((Object)$notifications).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HubotSite(defaultSite=" + this.isDefaultSite() + ", name=" + this.getName() + ", url=" + String.valueOf(this.getUrl()) + ", room=" + this.getRoom() + ", roomPrefix=" + this.getRoomPrefix() + ", failOnError=" + this.isFailOnError() + ", useFolderName=" + this.isUseFolderName() + ", notifications=" + String.valueOf(this.getNotifications()) + ")";
    }

    @Generated
    public static class HubotSiteBuilder {
        @Generated
        private boolean defaultSite;
        @Generated
        private String name;
        @Generated
        private URL url;
        @Generated
        private String room;
        @Generated
        private String roomPrefix;
        @Generated
        private boolean failOnError;
        @Generated
        private boolean useFolderName;
        @Generated
        private List<Config> notifications;

        @Generated
        HubotSiteBuilder() {
        }

        @Generated
        public HubotSiteBuilder defaultSite(boolean defaultSite) {
            this.defaultSite = defaultSite;
            return this;
        }

        @Generated
        public HubotSiteBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public HubotSiteBuilder url(URL url) {
            this.url = url;
            return this;
        }

        @Generated
        public HubotSiteBuilder room(String room) {
            this.room = room;
            return this;
        }

        @Generated
        public HubotSiteBuilder roomPrefix(String roomPrefix) {
            this.roomPrefix = roomPrefix;
            return this;
        }

        @Generated
        public HubotSiteBuilder failOnError(boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        @Generated
        public HubotSiteBuilder useFolderName(boolean useFolderName) {
            this.useFolderName = useFolderName;
            return this;
        }

        @Generated
        public HubotSiteBuilder notifications(List<Config> notifications) {
            this.notifications = notifications;
            return this;
        }

        @Generated
        public HubotSite build() {
            return new HubotSite(this.defaultSite, this.name, this.url, this.room, this.roomPrefix, this.failOnError, this.useFolderName, this.notifications);
        }

        @Generated
        public String toString() {
            return "HubotSite.HubotSiteBuilder(defaultSite=" + this.defaultSite + ", name=" + this.name + ", url=" + String.valueOf(this.url) + ", room=" + this.room + ", roomPrefix=" + this.roomPrefix + ", failOnError=" + this.failOnError + ", useFolderName=" + this.useFolderName + ", notifications=" + String.valueOf(this.notifications) + ")";
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<HubotSite> {
        public String getDisplayName() {
            return "Hubot Site";
        }

        @SuppressFBWarnings
        public FormValidation doValidate(@AncestorInPath Item project, @QueryParameter String name, @QueryParameter String url, @QueryParameter String room, @QueryParameter String roomPrefix, @QueryParameter boolean useFolderName) throws IOException {
            AbstractFolder folder;
            url = Util.fixEmpty((String)url);
            name = Util.fixEmpty((String)name);
            room = Util.fixEmpty((String)room);
            if ((roomPrefix = Util.fixEmpty((String)roomPrefix)) == null) {
                roomPrefix = "";
            }
            if (name == null) {
                return FormValidation.error((String)"Site name is empty or null.");
            }
            HashMap<String, String> extraData = new HashMap<String, String>();
            extraData.put("JENKINS_URL", Jenkins.getInstance().getRootUrl());
            if (project instanceof AbstractFolder) {
                folder = (AbstractFolder)project;
                Object folderName = folder.getName();
                String folderUrl = folder.getAbsoluteUrl();
                extraData.put("FOLDER_URL", folderUrl);
                ItemGroup parent = project.getParent();
                while (parent != null) {
                    if (parent instanceof AbstractFolder) {
                        AbstractFolder parentFolder = (AbstractFolder)parent;
                        folderName = parentFolder.getName() + " \u00bb " + (String)folderName;
                    }
                    if (parent instanceof Item) {
                        parent = ((Item)parent).getParent();
                        continue;
                    }
                    parent = null;
                }
                extraData.put("FOLDER_NAME", (String)folderName);
            }
            if (useFolderName) {
                if (project instanceof AbstractFolder) {
                    folder = (AbstractFolder)project;
                    room = roomPrefix + folder.getName();
                } else if (room == null) {
                    return FormValidation.error((String)"Room Name is empty or null, is required for global config.");
                }
            } else if (room == null) {
                return FormValidation.error((String)"Room Name is empty or null.");
            }
            try {
                if (url == null) {
                    return FormValidation.error((String)"URL is empty or null.");
                }
                new URL(Common.sanitizeURL(url));
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)String.format("Malformed URL (%s)", url), (Object[])new Object[]{e});
            }
            String userName = "anonymous";
            String userId = null;
            if (User.current() != null) {
                userName = User.current().getDisplayName();
                userId = User.current().getId();
            }
            try {
                Message message = Message.builder().stepName(Common.STEP.TEST.name()).message("Hubot Site: " + name + " configured successfully.").ts(System.currentTimeMillis()).extraData(extraData).userId(userId).userName(userName).status(Type.SUCCESS.name()).build();
                HubotSite site = HubotSite.builder().room((String)room).url(new URL(Common.sanitizeURL(url))).build();
                HubotService service = new HubotService(site);
                ResponseData<Void> response = service.sendMessage(message);
                if (!response.isSuccessful()) {
                    return FormValidation.error((String)("Hubot: Error while sending a test message - Error Code: " + response.getCode() + " Error Message: " + response.getError()));
                }
                return FormValidation.ok((String)"Success  - Please check hubot logs as well to make sure there isn't a problem with script!.");
            }
            catch (Exception e) {
                e.printStackTrace();
                return FormValidation.error((String)String.format("Error while configuring site: %s", name), (Object[])new Object[]{e});
            }
        }
    }
}

