/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.hubot.config;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.logging.Logger;
import lombok.Generated;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.hubot.config.GlobalConfig;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotFolderProperty;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotSite;

public class HubotJobProperty
extends JobProperty
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(HubotJobProperty.class.getName());
    public final String siteNames;
    private boolean enableNotifications;

    @DataBoundConstructor
    public HubotJobProperty(String siteNames, boolean enableNotifications) {
        this.siteNames = siteNames;
        this.enableNotifications = enableNotifications;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Generated
    public static HubotJobPropertyBuilder builder() {
        return new HubotJobPropertyBuilder();
    }

    @Generated
    public String getSiteNames() {
        return this.siteNames;
    }

    @Generated
    public boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public boolean isApplicable(Class<? extends Job> jobType) {
            return Job.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Hubot Job Property";
        }

        public ListBoxModel doFillSiteNamesItems(@AncestorInPath Item project) {
            ArrayList<ListBoxModel.Option> hubotSites = new ArrayList<ListBoxModel.Option>();
            hubotSites.add(new ListBoxModel.Option("Optional - Please select, otherwise it will use default site from parent folder(s)/global.", ""));
            Object folderName = null;
            ItemGroup parent = project.getParent();
            while (parent != null) {
                if (parent instanceof AbstractFolder) {
                    HubotSite[] sites;
                    AbstractFolder folder = (AbstractFolder)parent;
                    folderName = folderName == null ? folder.getName() : folder.getName() + " \u00bb " + (String)folderName;
                    HubotFolderProperty jfp = (HubotFolderProperty)folder.getProperties().get(HubotFolderProperty.class);
                    if (jfp != null && (sites = jfp.getSites()) != null && sites.length > 0) {
                        for (HubotSite site : sites) {
                            hubotSites.add(new ListBoxModel.Option((String)folderName + " - " + site.getName(), site.getName()));
                        }
                    }
                }
                if (parent instanceof Item) {
                    parent = ((Item)parent).getParent();
                    continue;
                }
                parent = null;
            }
            for (HubotSite site : new GlobalConfig().getSites()) {
                hubotSites.add(new ListBoxModel.Option("Global - " + site.getName(), site.getName()));
            }
            return new ListBoxModel(hubotSites);
        }
    }

    @Generated
    public static class HubotJobPropertyBuilder {
        @Generated
        private String siteNames;
        @Generated
        private boolean enableNotifications;

        @Generated
        HubotJobPropertyBuilder() {
        }

        @Generated
        public HubotJobPropertyBuilder siteNames(String siteNames) {
            this.siteNames = siteNames;
            return this;
        }

        @Generated
        public HubotJobPropertyBuilder enableNotifications(boolean enableNotifications) {
            this.enableNotifications = enableNotifications;
            return this;
        }

        @Generated
        public HubotJobProperty build() {
            return new HubotJobProperty(this.siteNames, this.enableNotifications);
        }

        @Generated
        public String toString() {
            return "HubotJobProperty.HubotJobPropertyBuilder(siteNames=" + this.siteNames + ", enableNotifications=" + this.enableNotifications + ")";
        }
    }
}

