/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request.util;

import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;

public class BackWardCompatibleRedirectStrategy
extends DefaultRedirectStrategy {
    private static final String[] REDIRECT_METHODS = new String[]{"GET", "HEAD"};

    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
        if (!response.containsHeader("Location")) {
            return false;
        }
        int statusCode = response.getCode();
        String method = request.getMethod();
        Header locationHeader = response.getFirstHeader("location");
        return switch (statusCode) {
            case 302 -> {
                if (this.isRedirectable(method) && locationHeader != null) {
                    yield true;
                }
                yield false;
            }
            case 301, 307, 308 -> this.isRedirectable(method);
            case 303 -> true;
            default -> false;
        };
    }

    protected boolean isRedirectable(String method) {
        for (String m : REDIRECT_METHODS) {
            if (!m.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }
}

