/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request.auth;

import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import hudson.Util;
import java.io.IOException;
import java.io.PrintStream;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import jenkins.plugins.http_request.auth.Authenticator;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;

public class CertificateAuthentication
implements Authenticator {
    private final StandardCertificateCredentials credentials;
    private final boolean ignoreSslErrors;

    public CertificateAuthentication(StandardCertificateCredentials credentials) {
        this.credentials = credentials;
        this.ignoreSslErrors = false;
    }

    public CertificateAuthentication(StandardCertificateCredentials credentials, boolean ignoreSslErrors) {
        this.credentials = credentials;
        this.ignoreSslErrors = ignoreSslErrors;
    }

    @Override
    public String getKeyName() {
        return this.credentials.getId();
    }

    @Override
    public CloseableHttpClient authenticate(HttpClientBuilder clientBuilder, HttpClientContext context, HttpUriRequestBase requestBase, PrintStream logger) throws IOException {
        try {
            KeyStore keyStore = this.credentials.getKeyStore();
            String keyStorePass = Util.fixEmpty((String)this.credentials.getPassword().getPlainText());
            char[] keyStorePassChars = keyStorePass == null ? null : keyStorePass.toCharArray();
            SSLContextBuilder contextBuilder = SSLContexts.custom();
            if (keyStorePassChars == null) {
                logger.println("WARNING: Jenkins Certificate Credential '" + this.credentials.getId() + "' was saved without a password, so any certificates (and chain of trust) in it would be ignored by Java PKCS12 support!");
            }
            try {
                TrustAllStrategy trustStrategy = null;
                if (this.ignoreSslErrors) {
                    trustStrategy = new TrustAllStrategy();
                }
                contextBuilder.loadTrustMaterial(keyStore, (TrustStrategy)trustStrategy);
                logger.println("Added Trust Material from provided KeyStore");
            }
            catch (Exception e) {
                logger.println("Failed to add Trust Material from provided KeyStore (so Key Material might end up untrusted): " + e.getMessage());
            }
            contextBuilder.loadKeyMaterial(keyStore, keyStorePassChars);
            logger.println("Added Key Material from provided KeyStore");
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(contextBuilder.build(), (HostnameVerifier)new DefaultHostnameVerifier());
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
            logger.println("Set SSL context and socket factory for the HTTP client builder");
            return clientBuilder.build();
        }
        catch (Exception e) {
            logger.println("Failed to set SSL context: " + e.getMessage());
            throw new IOException(e);
        }
    }
}

