/*
 *  Certain versions of software accessible here may contain branding from
 *  Hewlett-Packard Company (now HP Inc.) and Hewlett Packard Enterprise Company.
 *  This software was acquired by Micro Focus on September 1, 2017, and is now
 *  offered by OpenText.
 *  Any reference to the HP and Hewlett Packard Enterprise/HPE marks is historical
 *  in nature, and the HP and Hewlett Packard Enterprise/HPE marks are the
 *  property of their respective owners.
 *  OpenText is a trademark of Open Text.
 *  __________________________________________________________________
 *  MIT License
 *
 *  Copyright 2012-2025 Open Text.
 *
 *  The only warranties for products and services of Open Text and
 *  its affiliates and licensors ("Open Text") are as may be set forth
 *  in the express warranty statements accompanying such products and services.
 *  Nothing herein should be construed as constituting an additional warranty.
 *  Open Text shall not be liable for technical or editorial errors or
 *  omissions contained herein. The information contained herein is subject
 *  to change without notice.
 *
 *  Except as specifically indicated otherwise, this document contains
 *  confidential information and a valid license is required for possession,
 *  use or copying. If this work is provided to the U.S. Government,
 *  consistent with FAR 12.211 and 12.212, Commercial Computer Software,
 *  Computer Software Documentation, and Technical Data for Commercial Items are
 *  licensed to the U.S. Government under vendor's standard commercial license.
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  ___________________________________________________________________
 */
(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define([], function () {
            return (root.returnExportsGlobal = factory());
        });
    } else if (typeof exports === 'object') {
        // Node. Does not work with strict CommonJS, but
        // only CommonJS-like enviroments that support module.exports,
        // like Node.
        module.exports = factory();
    } else {
        root['Chartist.plugins.ctAxisTitle'] = factory();
    }
}(this, function () {

    /**
     * Chartist.js plugin to display a title for 1 or 2 axises.
     *
     */
    /* global Chartist */
    (function (window, document, Chartist) {
        'use strict';

        var axisDefaults = {
            axisTitle: '',
            axisClass: 'ct-axis-title',
            offset: {
                x: 0,
                y: 0
            },
            textAnchor: 'middle',
            flipText: false
        };
        var defaultOptions = {
            xAxis: axisDefaults,
            yAxis: axisDefaults
        };

        Chartist.plugins = Chartist.plugins || {};
        Chartist.plugins.ctAxisTitle = function (options) {

            options = Chartist.extend({}, defaultOptions, options);

            return function ctAxisTitle(chart) {

                chart.on('created', function (data) {

                    if (!options.axisX.axisTitle && !options.axisY.axisTitle) {
                        throw new Error('ctAxisTitle plugin - You must provide at least one axis title');
                    } else if (!data.axisX && !data.axisY) {
                        throw new Error('ctAxisTitle plugin can only be used on charts that have at least one axis');
                    }

                    var xPos;
                    var yPos;
                    var title;

                    //position axis X title
                    if (options.axisX.axisTitle && data.axisX) {

                        xPos = (data.axisX.axisLength / 2) + data.options.axisY.offset + data.options.chartPadding.left;

                        yPos = data.options.chartPadding.top;

                        if (data.options.axisY.position === 'end') {
                            xPos -= data.options.axisY.offset;
                        }

                        if (data.options.axisX.position === 'end') {
                            yPos += data.axisY.axisLength;
                        }

                        title = new Chartist.Svg("text");
                        title.addClass(options.axisX.axisClass);
                        title.text(options.axisX.axisTitle);
                        title.attr({
                            x: xPos + options.axisX.offset.x,
                            y: yPos + options.axisX.offset.y,
                            "text-anchor": options.axisX.textAnchor
                        });

                        data.svg.append(title, true);

                    }

                    //position axis Y title
                    if (options.axisY.axisTitle && data.axisY) {
                        xPos = 0;


                        yPos = (data.axisY.axisLength / 2) + data.options.chartPadding.top;

                        if (data.options.axisX.position === 'start') {
                            yPos += data.options.axisX.offset;
                        }

                        if (data.options.axisY.position === 'end') {
                            xPos = data.axisX.axisLength;
                        }

                        var transform = 'rotate(' + (options.axisY.flipTitle ? -90 : 90) + ', ' + xPos + ', ' + yPos + ')';

                        title = new Chartist.Svg("text");
                        title.addClass(options.axisY.axisClass);
                        title.text(options.axisY.axisTitle);
                        title.attr({
                            x: xPos + options.axisY.offset.x,
                            y: yPos + options.axisY.offset.y,
                            transform: transform,
                            "text-anchor": options.axisY.textAnchor
                        });

                        data.svg.append(title, true);

                    }

                });
            };
        };

    }(window, document, Chartist));

    return Chartist.plugins.ctAxisTitle;

}));
