/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.html.HtmlTableColumn;
import org.htmlunit.html.HtmlTableColumnGroup;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxClasses;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.html.HTMLTableComponent;

@JsxClasses(value={@JsxClass(domClass=HtmlTableColumn.class), @JsxClass(domClass=HtmlTableColumnGroup.class)})
public class HTMLTableColElement
extends HTMLTableComponent {
    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public int getSpan() {
        int i;
        String span = this.getDomNodeOrDie().getAttributeDirect("span");
        try {
            i = Integer.parseInt(span);
            if (i < 1) {
                i = 1;
            }
        }
        catch (NumberFormatException e) {
            i = 1;
        }
        return i;
    }

    @JsxSetter
    public void setSpan(Object span) {
        double d = JavaScriptEngine.toNumber(span);
        int i = (int)d;
        if (i < 1) {
            i = 1;
        }
        this.getDomNodeOrDie().setAttribute("span", Integer.toString(i));
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getWidthOrHeight("width", null);
    }

    @JsxSetter(propertyName="width")
    public void setWidth_js(Object width) {
        String value = JavaScriptEngine.toString(width);
        this.setWidthOrHeight("width", value, false);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.getDomNodeOrDie() instanceof HtmlTableColumn;
    }

    @Override
    public void setOuterHTML(Object value) {
        throw JavaScriptEngine.reportRuntimeError("outerHTML is read-only for tag '" + this.getDomNodeOrDie().getNodeName() + "'");
    }
}

