/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.net.URL;
import org.htmlunit.Page;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.event.MessageEvent;

@JsxClass
public class MessagePort
extends EventTarget {
    private MessagePort port1_;

    public MessagePort() {
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    public MessagePort(MessagePort port1) {
        this.port1_ = port1;
    }

    @JsxGetter
    public Object getOnmessage() {
        return this.getHandlerForJavaScript("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setHandlerForJavaScript("message", onmessage);
    }

    private Object getHandlerForJavaScript(String eventName) {
        return this.getEventListenersContainer().getEventHandler(eventName);
    }

    private void setHandlerForJavaScript(String eventName, Object handler) {
        this.getEventListenersContainer().setEventHandler(eventName, handler);
    }

    @JsxFunction
    public void postMessage(String message, Object transfer) {
        if (this.port1_ != null) {
            Window w = this.getWindow();
            WebWindow webWindow = w.getWebWindow();
            Page page = webWindow.getEnclosedPage();
            URL currentURL = page.getUrl();
            final MessageEvent event = new MessageEvent();
            String origin = currentURL.getProtocol() + "://" + currentURL.getHost() + ':' + currentURL.getPort();
            event.initMessageEvent("message", false, false, message, origin, "", w, transfer);
            event.setParentScope((Scriptable)this.port1_);
            event.setPrototype(this.getPrototype(event.getClass()));
            final AbstractJavaScriptEngine<?> jsEngine = webWindow.getWebClient().getJavaScriptEngine();
            PostponedAction action = new PostponedAction(page, "MessagePort.postMessage"){

                @Override
                public void execute() {
                    HtmlUnitContextFactory cf = jsEngine.getContextFactory();
                    cf.call(cx -> MessagePort.this.port1_.dispatchEvent(event));
                }
            };
            jsEngine.addPostponedAction(action);
        }
    }
}

