/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.util;

import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import java.util.Base64;
import org.apache.http.entity.ContentType;
import org.apache.http.message.AbstractHttpMessage;

public class HttpMessageUtil {
    private static final String KEY_ACCEPT = "Accept";
    private static final String KEY_CONTENT_TYPE = "Content-Type";
    private static final String KEY_AUTHORIZATION = "Authorization";

    public static void accept(AbstractHttpMessage m, ContentType ct) {
        if (ct != null) {
            m.setHeader(KEY_ACCEPT, ct.getMimeType());
        }
    }

    public static void contentType(AbstractHttpMessage m, ContentType ct) {
        m.setHeader(KEY_CONTENT_TYPE, ct.getMimeType());
    }

    public static void basicAuthentication(AbstractHttpMessage m, String username, String password) {
        String auth = "Basic " + new String(Base64.getEncoder().encodeToString((username + ":" + password).getBytes()));
        m.setHeader(KEY_AUTHORIZATION, auth);
    }

    public static void basicAuthentication(AbstractHttpMessage m, Credentials cred) {
        if (cred.getUsername() == null) {
            return;
        }
        HttpMessageUtil.basicAuthentication(m, cred.getUsername(), cred.getPassword());
    }
}

