/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor.export;

import com.microfocus.sv.svconfigurator.processor.export.ZipWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWriter {
    Map<String, byte[]> entries = new LinkedHashMap<String, byte[]>();
    private static final Logger LOG = LoggerFactory.getLogger(ZipWriter.class);

    public static String entityNameToFileName(String entityName) {
        return entityName.replaceAll("[^a-zA-Z0-9 .-]", "_").trim();
    }

    public void addData(String filePath, byte[] data) {
        LOG.info("    writing '" + filePath + "'...");
        this.entries.put(filePath, data);
    }

    public void commit() throws IOException {
        for (Map.Entry<String, byte[]> e : this.entries.entrySet()) {
            this.writeDataImpl(e.getValue(), e.getKey());
        }
        this.entries.clear();
    }

    public void rollback() {
        this.entries.clear();
    }

    protected abstract void writeDataImpl(byte[] var1, String var2) throws IOException;

    public void close() throws IOException {
    }
}

